/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.printing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.text.MessageFormat;
import java.util.Observable;
import java.util.Observer;
import javax.swing.RepaintManager;
import oracle.dbtools.crest.swingui.printing.Messages;

public class PrintPreviewModel
extends Observable
implements Pageable,
Printable {
    private Object objectToPrint = null;
    private Dimension objectDimension = null;
    private PageFormat pageformat = new PageFormat();
    private boolean pageCornersEnabled = true;
    private int printXScalingFactor = 100;
    private int printYScalingFactor = 100;
    private int previewXScalingFactor = 10;
    private int previewYScalingFactor = 10;
    private boolean computeRequired = false;
    private int numberOfPages;
    private int numberOfColumns;
    private int numberOfRows;
    private int widthPieceOfObject;
    private int heightPieceOfObject;

    public PrintPreviewModel(Component component, Dimension dimension) {
        this.objectToPrint = component;
        this.objectDimension = dimension;
        this.computeRequired = true;
    }

    @Override
    public int getNumberOfPages() {
        this.computePrintLayout();
        return this.numberOfPages;
    }

    public void setPageCorners(boolean bl) {
        this.pageCornersEnabled = bl;
        this.updateObservers();
    }

    public boolean getPageCorners() {
        return this.pageCornersEnabled;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageformat = pageFormat;
        this.computeRequired = true;
        this.updateObservers();
    }

    public PageFormat getPageFormat() {
        return this.pageformat;
    }

    @Override
    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        this.computePrintLayout();
        if (n >= this.numberOfPages) {
            throw new IndexOutOfBoundsException(MessageFormat.format(Messages.getString("PrintPreviewModel.NumberOfPages"), this.numberOfPages, n));
        }
        return this.pageformat;
    }

    public int getPreviewHeight() {
        return (int)(this.pageformat.getHeight() * ((double)this.previewYScalingFactor / 100.0));
    }

    public void setPreviewScalingFactors(int n, int n2) {
        this.previewXScalingFactor = n;
        this.previewYScalingFactor = n2;
        this.updateObservers();
    }

    public int getPreviewWidth() {
        return (int)(this.pageformat.getWidth() * ((double)this.previewXScalingFactor / 100.0));
    }

    public int getPreviewXScalingFactor() {
        return this.previewXScalingFactor;
    }

    public int getPreviewYScalingFactor() {
        return this.previewYScalingFactor;
    }

    public void setPrintScalingFactors(int n, int n2) {
        this.printXScalingFactor = n;
        this.printYScalingFactor = n2;
        this.computeRequired = true;
        this.updateObservers();
    }

    public int getPrintXScalingFactor() {
        return this.printXScalingFactor;
    }

    public int getPrintYScalingFactor() {
        return this.printYScalingFactor;
    }

    @Override
    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        this.computePrintLayout();
        if (n >= this.numberOfPages) {
            throw new IndexOutOfBoundsException("Number of pages : " + this.numberOfPages + " Requested pageindex : " + n);
        }
        return this;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        return this.printPieceOfObject(graphics, n, false);
    }

    public int printPreview(Graphics graphics, int n) {
        return this.printPieceOfObject(graphics, n, true);
    }

    public void updateObservers() {
        this.setChanged();
        if (this.countObservers() != 0) {
            this.notifyObservers();
        }
    }

    public void updateObservers(Observer observer) {
        this.setChanged();
        this.notifyObservers(observer);
    }

    private boolean isDoubleBufferingEnabled() {
        if (this.objectToPrint instanceof Component) {
            RepaintManager repaintManager = RepaintManager.currentManager((Component)this.objectToPrint);
            return repaintManager.isDoubleBufferingEnabled();
        }
        return false;
    }

    private void computePrintLayout() {
        if (!this.computeRequired) {
            return;
        }
        if (this.objectToPrint == null) {
            this.numberOfPages = 0;
            return;
        }
        int n = (int)((double)this.objectDimension.width * ((double)this.printXScalingFactor / 100.0));
        int n2 = (int)((double)this.objectDimension.height * ((double)this.printYScalingFactor / 100.0));
        int n3 = (int)this.pageformat.getImageableWidth();
        int n4 = (int)this.pageformat.getImageableHeight();
        this.numberOfColumns = Math.max((int)Math.ceil((double)n / (double)n3), 1);
        this.numberOfRows = Math.max((int)Math.ceil((double)n2 / (double)n4), 1);
        this.widthPieceOfObject = (int)((double)n3 / ((double)this.printXScalingFactor / 100.0));
        this.heightPieceOfObject = (int)((double)n4 / ((double)this.printYScalingFactor / 100.0));
        this.numberOfPages = this.numberOfColumns * this.numberOfRows;
        this.computeRequired = false;
    }

    private void disableDoubleBuffering() {
        if (this.objectToPrint instanceof Component) {
            RepaintManager repaintManager = RepaintManager.currentManager((Component)this.objectToPrint);
            repaintManager.setDoubleBufferingEnabled(false);
        }
    }

    private void enableDoubleBuffering() {
        if (this.objectToPrint instanceof Component) {
            RepaintManager repaintManager = RepaintManager.currentManager((Component)this.objectToPrint);
            repaintManager.setDoubleBufferingEnabled(true);
        }
    }

    private int printPieceOfObject(Graphics graphics, int n, boolean bl) {
        this.computePrintLayout();
        if (n >= this.numberOfPages || this.objectToPrint == null) {
            return 1;
        }
        boolean bl2 = false;
        if (this.isDoubleBufferingEnabled()) {
            this.disableDoubleBuffering();
            bl2 = true;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        double d = 1.0;
        double d2 = 1.0;
        if (bl) {
            d = (double)this.previewXScalingFactor / 100.0;
            d2 = (double)this.previewYScalingFactor / 100.0;
        }
        double d3 = (double)this.printXScalingFactor / 100.0;
        double d4 = (double)this.printYScalingFactor / 100.0;
        if (bl) {
            d3 *= (double)this.previewXScalingFactor / 100.0;
            d4 *= (double)this.previewYScalingFactor / 100.0;
        }
        int n2 = n % this.numberOfColumns;
        int n3 = n / this.numberOfColumns;
        int n4 = n2 * this.widthPieceOfObject;
        int n5 = n3 * this.heightPieceOfObject;
        int n6 = Math.min(this.widthPieceOfObject, this.objectDimension.width - n4);
        int n7 = Math.min(this.heightPieceOfObject, this.objectDimension.height - n5);
        if (this.objectToPrint instanceof Image) {
            graphics2D.translate(this.pageformat.getImageableX() * d, this.pageformat.getImageableY() * d2);
            graphics2D.scale(d3, d4);
            graphics2D.drawImage((Image)this.objectToPrint, 0, 0, n6 - 1, n7 - 1, n4, n5, n4 + n6 - 1, n5 + n7 - 1, null);
        } else {
            graphics2D.translate(this.pageformat.getImageableX() * d, this.pageformat.getImageableY() * d2);
            graphics2D.translate((double)(-n4) * d3, (double)(-n5) * d4);
            graphics2D.scale(d3, d4);
            Shape shape = graphics2D.getClip();
            graphics2D.clipRect(n4, n5, n6, n7);
            ((Component)this.objectToPrint).paint(graphics2D);
            graphics2D.setClip(shape);
        }
        graphics2D.setTransform(affineTransform);
        graphics2D.translate(this.pageformat.getImageableX() * d, this.pageformat.getImageableY() * d2);
        graphics2D.scale(d, d2);
        int n8 = (int)this.pageformat.getImageableWidth();
        int n9 = (int)this.pageformat.getImageableHeight();
        if (this.pageCornersEnabled && this.numberOfPages > 1) {
            graphics2D.setColor(Color.black);
            graphics2D.drawLine(0, 0, 20, 0);
            graphics2D.drawLine(0, 0, 0, 20);
            graphics2D.drawLine(n8, 0, n8 - 20, 0);
            graphics2D.drawLine(n8, 0, n8, 20);
            graphics2D.drawLine(0, n9, 20, n9);
            graphics2D.drawLine(0, n9, 0, n9 - 20);
            graphics2D.drawLine(n8, n9, n8 - 20, n9);
            graphics2D.drawLine(n8, n9, n8, n9 - 20);
        }
        graphics2D.setTransform(affineTransform);
        if (this.numberOfPages > 1) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = "row " + (n3 + 1) + " / col " + (n2 + 1);
            int n10 = ((int)this.pageformat.getWidth() - fontMetrics.stringWidth(string)) / 2;
            graphics2D.drawString(string, n10, (int)this.pageformat.getHeight() - 20);
        }
        if (bl2) {
            this.enableDoubleBuffering();
        }
        return 0;
    }

    public void computeSettings() {
        this.computePrintLayout();
    }

    public Object getObjectToPrint() {
        return this.objectToPrint;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public int getPageWidth() {
        return this.widthPieceOfObject;
    }

    public int getPageHeight() {
        return this.heightPieceOfObject;
    }
}

