/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.printing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.printing.Messages;
import oracle.dbtools.crest.swingui.printing.PrintPreviewModel;
import oracle.dbtools.crest.swingui.printing.SVGPrinter;

public class PrintPreviewController
extends JPanel
implements ActionListener {
    private PrintPreviewModel model;
    private PrinterJob prnJob;
    private JLabel jlblZoomPrint;
    private JComboBox jedtZoomPrint;
    private JLabel jlblZoomPreview;
    private JComboBox jedtZoomPreview;
    private JButton jactPageSetup;
    private JButton jactPrint;
    GUIConfiguration config = GUIConfiguration.getInstance();
    private JLabel lbNbrPages;
    private JDialog dialog = null;

    public PrintPreviewController(PrintPreviewModel printPreviewModel) {
        this.model = printPreviewModel;
        this.initGUIComponents();
        this.prnJob = PrinterJob.getPrinterJob();
        this.updateNumberOfPagesLabel(printPreviewModel.getNumberOfPages());
    }

    private void initGUIComponents() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.jlblZoomPreview = new JLabel(Messages.getString("PrintPreviewController.Zoom"));
        String[] stringArray = new String[]{"25%", "50%", "75%", "100%", "200%", "400%"};
        this.jedtZoomPreview = new JComboBox<String>(stringArray);
        this.jedtZoomPreview.setPreferredSize(new Dimension(70, 20));
        this.jedtZoomPreview.setMinimumSize(this.jedtZoomPreview.getPreferredSize());
        this.jedtZoomPreview.setMaximumSize(this.jedtZoomPreview.getPreferredSize());
        this.jedtZoomPreview.setEditable(true);
        this.jedtZoomPreview.setSelectedItem(this.model.getPreviewXScalingFactor() + "%");
        this.jedtZoomPreview.addActionListener(this);
        this.jlblZoomPrint = new JLabel(Messages.getString("PrintPreviewController.PrintScale"));
        this.jedtZoomPrint = new JComboBox<String>(stringArray);
        this.jedtZoomPrint.setPreferredSize(new Dimension(70, 20));
        this.jedtZoomPrint.setMinimumSize(this.jedtZoomPrint.getPreferredSize());
        this.jedtZoomPrint.setMaximumSize(this.jedtZoomPrint.getPreferredSize());
        this.jedtZoomPrint.setEditable(true);
        this.jedtZoomPrint.setSelectedItem(this.model.getPrintXScalingFactor() + "%");
        this.jedtZoomPrint.addActionListener(this);
        Icon icon = this.config.getIcon("PAGE_SETUP_ICON");
        this.jactPageSetup = new JButton(Messages.getString("PrintPreviewController.PageSetup"), icon);
        this.jactPageSetup.addActionListener(this);
        icon = this.config.getIcon("PRINT_ICON");
        this.jactPrint = new JButton(Messages.getString("PrintPreviewController.Print"), icon);
        this.jactPrint.setPreferredSize(this.jactPageSetup.getPreferredSize());
        this.jactPrint.addActionListener(this);
        this.lbNbrPages = new JLabel();
        jPanel.add(this.jlblZoomPrint);
        jPanel.add(this.jedtZoomPrint);
        jPanel.add(new JPanel());
        jPanel.add(this.jlblZoomPreview);
        jPanel.add(this.jedtZoomPreview);
        jPanel.add(new JPanel());
        jPanel.add(this.jactPageSetup);
        jPanel.add(new JPanel());
        jPanel.add(this.jactPrint);
        jPanel.add(new JPanel());
        jPanel.add(this.lbNbrPages);
        this.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(Messages.getString("PrintPreviewController.Close"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PrintPreviewController.this.dialog != null) {
                    PrintPreviewController.this.dialog.dispose();
                }
            }
        });
        jButton.setPreferredSize(this.jactPageSetup.getPreferredSize());
        jPanel2.add(jButton);
        this.add((Component)jPanel2, "East");
    }

    private void updateNumberOfPagesLabel(int n) {
        this.lbNbrPages.setText(String.format(Messages.getString("PrintPreviewController.Pages"), n));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.jactPageSetup) {
            this.pageSetup();
        } else if (object == this.jedtZoomPrint) {
            this.zoomPrint();
        } else if (object == this.jedtZoomPreview) {
            this.zoomPreview();
        } else if (object == this.jactPrint) {
            this.print();
        }
    }

    private void zoomPrint() {
        try {
            int n = this.validateZoomFactor(this.jedtZoomPrint.getSelectedItem().toString());
            this.model.setPrintScalingFactors(n, n);
            this.updateNumberOfPagesLabel(this.model.getNumberOfPages());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, numberFormatException.getMessage());
            this.jedtZoomPrint.setSelectedItem(this.model.getPrintXScalingFactor() + "%");
        }
    }

    private void zoomPreview() {
        try {
            int n = this.validateZoomFactor(this.jedtZoomPreview.getSelectedItem().toString());
            this.model.setPreviewScalingFactors(n, n);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, numberFormatException.getMessage());
            this.jedtZoomPreview.setSelectedItem(this.model.getPreviewXScalingFactor() + "%");
        }
    }

    public void pageSetup() {
        PageFormat pageFormat;
        if (this.prnJob.printDialog() && (pageFormat = this.prnJob.pageDialog(this.prnJob.defaultPage())) != this.model.getPageFormat()) {
            this.model.setPageFormat(pageFormat);
            this.updateNumberOfPagesLabel(this.model.getNumberOfPages());
        }
    }

    public void print() {
        try {
            if (this.model.getObjectToPrint() instanceof Diagram) {
                new SVGPrinter(this.prnJob, this.model).print();
            } else {
                this.prnJob.setPageable(this.model);
                if (this.prnJob.printDialog()) {
                    this.prnJob.print();
                }
            }
        }
        catch (PrinterException printerException) {
            JOptionPane.showMessageDialog(this, printerException.getMessage());
        }
    }

    private int validateZoomFactor(String string) throws NumberFormatException {
        if (string.endsWith("%")) {
            string = string.substring(0, string.length() - 1);
        }
        string = string.trim();
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(Messages.getString("PrintPreviewController.EnterZoomFactorBetween"));
        }
        if (n < 2 || n > 1000) {
            throw new NumberFormatException(Messages.getString("PrintPreviewController.EnterZoomFactorBetween"));
        }
        return n;
    }

    public void setDialog(JDialog jDialog) {
        this.dialog = jDialog;
    }
}

