/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.printing;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.RepaintManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.printing.AbstractExporter;
import oracle.dbtools.crest.swingui.printing.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.net.URLFilter;

public class ImageExporter
extends AbstractExporter {
    private static final Logger LOGGER = new Logger(ImageExporter.class);

    public ImageExporter(ApplicationView applicationView) {
        super(applicationView);
        this.getFilterList().add(new PNGFileFilter());
        this.getFilterList().add(new JPEGFileFilter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToImage(Diagram diagram, Dimension dimension, int n, String string, String string2) throws Exception {
        System.gc();
        BufferedImage bufferedImage = new BufferedImage(dimension.width + 10, dimension.height + 10, n);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(diagram.getBackground());
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        diagram.paint(graphics2D);
        graphics2D.dispose();
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        try {
            ImageIO.write((RenderedImage)bufferedImage, string2, fileOutputStream);
        }
        finally {
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(Diagram diagram) {
        block8: {
            try {
                File file = this.getFile();
                if (file == null) break block8;
                String string = this.getFileName(file);
                TimeLog.log("Export Started");
                RepaintManager repaintManager = RepaintManager.currentManager(diagram);
                repaintManager.setDoubleBufferingEnabled(false);
                ProgressDialog progressDialog = new ProgressDialog(this.getAppView(), "", 0, 100, true);
                try {
                    progressDialog.setNote(Messages.getString("ImageExporter.SavingFileWait"));
                    progressDialog.setProgress(1);
                    Dimension dimension = diagram.getPreferredScrollableViewportSize();
                    String string2 = "png";
                    if (this.isImageType(string, ".jpg")) {
                        string2 = "jpg";
                    }
                    try {
                        this.exportToImage(diagram, dimension, 9, string, string2);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        this.exportToImage(diagram, dimension, 13, string, string2);
                    }
                    TimeLog.log("Export End");
                }
                finally {
                    repaintManager.setDoubleBufferingEnabled(true);
                    progressDialog.close();
                }
            }
            catch (Exception exception) {
                LOGGER.error(Messages.getString("ImageExporter.11"), exception);
                MessageDialogs.showErrorMessage("Error occures while saving image file.");
            }
        }
    }

    protected String getDefaultExtension() {
        return ".png";
    }

    @Override
    protected String getTitle() {
        return Messages.getString("ImageExporter.SaveAsImageFile");
    }

    @Override
    protected boolean isSupportedExtension(String string) {
        return string.equals("png") || string.equals("jpg");
    }

    private boolean isImageType(String string, String string2) {
        return string.toLowerCase().endsWith(string2.toLowerCase());
    }

    private class JPEGFileFilter
    implements URLFilter {
        private JPEGFileFilter() {
        }

        public boolean accept(URL uRL) {
            File file = new File(uRL.getPath());
            if (file.isDirectory()) {
                return true;
            }
            String string = AbstractExporter.getExtension(file);
            if (string != null) {
                return string.equals("jpg");
            }
            return false;
        }

        public String toString() {
            return Messages.getString("ImageExporter.JPGImages");
        }
    }

    private class PNGFileFilter
    implements URLFilter {
        private PNGFileFilter() {
        }

        public boolean accept(URL uRL) {
            File file = new File(uRL.getPath());
            if (file.isDirectory()) {
                return true;
            }
            String string = AbstractExporter.getExtension(file);
            if (string != null) {
                return string.equals("png");
            }
            return false;
        }

        public String toString() {
            return Messages.getString("ImageExporter.PNGImages");
        }
    }
}

