/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.printing;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.swing.JDialog;
import oracle.dbtools.crest.swingui.printing.SwingComponentPrinter;
import oracle.dbtools.crest.util.logging.Logger;

public class DesignPrintModule {
    private SwingComponentPrinter printer = null;
    private static final Logger LOGGER = new Logger(DesignPrintModule.class);

    public String[] connect() {
        this.disconnect();
        System.gc();
        ArrayList arrayList = new ArrayList();
        this.initialize(arrayList);
        return arrayList.toArray(new String[0]);
    }

    protected void initialize(Collection collection) {
        String string = "oracle.dbtools.crest.swingui.printing.SwingComponentAdapter";
        try {
            Class<?> clazz = Class.forName(string);
            if (clazz != null) {
                this.printer = (SwingComponentPrinter)clazz.newInstance();
            } else {
                collection.add("created null instance");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            collection.add("Check if printclasses are in classpath");
            collection.add(classNotFoundException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            collection.add("Can not instantiate printer implementation");
            collection.add(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            collection.add("Can not access constructor for printer implementation");
            collection.add(illegalAccessException.getMessage());
        }
        catch (Throwable throwable) {
            LOGGER.error("Can not initialize DesignPrintModule: " + throwable);
        }
    }

    public void disconnect() {
        if (this.printer != null) {
            try {
                this.printer.getPreferences();
            }
            catch (IllegalStateException illegalStateException) {
                System.out.println("Error: DesignPrintView.disconnect");
            }
            this.printer.prepareGC();
            this.printer = null;
        }
    }

    public void setComponentToPrint(Component component, Dimension dimension) {
        this.printer.setComponentToPrint(component, dimension);
    }

    public Component getViewComponent() {
        return this.printer.getViewComponent();
    }

    public Component getButtonPanel() {
        return this.printer.getButtonPanel();
    }

    public void setDialog(JDialog jDialog) {
        this.printer.setDialog(jDialog);
    }

    public void setPreferences(Properties properties) {
        this.printer.setPreferences(properties);
    }

    public Properties getPreferences() {
        return this.printer.getPreferences();
    }
}

