/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.multidimensional;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Legend;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.TVDiagramView;
import oracle.dbtools.crest.swingui.TVLabel;
import oracle.dbtools.crest.swingui.TVLegend;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.multidimensional.ControllerMultidimensional;
import oracle.dbtools.crest.swingui.multidimensional.Messages;
import oracle.dbtools.crest.swingui.multidimensional.TVCube;
import oracle.dbtools.crest.swingui.multidimensional.TVDimension;
import oracle.dbtools.crest.swingui.multidimensional.TVLevel;
import oracle.dbtools.crest.swingui.multidimensional.TVLink;
import oracle.dbtools.crest.swingui.multidimensional.TVRaggedHLink;

public class DPVMultidimensional
extends DesignPartView {
    private static final Dimension TOPVIEW_SIZE = new Dimension(100, 100);
    public static final String MI_FACT_ENTITIES = Messages.getString("DPVMultidimensional.Entities");
    private ControllerMultidimensional controller;
    private int xdelta = 70;
    private int ydelta = 40;
    private int xcube = 10;
    private int xdimension = 100;
    private int xlevel = 150;
    private int ydimension = 10;
    private Map arrangedMap = new TreeMap();
    private JPopupMenu menu;
    private JCheckBoxMenuItem miAutoRoute;
    private JCheckBoxMenuItem miShowGrid;
    private JMenu detailsMenu;
    private JCheckBoxMenuItem miAllDetails;
    private JCheckBoxMenuItem miNameOnly;
    private JCheckBoxMenuItem miElements;
    private JCheckBoxMenuItem miKeys;
    private JCheckBoxMenuItem miShowLegend;
    private JMenuItem miDiagramColor;

    public DPVMultidimensional(ApplicationView applicationView, DesignPart designPart) {
        super(applicationView, designPart);
        this.controller = new ControllerMultidimensional(applicationView);
        this.controller.setName("Multidimensional");
        this.controller.setDesignPartView(this);
    }

    @Override
    public TopView createViewFor(DesignObject designObject) {
        return this.createTopViewFor(designObject);
    }

    @Override
    public AbstractController getController() {
        return this.controller;
    }

    public TopView createViewSynonim(DesignObject designObject) {
        AbstractMDObject abstractMDObject = (AbstractMDObject)designObject;
        TopView topView = abstractMDObject.getFirstViewForDPV(this);
        if (topView == null) {
            if (designObject instanceof Cube) {
                topView = new TVCube(this.getApplicationView(), this);
            } else if (designObject instanceof oracle.dbtools.crest.model.design.multidimensional.Dimension) {
                topView = new TVDimension(this.getApplicationView(), this);
            } else if (designObject instanceof Link) {
                topView = new TVLink(this.getApplicationView(), this);
            } else if (designObject instanceof Level) {
                topView = new TVLevel(this.getApplicationView(), this);
            } else if (designObject instanceof RaggedHLink) {
                topView = new TVRaggedHLink(this.getApplicationView(), this);
            }
        }
        if (topView != null) {
            topView.setModel(designObject);
            this.modelToView.put(designObject, topView);
            this.add(topView);
        }
        return topView;
    }

    public MultidimensionalDesign getMultidimensionalDesign() {
        return (MultidimensionalDesign)this.getDesignPart();
    }

    public void rearrangeDiagram(boolean bl) {
        Object object;
        Object object2;
        AbstractMDObject abstractMDObject;
        this.xdelta = 70;
        this.ydelta = 40;
        this.xcube = 10;
        this.xdimension = 100;
        this.xlevel = 150;
        this.ydimension = 10;
        this.arrangedMap.clear();
        if (bl) {
            this.resetSize();
        }
        Dimension dimension = this.getLargestDimension(this.getMultidimensionalDesign().getCubeSet().iterator());
        this.xdimension = this.xcube + dimension.width + 2 * this.xdelta;
        dimension = this.getLargestDimension(this.getMultidimensionalDesign().getDimensionSet().iterator());
        this.xlevel = this.xdimension + dimension.width + 2 * this.xdelta;
        Iterator iterator = this.getMultidimensionalDesign().getCubeSet().iterator();
        while (iterator.hasNext()) {
            abstractMDObject = (Cube)iterator.next();
            this.rearrangeCube((Cube)abstractMDObject);
        }
        iterator = this.getMultidimensionalDesign().getDimensionSet().iterator();
        while (iterator.hasNext()) {
            abstractMDObject = (oracle.dbtools.crest.model.design.multidimensional.Dimension)iterator.next();
            object2 = this.arrangedMap.get(abstractMDObject.getObjectID());
            if (object2 != null) continue;
            this.rearrangeDimension((oracle.dbtools.crest.model.design.multidimensional.Dimension)abstractMDObject);
            this.arrangedMap.put(abstractMDObject.getObjectID(), abstractMDObject);
        }
        iterator = this.getMultidimensionalDesign().getLevelSet().iterator();
        int n = this.xlevel;
        while (iterator.hasNext()) {
            object2 = (Level)iterator.next();
            object = this.arrangedMap.get(((ModelIDObject)object2).getObjectID());
            if (object != null) continue;
            this.positionObject((DesignObject)object2, n, this.ydimension);
            Rectangle rectangle = this.getDesObjBounds((DesignObject)object2);
            n = n + rectangle.width + this.xdelta;
            this.arrangedMap.put(((ModelIDObject)object2).getObjectID(), object2);
        }
        iterator = this.getMultidimensionalDesign().getLinkSet().iterator();
        while (iterator.hasNext()) {
            object2 = (Link)iterator.next();
            object = (TVLink)((Link)object2).getTopView();
            ((TVLink)object).getEdge().straightLine(false);
            object = null;
        }
        this.arrangedMap.clear();
    }

    private void resetSize() {
        ArrayList arrayList = new ArrayList();
        this.getMultidimensionalDesign().getCubeSet().addAllElementsTo(arrayList);
        this.getMultidimensionalDesign().getLevelSet().addAllElementsTo(arrayList);
        this.getMultidimensionalDesign().getDimensionSet().addAllElementsTo(arrayList);
        for (DesignObject designObject : arrayList) {
            this.resetSizeOf(designObject);
        }
    }

    private void resetSizeOf(DesignObject designObject) {
        TopView topView = ((AbstractMDObject)designObject).getFirstViewForDPV(this);
        if (topView != null) {
            Rectangle rectangle = topView.getCalculatedBounds();
            if (topView.getCellView() != null) {
                topView.getCellView().setNewBounds(new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
            } else {
                topView.setBounds(new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
            }
        }
    }

    private Dimension getLargestDimension(Iterator iterator) {
        int n = 0;
        int n2 = 0;
        while (iterator.hasNext()) {
            DesignObject designObject = (DesignObject)iterator.next();
            Object v = this.arrangedMap.get(designObject.getObjectID());
            if (v != null) continue;
            TopView topView = ((AbstractMDObject)designObject).getFirstViewForDPV(this);
            if (topView == null) {
                topView = designObject.getTopView();
            }
            if (topView == null) continue;
            Rectangle rectangle = topView.getCellView() != null ? topView.getCellView().getBounds().getBounds() : topView.getBounds();
            if (rectangle.height > n) {
                n = rectangle.height;
            }
            if (rectangle.width <= n2) continue;
            n2 = rectangle.width;
        }
        return new Dimension(n2, n);
    }

    private void rearrangeCube(Cube cube) {
        Object object2;
        int n = this.ydimension;
        for (Object object2 : cube.getDimensions()) {
            Object v = this.arrangedMap.get(((ModelIDObject)object2).getObjectID());
            if (v != null) continue;
            this.rearrangeDimension((oracle.dbtools.crest.model.design.multidimensional.Dimension)object2);
            this.arrangedMap.put(((ModelIDObject)object2).getObjectID(), object2);
        }
        object2 = this.getDesObjBounds(cube);
        if (n + ((Rectangle)object2).height > this.ydimension) {
            this.ydimension = n + ((Rectangle)object2).height + this.ydelta;
        } else {
            int n2 = n + (this.ydimension - n - this.ydelta) / 2;
            if (n2 + ((Rectangle)object2).height / 2 > this.ydimension) {
                n2 = this.ydimension - ((Rectangle)object2).height / 2;
            }
            n = n2 - ((Rectangle)object2).height / 2;
        }
        this.positionObject(cube, this.xcube, n);
        this.arrangedMap.put(cube.getObjectID(), cube);
    }

    private void rearrangeDimension(oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        Object object;
        int n = this.ydimension;
        Iterator iterator = dimension.getHierarchies().iterator();
        while (iterator.hasNext()) {
            object = (Hierarchy)iterator.next();
            Dimension dimension2 = this.getLargestDimension(((Hierarchy)object).getLevels().iterator());
            this.rearrangeHierarcy((Hierarchy)object);
            this.ydimension = this.ydimension + dimension2.height + this.ydelta;
        }
        object = this.getDesObjBounds(dimension);
        if (n + ((Rectangle)object).height > this.ydimension) {
            this.ydimension = n + ((Rectangle)object).height + this.ydelta;
        } else {
            int n2 = n + (this.ydimension - n - this.ydelta) / 2;
            if (n2 + ((Rectangle)object).height / 2 > this.ydimension) {
                n2 = this.ydimension - ((Rectangle)object).height / 2;
            }
            n = n2 - ((Rectangle)object).height / 2;
        }
        this.positionObject(dimension, this.xdimension, n);
        this.arrangedMap.put(dimension.getObjectID(), dimension);
    }

    private void rearrangeHierarcy(Hierarchy hierarchy) {
        Iterator iterator = hierarchy.getLevels().iterator();
        int n = this.xlevel;
        while (iterator.hasNext()) {
            Rectangle rectangle;
            Level level = (Level)iterator.next();
            Object v = this.arrangedMap.get(level.getObjectID());
            if (v == null) {
                this.positionObject(level, n, this.ydimension);
                rectangle = this.getDesObjBounds(level);
                if (rectangle == null) continue;
                n = n + rectangle.width + this.xdelta;
                this.arrangedMap.put(level.getObjectID(), level);
                continue;
            }
            rectangle = this.getDesObjBounds(level);
            n = n + rectangle.width + this.xdelta;
        }
    }

    private Rectangle getDesObjBounds(DesignObject designObject) {
        Rectangle rectangle = null;
        TopView topView = ((AbstractMDObject)designObject).getFirstViewForDPV(this);
        if (topView == null) {
            topView = designObject.getTopView();
        }
        if (topView != null) {
            rectangle = topView.getCellView() != null ? topView.getCellView().getBounds().getBounds() : topView.getBounds();
        }
        return rectangle;
    }

    private void positionObject(DesignObject designObject, int n, int n2) {
        Rectangle rectangle = this.getDesObjBounds(designObject);
        TopView topView = ((AbstractMDObject)designObject).getFirstViewForDPV(this);
        if (topView != null && rectangle != null) {
            if (topView.getCellView() != null) {
                topView.getCellView().setNewBounds(new Rectangle(n, n2, rectangle.width, rectangle.height));
            } else {
                topView.setBounds(new Rectangle(n, n2, rectangle.width, rectangle.height));
            }
        }
    }

    @Override
    public DesignPartView createSubordinateView(ApplicationView applicationView, DesignPart designPart) {
        return new DPVMultidimensional(this.getApplicationView(), this.getDesignPart());
    }

    @Override
    public TopView createTopViewFor(DesignObject designObject) {
        TopView topView = null;
        if (designObject instanceof Cube) {
            TVCube tVCube = new TVCube(this.getApplicationView(), this);
            tVCube.setModel(designObject);
            topView = tVCube;
            topView.setSize(new Dimension(TOPVIEW_SIZE));
        } else {
            if (designObject instanceof Note) {
                TVNote tVNote = new TVNote(this.getApplicationView(), this);
                tVNote.setModel(designObject);
                return tVNote;
            }
            if (designObject instanceof Legend) {
                TVLegend tVLegend = new TVLegend(this.getApplicationView(), this);
                tVLegend.setModel(designObject);
                return tVLegend;
            }
            if (designObject instanceof Level) {
                TVLevel tVLevel = new TVLevel(this.getApplicationView(), this);
                tVLevel.setModel(designObject);
                topView = tVLevel;
                Dimension dimension = new Dimension(170, 65);
                topView.setSize(dimension);
            } else if (designObject instanceof oracle.dbtools.crest.model.design.multidimensional.Dimension) {
                TVDimension tVDimension = new TVDimension(this.getApplicationView(), this);
                tVDimension.setModel(designObject);
                topView = tVDimension;
                Dimension dimension = new Dimension(80, 30);
                topView.setSize(dimension);
            } else if (designObject instanceof Link) {
                TVLink tVLink = new TVLink(this.getApplicationView(), this);
                tVLink.setModel(designObject);
                topView = tVLink;
                topView.setSize(new Dimension(TOPVIEW_SIZE));
            } else if (designObject instanceof RaggedHLink) {
                TVRaggedHLink tVRaggedHLink = new TVRaggedHLink(this.getApplicationView(), this);
                tVRaggedHLink.setModel(designObject);
                topView = tVRaggedHLink;
                topView.setSize(new Dimension(TOPVIEW_SIZE));
            } else if (designObject instanceof DiagramView) {
                TVDiagramView tVDiagramView = new TVDiagramView(this.getApplicationView(), this);
                tVDiagramView.setModel(designObject);
                topView = tVDiagramView;
                topView.setSize(new Dimension(TOPVIEW_SIZE));
            } else if (designObject instanceof Label) {
                TVLabel tVLabel = new TVLabel(this.getApplicationView(), this);
                tVLabel.setModel(designObject);
                topView = tVLabel;
                topView.setSize(new Dimension(TOPVIEW_SIZE));
            } else {
                return null;
            }
        }
        this.registerForTreemodel(topView);
        this.setDirty(true);
        return topView;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        this.menu = new JPopupMenu();
        if (this.isEditable()) {
            this.addUndoRedo(this.menu);
            this.menu.addSeparator();
            this.miAutoRoute = new JCheckBoxMenuItem(MI_AUTO_ROUTE);
            this.miAutoRoute.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DPVMultidimensional.this.setAutoRoute(!DPVMultidimensional.this.isAutoRoute());
                    DPVMultidimensional.this.getWorkSpace().updateSettings();
                }
            });
            this.menu.add(this.miAutoRoute);
            this.menu.addSeparator();
            this.menu.add(this.getStraightenLinesItem());
            this.menu.addSeparator();
            this.menu.add(this.getDetailsMenu());
            this.menu.addSeparator();
            this.miDiagramColor = this.menu.add(new AbstractAction(MI_DIAGRAM_COLOR){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DPVMultidimensional.this.changeDiagramColor();
                }
            });
            this.miDiagramColor.setEnabled(false);
            this.menu.addSeparator();
        }
        this.menu.add(this.getGoToDiagramMenu());
        this.menu.addSeparator();
        this.menu.add(this.getShowMenu());
        this.menu.addSeparator();
        this.menu.add(DataModelerAddin.findOrCreateVersioningMenu(this.menu));
        this.menu.addSeparator();
        this.menu.add(new AbstractAction(MI_PROPERTIES){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVMultidimensional.this.getDesignPart().showPropertyDialog();
            }
        });
        if (this.isEditable()) {
            this.miAutoRoute.setSelected(this.isAutoRoute());
            this.miAllDetails.setSelected(this.showAllDetails());
            this.miNameOnly.setSelected(this.isShowNamesOnly());
            this.miElements.setSelected(this.showElements());
            this.miKeys.setSelected(this.showKeys());
            this.miDiagramColor.setEnabled(true);
        }
        return this.menu;
    }

    public JMenu getShowMenu() {
        JMenu jMenu = new JMenu(MenuUtils.getMnemonicStr(MI_SHOW));
        jMenu.setMnemonic(MenuUtils.getMnemonicKey(MI_SHOW));
        this.miShowGrid = new JCheckBoxMenuItem(MI_SHOW_GRID);
        this.miShowGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVMultidimensional.this.setShowGrid(!DPVMultidimensional.this.showGrid());
            }
        });
        jMenu.add(this.miShowGrid);
        jMenu.addSeparator();
        this.miShowLegend = new JCheckBoxMenuItem(MI_SHOW_LEGEND);
        this.miShowLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVMultidimensional.this.setShowLegend(!DPVMultidimensional.this.showLegend());
            }
        });
        jMenu.add(this.miShowLegend);
        this.miShowGrid.setSelected(this.showGrid());
        this.miShowLegend.setSelected(this.showLegend());
        return jMenu;
    }

    @Override
    public JMenu getDetailsMenu() {
        this.detailsMenu = new JMenu(MenuUtils.getMnemonicStr(MI_DETAILS));
        this.detailsMenu.setMnemonic(MenuUtils.getMnemonicKey(MI_DETAILS));
        this.miAllDetails = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_ALL_DETAILS));
        this.miAllDetails.setMnemonic(MenuUtils.getMnemonicKey(MI_ALL_DETAILS));
        this.miNameOnly = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_NAMES_ONLY));
        this.miNameOnly.setMnemonic(MenuUtils.getMnemonicKey(MI_NAMES_ONLY));
        this.miElements = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_ELEMENTS));
        this.miElements.setMnemonic(MenuUtils.getMnemonicKey(MI_ELEMENTS));
        this.miKeys = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_FACT_ENTITIES));
        this.miKeys.setMnemonic(MenuUtils.getMnemonicKey(MI_FACT_ENTITIES));
        this.miAllDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVMultidimensional.this.setShowAllDetails(true);
                DPVMultidimensional.this.setShowNamesOnly(false);
                DPVMultidimensional.this.setShowElements(false);
                DPVMultidimensional.this.setShowDatatype(false);
                DPVMultidimensional.this.setShowKeys(false);
                DPVMultidimensional.this.getWorkSpace().invalidate();
                DPVMultidimensional.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miAllDetails);
        this.detailsMenu.addSeparator();
        this.miNameOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVMultidimensional.this.setShowNamesOnly(true);
                DPVMultidimensional.this.setShowAllDetails(false);
                DPVMultidimensional.this.setShowNamesOnly(true);
                DPVMultidimensional.this.setShowElements(false);
                DPVMultidimensional.this.setShowDatatype(false);
                DPVMultidimensional.this.setShowKeys(false);
                DPVMultidimensional.this.getWorkSpace().invalidate();
                DPVMultidimensional.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miNameOnly);
        this.miKeys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVMultidimensional.this.setShowKeys(!DPVMultidimensional.this.showKeys());
                if (DPVMultidimensional.this.showKeys()) {
                    DPVMultidimensional.this.setShowAllDetails(false);
                    DPVMultidimensional.this.setShowNamesOnly(false);
                } else if (!DPVMultidimensional.this.showElements()) {
                    DPVMultidimensional.this.setShowAllDetails(true);
                }
                DPVMultidimensional.this.getWorkSpace().invalidate();
                DPVMultidimensional.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miKeys);
        this.miElements.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVMultidimensional.this.setShowElements(!DPVMultidimensional.this.showElements());
                if (!DPVMultidimensional.this.showElements()) {
                    DPVMultidimensional.this.setShowDatatype(false);
                    if (!DPVMultidimensional.this.showKeys()) {
                        DPVMultidimensional.this.setShowAllDetails(true);
                    }
                } else {
                    DPVMultidimensional.this.setShowAllDetails(false);
                    DPVMultidimensional.this.setShowNamesOnly(false);
                }
                DPVMultidimensional.this.getWorkSpace().invalidate();
                DPVMultidimensional.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miElements);
        this.miAllDetails.setSelected(this.showAllDetails());
        this.miNameOnly.setSelected(this.isShowNamesOnly());
        this.miElements.setSelected(this.showElements());
        this.miKeys.setSelected(this.showKeys());
        return this.detailsMenu;
    }

    @Override
    public boolean isStorable() {
        return false;
    }

    public DesignPartView getCompactDiagram() {
        return this.getMultidimensionalDesign().getCompactDiagram();
    }

    public void setCompactDiagram(DesignPartView designPartView) {
    }
}

