/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.multidimensional;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GlassComponent;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.PointsEnteredCallback;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.multidimensional.MDDiagramCell;
import oracle.dbtools.crest.swingui.multidimensional.AbstractMDTV;
import oracle.dbtools.crest.swingui.multidimensional.DPVCompactMultidimentional;
import oracle.dbtools.crest.swingui.multidimensional.Messages;
import oracle.dbtools.crest.swingui.multidimensional.TVLink;
import oracle.dbtools.crest.swingui.multidimensional.TVRaggedHLink;

public class ControllerMultidimensional
extends AbstractController {
    private final String[] OBJECT_MDD_PATH = new String[]{AbstractController.OBJECT_CAPTION, AbstractController.MDD_CAPTION};
    private DesignPartView dpv = null;
    private Select select;
    private ZoomIn zoomIn;
    private ZoomOut zoomOut;
    private FitScreen fitScreen;
    private ActualSize actualSize;
    private Search search;
    private MDObjectCollector collector = null;
    private NewCube newCube;
    private NewDimension newDimension;
    private NewLevel newLevel;
    private NewLink newLink;
    private NewRaggedHLink newRaggedHLink;
    private NewNote newNote;
    private Delete delete;

    public ControllerMultidimensional(ApplicationView applicationView) {
        super(applicationView);
    }

    public JMenu getObjectMultidimensionalMenu() {
        return this.getApplicationView().getControllerSet().getMenuStructure().get(this.OBJECT_MDD_PATH);
    }

    @Override
    public void initializeActions() {
        if (this.isEditable()) {
            this.select = new Select();
            this.newCube = new NewCube();
            this.newDimension = new NewDimension();
            this.newLevel = new NewLevel();
            this.newLink = new NewLink();
            this.newRaggedHLink = new NewRaggedHLink();
            this.newNote = new NewNote();
            this.delete = new Delete();
            this.add(this.select);
            this.add(this.newCube);
            this.add(this.newDimension);
            this.add(this.newLevel);
            this.add(this.newLink);
            this.add(this.newRaggedHLink);
            this.add(this.newNote);
            this.add(this.delete);
        }
        this.zoomIn = new ZoomIn();
        this.add(this.zoomIn);
        this.zoomOut = new ZoomOut();
        this.add(this.zoomOut);
        this.fitScreen = new FitScreen();
        this.add(this.fitScreen);
        this.actualSize = new ActualSize();
        this.add(this.actualSize);
        this.search = new Search();
        this.add(this.search);
    }

    public FitScreen getFitScreen() {
        return this.fitScreen;
    }

    public ActualSize getActualSize() {
        return this.actualSize;
    }

    @Override
    public MDBAction getSearch() {
        return this.search;
    }

    public ZoomIn getZoomIn() {
        return this.zoomIn;
    }

    public ZoomOut getZoomOut() {
        return this.zoomOut;
    }

    @Override
    public String getToolBarName() {
        return Messages.getString("ControllerMultidimensional.Multidimensional");
    }

    @Override
    public DesignPartView getDesignPartView() {
        return this.dpv;
    }

    @Override
    public void setDesignPartView(DesignPartView designPartView) {
        this.dpv = designPartView;
    }

    @Override
    public void updateActions() {
        boolean bl = true;
        if (this.getDesign().isLoadFromDB() && this.getDesignPartView().getDesignPart().getRepositoryOID() != null) {
            bl = this.getDesignPartView().getDesignPart().isCheckedOutByMe();
        }
        this.getDesignPartView().getWorkSpace().updateReadOnlyStatus();
        this.setEnabled(this.newCube, bl);
        this.setEnabled(this.newDimension, bl);
        this.setEnabled(this.newLevel, bl);
        this.setEnabled(this.newLink, bl);
        this.setEnabled(this.newRaggedHLink, bl);
        this.setEnabled(this.newNote, bl);
        this.setEnabled(this.delete, bl);
    }

    public class MDObjectCollector
    implements PointsEnteredCallback {
        private GlassComponent glassComp = null;
        private boolean raggedHLink = false;
        boolean rolePlaying;

        public MDObjectCollector() {
            this.startCollecting();
        }

        public void startCollecting() {
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().clearSelection();
            this.collect();
        }

        public MDObjectCollector(boolean bl) {
            this.raggedHLink = bl;
            this.startCollecting();
        }

        private void collect() {
            this.glassComp = ControllerMultidimensional.this.getDesignPartView().getGlassPane();
            this.glassComp.getPoints(this, 2);
        }

        public void stopWaiting() {
            if (this.glassComp != null) {
                this.glassComp.stopAll();
            }
        }

        @Override
        public void rectangleSelected(Rectangle rectangle) {
        }

        @Override
        public void pointSelected(Point point) {
        }

        @Override
        public void pointsSelected(Point[] pointArray) {
            this.rolePlaying = false;
            AbstractMDTV abstractMDTV = this.getTVEntityFor(pointArray[0]);
            AbstractMDTV abstractMDTV2 = this.getTVEntityFor(pointArray[1]);
            ArrayList<String> arrayList = new ArrayList<String>();
            if (abstractMDTV == null) {
                arrayList.add(Messages.getString("ControllerMultidimensional.NoSourceObjectSelected"));
            }
            if (abstractMDTV2 == null) {
                arrayList.add(Messages.getString("ControllerMultidimensional.NoDestinationObjectSelected"));
            }
            if (abstractMDTV != null && abstractMDTV == abstractMDTV2) {
                arrayList.add(Messages.getString("ControllerMultidimensional.SourceAndTargetObjectsAreEquals"));
            }
            if (this.raggedHLink) {
                if (arrayList.size() == 0) {
                    AbstractMDObject abstractMDObject = (AbstractMDObject)abstractMDTV.getModel();
                    AbstractMDObject abstractMDObject2 = (AbstractMDObject)abstractMDTV2.getModel();
                    if (abstractMDObject2 instanceof Level && abstractMDObject instanceof Level) {
                        if (((Level)abstractMDObject).getFirstRaggedHLinkTo((Level)abstractMDObject2) != null) {
                            arrayList.add(Messages.getString("ControllerMultidimensional.ThereIsRaggedHierarchyLink"));
                        }
                        if (abstractMDObject.getFirstLinkToTarget(abstractMDObject2) != null) {
                            arrayList.add(Messages.getString("ControllerMultidimensional.ThereIsRollupLlink"));
                        }
                    } else {
                        arrayList.add(Messages.getString("ControllerMultidimensional.RaggedHierarchyLinkDrawnBetweenLevels"));
                    }
                    if (arrayList.size() == 0) {
                        this.createRaggedHLink(abstractMDTV, abstractMDTV2);
                    } else {
                        JOptionPane.showMessageDialog(ControllerMultidimensional.this.getDesignPartView(), arrayList.toArray(), Messages.getString("ControllerMultidimensional.NewLink"), 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(ControllerMultidimensional.this.getDesignPartView(), arrayList.toArray(), Messages.getString("ControllerMultidimensional.NewLink"), 0);
                }
            } else if (arrayList.size() == 0) {
                AbstractMDObject abstractMDObject = (AbstractMDObject)abstractMDTV.getModel();
                AbstractMDObject abstractMDObject3 = (AbstractMDObject)abstractMDTV2.getModel();
                if (abstractMDObject instanceof Cube && abstractMDObject3 instanceof Dimension) {
                    if (abstractMDObject.getFirstLinkToTarget(abstractMDObject3) != null) {
                        int n = JOptionPane.showConfirmDialog(ControllerMultidimensional.this.getDesignPartView(), Messages.getString("ControllerMultidimensional.ThereIsDimensionUsage"));
                        if (n > 0) {
                            ControllerMultidimensional.this.select.actionPerformed(null);
                            return;
                        }
                        abstractMDObject.getFirstLinkToTarget(abstractMDObject3).getRollupLink().setRolePlaying(true);
                        this.rolePlaying = true;
                    }
                } else if (abstractMDObject.getFirstLinkToTarget(abstractMDObject3) != null) {
                    arrayList.add(Messages.getString("ControllerMultidimensional.OneLinkBetweenObjects"));
                }
                if (abstractMDObject3 instanceof Cube) {
                    arrayList.add(Messages.getString("ControllerMultidimensional.CubeCouldntBeTargetObject"));
                }
                if (abstractMDObject3 instanceof Dimension && abstractMDObject instanceof Level) {
                    arrayList.add(Messages.getString("ControllerMultidimensional.InpossibleLinkLD"));
                }
                if (abstractMDObject3 instanceof Dimension && abstractMDObject instanceof Dimension) {
                    arrayList.add(Messages.getString("ControllerMultidimensional.InpossibleLinkDD"));
                }
                if (abstractMDObject instanceof Cube && abstractMDObject3 instanceof Level) {
                    arrayList.add(Messages.getString("ControllerMultidimensional.InpossibleLinkCL"));
                }
                if (abstractMDObject3 instanceof Level && abstractMDObject instanceof Level && ((Level)abstractMDObject).getFirstRaggedHLinkTo((Level)abstractMDObject3) != null) {
                    arrayList.add(Messages.getString("ControllerMultidimensional.15"));
                }
                if (abstractMDObject instanceof Level && ((Level)abstractMDObject).isValueBasedHierarchy()) {
                    String string = ((Level)abstractMDObject).getName();
                    arrayList.add(MessageFormat.format(Messages.getString("ControllerMultidimensional.Level"), string));
                }
                if (abstractMDObject3 instanceof Level && !(abstractMDObject instanceof Dimension) && ((Level)abstractMDObject3).isValueBasedHierarchy()) {
                    String string = ((Level)abstractMDObject3).getName();
                    arrayList.add(MessageFormat.format(Messages.getString("ControllerMultidimensional.Level"), string));
                }
                if (arrayList.size() == 0) {
                    Link link = this.createLink(abstractMDTV, abstractMDTV2);
                    if (link.getRollupLink() != null) {
                        link.getRollupLink().setRolePlaying(this.rolePlaying);
                    }
                } else {
                    JOptionPane.showMessageDialog(ControllerMultidimensional.this.getDesignPartView(), arrayList.toArray(), Messages.getString("ControllerMultidimensional.NewRaggedHierarchyLink"), 0);
                }
            } else {
                JOptionPane.showMessageDialog(ControllerMultidimensional.this.getDesignPartView(), arrayList.toArray(), Messages.getString("ControllerMultidimensional.NewLink"), 0);
            }
            this.startCollecting();
        }

        private AbstractMDTV getTVEntityFor(Point point) {
            Object object = ControllerMultidimensional.this.getDesignPartView().getWorkSpace().getFirstCellForLocation(point.getX(), point.getY());
            if (object != null && object instanceof MDDiagramCell) {
                return (AbstractMDTV)((MDDiagramCell)object).getTopView();
            }
            return null;
        }

        private Link createLink(AbstractMDTV abstractMDTV, AbstractMDTV abstractMDTV2) {
            ApplicationView.log(Messages.getString("ControllerMultidimensional.CreateLink"));
            Link link = ControllerMultidimensional.this.getDesign().getMultidimensionalDesign().createLink();
            link.setSourceTV(abstractMDTV);
            link.setTargetTV(abstractMDTV2);
            DesignPartView designPartView = ControllerMultidimensional.this.getDesignPartView();
            ((TVLink)link.getViewFor(designPartView)).addConnection();
            DesignPartView designPartView2 = designPartView instanceof DPVCompactMultidimentional ? ControllerMultidimensional.this.getDesign().getMultidimensionalDesign().getMainView() : ControllerMultidimensional.this.getDesign().getMultidimensionalDesign().getCompactDiagram();
            DesignObject designObject = abstractMDTV.getModel();
            DesignObject designObject2 = abstractMDTV2.getModel();
            AbstractMDTV abstractMDTV3 = (AbstractMDTV)designObject.getFirstViewForDPV(designPartView2);
            AbstractMDTV abstractMDTV4 = (AbstractMDTV)designObject2.getFirstViewForDPV(designPartView2);
            link.setSourceTV(abstractMDTV3);
            link.setTargetTV(abstractMDTV4);
            if (designPartView instanceof DPVCompactMultidimentional) {
                ((TVLink)link.getViewFor(designPartView2)).addConnection();
            }
            return link;
        }

        private void createRaggedHLink(AbstractMDTV abstractMDTV, AbstractMDTV abstractMDTV2) {
            ApplicationView.log(Messages.getString("ControllerMultidimensional.CreateRaggedHLink"));
            RaggedHLink raggedHLink = ControllerMultidimensional.this.getDesign().getMultidimensionalDesign().createRaggedHLink();
            raggedHLink.setSourceTV(abstractMDTV);
            raggedHLink.setTargetTV(abstractMDTV2);
            DesignPartView designPartView = ControllerMultidimensional.this.getDesignPartView();
            ((TVRaggedHLink)raggedHLink.getViewFor(designPartView)).addConnection();
            DesignPartView designPartView2 = designPartView instanceof DPVCompactMultidimentional ? ControllerMultidimensional.this.getDesign().getMultidimensionalDesign().getMainView() : ControllerMultidimensional.this.getDesign().getMultidimensionalDesign().getCompactDiagram();
            DesignObject designObject = abstractMDTV.getModel();
            DesignObject designObject2 = abstractMDTV2.getModel();
            AbstractMDTV abstractMDTV3 = (AbstractMDTV)designObject.getFirstViewForDPV(designPartView2);
            AbstractMDTV abstractMDTV4 = (AbstractMDTV)designObject2.getFirstViewForDPV(designPartView2);
            raggedHLink.setSourceTV(abstractMDTV3);
            raggedHLink.setTargetTV(abstractMDTV4);
            if (designPartView instanceof DPVCompactMultidimentional) {
                ((TVRaggedHLink)raggedHLink.getViewFor(designPartView2)).addConnection();
            }
        }

        @Override
        public Component getTargetCoordinateSpace() {
            return ControllerMultidimensional.this.getDesignPartView().getWorkSpace();
        }
    }

    class Search
    extends MDBAction {
        private Search() {
            super(MenuUtils.getMnemonicStr(AbstractController.SEARCH_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("SEARCH_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SEARCH_CAPTION));
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public boolean addToolbarSeparator() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerMultidimensional.this.getApplicationView().search(4);
        }
    }

    class ActualSize
    extends MDBAction {
        private ActualSize() {
            super(MenuUtils.getMnemonicStr(AbstractController.ACTUAL_SIZE_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("ACTUAL_SIZE_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ACTUAL_SIZE_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView = ControllerMultidimensional.this.getApplicationView().getCurrentDPV();
            designPartView.actualSize();
        }
    }

    class FitScreen
    extends MDBAction {
        private FitScreen() {
            super(MenuUtils.getMnemonicStr(AbstractController.FIT_SCREEN_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("FIT_SCREEN_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.FIT_SCREEN_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView = ControllerMultidimensional.this.getApplicationView().getCurrentDPV();
            designPartView.fitScreen();
        }
    }

    class ZoomOut
    extends MDBAction {
        private ZoomOut() {
            super(MenuUtils.getMnemonicStr(AbstractController.ZOOM_OUT_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("ZOOM_OUT_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ZOOM_OUT_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView = ControllerMultidimensional.this.getApplicationView().getCurrentDPV();
            designPartView.zoomOut();
        }
    }

    class ZoomIn
    extends MDBAction {
        private ZoomIn() {
            super(MenuUtils.getMnemonicStr(AbstractController.ZOOM_IN_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("ZOOM_IN_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ZOOM_IN_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addToolbarSeparator() {
            return ControllerMultidimensional.this.isEditable();
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView = ControllerMultidimensional.this.getApplicationView().getCurrentDPV();
            designPartView.zoomIn();
        }
    }

    class Delete
    extends MDBAction {
        private Delete() {
            super(MenuUtils.getMnemonicStr(AbstractController.DELETE_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("DELETE_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMenuPath(ControllerMultidimensional.this.OBJECT_MDD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DELETE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerMultidimensional.this.collector != null) {
                ControllerMultidimensional.this.collector.stopWaiting();
            }
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setDrawnObjectID(6);
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setCursor(Diagram.DELETE_CURSOR);
            ControllerMultidimensional.this.updateToolbar(this);
        }
    }

    class NewNote
    extends MDBAction {
        private NewNote() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_NOTE_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("NOTE_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMenuPath(ControllerMultidimensional.this.OBJECT_MDD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_NOTE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerMultidimensional.this.collector != null) {
                ControllerMultidimensional.this.collector.stopWaiting();
            }
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setDrawnObjectID(5);
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerMultidimensional.this.updateToolbar(this);
        }
    }

    class NewRaggedHLink
    extends MDBAction {
        private NewRaggedHLink() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_RAGGED_H_LINK_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("RAGGED_LINK_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMenuPath(ControllerMultidimensional.this.OBJECT_MDD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_RAGGED_H_LINK_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setDrawnObjectID(16);
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerMultidimensional.this.updateToolbar(this);
            if (ControllerMultidimensional.this.collector != null) {
                ControllerMultidimensional.this.collector.stopWaiting();
            }
            ControllerMultidimensional.this.collector = new MDObjectCollector(true);
        }
    }

    class NewLink
    extends MDBAction {
        private NewLink() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_LINK_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("LINK_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMenuPath(ControllerMultidimensional.this.OBJECT_MDD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_LINK_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setDrawnObjectID(14);
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerMultidimensional.this.updateToolbar(this);
            if (ControllerMultidimensional.this.collector != null) {
                ControllerMultidimensional.this.collector.stopWaiting();
            }
            ControllerMultidimensional.this.collector = new MDObjectCollector();
        }
    }

    class NewDimension
    extends MDBAction {
        private NewDimension() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_DIMENSION_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("DIMENSION_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMenuPath(ControllerMultidimensional.this.OBJECT_MDD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_DIMENSION_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerMultidimensional.this.collector != null) {
                ControllerMultidimensional.this.collector.stopWaiting();
            }
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setDrawnObjectID(13);
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerMultidimensional.this.updateToolbar(this);
        }
    }

    class NewLevel
    extends MDBAction {
        private NewLevel() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_LEVEL_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("LEVEL_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMenuPath(ControllerMultidimensional.this.OBJECT_MDD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_LEVEL_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerMultidimensional.this.collector != null) {
                ControllerMultidimensional.this.collector.stopWaiting();
            }
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setDrawnObjectID(12);
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerMultidimensional.this.updateToolbar(this);
        }
    }

    class NewCube
    extends MDBAction {
        private NewCube() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_CUBE_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("CUBE_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMenuPath(ControllerMultidimensional.this.OBJECT_MDD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_CUBE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerMultidimensional.this.collector != null) {
                ControllerMultidimensional.this.collector.stopWaiting();
            }
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setDrawnObjectID(11);
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerMultidimensional.this.updateToolbar(this);
        }
    }

    class Select
    extends MDBAction {
        private Select() {
            super(MenuUtils.getMnemonicStr(AbstractController.SELECT_CAPTION), ControllerMultidimensional.this.getConfiguration().getIcon("SELECT_ICON", ControllerMultidimensional.this.getPreferredIconSize()));
            this.setMenuPath(ControllerMultidimensional.this.OBJECT_MDD_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SELECT_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerMultidimensional.this.collector != null) {
                ControllerMultidimensional.this.collector.stopWaiting();
            }
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setDrawnObjectID(-1);
            ControllerMultidimensional.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(0));
            ControllerMultidimensional.this.updateToolbar(this);
        }
    }
}

