/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.logical;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.placeholder.PlaceHolder;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.ModelPropertiesDialogEx;
import oracle.dbtools.crest.swingui.logical.ControllerLogical;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.logical.Messages;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVEntityView;
import oracle.dbtools.crest.swingui.logical.TVInheritanceRelation;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.swingui.relational.TVView;

public class DPVLogicalSubView
extends DPVLogical {
    private AbstractController controller;
    private DesignObjectCollection tvEntities = new DesignObjectCollection(true);
    private DesignObjectCollection tvViews = new DesignObjectCollection(true);
    private DesignObjectCollection tvRelations = new DesignObjectCollection(true);
    private DesignObjectCollection tvInhRelations = new DesignObjectCollection(true);

    public DPVLogicalSubView(ApplicationView applicationView, DesignPart designPart) {
        super(applicationView, designPart);
        ((LogicalDesign)designPart).getEntitySet().addSetListener(this.tvEntities);
        ((LogicalDesign)designPart).getEntityViewSet().addSetListener(this.tvViews);
        ((LogicalDesign)designPart).getRelationSet().addSetListener(this.tvRelations);
        ((LogicalDesign)designPart).getInheritanceRelationSet().addSetListener(this.tvInhRelations);
        this.controller = new ControllerLogical(applicationView);
        this.controller.setName("Logical_SubView");
        this.controller.setDesignPartView(this);
        this.tvEntities.setElementDescriptor(Entity.class);
        this.tvEntities.setName(Messages.getString("DPVLogicalSubView.Entities"));
        this.tvViews.setElementDescriptor(EntityView.class);
        this.tvViews.setName(Messages.getString("DPVLogicalSubView.Views"));
        this.tvRelations.setElementDescriptor(Relation.class);
        this.tvRelations.setName(Messages.getString("DPVLogicalSubView.Relations"));
        this.tvInhRelations.setElementDescriptor(InheritanceRelation.class);
        this.tvInhRelations.setName(Messages.getString("DPVLogicalSubView.Hierarchies"));
    }

    @Override
    public void clearDPV() {
        ((LogicalDesign)this.getDesignPart()).getEntitySet().removeSetListener(this.tvEntities);
        ((LogicalDesign)this.getDesignPart()).getEntityViewSet().removeSetListener(this.tvViews);
        ((LogicalDesign)this.getDesignPart()).getRelationSet().removeSetListener(this.tvRelations);
        ((LogicalDesign)this.getDesignPart()).getInheritanceRelationSet().removeSetListener(this.tvInhRelations);
        super.clearDPV();
    }

    @Override
    public void sortCollections() {
        this.tvEntities.sort();
        this.tvViews.sort();
        this.tvRelations.sort();
        this.tvInhRelations.sort();
    }

    @Override
    public void objectAdded(DesignPart designPart, DesignObject designObject) {
        if (ApplicationView.loading || !this.isCurrentDPV()) {
            return;
        }
        TopView topView = this.getViewFor(designObject);
        if (topView == null) {
            this.addViewFor(designObject);
        }
    }

    @Override
    public TopView createViewFor(DesignObject designObject) {
        if (ApplicationView.loading || !this.isCurrentDPV()) {
            return null;
        }
        return this.createTopViewFor(designObject);
    }

    @Override
    public int getNumberOfChildren() {
        return 5;
    }

    @Override
    public ModelObject getChild(int n) {
        switch (n) {
            case 0: {
                return this.tvEntities;
            }
            case 1: {
                return this.tvViews;
            }
            case 2: {
                return this.tvRelations;
            }
            case 3: {
                return this.tvInhRelations;
            }
            case 4: {
                return this.getDisplays();
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if (modelObject == this.tvEntities) {
            return 0;
        }
        if (modelObject == this.tvViews) {
            return 1;
        }
        if (modelObject == this.tvRelations) {
            return 2;
        }
        if (modelObject == this.tvInhRelations) {
            return 3;
        }
        if (modelObject == this.getDisplays()) {
            return 4;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public AbstractController getController() {
        return this.controller;
    }

    @Override
    public void setPlaceHolder(PlaceHolder placeHolder) {
        super.setPlaceHolder(placeHolder);
        this.tvEntities.setParent(this.getPlaceHolder());
        this.tvViews.setParent(this.getPlaceHolder());
        this.tvRelations.setParent(this.getPlaceHolder());
        this.tvInhRelations.setParent(this.getPlaceHolder());
        this.getDisplays().setParent(this.getPlaceHolder());
    }

    @Override
    public boolean isMainDiagram() {
        return false;
    }

    @Override
    public void registerForTreemodel(TopView topView) {
        DesignObjectPlaceHolder designObjectPlaceHolder = new DesignObjectPlaceHolder(topView.getModel().getDesignPart(), topView.getModel());
        designObjectPlaceHolder.setTopView(topView);
        if (topView instanceof TVEntity && !this.tvEntities.containsPlaceHolderFor(topView.getModel())) {
            this.tvEntities.add(designObjectPlaceHolder);
        } else if (topView instanceof TVEntityView && !this.tvViews.containsPlaceHolderFor(topView.getModel())) {
            this.tvViews.add(designObjectPlaceHolder);
        } else if (topView instanceof TVInheritanceRelation && !this.tvInhRelations.containsPlaceHolderFor(topView.getModel())) {
            this.tvInhRelations.add(designObjectPlaceHolder);
        } else if (topView instanceof TVRelation && !this.tvRelations.containsPlaceHolderFor(topView.getModel())) {
            this.tvRelations.add(designObjectPlaceHolder);
        }
        if (this.getViewFor(topView.getModel()) == null) {
            this.modelToView.put(topView.getModel(), topView);
        }
    }

    @Override
    public void unregisterFromTreemodel(TopView topView) {
        if (topView != null) {
            this.unregisterTopView(topView);
            DesignObject designObject = topView.getModel();
            TopView topView2 = this.getFirstViewFor(designObject);
            if (topView2 == null) {
                if (topView instanceof TVEntity) {
                    this.tvEntities.removePlaceHolderFor(designObject);
                }
                if (topView instanceof TVView) {
                    this.tvViews.removePlaceHolderFor(designObject);
                }
                if (topView instanceof TVInheritanceRelation) {
                    this.tvInhRelations.removePlaceHolderFor(designObject);
                }
                if (topView instanceof TVRelation) {
                    this.tvRelations.removePlaceHolderFor(designObject);
                }
            }
        }
    }

    public Collection getTVEnities() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        for (TopView topView : this.topViews) {
            if (!(topView instanceof TVEntity)) continue;
            arrayList.add(topView);
        }
        return arrayList;
    }

    @Override
    public Collection getTVEntityViews() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        for (TopView topView : this.topViews) {
            if (!(topView instanceof TVEntityView)) continue;
            arrayList.add(topView);
        }
        return arrayList;
    }

    public Collection getTVRelations() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        for (TopView topView : this.topViews) {
            if (!(topView instanceof TVRelation)) continue;
            arrayList.add(topView);
        }
        return arrayList;
    }

    public void rearrangeDiagram() {
        int n = 20;
        int n2 = 20;
        int n3 = 35;
        int n4 = 25;
        int n5 = 0;
        Collection collection = this.getTVEnities();
        float f = (float)Math.sqrt(collection.size());
        long l = (int)f;
        if (Math.sqrt(f * f) != (double)f) {
            ++l;
        }
        ++l;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ++n5;
            TopView topView = (TopView)iterator.next();
            Dimension dimension = this.getEntitySize((Entity)topView.getModel());
            n3 = dimension.width;
            n4 = Math.max(dimension.height, n4);
            if (topView.getCellView() != null) {
                topView.getCellView().setNewBounds(new Rectangle(new Point(n, n2), dimension));
            } else {
                topView.setBounds(new Rectangle(new Point(n, n2), dimension));
            }
            n = n + n3 + 50;
            if ((long)n5 != l) continue;
            n5 = 0;
            n = 20;
            n2 = n2 + n4 + 50;
            n4 = 25;
        }
    }

    private Dimension getEntitySize(Entity entity) {
        int n;
        int n2 = 35;
        int n3 = 25;
        int n4 = 0;
        StructuredType structuredType = null;
        if (entity.isBST() && entity.getTypeSubstitution() != null) {
            structuredType = entity.getBasedOnStructuredType();
            if (structuredType != null) {
                n4 = structuredType.getElements().length;
            }
        } else {
            n4 = entity.getElements().length;
        }
        n3 += n4 * 14;
        if (entity.getKeys().length > 0 && !this.allKeysAreFK(entity.getKeys())) {
            n3 += 4;
            for (n = 0; n < entity.getKeys().length; ++n) {
                if (entity.getKeys()[n].isFK()) continue;
                n3 += 14;
            }
        }
        n = entity.getName().length() * 6;
        int n5 = 1;
        for (int i = 0; i < n4; ++i) {
            int n6;
            int n7;
            DesignObject designObject;
            if (structuredType != null) {
                designObject = structuredType.getElements()[i];
                n7 = designObject.getName().length() * 7;
                n6 = ((TypeElement)designObject).getDataType().length() * 7;
                n = Math.max(n7, n);
                n5 = Math.max(n6, n5);
                continue;
            }
            designObject = (ContainedObjectWithDomain)entity.getElement(i);
            n7 = ((ContainedObject)designObject).getName().length() * 7;
            n6 = ((ContainedObjectWithDomain)designObject).getDataType().toString().length() * 7 + 20;
            n = Math.max(n7, n);
            n5 = Math.max(n6, n5);
        }
        if (n == 1) {
            n = entity.getName().length() * 7;
        }
        return new Dimension(n2 + n + n5, n3);
    }

    private boolean allKeysAreFK(KeyObject[] keyObjectArray) {
        boolean bl = true;
        for (int i = 0; i < keyObjectArray.length; ++i) {
            if (keyObjectArray[i].isFK()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    @Override
    public DesignPartView createSubordinateView(ApplicationView applicationView, DesignPart designPart) {
        return new DPVLogicalSubView(this.getApplicationView(), this.getDesignPart());
    }

    @Override
    protected void showPropertiesDialog() {
        if (!this.getPlaceHolder().isDialogVisible()) {
            ModelPropertiesDialogEx modelPropertiesDialogEx = new ModelPropertiesDialogEx(this.getDesign().getAppView(), this.getPlaceHolder());
            modelPropertiesDialogEx.initProperties(this.getPlaceHolder());
            modelPropertiesDialogEx.show();
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && this.isBoxInBox()) {
            ((LogicalDesign)this.getDesignPart()).fixBoxInBox(this);
        }
    }

    @Override
    public void setVisible(boolean bl, ProgressDialog progressDialog) {
        super.setVisible(bl, progressDialog);
        if (bl && this.isBoxInBox()) {
            ((LogicalDesign)this.getDesignPart()).fixBoxInBox(this);
        }
    }
}

