/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.logical;

import com.adbs.ast.KeywordFormat;
import com.adbs.querybuilder.PlainTextSQLBuilder;
import com.adbs.querybuilder.QueryBuilder;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.TopViewCollection;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Legend;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.logical.RelationSet;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.SelectNeighborsDialog;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TVDiagramView;
import oracle.dbtools.crest.swingui.TVLabel;
import oracle.dbtools.crest.swingui.TVLegend;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TVTypeSubstitution;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.editor.ModelPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.viewbuilder.QBUtils;
import oracle.dbtools.crest.swingui.logical.ControllerLogical;
import oracle.dbtools.crest.swingui.logical.Messages;
import oracle.dbtools.crest.swingui.logical.TVArc;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVEntityView;
import oracle.dbtools.crest.swingui.logical.TVInheritanceRelation;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class DPVLogical
extends DesignPartView {
    private static final Dimension TOPVIEW_SIZE = new Dimension(280, 320);
    private ControllerLogical controller;
    public static final String MI_ATTRIBUTES = Messages.getString("DPVLogical.Attributes");
    public static final String MI_KEY_ELEMENTS = Messages.getString("DPVLogical.KeyElements");
    private JPopupMenu menu;
    private JMenuItem miPaste;
    private JCheckBoxMenuItem miBarkerNotation;
    private JCheckBoxMenuItem miBachmanNotation;
    private JCheckBoxMenuItem miIENotation;
    private JCheckBoxMenuItem miAutoRoute;
    private JCheckBoxMenuItem miShowGrid;
    private JCheckBoxMenuItem miAllDetails;
    private JCheckBoxMenuItem miNameOnly;
    private JCheckBoxMenuItem miElements;
    private JCheckBoxMenuItem miKeyElements;
    private JCheckBoxMenuItem miDatatype;
    private JCheckBoxMenuItem miKeys;
    private JCheckBoxMenuItem miKeyAndIndexColumns;
    private JCheckBoxMenuItem miBoxInBox;
    private JCheckBoxMenuItem miShowLegend;
    private JCheckBoxMenuItem miShowLabels;
    private JMenuItem miDiagramColor;
    private int left = 20;
    private int top = 20;
    private int width = 35;
    private int height = 25;
    private int count = 0;
    private static final Logger LOGGER = new Logger(DPVLogical.class);

    public DPVLogical(ApplicationView applicationView, DesignPart designPart) {
        super(applicationView, designPart);
        this.controller = new ControllerLogical(applicationView);
        this.controller.setName("Logical");
        this.controller.setDesignPartView(this);
    }

    @Override
    public TopView createViewFor(DesignObject designObject) {
        return this.createTopViewFor(designObject);
    }

    @Override
    public AbstractController getController() {
        return this.controller;
    }

    public Collection getTVTypeSubstitutions() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        Iterator iterator = ((LogicalDesign)this.getDesignPart()).getTypeSubstitutionSet().iterator();
        while (iterator.hasNext()) {
            TypeSubstitution typeSubstitution = (TypeSubstitution)iterator.next();
            TopView topView = typeSubstitution.getViewFor(this);
            if (topView == null) continue;
            arrayList.add(topView);
        }
        return arrayList;
    }

    @Override
    public DesignPartView createSubordinateView(ApplicationView applicationView, DesignPart designPart) {
        return new DPVLogical(this.getApplicationView(), this.getDesignPart());
    }

    @Override
    public void fireSelectionChanged() {
        if (((ControllerLogical)this.getController()).getNewArcAction() != null) {
            ((ControllerLogical)this.getController()).getNewArcAction().setEnabled(true);
        }
        if (((ControllerLogical)this.getController()).getAddToArcAction() != null) {
            ((ControllerLogical)this.getController()).getAddToArcAction().setEnabled(true);
        }
        if (((ControllerLogical)this.getController()).getRemoveFromArcAction() != null) {
            ((ControllerLogical)this.getController()).getRemoveFromArcAction().setEnabled(true);
        }
    }

    @Override
    public boolean canCreateDisplays() {
        return true;
    }

    @Override
    public TopView createTopViewFor(DesignObject designObject) {
        TopView topView = null;
        if (designObject instanceof Entity) {
            TVEntity tVEntity = new TVEntity(this.getApplicationView(), this);
            tVEntity.setModel(designObject);
            topView = tVEntity;
        } else if (designObject instanceof EntityView) {
            TVEntityView tVEntityView = new TVEntityView(this.getApplicationView(), this);
            tVEntityView.setModel(designObject);
            topView = tVEntityView;
        } else if (designObject instanceof InheritanceRelation) {
            TVInheritanceRelation tVInheritanceRelation = new TVInheritanceRelation(this.getApplicationView(), this);
            tVInheritanceRelation.setModel(designObject);
            topView = tVInheritanceRelation;
        } else if (designObject instanceof Relation) {
            TVRelation tVRelation = new TVRelation(this.getApplicationView(), this);
            tVRelation.setModel(designObject);
            topView = tVRelation;
        } else if (designObject instanceof Arc) {
            TVArc tVArc = new TVArc(this.getApplicationView(), this);
            tVArc.setModel(designObject);
            topView = tVArc;
        } else {
            if (designObject instanceof TypeSubstitution) {
                TVTypeSubstitution tVTypeSubstitution = new TVTypeSubstitution(this.getApplicationView(), this);
                tVTypeSubstitution.setModel(designObject);
                tVTypeSubstitution.setSize(new Dimension(TOPVIEW_SIZE));
                return tVTypeSubstitution;
            }
            if (designObject instanceof Note) {
                TVNote tVNote = new TVNote(this.getApplicationView(), this);
                tVNote.setModel(designObject);
                tVNote.setSize(new Dimension(TOPVIEW_SIZE));
                return tVNote;
            }
            if (designObject instanceof Legend) {
                TVLegend tVLegend = new TVLegend(this.getApplicationView(), this);
                tVLegend.setModel(designObject);
                tVLegend.setSize(new Dimension(TOPVIEW_SIZE));
                return tVLegend;
            }
            if (designObject instanceof Label) {
                TVLabel tVLabel = new TVLabel(this.getApplicationView(), this);
                tVLabel.setModel(designObject);
                tVLabel.setSize(new Dimension(new Dimension(40, 20)));
                return tVLabel;
            }
            if (designObject instanceof DiagramView) {
                TVDiagramView tVDiagramView = new TVDiagramView(this.getApplicationView(), this);
                tVDiagramView.setModel(designObject);
                tVDiagramView.setSize(new Dimension(TOPVIEW_SIZE));
                return tVDiagramView;
            }
            return null;
        }
        topView.setSize(new Dimension(TOPVIEW_SIZE));
        this.registerForTreemodel(topView);
        this.setDirty(true);
        return topView;
    }

    protected void showPropertiesDialog() {
        if (!this.isMasterDPV()) {
            if (!this.getPlaceHolder().isDialogVisible()) {
                ModelPropertiesDialogEx modelPropertiesDialogEx = new ModelPropertiesDialogEx(this.getDesign().getAppView(), this.getPlaceHolder());
                modelPropertiesDialogEx.initProperties(this.getPlaceHolder());
                modelPropertiesDialogEx.show();
            }
        } else {
            this.getDesignPart().showPropertyDialog();
        }
    }

    @Override
    public JPopupMenu getPopupMenu() {
        this.menu = new JPopupMenu();
        if (this.isEditable()) {
            this.miBarkerNotation = new JCheckBoxMenuItem(Messages.getString("DPVLogical.BarkerNotation"));
            this.miBachmanNotation = new JCheckBoxMenuItem(Messages.getString("DPVLogical.BachmanNotation"));
            this.miIENotation = new JCheckBoxMenuItem(Messages.getString("DPVLogical.IENotation"));
            this.miAutoRoute = new JCheckBoxMenuItem(MI_AUTO_ROUTE);
            this.miBoxInBox = new JCheckBoxMenuItem(Messages.getString("DPVLogical.BoxInBoxPresentation"));
            this.addUndoRedo(this.menu);
            this.menu.addSeparator();
            this.miPaste = this.menu.add(new AbstractAction(MI_PASTE){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DPVLogical.this.getController().paste(DPVLogical.this.pt);
                }
            });
            this.menu.addSeparator();
            this.addSubViewAndDisplayMenus(this.menu);
            this.miAutoRoute.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DPVLogical.this.setAutoRoute(!DPVLogical.this.isAutoRoute());
                    DPVLogical.this.getWorkSpace().updateSettings();
                }
            });
            this.menu.add(this.miAutoRoute);
            this.menu.addSeparator();
            this.menu.add(this.getStraightenLinesItem());
            this.menu.addSeparator();
            this.menu.add(this.getDetailsMenu());
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(MI_RESIZE_OBJECTS_TO_VISIBLE){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DPVLogical.this.startAutoLayoutEdit(DesignPartView.MI_RESIZE_OBJECTS_TO_VISIBLE + " of " + DPVLogical.this.getName());
                    try {
                        DPVLogical.this.resizeEntities();
                        DPVLogical.this.resizeViews();
                        if (!DPVLogical.this.isAutoRoute()) {
                            DPVLogical.this.straightenLines(false);
                        }
                    }
                    finally {
                        DPVLogical.this.stopAutoLayoutEdit();
                    }
                }
            });
            this.menu.addSeparator();
            this.miDiagramColor = this.menu.add(new AbstractAction(MI_DIAGRAM_COLOR){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DPVLogical.this.changeDiagramColor();
                }
            });
            this.miDiagramColor.setEnabled(false);
            this.menu.addSeparator();
            this.miBarkerNotation.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DPVLogical.this.getNotation() != 1) {
                        DPVLogical.this.setNotation(1);
                        if (DPVLogical.this.getDesignPart() instanceof LogicalDesign) {
                            ((LogicalDesign)DPVLogical.this.getDesignPart()).updateRelationViews(DPVLogical.this);
                        }
                        DPVLogical.this.getWorkSpace().SendAllLinesToBack();
                        if (DPVLogical.this.getDesignPart() instanceof LogicalDesign && DPVLogical.this.isBoxInBox()) {
                            ((LogicalDesign)DPVLogical.this.getDesignPart()).fixBoxInBox(DPVLogical.this);
                        }
                        DPVLogical.this.getWorkSpace().repaint();
                    }
                }
            });
            this.menu.add(this.miBarkerNotation);
            this.miBachmanNotation.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DPVLogical.this.getNotation() != 0) {
                        DPVLogical.this.setNotation(0);
                        if (DPVLogical.this.getDesignPart() instanceof LogicalDesign) {
                            ((LogicalDesign)DPVLogical.this.getDesignPart()).updateRelationViews(DPVLogical.this);
                        }
                        DPVLogical.this.getWorkSpace().SendAllLinesToBack();
                        if (DPVLogical.this.getDesignPart() instanceof LogicalDesign && DPVLogical.this.isBoxInBox()) {
                            ((LogicalDesign)DPVLogical.this.getDesignPart()).fixBoxInBox(DPVLogical.this);
                        }
                        DPVLogical.this.getWorkSpace().repaint();
                    }
                }
            });
            this.menu.add(this.miBachmanNotation);
            this.miIENotation.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (DPVLogical.this.getNotation() != 2) {
                        DPVLogical.this.setNotation(2);
                        if (DPVLogical.this.getDesignPart() instanceof LogicalDesign) {
                            ((LogicalDesign)DPVLogical.this.getDesignPart()).updateRelationViews(DPVLogical.this);
                        }
                        DPVLogical.this.getWorkSpace().SendAllLinesToBack();
                        if (DPVLogical.this.getDesignPart() instanceof LogicalDesign && DPVLogical.this.isBoxInBox()) {
                            ((LogicalDesign)DPVLogical.this.getDesignPart()).fixBoxInBox(DPVLogical.this);
                        }
                        DPVLogical.this.getWorkSpace().repaint();
                    }
                }
            });
            this.menu.add(this.miIENotation);
            this.menu.addSeparator();
            this.miBoxInBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DPVLogical.this.setBoxInBox(!DPVLogical.this.isBoxInBox());
                    DPVLogical.this.updateInheritances(DPVLogical.this.isBoxInBox());
                }
            });
            this.menu.add(this.miBoxInBox);
            this.menu.addSeparator();
        }
        this.menu.add(this.getGoToDiagramMenu());
        this.menu.addSeparator();
        this.menu.add(this.getShowMenu());
        this.menu.addSeparator();
        this.menu.add(new AbstractAction(MI_VALIDATE_ALL_VIEWS){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVLogical.this.validateAllViews();
            }
        });
        this.menu.addSeparator();
        this.menu.add(new AbstractAction(MI_PARSE_OLDER_STYLE_VIEWS){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVLogical.this.parseOlderStyleViews();
            }
        });
        this.menu.addSeparator();
        this.menu.add(DataModelerAddin.findOrCreateVersioningMenu(this.menu));
        this.menu.addSeparator();
        this.menu.add(new AbstractAction(MI_PROPERTIES){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVLogical.this.showPropertiesDialog();
            }
        });
        if (this.isEditable()) {
            this.miPaste.setEnabled(this.canPaste());
            this.miAutoRoute.setSelected(this.isAutoRoute());
            this.miBoxInBox.setSelected(this.isBoxInBox());
            this.miKeyElements.setVisible(true);
            if (this.getNotation() == 0) {
                this.miBachmanNotation.setSelected(true);
                this.miBarkerNotation.setSelected(false);
                this.miIENotation.setSelected(false);
            } else if (this.getNotation() == 1) {
                this.miBachmanNotation.setSelected(false);
                this.miBarkerNotation.setSelected(true);
                this.miIENotation.setSelected(false);
                this.miKeyElements.setVisible(false);
                this.setShowKeyElements(false);
            } else if (this.getNotation() == 2) {
                this.miIENotation.setSelected(true);
                this.miBachmanNotation.setSelected(false);
                this.miBarkerNotation.setSelected(false);
            }
            this.miAllDetails.setSelected(this.showAllDetails());
            this.miNameOnly.setSelected(this.isShowNamesOnly());
            this.miElements.setSelected(this.showElements());
            this.miKeyElements.setSelected(this.showKeyElements());
            this.miDatatype.setSelected(this.showDatatype());
            this.miDatatype.setVisible(this.getNotation() != 1);
            this.miKeys.setSelected(this.showKeys());
            this.miKeys.setVisible(this.getNotation() != 1);
            this.miKeyAndIndexColumns.setSelected(this.showKeyAndIndexColumns());
            this.miKeyAndIndexColumns.setVisible(this.showKeys() || this.showIndexes());
            this.miDiagramColor.setEnabled(true);
        }
        return this.menu;
    }

    @Override
    public JMenu getDetailsMenu() {
        JMenu jMenu = new JMenu(MenuUtils.getMnemonicStr(MI_DETAILS));
        jMenu.setMnemonic(MenuUtils.getMnemonicKey(MI_DETAILS));
        this.miAllDetails = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_ALL_DETAILS));
        this.miAllDetails.setMnemonic(MenuUtils.getMnemonicKey(MI_ALL_DETAILS));
        this.miNameOnly = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_NAMES_ONLY));
        this.miNameOnly.setMnemonic(MenuUtils.getMnemonicKey(MI_NAMES_ONLY));
        this.miElements = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_ATTRIBUTES));
        this.miElements.setMnemonic(MenuUtils.getMnemonicKey(MI_ATTRIBUTES));
        this.miKeyElements = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_KEY_ELEMENTS));
        this.miKeyElements.setMnemonic(MenuUtils.getMnemonicKey(MI_KEY_ELEMENTS));
        this.miDatatype = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_DATATYPE));
        this.miDatatype.setMnemonic(MenuUtils.getMnemonicKey(MI_DATATYPE));
        this.miKeys = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_KEYS));
        this.miKeys.setMnemonic(MenuUtils.getMnemonicKey(MI_KEYS));
        this.miKeyAndIndexColumns = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_KEY_AND_INDEX_COLUMNS));
        this.miKeyAndIndexColumns.setMnemonic(MenuUtils.getMnemonicKey(MI_KEY_AND_INDEX_COLUMNS));
        this.miAllDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVLogical.this.setShowAllDetails(true);
                DPVLogical.this.setShowNamesOnly(false);
                DPVLogical.this.setShowElements(false);
                DPVLogical.this.setShowKeyElements(false);
                DPVLogical.this.setShowDatatype(false);
                DPVLogical.this.setShowKeys(false);
                DPVLogical.this.setShowKeyAndIndexColumns(false);
                DPVLogical.this.getWorkSpace().invalidate();
                DPVLogical.this.getWorkSpace().repaint();
            }
        });
        jMenu.add(this.miAllDetails);
        jMenu.addSeparator();
        this.miNameOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVLogical.this.setShowNamesOnly(true);
                DPVLogical.this.setShowAllDetails(false);
                DPVLogical.this.setShowElements(false);
                DPVLogical.this.setShowKeyElements(false);
                DPVLogical.this.setShowDatatype(false);
                DPVLogical.this.setShowKeys(false);
                DPVLogical.this.setShowKeyAndIndexColumns(false);
                DPVLogical.this.getWorkSpace().invalidate();
                DPVLogical.this.getWorkSpace().repaint();
                DPVLogical.this.setDirty(true);
            }
        });
        jMenu.add(this.miNameOnly);
        this.miElements.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVLogical.this.setShowElements(!DPVLogical.this.showElements());
                if (!DPVLogical.this.showElements() && !DPVLogical.this.showKeyElements()) {
                    DPVLogical.this.setShowDatatype(false);
                    if (!DPVLogical.this.showKeys()) {
                        DPVLogical.this.setShowAllDetails(true);
                    }
                } else {
                    DPVLogical.this.setShowAllDetails(false);
                    DPVLogical.this.setShowNamesOnly(false);
                    if (DPVLogical.this.showElements()) {
                        DPVLogical.this.setShowKeyElements(false);
                    }
                }
                DPVLogical.this.getWorkSpace().invalidate();
                DPVLogical.this.getWorkSpace().repaint();
                DPVLogical.this.setDirty(true);
            }
        });
        jMenu.add(this.miElements);
        this.miKeyElements.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVLogical.this.setShowKeyElements(!DPVLogical.this.showKeyElements());
                if (!DPVLogical.this.showElements() && !DPVLogical.this.showKeyElements()) {
                    DPVLogical.this.setShowDatatype(false);
                    if (!DPVLogical.this.showKeys()) {
                        DPVLogical.this.setShowAllDetails(true);
                    }
                } else {
                    DPVLogical.this.setShowAllDetails(false);
                    DPVLogical.this.setShowNamesOnly(false);
                    if (DPVLogical.this.showKeyElements()) {
                        DPVLogical.this.setShowElements(false);
                    }
                }
                DPVLogical.this.getWorkSpace().invalidate();
                DPVLogical.this.getWorkSpace().repaint();
                DPVLogical.this.setDirty(true);
            }
        });
        jMenu.add(this.miKeyElements);
        this.miDatatype.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVLogical.this.setShowDatatype(!DPVLogical.this.showDatatype());
                if (DPVLogical.this.showDatatype()) {
                    if (!DPVLogical.this.showKeyElements()) {
                        DPVLogical.this.setShowElements(true);
                    }
                    DPVLogical.this.setShowAllDetails(false);
                    DPVLogical.this.setShowNamesOnly(false);
                }
                DPVLogical.this.getWorkSpace().invalidate();
                DPVLogical.this.getWorkSpace().repaint();
                DPVLogical.this.setDirty(true);
            }
        });
        jMenu.add(this.miDatatype);
        this.miKeys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVLogical.this.setShowKeys(!DPVLogical.this.showKeys());
                if (DPVLogical.this.showKeys()) {
                    DPVLogical.this.setShowAllDetails(false);
                    DPVLogical.this.setShowNamesOnly(false);
                } else if (!DPVLogical.this.showElements() && !DPVLogical.this.showKeyElements()) {
                    DPVLogical.this.setShowAllDetails(true);
                }
                DPVLogical.this.getWorkSpace().invalidate();
                DPVLogical.this.getWorkSpace().repaint();
                DPVLogical.this.setDirty(true);
            }
        });
        this.miKeyAndIndexColumns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVLogical.this.setShowKeyAndIndexColumns(!DPVLogical.this.showKeyAndIndexColumns());
                DPVLogical.this.getWorkSpace().repaint();
                DPVLogical.this.setDirty(true);
            }
        });
        jMenu.add(this.miKeys);
        jMenu.add(this.miKeyAndIndexColumns);
        this.miAllDetails.setSelected(this.showAllDetails());
        this.miNameOnly.setSelected(this.isShowNamesOnly());
        this.miElements.setSelected(this.showElements());
        this.miKeyElements.setSelected(this.showKeyElements());
        this.miDatatype.setSelected(this.showDatatype());
        this.miKeys.setSelected(this.showKeys());
        this.miKeyAndIndexColumns.setSelected(this.showKeyAndIndexColumns());
        this.miKeyAndIndexColumns.setVisible(this.showKeys() || this.showIndexes());
        this.miDatatype.setVisible(this.getNotation() != 1);
        this.miKeys.setVisible(this.getNotation() != 1);
        return jMenu;
    }

    public JMenu getShowMenu() {
        JMenu jMenu = new JMenu(MenuUtils.getMnemonicStr(MI_SHOW));
        jMenu.setMnemonic(MenuUtils.getMnemonicKey(MI_SHOW));
        this.miShowGrid = new JCheckBoxMenuItem(MI_SHOW_GRID);
        this.miShowGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVLogical.this.setShowGrid(!DPVLogical.this.showGrid());
                DPVLogical.this.setDirty(true);
            }
        });
        jMenu.add(this.miShowGrid);
        jMenu.addSeparator();
        this.miShowLabels = new JCheckBoxMenuItem(MI_SHOW_LABELS);
        this.miShowLabels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVLogical.this.setShowLabels(!DPVLogical.this.showLabels());
                DPVLogical.this.setDirty(true);
            }
        });
        jMenu.add(this.miShowLabels);
        jMenu.addSeparator();
        this.miShowLegend = new JCheckBoxMenuItem(MI_SHOW_LEGEND);
        this.miShowLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DPVLogical.this.setShowLegend(!DPVLogical.this.showLegend());
                DPVLogical.this.setDirty(true);
            }
        });
        jMenu.add(this.miShowLegend);
        this.miShowGrid.setSelected(this.showGrid());
        this.miShowLabels.setSelected(this.showLabels());
        this.miShowLegend.setSelected(this.showLegend());
        return jMenu;
    }

    @Override
    public void updateInheritances(boolean bl) {
        Iterator iterator = ((LogicalDesign)this.getDesignPart()).getInheritanceRelationSet().iterator();
        while (iterator.hasNext()) {
            InheritanceRelation inheritanceRelation = (InheritanceRelation)iterator.next();
            TVInheritanceRelation tVInheritanceRelation = (TVInheritanceRelation)inheritanceRelation.getViewFor(this);
            if (tVInheritanceRelation == null) continue;
            if (bl) {
                tVInheritanceRelation.removeConnection();
                tVInheritanceRelation.updateParents();
                continue;
            }
            tVInheritanceRelation.addConnection();
        }
    }

    public Collection getTVEntities() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        Iterator iterator = ((LogicalDesign)this.getDesignPart()).getEntitySet().iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            TopViewCollection topViewCollection = entity.getViewsForDPV(this);
            for (TopView topView : topViewCollection) {
                if (topView == null) continue;
                arrayList.add(topView);
            }
        }
        return arrayList;
    }

    public Collection getTVFKRelations() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        Iterator iterator = ((LogicalDesign)this.getDesignPart()).getRelationSet().iterator();
        while (iterator.hasNext()) {
            Relation relation = (Relation)iterator.next();
            TopView topView = relation.getViewFor(this);
            if (topView == null) continue;
            arrayList.add(topView);
        }
        return arrayList;
    }

    public Collection getTVEntityViews() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        Iterator iterator = ((LogicalDesign)this.getDesignPart()).getEntityViewSet().iterator();
        while (iterator.hasNext()) {
            EntityView entityView = (EntityView)iterator.next();
            TopViewCollection topViewCollection = entityView.getViewsForDPV(this);
            for (TopView topView : topViewCollection) {
                if (topView == null) continue;
                arrayList.add(topView);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSubViewFromSelected() {
        Object[] objectArray = this.getSelectedObjects();
        DesignPartView designPartView = null;
        if (objectArray.length > 0) {
            this.getUndoManager().setLocked(true);
            try {
                designPartView = this.getApplicationView().createSubview(this);
                if (designPartView != null) {
                    int n;
                    ObjectListener objectListener;
                    Object object;
                    designPartView.getUndoManager().setLocked(true);
                    designPartView.setAutoRoute(false);
                    for (int i = 0; i < objectArray.length; ++i) {
                        Object object2 = objectArray[i];
                        if (!(object2 instanceof Entity) && !(object2 instanceof EntityView)) continue;
                        object = ((ContainerView)((DesignObject)object2).getTopView()).createViewSynonim(designPartView);
                        objectListener = this.getViewFor((DesignObject)object2);
                        if (((TopView)object).getCellView() != null) {
                            ((TopView)object).getCellView().setNewBounds(((TopView)objectListener).getBounds());
                        } else {
                            ((TopView)object).setBounds(((TopView)objectListener).getBounds());
                        }
                        if (object instanceof TVEntity) {
                            ((TVEntity)object).addTVRelations();
                            ((TVEntity)object).addArcs();
                            if (((TVEntity)object).getCellView() != null) {
                                ((oracle.dbtools.crest.swingui.diagram.logical.EntityView)((TVEntity)object).getCellView()).updateParent();
                                ((oracle.dbtools.crest.swingui.diagram.logical.EntityView)((TVEntity)object).getCellView()).setChildPositions();
                            }
                        }
                        ((ContainerView)object).addTVTypeSubstitutions();
                        designPartView.synchronizeSynonymWithDisplays((TopView)object);
                    }
                    RelationSet relationSet = ((LogicalDesign)this.getDesignPart()).getRelationSet();
                    for (n = 0; n < objectArray.length; ++n) {
                        object = objectArray[n];
                        if (!(object instanceof Entity)) continue;
                        objectListener = (Entity)object;
                        Collection collection = relationSet.getRelationsToSource((Entity)objectListener);
                        collection.addAll(((LogicalDesign)this.getDesignPart()).getInheritanceRelationSet().getRelationsToSource((Entity)objectListener));
                        Object[] objectArray2 = collection.toArray();
                        for (int i = 0; i < objectArray2.length; ++i) {
                            Object object3;
                            int n2;
                            List list;
                            List list2;
                            DesignObject designObject = (DesignObject)objectArray2[i];
                            TVConnector tVConnector = (TVConnector)designObject.getFirstViewForDPV(this);
                            TVConnector tVConnector2 = (TVConnector)designObject.getFirstViewForDPV(designPartView);
                            if (tVConnector2 == null || tVConnector == null) continue;
                            EdgeView edgeView = null;
                            if (tVConnector.getEdge() != null) {
                                edgeView = (EdgeView)tVConnector.getEdge().getCellView();
                            }
                            if (edgeView != null) {
                                list2 = edgeView.getPoints();
                                list = tVConnector2.getEdgePoints();
                                list.clear();
                                for (n2 = 0; n2 < list2.size(); ++n2) {
                                    object3 = list2.get(n2);
                                    Point2D point2D = null;
                                    if (object3 instanceof Point2D) {
                                        point2D = (Point2D)object3;
                                    } else if (object3 instanceof PortView) {
                                        point2D = ((PortView)object3).getPoint();
                                    }
                                    if (point2D == null) continue;
                                    list.add(DiagramConstants.createPoint(point2D.getX(), point2D.getY()));
                                }
                                if (tVConnector2.getEdge() == null || tVConnector2.getEdge().getCellView() == null) continue;
                                Hashtable hashtable = new Hashtable();
                                DiagramConstants.setPoints(hashtable, list);
                                tVConnector2.getEdge().changeAttributes(hashtable);
                                tVConnector2.getEdge().getCellView().update();
                                if (list.size() != 2) continue;
                                tVConnector2.getEdge().straightLine(false);
                                continue;
                            }
                            list2 = tVConnector.getEdgePoints();
                            list = tVConnector2.getEdgePoints();
                            list.clear();
                            for (n2 = 0; n2 < list2.size(); ++n2) {
                                object3 = (Point2D)list2.get(n2);
                                list.add(DiagramConstants.createPoint(((Point2D)object3).getX(), ((Point2D)object3).getY()));
                            }
                        }
                    }
                    for (n = 0; n < objectArray.length; ++n) {
                        object = objectArray[n];
                        if (!(object instanceof Entity) || (objectListener = (TVEntity)designPartView.getViewFor((DesignObject)object)) == null) continue;
                        ((TVEntity)objectListener).addArcs();
                    }
                    designPartView.setAutoRoute(this.isAutoRoute());
                    designPartView.getWorkSpace().updateSettings();
                }
            }
            finally {
                this.getUndoManager().setLocked(false);
                if (designPartView != null) {
                    designPartView.getUndoManager().setLocked(false);
                }
            }
        }
    }

    @Override
    public void selectNeighbors(ContainerObject containerObject) {
        SelectNeighborsDialog selectNeighborsDialog = new SelectNeighborsDialog(this.getApplicationView());
        selectNeighborsDialog.showDialog();
        int n = selectNeighborsDialog.getZones();
        if (n > -1) {
            ArrayList<ContainerObject> arrayList = new ArrayList<ContainerObject>();
            Entity entity = (Entity)containerObject;
            arrayList.add(containerObject);
            this.collectNeighbors(entity, arrayList, n, n == 0);
            this.getWorkSpace().setSelectionCells(this.getCellsFromObjects(arrayList).toArray());
        }
    }

    private void collectNeighbors(Entity entity, List list, int n, boolean bl) {
        int n2 = --n;
        List list2 = entity.getRelations();
        for (Relation relation : list2) {
            Entity entity2;
            if (relation instanceof InheritanceRelation || list.contains(entity2 = relation.getOtherEntity(entity))) continue;
            list.add(entity2);
            if (!bl && n2 <= 0) continue;
            this.collectNeighbors(entity2, list, n2, bl);
        }
    }

    public void resizeEntity(TopView topView) {
        Entity entity = (Entity)topView.getModel();
        if (!this.isBoxInBox() || !entity.isHierarchicalEntityType()) {
            Dimension dimension = this.getEntitySize(entity, this.getFontMetrics(topView));
            if (topView.getCellView() != null) {
                Point point = topView.getCellView().getBounds().getBounds().getLocation();
                topView.getCellView().setNewBounds(new Rectangle(new Point(point.x, point.y), dimension));
            } else {
                Point point = topView.getLocation();
                topView.setBounds(new Rectangle(new Point(point.x, point.y), dimension));
            }
        }
    }

    public void resizeEntities() {
        List list = (List)this.getTVEntities();
        for (TopView topView : list) {
            if (topView == null) continue;
            this.resizeEntity(topView);
        }
    }

    public void resizeView(TopView topView) {
        Dimension dimension = this.getEntityViewSize((EntityView)topView.getModel(), this.getFontMetrics(topView));
        if (topView.getCellView() != null) {
            Point point = topView.getCellView().getBounds().getBounds().getLocation();
            topView.getCellView().setNewBounds(new Rectangle(new Point(point.x, point.y), dimension));
        } else {
            Point point = topView.getLocation();
            topView.setBounds(new Rectangle(new Point(point.x, point.y), dimension));
        }
    }

    public void resizeViews() {
        List list = (List)this.getTVViews();
        for (TopView topView : list) {
            if (topView == null) continue;
            this.resizeView(topView);
        }
    }

    @Override
    public void resizeSelectedObjects() {
        if (this.getWorkSpace().getSelectionCount() > 0) {
            Object[] objectArray = this.getWorkSpace().getSelectionCells();
            for (int i = 0; i < objectArray.length; ++i) {
                TopView topView;
                Object object = objectArray[i];
                if (!(object instanceof DefaultDiagramCell) || (topView = ((DefaultDiagramCell)object).getTopView()) == null) continue;
                if (topView instanceof TVEntity) {
                    this.resizeEntity(topView);
                    continue;
                }
                if (!(topView instanceof TVEntityView)) continue;
                this.resizeView(topView);
            }
        }
    }

    public Collection getTVViews() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        Iterator iterator = ((LogicalDesign)this.getDesignPart()).getEntityViewSet().iterator();
        while (iterator.hasNext()) {
            EntityView entityView = (EntityView)iterator.next();
            TopViewCollection topViewCollection = entityView.getViewsForDPV(this);
            for (TopView topView : topViewCollection) {
                if (topView == null) continue;
                arrayList.add(topView);
            }
        }
        return arrayList;
    }

    private Dimension getEntityViewSize(EntityView entityView, FontMetrics fontMetrics) {
        int n;
        int n2 = 25;
        int n3 = 25;
        int n4 = 0;
        int n5 = 1;
        String string = entityView.getName();
        StructuredType structuredType = null;
        if (entityView.isBST() && entityView.getBasedOnStructuredType() != null) {
            string = string + " (" + entityView.getBasedOnStructuredType().getName() + ")";
        }
        int n6 = fontMetrics.stringWidth(string);
        if (this.isShowNamesOnly()) {
            return new Dimension(n2 * 2 + n6, n3);
        }
        if (this.showAllDetails() || this.showElements() || this.showKeyElements()) {
            if (entityView.isBST() && entityView.getTypeSubstitution() != null) {
                structuredType = entityView.getBasedOnStructuredType();
                if (structuredType != null) {
                    n4 = structuredType.getElements().length;
                }
            } else {
                n4 = entityView.getElements().length;
            }
            n3 += n4 * 15;
            if (this.showAllDetails() && (n = entityView.getUsedTablesAndViews().size()) > 0) {
                n3 += n * 15;
            }
        }
        n = 0;
        for (int i = 0; i < n4; ++i) {
            int n7;
            if (structuredType != null) {
                TypeElement typeElement = structuredType.getElements()[i];
                int n8 = fontMetrics.stringWidth(typeElement.getName());
                n = Math.max(n8, n);
                if (!this.showAllDetails() && !this.showDatatype()) continue;
                n7 = fontMetrics.stringWidth(typeElement.getDataType());
                n5 = Math.max(n7, n5);
                continue;
            }
            if (entityView.getElement(i) instanceof AttributeView) {
                AttributeView attributeView = (AttributeView)entityView.getElement(i);
                String string2 = attributeView.getAlias();
                if ("".equalsIgnoreCase(string2)) {
                    string2 = attributeView.getReferencedName();
                }
                n7 = fontMetrics.stringWidth(string2);
                n = Math.max(n7, n);
                if (!this.showAllDetails() && !this.showDatatype()) continue;
                int n9 = fontMetrics.stringWidth(attributeView.getDataType());
                n5 = Math.max(n9, n5);
                continue;
            }
            int n10 = fontMetrics.stringWidth(entityView.getElement(i).getName());
            n = Math.max(n10, n);
        }
        if (n > 250) {
            n = 250;
        }
        n = Math.max(n6, n);
        return new Dimension(n2 + n + n5 + 10, n3);
    }

    public void rearrangeEntities() {
        this.left = 20;
        this.top = 20;
        this.width = 35;
        this.height = 50;
        this.count = 0;
        List list = (List)this.getTVEntities();
        Collections.sort(list, new EntityComparator());
        float f = (float)Math.sqrt(list.size());
        long l = (int)f;
        if (Math.sqrt(f * f) != (double)f) {
            ++l;
        }
        ++l;
        for (TopView topView : list) {
            if (topView == null) continue;
            ++this.count;
            Dimension dimension = this.getEntitySize((Entity)topView.getModel(), this.getFontMetrics(topView));
            this.width = dimension.width;
            this.height = Math.max(dimension.height, this.height);
            if (topView.getCellView() != null) {
                topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), dimension));
            } else {
                topView.setBounds(new Rectangle(new Point(this.left, this.top), dimension));
            }
            this.left = this.left + this.width + 50;
            if ((long)this.count != l) continue;
            this.count = 0;
            this.left = 20;
            this.top = this.top + this.height + 150;
            this.height = 25;
        }
    }

    private Dimension getEntitySize(Entity entity, FontMetrics fontMetrics) {
        int n;
        int n2;
        int n3 = 35;
        int n4 = 25;
        int n5 = 0;
        int n6 = 1;
        String string = entity.getName();
        StructuredType structuredType = null;
        if (entity.isBST() && entity.getBasedOnStructuredType() != null) {
            string = string + " (" + entity.getBasedOnStructuredType().getName() + ")";
        }
        int n7 = fontMetrics.stringWidth(string);
        if (this.isShowNamesOnly()) {
            return new Dimension(n3 * 2 + n7, n4);
        }
        if (this.showAllDetails() || this.showElements() || this.showKeyElements()) {
            if (entity.isBST() && entity.getTypeSubstitution() != null) {
                structuredType = entity.getBasedOnStructuredType();
                if (structuredType != null) {
                    n5 = structuredType.getElements().length;
                }
            } else if (this.showKeyElements()) {
                ContainedObject[] containedObjectArray = entity.getElements();
                n2 = 0;
                for (n = 0; n < containedObjectArray.length; ++n) {
                    ContainedObjectWithDomain containedObjectWithDomain = (ContainedObjectWithDomain)containedObjectArray[n];
                    if (!containedObjectWithDomain.isPKElement() && !containedObjectWithDomain.isFKElement() && !containedObjectWithDomain.isUnique()) continue;
                    ++n2;
                }
                n5 = n2;
            } else {
                n5 = entity.getElements().length;
            }
            n4 += n5 * 15;
        }
        int n8 = 0;
        if (this.getNotation() != 1 && (this.showAllDetails() || this.showKeys())) {
            n2 = 0;
            if (entity.getKeys().length > 0 && !this.allKeysAreFK(entity.getKeys())) {
                n4 += 6;
                for (n = 0; n < entity.getKeys().length; ++n) {
                    if (entity.getKeys()[n].isFK()) continue;
                    ++n2;
                    int n9 = fontMetrics.stringWidth(entity.getKeys()[n].getName());
                    if (this.showAllDetails() || this.showKeyAndIndexColumns()) {
                        String string2 = " (";
                        ContainedObject[] containedObjectArray = entity.getKeys()[n].getElements();
                        for (int i = 0; i < containedObjectArray.length; ++i) {
                            ContainedObject containedObject = containedObjectArray[i];
                            String string3 = containedObject.getName();
                            if (i > 0) {
                                string2 = string2 + ", ";
                            }
                            string2 = string2 + string3;
                        }
                        string2 = string2 + ")";
                        n9 += fontMetrics.stringWidth(string2);
                    }
                    n8 = Math.max(n9, n8);
                }
            }
            if (n2 > 0) {
                n4 += n2 * 14;
            }
        }
        n2 = 0;
        for (n = 0; n < n5; ++n) {
            int n10;
            int n11;
            DesignObject designObject;
            if (structuredType != null) {
                designObject = structuredType.getElements()[n];
                n11 = fontMetrics.stringWidth(designObject.getName());
                n2 = Math.max(n11, n2);
                if (this.getNotation() == 1 || !this.showAllDetails() && !this.showDatatype()) continue;
                n10 = fontMetrics.stringWidth(((TypeElement)designObject).getDataType()) + 40;
                n6 = Math.max(n10, n6);
                continue;
            }
            designObject = (ContainedObjectWithDomain)entity.getElement(n);
            n11 = fontMetrics.stringWidth(((ContainedObject)designObject).getName());
            n2 = Math.max(n11, n2);
            if (this.getNotation() == 1 || !this.showAllDetails() && !this.showDatatype()) continue;
            n10 = fontMetrics.stringWidth(this.getDataType((ContainedObjectWithDomain)designObject));
            n6 = Math.max(n10, n6);
        }
        if (n2 == 1) {
            n2 = fontMetrics.stringWidth(entity.getName());
        }
        n2 = Math.max(n8, n2 + n6 + 20);
        n2 = Math.max(n7, n2);
        return new Dimension(n3 + n2, n4);
    }

    protected String getDataType(ContainedObjectWithDomain containedObjectWithDomain) {
        String string = containedObjectWithDomain.getFormulaDesc();
        if (string != null && string.length() > 0 && ("Derived".equalsIgnoreCase(containedObjectWithDomain.getSourceType()) || "Aggregate".equalsIgnoreCase(containedObjectWithDomain.getSourceType()) || containedObjectWithDomain instanceof Column && ((Column)containedObjectWithDomain).isComputed().booleanValue())) {
            return string;
        }
        if (containedObjectWithDomain instanceof Attribute) {
            return ((Attribute)containedObjectWithDomain).getLogicalRepresentationName();
        }
        if (containedObjectWithDomain.isReference() && containedObjectWithDomain.getDataType() instanceof StructuredType) {
            return "REF " + containedObjectWithDomain.getDataType().toString();
        }
        Datatype datatype = containedObjectWithDomain.getDataType();
        if (datatype != null) {
            return datatype.toString();
        }
        return "";
    }

    private boolean allKeysAreFK(KeyObject[] keyObjectArray) {
        boolean bl = true;
        for (int i = 0; i < keyObjectArray.length; ++i) {
            if (keyObjectArray[i].isFK()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void setController(ControllerLogical controllerLogical) {
        this.controller = controllerLogical;
    }

    public void validateAllViews() {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                try {
                    ProgressDialog progressDialog = new ProgressDialog(ApplicationView.getInstance(), "", 0, DPVLogical.this.getTVEntityViews().size());
                    try {
                        Iterator iterator = DPVLogical.this.getTVEntityViews().iterator();
                        int n = 0;
                        while (iterator.hasNext()) {
                            TVEntityView tVEntityView = (TVEntityView)iterator.next();
                            progressDialog.setNote("Validating View - " + tVEntityView.getEntityViewModel().getName());
                            progressDialog.setProgress(++n);
                            if (tVEntityView.getEntityViewModel().isValidSQL()) continue;
                            tVEntityView.getEntityViewModel().validateSQL();
                        }
                    }
                    finally {
                        progressDialog.close();
                        DPVLogical.this.getWorkSpace().repaint();
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Error Validating All Views: ", exception);
                }
                finally {
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        thread.start();
    }

    public void parseOlderStyleViews() {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
                try {
                    QueryBuilder queryBuilder = new QueryBuilder(true);
                    PlainTextSQLBuilder plainTextSQLBuilder = new PlainTextSQLBuilder();
                    plainTextSQLBuilder.setKeywordFormat(KeywordFormat.UpperCase);
                    plainTextSQLBuilder.setQueryBuilder(queryBuilder);
                    QBUtils.initMetadata(DPVLogical.this.getDesignPart(), queryBuilder, plainTextSQLBuilder);
                    ProgressDialog progressDialog = new ProgressDialog(ApplicationView.getInstance(), "", 0, DPVLogical.this.getTVEntityViews().size());
                    try {
                        Iterator iterator = DPVLogical.this.getTVEntityViews().iterator();
                        int n = 0;
                        while (iterator.hasNext()) {
                            TVEntityView tVEntityView = (TVEntityView)iterator.next();
                            progressDialog.setNote("Parsing View - " + tVEntityView.getEntityViewModel().getName());
                            progressDialog.setProgress(++n);
                            if (tVEntityView.getEntityViewModel().isParsed()) continue;
                            tVEntityView.getEntityViewModel().parseOlderStyleView(queryBuilder, plainTextSQLBuilder);
                        }
                    }
                    finally {
                        progressDialog.close();
                        DPVLogical.this.getWorkSpace().repaint();
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Error Parsing Older Style Views: ", exception);
                }
                finally {
                    Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        thread.start();
    }

    class EntityComparator
    implements Comparator {
        EntityComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            int n2;
            int n3;
            int n4;
            Entity entity = (Entity)((TopView)object).getModel();
            Entity entity2 = (Entity)((TopView)object2).getModel();
            int n5 = entity.getRelations().size();
            if (n5 < (n4 = entity2.getRelations().size())) {
                return 1;
            }
            if (n5 > n4) {
                return -1;
            }
            int n6 = ((LogicalDesign)entity.getDesignPart()).getRelationSet().getRelationsTo(entity).size();
            if (n6 < (n3 = ((LogicalDesign)entity2.getDesignPart()).getRelationSet().getRelationsTo(entity2).size())) {
                return 1;
            }
            if (n6 > n3) {
                return -1;
            }
            int n7 = entity.getElementsCollection().size();
            if (n7 < (n2 = entity2.getElementsCollection().size())) {
                return 1;
            }
            if (n7 > n2) {
                return -1;
            }
            int n8 = entity.getKeySet().size();
            if (n8 < (n = entity2.getKeySet().size())) {
                return 1;
            }
            if (n8 > n) {
                return -1;
            }
            return 0;
        }
    }
}

