/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.logical;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GlassComponent;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.PointsEnteredCallback;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerDiagramCell;
import oracle.dbtools.crest.swingui.diagram.logical.EntityDiagramCell;
import oracle.dbtools.crest.swingui.editor.logical.RelationPropertiesDialogEx;
import oracle.dbtools.crest.swingui.engineeringcompare.EngineeringCompareDialog;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.logical.Messages;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.ide.Ide;

public class ControllerLogical
extends AbstractController {
    private Select select;
    private ZoomIn zoomIn;
    private ZoomOut zoomOut;
    private FitScreen fitScreen;
    private ActualSize actualSize;
    private Search search;
    private FWDEngineer fwdEngineer;
    private EntityCollector eCollector = null;
    private NewArc newArc;
    private AddToArc add2Arc;
    private RemoveFromArc removeFromArc;
    private NewEntity newEntity;
    private NewEntityView newEntityView;
    private NewRelationManyToMany newRelMany2Many;
    private NewRelationOneToMany newRelOne2Many;
    private NewRelationOneToManyIdentifying newRelOne2ManyIdent;
    private NewRelationOneToOne newRelOne2One;
    private NewTypeSubstitution newTypeSubstitution;
    private NewNote newNote;
    private Delete delete;
    DesignPartView designPV = null;
    private final String[] OBJECT_LOGICAL_PATH = new String[]{AbstractController.OBJECT_CAPTION, AbstractController.LOGICAL_CAPTION};
    private final String[] DESIGN_PATH = new String[]{AbstractController.DESIGN_CAPTION};

    public ControllerLogical(ApplicationView applicationView) {
        super(applicationView);
    }

    @Override
    public void initializeActions() {
        if (this.isEditable()) {
            this.select = new Select();
            this.newEntity = new NewEntity();
            this.newEntityView = new NewEntityView();
            this.newRelMany2Many = new NewRelationManyToMany();
            this.newRelOne2Many = new NewRelationOneToMany();
            this.newRelOne2ManyIdent = new NewRelationOneToManyIdentifying();
            this.newRelOne2One = new NewRelationOneToOne();
            this.newTypeSubstitution = new NewTypeSubstitution();
            this.newNote = new NewNote();
            this.delete = new Delete();
            this.newArc = new NewArc();
            this.add2Arc = new AddToArc();
            this.removeFromArc = new RemoveFromArc();
            this.fwdEngineer = new FWDEngineer();
            this.add(this.select);
            this.add(this.newEntity);
            this.add(this.newEntityView);
            this.add(this.newRelMany2Many);
            this.add(this.newRelOne2Many);
            this.add(this.newRelOne2ManyIdent);
            this.add(this.newRelOne2One);
            this.add(this.newTypeSubstitution);
            this.add(this.newArc);
            this.add(this.add2Arc);
            this.add(this.removeFromArc);
            this.add(this.newNote);
            this.add(this.delete);
            this.add(this.fwdEngineer);
        }
        this.zoomIn = new ZoomIn();
        this.add(this.zoomIn);
        this.zoomOut = new ZoomOut();
        this.add(this.zoomOut);
        this.fitScreen = new FitScreen();
        this.add(this.fitScreen);
        this.actualSize = new ActualSize();
        this.add(this.actualSize);
        this.search = new Search();
        this.add(this.search);
    }

    @Override
    public String getToolBarName() {
        return Messages.getString("ControllerLogical.Logical");
    }

    public DPVLogical getDPVLogical() {
        return this.getApplicationView().getDPVLogical();
    }

    @Override
    public void setDesignPartView(DesignPartView designPartView) {
        this.designPV = designPartView;
    }

    @Override
    public DesignPartView getDesignPartView() {
        if (this.designPV != null) {
            return this.designPV;
        }
        return this.getDPVLogical();
    }

    @Override
    public boolean canPaste() {
        for (Object e : this.getApplicationView().getCopiedObjects()) {
            if (e == null || !(e instanceof Entity) && !(e instanceof EntityView)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void paste(Point point) {
        Iterator iterator = this.getApplicationView().getCopiedObjects().iterator();
        int n = 0;
        int n2 = 0;
        while (iterator.hasNext()) {
            TopView topView;
            ContainerObject containerObject;
            Object e = iterator.next();
            if (!(e instanceof DesignObject)) continue;
            ContainerObject containerObject2 = (ContainerObject)e;
            if (containerObject2 instanceof Entity) {
                ApplicationView.log(Messages.getString("ControllerLogical.CreateEntity"));
                containerObject = ((LogicalDesign)this.getDesignPartView().getDesignPart()).createEntity();
            } else {
                ApplicationView.log(Messages.getString("ControllerLogical.CreateEntityView"));
                containerObject = ((LogicalDesign)this.getDesignPartView().getDesignPart()).createEntityView();
            }
            containerObject2.copy(containerObject);
            TopView topView2 = this.getDesignPartView().getViewFor(containerObject);
            if (topView2 == null || topView2.getCellView() == null || (topView = containerObject2.getTopView()) == null || topView.getCellView() == null) continue;
            Rectangle rectangle = new Rectangle(topView.getCellView().getBounds().getBounds());
            Point2D point2D = null;
            if (point != null) {
                point2D = this.getDesignPartView().getWorkSpace().fromScreen(new Point2D.Double(point.x, point.y));
            }
            if (point2D != null) {
                rectangle.x = (int)point2D.getX() + n;
                rectangle.y = (int)point2D.getY() + n2;
            } else {
                rectangle.x += 30 + n;
                rectangle.y += 30 + n2;
            }
            topView2.getCellView().setNewBounds(rectangle);
            n += 20;
            n2 += 20;
        }
    }

    public JMenu getObjectLogicalMenu() {
        return this.getApplicationView().getControllerSet().getMenuStructure().get(this.OBJECT_LOGICAL_PATH);
    }

    public FitScreen getFitScreen() {
        return this.fitScreen;
    }

    public ActualSize getActualSize() {
        return this.actualSize;
    }

    @Override
    public MDBAction getSearch() {
        return this.search;
    }

    public ZoomIn getZoomIn() {
        return this.zoomIn;
    }

    public ZoomOut getZoomOut() {
        return this.zoomOut;
    }

    public NewArc getNewArcAction() {
        return this.newArc;
    }

    public AddToArc getAddToArcAction() {
        return this.add2Arc;
    }

    public RemoveFromArc getRemoveFromArcAction() {
        return this.removeFromArc;
    }

    @Override
    public void updateActions() {
        boolean bl = true;
        if (this.getDesign().isLoadFromDB() && this.getDesignPartView().getDesignPart().getRepositoryOID() != null) {
            bl = this.getDesignPartView().getDesignPart().isCheckedOutByMe();
        }
        this.getDesignPartView().getWorkSpace().updateReadOnlyStatus();
        this.setEnabled(this.newEntity, bl);
        this.setEnabled(this.newEntityView, bl);
        this.setEnabled(this.newRelMany2Many, bl);
        this.setEnabled(this.newRelOne2Many, bl);
        this.setEnabled(this.newRelOne2ManyIdent, bl);
        this.setEnabled(this.newRelOne2One, bl);
        this.setEnabled(this.newTypeSubstitution, bl);
        this.setEnabled(this.newArc, bl);
        this.setEnabled(this.add2Arc, bl);
        this.setEnabled(this.removeFromArc, bl);
        this.setEnabled(this.newNote, bl);
        this.setEnabled(this.delete, bl);
    }

    class Search
    extends MDBAction {
        private Search() {
            super(MenuUtils.getMnemonicStr(AbstractController.SEARCH_CAPTION), ControllerLogical.this.getConfiguration().getIcon("SEARCH_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SEARCH_CAPTION));
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public boolean addToolbarSeparator() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerLogical.this.getApplicationView().search(1);
        }
    }

    class ActualSize
    extends MDBAction {
        private ActualSize() {
            super(MenuUtils.getMnemonicStr(AbstractController.ACTUAL_SIZE_CAPTION), ControllerLogical.this.getConfiguration().getIcon("ACTUAL_SIZE_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ACTUAL_SIZE_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView = ControllerLogical.this.getApplicationView().getCurrentDPV();
            designPartView.actualSize();
        }
    }

    class FitScreen
    extends MDBAction {
        private FitScreen() {
            super(MenuUtils.getMnemonicStr(AbstractController.FIT_SCREEN_CAPTION), ControllerLogical.this.getConfiguration().getIcon("FIT_SCREEN_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.FIT_SCREEN_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView = ControllerLogical.this.getApplicationView().getCurrentDPV();
            designPartView.fitScreen();
        }
    }

    class ZoomOut
    extends MDBAction {
        private ZoomOut() {
            super(MenuUtils.getMnemonicStr(AbstractController.ZOOM_OUT_CAPTION), ControllerLogical.this.getConfiguration().getIcon("ZOOM_OUT_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ZOOM_OUT_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView = ControllerLogical.this.getApplicationView().getCurrentDPV();
            designPartView.zoomOut();
        }
    }

    class ZoomIn
    extends MDBAction {
        private ZoomIn() {
            super(MenuUtils.getMnemonicStr(AbstractController.ZOOM_IN_CAPTION), ControllerLogical.this.getConfiguration().getIcon("ZOOM_IN_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ZOOM_IN_CAPTION));
            this.setAllowedInToolbar(true);
        }

        @Override
        public boolean addToolbarSeparator() {
            return ControllerLogical.this.isEditable();
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            DesignPartView designPartView = ControllerLogical.this.getApplicationView().getCurrentDPV();
            designPartView.zoomIn();
        }
    }

    class TypedElementCollector
    implements PointsEnteredCallback {
        private GlassComponent glassComp = null;
        protected boolean showSwapColumnsDialog;

        protected TypedElementCollector() {
            this.collect();
        }

        protected void collect() {
            this.glassComp = ControllerLogical.this.getDesignPartView().getGlassPane();
            this.glassComp.getPoints(this, 2);
        }

        public void stopWaiting() {
            if (this.glassComp != null) {
                this.glassComp.stopAll();
            }
        }

        private String title() {
            return Messages.getString("ControllerLogical.NewTypeSubstitution");
        }

        @Override
        public void rectangleSelected(Rectangle rectangle) {
        }

        @Override
        public void pointSelected(Point point) {
        }

        @Override
        public void pointsSelected(Point[] pointArray) {
            ContainerView containerView = this.getContainerViewFor(pointArray[0]);
            ContainerView containerView2 = this.getContainerViewFor(pointArray[1]);
            ContainerObject containerObject = null;
            ContainerObject containerObject2 = null;
            if (containerView != null) {
                containerObject = (ContainerObject)containerView.getModel();
            }
            if (containerView2 != null) {
                containerObject2 = (ContainerObject)containerView2.getModel();
            }
            ArrayList<String> arrayList = new ArrayList<String>(2);
            if (containerObject != null && containerObject2 != null) {
                if (containerObject2 == containerObject) {
                    arrayList.add(Messages.getString("ControllerLogical.TwoDifferentObjectsMustBeSelected"));
                }
                if (containerObject.getClass() != containerObject2.getClass()) {
                    arrayList.add(Messages.getString("ControllerLogical.TwoObjectsSameKindShouldBeSelected"));
                }
                if (!containerObject.isBST() || !containerObject2.isBST()) {
                    arrayList.add(Messages.getString("ControllerLogical.ObjectsStructuredTypeCanBeSelected"));
                }
                if (containerObject.isBST() && containerObject2.isBST()) {
                    if (containerObject.getBasedOnStructuredType().getParentType() != containerObject2.getBasedOnStructuredType() && containerObject2.getBasedOnStructuredType().getParentType() != containerObject.getBasedOnStructuredType()) {
                        arrayList.add(Messages.getString("ControllerLogical.ObjectsStructuredTypeDirectSubtypeCanBeSelected"));
                    } else if (containerObject.getBasedOnStructuredType().getParentType() == containerObject2.getBasedOnStructuredType()) {
                        if (containerObject.getTypeSubstitution() != null) {
                            arrayList.add(MessageFormat.format(Messages.getString("ControllerLogical.TypeSubstitutionAlreadyDefined"), containerObject.getName()));
                        }
                    } else if (containerObject2.getTypeSubstitution() != null) {
                        arrayList.add(MessageFormat.format(Messages.getString("ControllerLogical.TypeSubstitutionAlreadyDefined"), containerObject2.getName()));
                    }
                }
                if (arrayList.size() == 0) {
                    this.doIt(containerView, containerView2);
                } else {
                    JOptionPane.showMessageDialog(ControllerLogical.this.getDesignPartView(), arrayList.toArray(), this.title(), 0);
                }
            } else {
                arrayList.add(Messages.getString("ControllerLogical.ErrorInObjectSelection"));
                JOptionPane.showMessageDialog(ControllerLogical.this.getDesignPartView(), arrayList.toArray(), this.title(), 0);
            }
            ControllerLogical.this.select_SelectAction();
        }

        protected ContainerView getContainerViewFor(Point point) {
            Object object = ControllerLogical.this.getDesignPartView().getWorkSpace().getFirstCellForLocation(point.getX(), point.getY());
            if (object != null && object instanceof ContainerDiagramCell) {
                return (ContainerView)((ContainerDiagramCell)object).getTopView();
            }
            return null;
        }

        public void doIt(ContainerView containerView, ContainerView containerView2) {
            ContainerObject containerObject = null;
            ContainerObject containerObject2 = null;
            ContainerObject containerObject3 = null;
            ContainerObject containerObject4 = null;
            ContainerView containerView3 = null;
            ContainerView containerView4 = null;
            if (containerView != null) {
                containerObject3 = (ContainerObject)containerView.getModel();
            }
            if (containerView2 != null) {
                containerObject4 = (ContainerObject)containerView2.getModel();
            }
            if (containerObject3 != null && containerObject4 != null) {
                if (containerObject3.getBasedOnStructuredType() == containerObject4.getBasedOnStructuredType().getParentType()) {
                    containerObject2 = containerObject3;
                    containerObject = containerObject4;
                    containerView4 = containerView;
                    containerView3 = containerView2;
                } else if (containerObject3.getBasedOnStructuredType().getParentType() == containerObject4.getBasedOnStructuredType()) {
                    containerObject = containerObject3;
                    containerObject2 = containerObject4;
                    containerView3 = containerView;
                    containerView4 = containerView2;
                }
                if (containerObject != null && containerObject2 != null) {
                    TypeSubstitution typeSubstitution = ControllerLogical.this.getDesign().getLogicalDesign().createTypeSubstitution();
                    typeSubstitution.setChildCV(containerView3);
                    typeSubstitution.setParentCV(containerView4);
                    typeSubstitution.addToAllDPVs();
                }
            }
        }

        @Override
        public Component getTargetCoordinateSpace() {
            return ControllerLogical.this.getDesignPartView().getWorkSpace();
        }
    }

    class NewTypeSubstitution
    extends MDBAction {
        TypedElementCollector collector;

        private NewTypeSubstitution() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_TYPE_SUBSTITUTION_CAPTION), ControllerLogical.this.getConfiguration().getIcon("RAGGED_LINK_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_TYPE_SUBSTITUTION_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerLogical.this.getDesignPartView().getWorkSpace().setDrawnObjectID(18);
            ControllerLogical.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerLogical.this.updateToolbar(this);
            if (this.collector != null) {
                this.collector.stopWaiting();
            }
            this.collector = new TypedElementCollector();
        }
    }

    public class EntityCollector
    implements PointsEnteredCallback {
        private GlassComponent glassComp = null;
        private int relationType = 0;

        public EntityCollector(int n) {
            this.relationType = n;
            this.startCollecting();
        }

        public void startCollecting() {
            ControllerLogical.this.getDesignPartView().getWorkSpace().clearSelection();
            this.collect();
        }

        private void collect() {
            this.glassComp = ControllerLogical.this.getDesignPartView().getGlassPane();
            this.glassComp.getPoints(this, 2);
        }

        public void stopWaiting() {
            if (this.glassComp != null) {
                this.glassComp.stopAll();
            }
        }

        @Override
        public void rectangleSelected(Rectangle rectangle) {
        }

        @Override
        public void pointSelected(Point point) {
        }

        @Override
        public void pointsSelected(Point[] pointArray) {
            Object object;
            TVEntity tVEntity = this.getTVEntityFor(pointArray[0]);
            TVEntity tVEntity2 = this.getTVEntityFor(pointArray[1]);
            ArrayList<String> arrayList = new ArrayList<String>();
            Entity entity = null;
            Entity entity2 = null;
            if (tVEntity != null) {
                entity = (Entity)tVEntity.getModel();
            }
            if (tVEntity2 != null) {
                entity2 = (Entity)tVEntity2.getModel();
            }
            if (tVEntity == null) {
                arrayList.add(Messages.getString("ControllerLogical.NoSourceEntitySelected"));
            }
            if (tVEntity2 == null) {
                arrayList.add(Messages.getString("ControllerLogical.NoTargetEntitySelected"));
            }
            if (entity != null && entity.isBST() && (object = entity.getPK()) == null) {
                arrayList.add(Messages.getString("ControllerLogical.ParEntityShouldHavePK"));
            }
            if (entity != null && entity2 != null) {
                if (entity.getTypeSubstitution() != null || entity2.getTypeSubstitution() != null) {
                    arrayList.add(Messages.getString("ControllerLogical.EntityCannotParticipateFKRelationship"));
                }
                if ((entity.isBST() || entity2.isBST()) && (LogicalDesign.ONE_TO_MANY_IDENTIFYING == this.relationType || LogicalDesign.ONE_TO_ONE_IDENTIFYING == this.relationType)) {
                    arrayList.add(Messages.getString("ControllerLogical.EntityCannotBePartIdentifyingRelationship"));
                }
            }
            this.checkFKPossibility(entity, entity2, arrayList);
            if (arrayList.size() == 0) {
                Object object2;
                boolean bl;
                if (entity == entity2 && (LogicalDesign.ONE_TO_MANY_IDENTIFYING == this.relationType || LogicalDesign.ONE_TO_ONE_IDENTIFYING == this.relationType)) {
                    this.relationType = LogicalDesign.ONE_TO_MANY_IDENTIFYING == this.relationType ? LogicalDesign.ONE_TO_MANY : LogicalDesign.ONE_TO_ONE;
                    object = Messages.getString("ControllerLogical.RecRelationshipCannotBeIdentifying");
                    JOptionPane.showMessageDialog(ControllerLogical.this.getDesignPartView(), object, Messages.getString("ControllerLogical.NewRelation"), 2);
                }
                if ((bl = entity.hasFK_Rel_PathTo(entity2)) && (LogicalDesign.ONE_TO_MANY_IDENTIFYING == this.relationType || LogicalDesign.ONE_TO_ONE_IDENTIFYING == this.relationType)) {
                    this.relationType = LogicalDesign.ONE_TO_MANY_IDENTIFYING == this.relationType ? LogicalDesign.ONE_TO_MANY : LogicalDesign.ONE_TO_ONE;
                    object2 = Messages.getString("ControllerLogical.CiclicRefWillBeCreated");
                    JOptionPane.showMessageDialog(ControllerLogical.this.getDesignPartView(), object2, Messages.getString("ControllerLogical.NewRelation"), 2);
                }
                if ((object2 = this.createRelation(tVEntity, tVEntity2)) != null && ((ModelObject)object2).getDesign().getAppView().getSettings().showPropertiesDialogOnNew()) {
                    RelationPropertiesDialogEx relationPropertiesDialogEx = new RelationPropertiesDialogEx(ControllerLogical.this.getApplicationView(), (DesignObject)object2);
                    ((ModelIDObject)object2).setShowForFirstTime(true);
                    relationPropertiesDialogEx.initProperties((DesignObject)object2);
                    relationPropertiesDialogEx.setModal(true);
                    relationPropertiesDialogEx.show();
                }
            } else {
                JOptionPane.showMessageDialog(ControllerLogical.this.getDesignPartView(), arrayList.toArray(), Messages.getString("ControllerLogical.NewRelation"), 0);
            }
            ControllerLogical.this.select_SelectAction();
        }

        private void checkFKPossibility(Entity entity, Entity entity2, List list) {
            if (entity != null && entity2 != null) {
                Attribute attribute;
                if (entity2.isBST()) {
                    Attribute attribute2;
                    if (entity.isBST() && (attribute2 = entity2.getRefToStructurtedType(entity.getBasedOnStructuredType(), entity)) == null) {
                        list.add(Messages.getString("ControllerLogical.ChildEntityDoesntHaveAttribute"));
                    }
                } else if (entity.isBST() && entity2.isBST() && (attribute = entity2.getRefToStructurtedType(entity.getBasedOnStructuredType(), entity)) == null) {
                    list.add(Messages.getString("ControllerLogical.ChildEntityDoesntHaveAttribute"));
                }
            }
        }

        private TVEntity getTVEntityFor(Point point) {
            Object object = ControllerLogical.this.getDesignPartView().getWorkSpace().getFirstCellForLocation(point.getX(), point.getY());
            if (object != null && object instanceof EntityDiagramCell) {
                return (TVEntity)((EntityDiagramCell)object).getTopView();
            }
            return null;
        }

        private Relation createRelation(TVEntity tVEntity, TVEntity tVEntity2) {
            ApplicationView.log(Messages.getString("ControllerLogical.CreateRelation"));
            Relation relation = ControllerLogical.this.getLogicalDesign().createRelation(this.relationType);
            if (LogicalDesign.ONE_TO_ONE_IDENTIFYING == this.relationType) {
                relation.setDominantRole((Entity)tVEntity.getModel());
                relation.setOptionalTarget(false);
            } else if (LogicalDesign.ONE_TO_MANY_IDENTIFYING == this.relationType) {
                relation.setOptionalTarget(false);
            }
            relation.setTargetEntity((Entity)tVEntity2.getModel());
            relation.setSourceEntity((Entity)tVEntity.getModel());
            relation.setSourceTV(tVEntity);
            relation.setTargetTV(tVEntity2);
            relation.addToAllDPVs();
            TVRelation tVRelation = (TVRelation)relation.getTopView();
            tVRelation.addConnection();
            return relation;
        }

        @Override
        public Component getTargetCoordinateSpace() {
            return ControllerLogical.this.getDesignPartView().getWorkSpace();
        }
    }

    class RemoveFromArc
    extends MDBAction {
        private RemoveFromArc() {
            super(MenuUtils.getMnemonicStr(AbstractController.REMOVE_FROM_ARC), ControllerLogical.this.getConfiguration().getIcon("REMOVE_FROM_ARC_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.REMOVE_FROM_ARC));
            this.setObjectAction(true);
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl && this.canHandle());
        }

        private boolean canHandle() {
            if (ControllerLogical.this.getDesign().isLoadFromDB() && !ControllerLogical.this.getDesignPartView().getDesignPart().isCheckedOutByMe()) {
                return false;
            }
            Object[] objectArray = ControllerLogical.this.getDesignPartView().getSelectedObjects();
            return ControllerLogical.this.getLogicalDesign().canRemoveFromArc(objectArray);
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = ControllerLogical.this.getDesignPartView().getSelectedObjects();
            ControllerLogical.this.getLogicalDesign().removeFromArc(objectArray);
            this.setEnabled(false);
        }
    }

    class AddToArc
    extends MDBAction {
        private AddToArc() {
            super(MenuUtils.getMnemonicStr(AbstractController.ADD_TO_ARC), ControllerLogical.this.getConfiguration().getIcon("ADD_TO_ARC_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.ADD_TO_ARC));
            this.setObjectAction(true);
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl && this.canHandle());
        }

        private boolean canHandle() {
            if (ControllerLogical.this.getDesign().isLoadFromDB() && !ControllerLogical.this.getDesignPartView().getDesignPart().isCheckedOutByMe()) {
                return false;
            }
            Object[] objectArray = ControllerLogical.this.getDesignPartView().getSelectedObjects();
            return ControllerLogical.this.getLogicalDesign().canAddToArc(objectArray);
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = ControllerLogical.this.getDesignPartView().getSelectedObjects();
            ControllerLogical.this.getLogicalDesign().addToArc(objectArray);
            this.setEnabled(false);
        }
    }

    class NewArc
    extends MDBAction {
        private NewArc() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_ARC), ControllerLogical.this.getConfiguration().getIcon("NEW_ARC_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_ARC));
            this.setObjectAction(true);
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl && this.canHandle());
        }

        private boolean canHandle() {
            if (ControllerLogical.this.getDesign().isLoadFromDB() && !ControllerLogical.this.getDesignPartView().getDesignPart().isCheckedOutByMe()) {
                return false;
            }
            Object[] objectArray = ControllerLogical.this.getDesignPartView().getSelectedObjects();
            return ControllerLogical.this.getLogicalDesign().canCreateArc(objectArray);
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = ControllerLogical.this.getDesignPartView().getSelectedObjects();
            ControllerLogical.this.getLogicalDesign().createArc(objectArray);
            this.setEnabled(false);
        }
    }

    class NewRelationOneToOne
    extends MDBAction {
        private NewRelationOneToOne() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_1_TO_1_RELATION_CAPTION), ControllerLogical.this.getConfiguration().getIcon("ONE_TO_1_RELATION_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_1_TO_1_RELATION_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerLogical.this.getDesignPartView().getWorkSpace().setDrawnObjectID(1);
            ControllerLogical.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerLogical.this.updateToolbar(this);
            if (ControllerLogical.this.eCollector != null) {
                ControllerLogical.this.eCollector.stopWaiting();
            }
            ControllerLogical.this.eCollector = new EntityCollector(LogicalDesign.ONE_TO_ONE);
        }
    }

    class NewRelationOneToManyIdentifying
    extends MDBAction {
        private NewRelationOneToManyIdentifying() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_1_TO_N_IDENTIFYING_RELATION_CAPTION), ControllerLogical.this.getConfiguration().getIcon("ONE_TO_N_I_RELATION_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_1_TO_N_IDENTIFYING_RELATION_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerLogical.this.getDesignPartView().getWorkSpace().setDrawnObjectID(1);
            ControllerLogical.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerLogical.this.updateToolbar(this);
            if (ControllerLogical.this.eCollector != null) {
                ControllerLogical.this.eCollector.stopWaiting();
            }
            ControllerLogical.this.eCollector = new EntityCollector(LogicalDesign.ONE_TO_MANY_IDENTIFYING);
        }
    }

    class NewRelationOneToMany
    extends MDBAction {
        private NewRelationOneToMany() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_1_TO_N_RELATION_CAPTION), ControllerLogical.this.getConfiguration().getIcon("ONE_TO_N_RELATION_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setObjectAction(true);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_1_TO_N_RELATION_CAPTION));
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerLogical.this.getDesignPartView().getWorkSpace().setDrawnObjectID(1);
            ControllerLogical.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerLogical.this.updateToolbar(this);
            if (ControllerLogical.this.eCollector != null) {
                ControllerLogical.this.eCollector.stopWaiting();
            }
            ControllerLogical.this.eCollector = new EntityCollector(LogicalDesign.ONE_TO_MANY);
        }
    }

    class NewRelationManyToMany
    extends MDBAction {
        private NewRelationManyToMany() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_M_TO_N_RELATION_CAPTION), ControllerLogical.this.getConfiguration().getIcon("M_TO_N_RELATION_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_M_TO_N_RELATION_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            ControllerLogical.this.getDesignPartView().getWorkSpace().setDrawnObjectID(1);
            ControllerLogical.this.getDesignPartView().getWorkSpace().setCursor(Diagram.LINE_CURSOR);
            ControllerLogical.this.updateToolbar(this);
            if (ControllerLogical.this.eCollector != null) {
                ControllerLogical.this.eCollector.stopWaiting();
            }
            ControllerLogical.this.eCollector = new EntityCollector(LogicalDesign.MANY_TO_MANY);
        }
    }

    public class FWDEngineer
    extends MDBAction {
        private FWDEngineer() {
            super(MenuUtils.getMnemonicStr(AbstractController.FORWARD_ENGINEER_CAPTION), ControllerLogical.this.getConfiguration().getIcon("FORWARD_ENGINEER_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.DESIGN_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.FORWARD_ENGINEER_CAPTION));
            this.setAccelerator(KeyStroke.getKeyStroke(70, 192, false));
        }

        @Override
        public boolean addSeparatorAfter() {
            return true;
        }

        @Override
        public boolean addToolbarSeparator() {
            return true;
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl && this.canHandle());
        }

        private boolean canHandle() {
            return !ControllerLogical.this.getDesign().isLoadFromDB() || ControllerLogical.this.getDesignPartView().getDesignPart().isCheckedOutByMe();
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerLogical.this.getDesign().getFirstOpenRelationalDesign() != null) {
                EngineeringCompareDialog engineeringCompareDialog = new EngineeringCompareDialog(ControllerLogical.this.getApplicationView(), ControllerLogical.this.getApplicationView().getCurrentDPV().getDesignPart());
                engineeringCompareDialog.setModal(true);
                engineeringCompareDialog.show();
            } else {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ControllerLogical.NoRelModelsAvailable"), Messages.getString("ControllerLogical.Warning"), 2);
            }
        }
    }

    class NewNote
    extends MDBAction {
        private NewNote() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_NOTE_CAPTION), ControllerLogical.this.getConfiguration().getIcon("NOTE_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_NOTE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerLogical.this.eCollector != null) {
                ControllerLogical.this.eCollector.stopWaiting();
            }
            ControllerLogical.this.getDesignPartView().getWorkSpace().setDrawnObjectID(5);
            ControllerLogical.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerLogical.this.updateToolbar(this);
        }
    }

    class NewEntityView
    extends MDBAction {
        private NewEntityView() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_VIEW_CAPTION), ControllerLogical.this.getConfiguration().getIcon("ENTITY_VIEW_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_VIEW_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerLogical.this.eCollector != null) {
                ControllerLogical.this.eCollector.stopWaiting();
            }
            ControllerLogical.this.getDesignPartView().getWorkSpace().setDrawnObjectID(19);
            ControllerLogical.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerLogical.this.updateToolbar(this);
        }
    }

    class NewEntity
    extends MDBAction {
        private NewEntity() {
            super(MenuUtils.getMnemonicStr(AbstractController.NEW_ENTITY_CAPTION), ControllerLogical.this.getConfiguration().getIcon("ENTITY_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.NEW_ENTITY_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerLogical.this.eCollector != null) {
                ControllerLogical.this.eCollector.stopWaiting();
            }
            ControllerLogical.this.getDesignPartView().getWorkSpace().setDrawnObjectID(0);
            ControllerLogical.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(1));
            ControllerLogical.this.updateToolbar(this);
        }
    }

    class Delete
    extends MDBAction {
        private Delete() {
            super(MenuUtils.getMnemonicStr(AbstractController.DELETE_CAPTION), ControllerLogical.this.getConfiguration().getIcon("DELETE_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.DELETE_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerLogical.this.eCollector != null) {
                ControllerLogical.this.eCollector.stopWaiting();
            }
            ControllerLogical.this.getDesignPartView().getWorkSpace().setDrawnObjectID(6);
            ControllerLogical.this.getDesignPartView().getWorkSpace().setCursor(Diagram.DELETE_CURSOR);
            ControllerLogical.this.updateToolbar(this);
        }
    }

    class Select
    extends MDBAction {
        private Select() {
            super(MenuUtils.getMnemonicStr(AbstractController.SELECT_CAPTION), ControllerLogical.this.getConfiguration().getIcon("SELECT_ICON", ControllerLogical.this.getPreferredIconSize()));
            this.setMenuPath(ControllerLogical.this.OBJECT_LOGICAL_PATH);
            this.setMnemonic(MenuUtils.getMnemonicKey(AbstractController.SELECT_CAPTION));
            this.setObjectAction(true);
        }

        @Override
        public boolean isToggleButton() {
            return true;
        }

        @Override
        public void doActionPerformed(ActionEvent actionEvent) {
            if (ControllerLogical.this.eCollector != null) {
                ControllerLogical.this.eCollector.stopWaiting();
            }
            ControllerLogical.this.getDesignPartView().getWorkSpace().setDrawnObjectID(-1);
            ControllerLogical.this.getDesignPartView().getWorkSpace().setCursor(new Cursor(0));
            ControllerLogical.this.updateToolbar(this);
        }
    }
}

