/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.glossary;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.GeneralPropertiesComparator;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.engineering.EngFilter;
import oracle.dbtools.crest.model.design.engineering.EngFilteredSelection;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngineeringObjectSelection;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.glossary.GlossaryImportSelection;
import oracle.dbtools.crest.model.design.glossary.GlossaryImporter;
import oracle.dbtools.crest.model.design.glossary.WordPropertiesComparator;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.TextCompareDialog;
import oracle.dbtools.crest.swingui.engineeringcompare.CompareCheckEditor;
import oracle.dbtools.crest.swingui.engineeringcompare.CompareTreeRenderer;
import oracle.dbtools.crest.swingui.glossary.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class ImportGlossaryDialog
extends CustomDialog
implements TreeSelectionListener,
TreeExpansionListener,
AdjustmentListener {
    private JPanel leftTreePanel;
    private JPanel rightTreePanel;
    private CompareTreeNavigationDesign leftNavDesign;
    private CompareTreeNavigationDesign rightNavDesign;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JScrollPane detailsSP;
    private MyJTree leftTree;
    private MyJTree rightTree;
    private JTable compareTable = new JTable();
    private SelectedCellRenderer selRenderer = new SelectedCellRenderer();
    private ModifiableCellRenderer propertyNamerenderer = new ModifiableCellRenderer();
    private JDialog dialog;
    private JPanel buttonPanel;
    private static String STATE_ALL = Messages.getString("ImportGlossaryDialog.ShowAllObjects");
    private static String STATE_NEW = Messages.getString("ImportGlossaryDialog.ShowNewObjects");
    private static String STATE_MODIFIED = Messages.getString("ImportGlossaryDialog.ShowModifiedObjects");
    JCheckBoxMenuItem item = new JCheckBoxMenuItem(STATE_ALL);
    JCheckBoxMenuItem item1 = new JCheckBoxMenuItem(STATE_NEW);
    JCheckBoxMenuItem item3 = new JCheckBoxMenuItem(STATE_MODIFIED);
    private JPopupMenu menu;
    private GlossaryImportSelection leftEngineer = null;
    private Glossary destination;
    JScrollBar leftSB;
    JScrollBar rightSB;
    private JButton button;
    JButton bnOpenFile;
    JCheckBox chbSaveInDefDomains;
    MyJTree startTree = null;
    boolean started = false;
    boolean sb_started = false;
    boolean sel_started = false;

    public ImportGlossaryDialog(ApplicationView applicationView, Glossary glossary, Glossary glossary2) {
        super(applicationView);
        this.destination = glossary2;
        this.leftEngineer = new GlossaryImportSelection(glossary, glossary2, applicationView.getCurrentDesign().getDesign());
        this.initRightTreePanel(this.leftEngineer.getRightRoot());
        this.initLeftTreePanel(this.leftEngineer.getLeftRoot());
        this.resetRightTree(this.leftEngineer.getRightRoot());
        this.resetLeftTree(this.leftEngineer.getLeftRoot());
        this.leftTreePanel.setPreferredSize(new Dimension(350, 400));
        this.rightTreePanel.setPreferredSize(new Dimension(350, 400));
        this.leftTreePanel.setMinimumSize(new Dimension(350, 200));
        this.rightTreePanel.setMinimumSize(new Dimension(350, 200));
        this.tabbedPane.setPreferredSize(new Dimension(700, 200));
        this.detailsSP = new JScrollPane(this.compareTable);
        this.compareTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2 && ((n = ImportGlossaryDialog.this.compareTable.getSelectedColumn()) == 2 || n == 3)) {
                    int n2 = ImportGlossaryDialog.this.compareTable.getSelectedRow();
                    String string = (String)ImportGlossaryDialog.this.compareTable.getModel().getValueAt(n2, 0);
                    Object object = ImportGlossaryDialog.this.compareTable.getModel().getValueAt(n2, 2);
                    Object object2 = ImportGlossaryDialog.this.compareTable.getModel().getValueAt(n2, 3);
                    if (object instanceof String && object2 instanceof String && (!"".equalsIgnoreCase((String)object) || !"".equalsIgnoreCase((String)object2))) {
                        TextCompareDialog textCompareDialog = new TextCompareDialog(ImportGlossaryDialog.this.getApplicationView(), (String)object, (String)object2);
                        textCompareDialog.setTitle(string);
                        textCompareDialog.showDialog();
                    }
                }
            }
        });
        this.detailsSP.setPreferredSize(new Dimension(700, 200));
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setLeftComponent(this.leftTreePanel);
        jSplitPane.setRightComponent(this.rightTreePanel);
        jSplitPane.setDividerLocation(-1);
        jSplitPane.setResizeWeight(0.5);
        JSplitPane jSplitPane2 = new JSplitPane(0, jSplitPane, this.tabbedPane);
        this.add((Component)jSplitPane2, "Center");
        this.tabbedPane.add(Messages.getString("ImportGlossaryDialog.Details"), this.detailsSP);
        this.initToolbar();
        this.add((Component)this.getButtonPanel(), "South");
        this.updateCompareTable(null);
    }

    public String getCaption() {
        return Messages.getString("ImportGlossaryDialog.ImportOfNamingStandardDefinitions");
    }

    private void initLeftTreePanel(ModelIdObjectSelection modelIdObjectSelection) {
        this.leftTreePanel = new JPanel(new BorderLayout());
        this.leftTree = new MyJTree();
        this.leftTree.setEditable(true);
        CompareTreeRenderer compareTreeRenderer = new CompareTreeRenderer(true);
        this.leftTree.setCellRenderer(compareTreeRenderer);
        CompareCheckEditor compareCheckEditor = new CompareCheckEditor(true);
        this.leftTree.setCellEditor(compareCheckEditor);
        JScrollPane jScrollPane = new JScrollPane(this.leftTree);
        this.leftTreePanel.add((Component)jScrollPane, "Center");
        this.leftTree.addTreeSelectionListener(this);
        this.leftTree.addTreeExpansionListener(this);
        this.leftSB = jScrollPane.getVerticalScrollBar();
        this.leftSB.addAdjustmentListener(this);
    }

    private void resetLeftTree(EngineeringObjectSelection engineeringObjectSelection) {
        engineeringObjectSelection.resetModifiedStatus();
        this.leftNavDesign = new CompareTreeNavigationDesign(engineeringObjectSelection);
        this.leftTree.setModel(this.leftNavDesign);
    }

    private void initRightTreePanel(ModelIdObjectSelection modelIdObjectSelection) {
        this.rightTreePanel = new JPanel(new BorderLayout());
        this.rightTree = new MyJTree();
        CompareTreeRenderer compareTreeRenderer = new CompareTreeRenderer(false);
        compareTreeRenderer.setShowCheckbox(false);
        this.rightTree.setCellRenderer(compareTreeRenderer);
        JScrollPane jScrollPane = new JScrollPane(this.rightTree);
        this.rightTreePanel.add((Component)jScrollPane, "Center");
        this.rightTree.addTreeSelectionListener(this);
        this.rightTree.addTreeExpansionListener(this);
        this.rightSB = jScrollPane.getVerticalScrollBar();
        this.rightSB.addAdjustmentListener(this);
    }

    private void resetRightTree(EngineeringObjectSelection engineeringObjectSelection) {
        engineeringObjectSelection.resetModifiedStatus();
        this.rightNavDesign = new CompareTreeNavigationDesign(engineeringObjectSelection);
        this.rightTree.setModel(this.rightNavDesign);
    }

    private void unregisterListeners() {
        this.leftNavDesign.unregisterAsListener();
        this.rightNavDesign.unregisterAsListener();
    }

    private void initToolbar() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.button = new JButton(Messages.getString("ImportGlossaryDialog.Filter"));
        this.button.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu = ImportGlossaryDialog.this.getFilterPopupMenu();
                jPopupMenu.show(ImportGlossaryDialog.this.button, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            }
        });
        jPanel.add(this.button);
        this.leftTreePanel.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        this.rightTreePanel.add((Component)jPanel2, "North");
        jPanel2.setPreferredSize(jPanel.getPreferredSize());
    }

    private void engineer() {
        GlossaryImporter glossaryImporter = new GlossaryImporter();
        glossaryImporter.importWords(this.leftEngineer.getLeftRoot().getChilds(), this.destination);
        if (((JDialog)this.getDialog()).isModal()) {
            this.unregisterListeners();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.synchroizeSelection(treeSelectionEvent);
        TreePath treePath = treeSelectionEvent.getPath();
        Object object = treePath.getLastPathComponent();
        this.updateCompareTable(object);
    }

    private void updateCompareTable(Object object) {
        if (object instanceof EngineeringObjectSelection || object == null) {
            int[] nArray = new int[]{0, 0, 0, 0};
            boolean bl = this.compareTable.getColumnModel() != null;
            int n = 4;
            if (bl) {
                n = this.compareTable.getColumnModel().getColumnCount();
                for (int i = 0; i < n; ++i) {
                    nArray[i] = this.compareTable.getColumnModel().getColumn(i).getWidth();
                }
            }
            GeneralPropertiesComparator generalPropertiesComparator = object == null ? new WordPropertiesComparator(null, null) : ((EngineeringObjectSelection)object).getPropertiesComparator();
            this.compareTable.setModel(new CompareModel(generalPropertiesComparator));
            this.compareTable.getColumnModel().getColumn(1);
            TableColumn tableColumn = this.compareTable.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(60);
            tableColumn.setWidth(60);
            tableColumn.setMaxWidth(70);
            tableColumn.setCellRenderer(this.selRenderer);
            tableColumn = this.compareTable.getColumnModel().getColumn(0);
            tableColumn.setCellRenderer(this.propertyNamerenderer);
            if (bl) {
                for (int i = 0; i < n; ++i) {
                    this.compareTable.getColumnModel().getColumn(i).setWidth(nArray[i]);
                    this.compareTable.getColumnModel().getColumn(i).setPreferredWidth(nArray[i]);
                }
            }
            this.compareTable.updateUI();
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        this.processExpEvent(treeExpansionEvent, false);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.processExpEvent(treeExpansionEvent, true);
    }

    void processExpEvent(TreeExpansionEvent treeExpansionEvent, boolean bl) {
        Object object = treeExpansionEvent.getSource();
        if (object instanceof JTree && !this.started) {
            this.startTree = (MyJTree)object;
            this.started = true;
            TreePath treePath = treeExpansionEvent.getPath();
            EngineeringObjectSelection engineeringObjectSelection = (EngineeringObjectSelection)treePath.getLastPathComponent();
            MyJTree myJTree = this.getOtherTree(this.startTree);
            myJTree.setExpandedState(new TreePath(engineeringObjectSelection.getCorrespondentNode().getPath()), bl);
            this.started = false;
        }
    }

    MyJTree getOtherTree(JTree jTree) {
        if (jTree == this.leftTree) {
            return this.rightTree;
        }
        return this.leftTree;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        if (object instanceof JScrollBar && !this.sb_started) {
            JScrollBar jScrollBar = (JScrollBar)object;
            if (jScrollBar == this.leftSB) {
                this.sb_started = true;
                this.rightSB.setValue(this.leftSB.getValue());
                this.sb_started = false;
            } else if (jScrollBar == this.rightSB) {
                this.sb_started = true;
                this.leftSB.setValue(this.rightSB.getValue());
                this.sb_started = false;
            }
        }
    }

    private void synchroizeSelection(TreeSelectionEvent treeSelectionEvent) {
        Object object = treeSelectionEvent.getSource();
        if (object instanceof JTree && !this.sel_started) {
            this.startTree = (MyJTree)object;
            this.sel_started = true;
            TreePath treePath = treeSelectionEvent.getPath();
            EngineeringObjectSelection engineeringObjectSelection = (EngineeringObjectSelection)treePath.getLastPathComponent();
            MyJTree myJTree = this.getOtherTree(this.startTree);
            myJTree.setSelectionPath(new TreePath(engineeringObjectSelection.getCorrespondentNode().getPath()));
            this.sel_started = false;
        }
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), this.getCaption());
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.addWindowListener(new ClosingListener());
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    int n = ImportGlossaryDialog.this.dialog.getWidth();
                    int n2 = ImportGlossaryDialog.this.dialog.getHeight();
                    n = Math.max(720, n);
                    n2 = Math.max(600, n2);
                    ImportGlossaryDialog.this.dialog.setSize(n, n2);
                }
            });
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "IMPORT_GLOSSARY_DIALOG";
    }

    public void setModal(boolean bl) {
        ((JDialog)this.getDialog()).setModal(bl);
    }

    @Override
    public void show() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new FlowLayout(2));
            JButton jButton = new JButton(Messages.getString("ImportGlossaryDialog.Import"));
            jButton.setMnemonic(69);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ImportGlossaryDialog.this.engineer();
                    ImportGlossaryDialog.this.close();
                }
            });
            JButton jButton2 = new JButton(Messages.getString("ImportGlossaryDialog.Cancel"));
            jButton2.setMnemonic(67);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ImportGlossaryDialog.this.close();
                }
            });
            JButton jButton3 = new JButton(this.getHelpAction());
            jButton3.setMnemonic(72);
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton3.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(jButton);
            this.buttonPanel.add(jButton2);
            this.buttonPanel.add(jButton3);
        }
        return this.buttonPanel;
    }

    private void setFilter(JTree jTree, EngFilter engFilter) {
        EngineeringObjectSelection engineeringObjectSelection = (EngineeringObjectSelection)jTree.getModel().getRoot();
        ((EngFilteredSelection)engineeringObjectSelection).setFilter(engFilter);
    }

    private JPopupMenu getFilterPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            this.item.addActionListener(new ShowAllListener());
            this.item.setSelected(true);
            this.item.setEnabled(false);
            this.item1.addActionListener(new PopupMenuListener());
            this.item3.addActionListener(new PopupMenuListener());
            this.menu.add(this.item);
            this.menu.add(this.item1);
            this.menu.add(this.item3);
        }
        return this.menu;
    }

    class ShowAllListener
    implements ActionListener {
        EngFilter filter = new EngFilter();

        ShowAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ImportGlossaryDialog.this.item.isSelected()) {
                this.filter.clearFilters();
                ImportGlossaryDialog.this.item.setEnabled(false);
                ImportGlossaryDialog.this.item1.setSelected(false);
                ImportGlossaryDialog.this.item3.setSelected(false);
                this.filter.addFilter(EngFilter.NO_FILTER);
                ImportGlossaryDialog.this.setFilter(ImportGlossaryDialog.this.leftTree, this.filter);
                ImportGlossaryDialog.this.setFilter(ImportGlossaryDialog.this.rightTree, this.filter);
                ImportGlossaryDialog.this.leftTree.updateUI();
                ImportGlossaryDialog.this.rightTree.updateUI();
            } else {
                ImportGlossaryDialog.this.item.setEnabled(true);
            }
            ImportGlossaryDialog.this.item.setSelected(true);
        }
    }

    class PopupMenuListener
    implements ActionListener {
        EngFilter filter = new EngFilter();

        PopupMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.filter.clearFilters();
            if (ImportGlossaryDialog.this.item1.isSelected() || ImportGlossaryDialog.this.item3.isSelected()) {
                ImportGlossaryDialog.this.item.setSelected(false);
            }
            if (ImportGlossaryDialog.this.item1.isSelected()) {
                this.filter.addFilter(EngFilter.STATE_NEW_FILTER);
            }
            if (ImportGlossaryDialog.this.item3.isSelected()) {
                this.filter.addFilter(EngFilter.STATE_MODIFIED_FILTER);
            }
            ImportGlossaryDialog.this.item.setEnabled(true);
            if (!ImportGlossaryDialog.this.item1.isSelected() && !ImportGlossaryDialog.this.item3.isSelected()) {
                this.filter.addFilter(EngFilter.NO_FILTER);
                ImportGlossaryDialog.this.item.setSelected(true);
                ImportGlossaryDialog.this.item.setEnabled(false);
            }
            ImportGlossaryDialog.this.setFilter(ImportGlossaryDialog.this.leftTree, this.filter);
            ImportGlossaryDialog.this.setFilter(ImportGlossaryDialog.this.rightTree, this.filter);
            ImportGlossaryDialog.this.leftTree.updateUI();
            ImportGlossaryDialog.this.rightTree.updateUI();
        }
    }

    class ModifiableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ModifiableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (jTable.getModel() instanceof CompareModel) {
                CompareModel compareModel = (CompareModel)jTable.getModel();
                EngPropertyHolder engPropertyHolder = (EngPropertyHolder)compareModel.getPropertiesList().get(n);
                this.setOpaque(true);
                this.setText(engPropertyHolder.getName());
                if (engPropertyHolder.isModified()) {
                    this.setForeground(Color.RED);
                } else {
                    this.setForeground(jTable.getForeground());
                }
                if (bl) {
                    this.setBackground(jTable.getSelectionBackground());
                    if (!engPropertyHolder.isModified()) {
                        this.setForeground(jTable.getSelectionForeground());
                    }
                } else {
                    this.setBackground(jTable.getBackground());
                }
            }
            this.setHorizontalAlignment(2);
            return this;
        }
    }

    class SelectedCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        SelectedCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3 = (Boolean)object;
            if (jTable.getModel() instanceof CompareModel) {
                CompareModel compareModel = (CompareModel)jTable.getModel();
                EngPropertyHolder engPropertyHolder = (EngPropertyHolder)compareModel.getPropertiesList().get(n);
                this.setOpaque(true);
                this.setHorizontalAlignment(0);
                this.setSelected(bl3);
                if (engPropertyHolder.isModified()) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
                if (bl) {
                    this.setBackground(jTable.getSelectionBackground());
                } else {
                    this.setBackground(jTable.getBackground());
                }
            }
            return this;
        }
    }

    public class CompareModel
    extends AbstractTableModel {
        private GeneralPropertiesComparator comp;

        CompareModel(GeneralPropertiesComparator generalPropertiesComparator) {
            this.comp = generalPropertiesComparator;
        }

        public List getPropertiesList() {
            return this.comp.getPropertiesList();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.comp.getPropertiesList().size();
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Messages.getString("ImportGlossaryDialog.Property");
            }
            if (n == 1) {
                return Messages.getString("ImportGlossaryDialog.Selected");
            }
            if (n == 2) {
                return this.comp.getLeftName();
            }
            if (n == 3) {
                return this.comp.getRightName();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 1) {
                EngPropertyHolder engPropertyHolder = (EngPropertyHolder)this.comp.getPropertiesList().get(n);
                return engPropertyHolder.isEditable();
            }
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            EngPropertyHolder engPropertyHolder = (EngPropertyHolder)this.comp.getPropertiesList().get(n);
            if (n2 == 0) {
                return engPropertyHolder.getName();
            }
            if (n2 == 1) {
                return new Boolean(engPropertyHolder.isSelected());
            }
            if (n2 == 2) {
                return engPropertyHolder.getLeftValue();
            }
            if (n2 == 3) {
                return engPropertyHolder.getRightValue();
            }
            return new Integer(n * n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                EngPropertyHolder engPropertyHolder = (EngPropertyHolder)this.comp.getPropertiesList().get(n);
                engPropertyHolder.setSelected((Boolean)object);
            }
        }
    }

    class MyJTree
    extends JTree {
        public MyJTree(TreeModel treeModel) {
            super(treeModel);
        }

        public MyJTree() {
        }

        @Override
        protected void setExpandedState(TreePath treePath, boolean bl) {
            super.setExpandedState(treePath, bl);
        }
    }

    class ClosingListener
    extends WindowAdapter {
        ClosingListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            ImportGlossaryDialog.this.unregisterListeners();
        }
    }
}

