/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.engineeringcompare;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.engineering.EngineeringObjectSelection;
import oracle.dbtools.crest.swingui.engineeringcompare.CompareTreeRenderer;
import oracle.dbtools.crest.swingui.engineeringcompare.EngineeringCompareDialog;
import oracle.dbtools.crest.swingui.engineeringcompare.Messages;

public class CompareCheckEditor
extends CompareTreeRenderer
implements TreeCellEditor,
ActionListener {
    private Set listeners = new HashSet();
    protected CellEditorListener list;

    public CompareCheckEditor(boolean bl) {
        super(bl);
        this.cbox.addActionListener(this);
    }

    @Override
    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        Component component = this.getTreeCellRendererComponent(jTree, object, true, bl2, bl3, n, true);
        return component;
    }

    @Override
    public boolean stopCellEditing() {
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        this.enableEngineerButton();
        return this.node;
    }

    private void enableEngineerButton() {
        if (this.node instanceof ModelIdObjectSelection) {
            boolean bl = this.node.checkSelected();
            String string = "checkSelected() is " + String.valueOf(bl);
            String string2 = Messages.getString("EngineeringCompareDialog.Engineer");
            Container container = this.getParentDialog(this.panel);
            if (container != null && container instanceof EngineeringCompareDialog) {
                EngineeringCompareDialog engineeringCompareDialog = (EngineeringCompareDialog)container;
                engineeringCompareDialog.enableButton(string2, bl);
            }
        }
    }

    private Container getParentDialog(Container container) {
        if (container instanceof EngineeringCompareDialog) {
            return container;
        }
        Container container2 = container.getParent();
        if (container2 == null) {
            return container;
        }
        return this.getParentDialog(container2);
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        MouseEvent mouseEvent;
        JTree jTree;
        TreePath treePath;
        Object object = eventObject.getSource();
        if (object instanceof JTree && eventObject instanceof MouseEvent && (treePath = (jTree = (JTree)object).getPathForLocation((mouseEvent = (MouseEvent)eventObject).getX(), mouseEvent.getY())) != null) {
            this.node = (EngineeringObjectSelection)treePath.getLastPathComponent();
        }
        if (this.node != null) {
            return this.node.isEditable();
        }
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.add(cellEditorListener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.remove(cellEditorListener);
    }

    protected void fireEditingStopped() {
        CellEditorListener[] cellEditorListenerArray = this.listeners.toArray(new CellEditorListener[0]);
        for (int i = 0; i < cellEditorListenerArray.length; ++i) {
            try {
                cellEditorListenerArray[i].editingStopped(new ChangeEvent(this));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void fireEditingCanceled() {
        CellEditorListener[] cellEditorListenerArray = this.listeners.toArray(new CellEditorListener[0]);
        for (int i = 0; i < cellEditorListenerArray.length; ++i) {
            try {
                cellEditorListenerArray[i].editingCanceled(new ChangeEvent(this));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.node.setSelected(this.cbox.isSelected());
    }
}

