/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.engineering;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectPlaceHolder;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.browser.EngineeringCheckEditor;
import oracle.dbtools.crest.swingui.browser.NavigationTreeRenderer;
import oracle.dbtools.crest.swingui.engineering.Messages;
import oracle.dbtools.crest.swingui.engineering.TreeNavigationDesign;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.ide.Ide;

public class EngineeringStatusDialog
extends JDialog
implements TreeSelectionListener {
    private JPanel treePanel;
    private ApplicationView appView;
    private DesignPart designPart;
    private TreeNavigationDesign stdes;
    private JComboBox pdcombo;
    private JComboBox ldvcombo;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JPanel buttons;
    private JPanel optionsTab;
    private JTextPane infoTab = new JTextPane();
    private JTextPane shouldBeDeletedTab;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private Border border1;
    private JScrollPane infoSP = new JScrollPane(this.infoTab);
    private TitledBorder titledBorder1;
    private Border border2;
    private JTree tree;
    private TitledBorder titledBorder2;
    private JPanel optionsPanel = new JPanel();
    private JPanel infoPanel = new JPanel();
    private JCheckBox showMappings = new JCheckBox(Messages.getString("EngineeringStatusDialog.ShowMappings"));
    private JCheckBox shouldBeDeleted = new JCheckBox(Messages.getString("EngineeringStatusDialog.DeleteGeneratedObjectsWithoutGenerator"));
    private JCheckBox engCoordinates = new JCheckBox(Messages.getString("EngineeringStatusDialog.EngineerCoordinates"));
    private JCheckBox engGenerated = new JCheckBox(Messages.getString("EngineeringStatusDialog.DoNotEngineerGeneratedObjects"));
    private JCheckBox engAsSubView = new JCheckBox(Messages.getString("EngineeringStatusDialog.AsSubView"));
    private JCheckBox replaceSpaces = new JCheckBox(Messages.getString("EngineeringStatusDialog.ReplaceSpacesWithUnderscore"));
    private JCheckBox capitalNames = new JCheckBox(Messages.getString("EngineeringStatusDialog.TransformNamesIntoCapitals"));

    public EngineeringStatusDialog(ApplicationView applicationView, DesignPart designPart) {
        super(applicationView.getFrame());
        this.appView = applicationView;
        this.designPart = designPart;
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        this.initTreePanel();
        this.treePanel.setPreferredSize(new Dimension(350, 500));
        this.tabbedPane.setPreferredSize(new Dimension(400, 500));
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setLeftComponent(this.treePanel);
        jSplitPane.setRightComponent(this.tabbedPane);
        jSplitPane.setDividerLocation(-1);
        jSplitPane.setOneTouchExpandable(true);
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.initButtons();
        this.addTabs();
        this.showObjectsWithOutOrigin();
        this.pack();
        this.centerOnScreen(this);
        this.addWindowListener(new ClosingListener());
    }

    public String getCaption() {
        return Messages.getString("EngineeringStatusDialog.Engineering");
    }

    private void initOptions() {
        this.border1 = new EtchedBorder(0);
        this.titledBorder1 = new TitledBorder(this.border1, Messages.getString("EngineeringStatusDialog.Options"));
        this.border2 = new EtchedBorder(0);
        this.titledBorder2 = new TitledBorder(this.border2, Messages.getString("EngineeringStatusDialog.ObjectInfo"));
        this.optionsPanel.setLayout(this.gridBagLayout1);
        this.optionsTab.setBorder(this.titledBorder1);
        this.optionsTab.setLayout(this.gridBagLayout2);
        this.infoPanel.setBorder(this.titledBorder2);
        this.infoPanel.setLayout(this.gridBagLayout3);
        this.optionsPanel.add((Component)this.optionsTab, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(16, 12, 0, 10), 4, 25));
        this.optionsTab.add((Component)this.shouldBeDeleted, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 12, 0, 4), 0, 0));
        this.optionsTab.add((Component)this.engCoordinates, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 12, 0, 82), 20, 0));
        this.optionsTab.add((Component)this.engGenerated, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 12, 4, 39), 3, 0));
        this.optionsTab.add((Component)this.replaceSpaces, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 12, 4, 39), 3, 0));
        this.optionsTab.add((Component)this.capitalNames, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 12, 4, 39), 3, 0));
        if (this.designPart instanceof RelationalDesign) {
            this.replaceSpaces.setEnabled(false);
            this.capitalNames.setEnabled(false);
        }
        this.optionsPanel.add((Component)this.infoPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 15.0, 10, 1, new Insets(0, 12, 11, 10), 8, 3));
        this.infoPanel.add((Component)this.infoSP, new GridBagConstraints(0, 1, 1, 1, 1.0, 20.0, 10, 1, new Insets(7, 10, 3, 8), 209, 117));
        this.infoPanel.add((Component)this.showMappings, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 10, 0, 94), 5, 0));
    }

    private void initTreePanel() {
        this.treePanel = new JPanel(new BorderLayout());
        this.stdes = new TreeNavigationDesign(this.designPart);
        this.tree = new JTree(this.stdes);
        this.tree.setEditable(true);
        NavigationTreeRenderer navigationTreeRenderer = new NavigationTreeRenderer();
        this.tree.setCellRenderer(navigationTreeRenderer);
        EngineeringCheckEditor engineeringCheckEditor = new EngineeringCheckEditor();
        this.tree.setCellEditor(engineeringCheckEditor);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.treePanel.add((Component)jScrollPane, "Center");
        this.tree.addTreeSelectionListener(this);
    }

    private void initButtons() {
        this.buttons = new JPanel(new FlowLayout());
        JButton jButton = new JButton(Messages.getString("EngineeringStatusDialog.Close"));
        jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton.setMnemonic(67);
        jButton.addActionListener(new CancelAction());
        this.buttons.add(jButton);
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(15, 10));
        this.buttons.add(jLabel);
        JButton jButton2 = new JButton(Messages.getString("EngineeringStatusDialog.EngineerTo"));
        jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        jButton2.addActionListener(new EngineerAction());
        this.engAsSubView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EngineeringStatusDialog.this.designPart.getDesign().setEngineerAsSubView(EngineeringStatusDialog.this.engAsSubView.isSelected());
            }
        });
        if (this.designPart instanceof LogicalDesign) {
            this.ldvcombo = new JComboBox();
            this.ldvcombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EngineeringStatusDialog.this.resetEngAsSubView();
                }
            });
            this.fillComboWithDPVs(this.designPart, this.ldvcombo);
            this.buttons.add(this.ldvcombo);
            this.buttons.add(jButton2);
            RelationalDesign[] relationalDesignArray = (RelationalDesign[])this.designPart.getDesign().getRelationalDesigns().toArray();
            this.pdcombo = new JComboBox<RelationalDesign>(relationalDesignArray);
            this.pdcombo.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.pdcombo.setSelectedItem(this.getDesign().getRelationalDesign());
            this.buttons.add(this.pdcombo);
            this.pdcombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EngineeringStatusDialog.this.showObjectsWithOutOrigin();
                }
            });
            if (this.designPart.getMainView() == this.appView.getCurrentDPV()) {
                this.engAsSubView.setSelected(false);
                this.engAsSubView.setEnabled(false);
                this.designPart.getDesign().setEngineerAsSubView(false);
            } else {
                this.engAsSubView.setSelected(true);
                this.designPart.getDesign().setEngineerAsSubView(true);
            }
            this.buttons.add(this.engAsSubView);
        } else if (this.designPart instanceof RelationalDesign) {
            JLabel jLabel2 = new JLabel(this.designPart.getName() + "    ");
            this.buttons.add(jLabel2);
            this.buttons.add(jButton2);
            JLabel jLabel3 = new JLabel(Messages.getString("EngineeringStatusDialog.LogicalModel") + this.getDesign().getLogicalDesign().getName());
            this.buttons.add(jLabel3);
            this.engAsSubView.setSelected(this.designPart.getDesign().isEngineerAsSubView());
            this.buttons.add(this.engAsSubView);
        }
        this.getContentPane().add((Component)this.buttons, "South");
    }

    private void addTabs() {
        this.addOptionsTab();
        this.initOptions();
        this.addShouldBeDeletedTab();
    }

    private void addShouldBeDeletedTab() {
        this.shouldBeDeletedTab = new JTextPane();
        this.tabbedPane.add(Messages.getString("EngineeringStatusDialog.ObjectsThatWillBeDeleted"), new JScrollPane(this.shouldBeDeletedTab));
    }

    private void addOptionsTab() {
        this.optionsTab = new JPanel();
        this.tabbedPane.add(Messages.getString("EngineeringStatusDialog.Options"), this.optionsPanel);
        this.initOptionsTab();
    }

    private void initOptionsTab() {
        this.initShowMappings();
        this.initShouldBeDeleted();
        this.initEngineerCoordinates();
        this.initEngineerGenerated();
        this.initReplaceSpaces();
        this.initCapitalNames();
    }

    public void centerOnScreen(JDialog jDialog) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = jDialog.getSize();
        Point point = new Point((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 3);
        jDialog.setLocation(point);
    }

    void initShowMappings() {
        this.showMappings.setSelected(this.designPart.getDesign().isShowMappingsInEngineeringDialog());
        this.showMappings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EngineeringStatusDialog.this.designPart.getDesign().setShowMappingsInEngineeringDialog(EngineeringStatusDialog.this.showMappings.isSelected());
                EngineeringStatusDialog.this.showInfo();
            }
        });
    }

    void initShouldBeDeleted() {
        this.shouldBeDeleted.setSelected(this.designPart.getDesign().isDeleteWithoutOrigin());
        this.shouldBeDeleted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EngineeringStatusDialog.this.designPart.getDesign().setDeleteWithoutOrigin(EngineeringStatusDialog.this.shouldBeDeleted.isSelected());
                EngineeringStatusDialog.this.showObjectsWithOutOrigin();
            }
        });
    }

    private void showObjectsWithOutOrigin() {
        if (this.shouldBeDeleted.isSelected()) {
            if (this.designPart instanceof LogicalDesign) {
                this.showRelObjectsWithOutOrigin((RelationalDesign)this.pdcombo.getSelectedItem());
            } else {
                this.showLogObjectsWithOutOrigin();
            }
            this.shouldBeDeletedTab.setCaretPosition(0);
        } else {
            this.shouldBeDeletedTab.setText("");
        }
    }

    private void resetEngAsSubView() {
        if (this.designPart.getMainView() == this.ldvcombo.getSelectedItem()) {
            this.engAsSubView.setSelected(false);
            this.engAsSubView.setEnabled(false);
            this.designPart.getDesign().setEngineerAsSubView(false);
        } else {
            this.engAsSubView.setEnabled(true);
            this.engAsSubView.setSelected(true);
            this.designPart.getDesign().setEngineerAsSubView(true);
        }
    }

    private void showLogObjectsWithOutOrigin() {
        LogicalDesign logicalDesign = this.designPart.getDesign().getLogicalDesign();
        StringBuffer stringBuffer = new StringBuffer(this.getDelEntitiesText(logicalDesign));
        stringBuffer.append(this.getDelCandidateKey(logicalDesign));
        stringBuffer.append(this.getDelRelationsText(logicalDesign));
        stringBuffer.append(this.getDelAttributesText(logicalDesign));
        this.shouldBeDeletedTab.setText(stringBuffer.toString());
    }

    private void showRelObjectsWithOutOrigin(RelationalDesign relationalDesign) {
        StringBuffer stringBuffer = new StringBuffer(this.getDelTablesText(relationalDesign));
        stringBuffer.append(this.getDelIndexesText(relationalDesign));
        stringBuffer.append(this.getDelFKeysText(relationalDesign));
        stringBuffer.append(this.getDelColumnsText(relationalDesign));
        this.shouldBeDeletedTab.setText(stringBuffer.toString());
    }

    void initEngineerCoordinates() {
        this.engCoordinates.setSelected(this.designPart.getDesign().isEngineerCoordinates());
        this.engCoordinates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EngineeringStatusDialog.this.designPart.getDesign().setEngineerCoordinates(EngineeringStatusDialog.this.engCoordinates.isSelected());
            }
        });
    }

    void initEngineerGenerated() {
        this.engGenerated.setEnabled(false);
        this.engGenerated.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EngineeringStatusDialog.this.designPart.getDesign().setEngineerGenerated(!EngineeringStatusDialog.this.engGenerated.isSelected());
            }
        });
    }

    private void initReplaceSpaces() {
        if (this.designPart instanceof LogicalDesign) {
            this.replaceSpaces.setSelected(this.designPart.getDesign().isReplaceSpaces());
            this.replaceSpaces.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EngineeringStatusDialog.this.designPart.getDesign().setReplaceSpaces(EngineeringStatusDialog.this.replaceSpaces.isSelected());
                }
            });
        }
    }

    private void initCapitalNames() {
        if (this.designPart instanceof LogicalDesign) {
            this.capitalNames.setSelected(this.designPart.getDesign().isCapitalNames());
            this.capitalNames.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EngineeringStatusDialog.this.designPart.getDesign().setCapitalNames(EngineeringStatusDialog.this.capitalNames.isSelected());
                }
            });
        }
    }

    SpringLayout getOptionsLayout() {
        return (SpringLayout)this.optionsTab.getLayout();
    }

    protected void setObjectConstraints(SpringLayout springLayout, Component component, int n, int n2) {
        SpringLayout.Constraints constraints = springLayout.getConstraints(component);
        constraints.setX(Spring.constant(n));
        constraints.setY(Spring.constant(n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void engineer() {
        if (this.designPart instanceof LogicalDesign) {
            RelationalDesign relationalDesign = (RelationalDesign)this.pdcombo.getSelectedItem();
            this.getDesign().setRelationalDesign(relationalDesign);
            ApplicationView.log(Messages.getString("EngineeringStatusDialog.ForwardEngineering"));
            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
            Ide.getMainWindow().setCursor(Cursor.getPredefinedCursor(0));
        } else if (this.designPart instanceof RelationalDesign) {
            // empty if block
        }
        if (this.isModal()) {
            this.stdes.unregisterAsListener();
            this.dispose();
        }
    }

    private Design getDesign() {
        return this.designPart.getDesign();
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getPath();
        Object object = treePath.getLastPathComponent();
        this.infoTab.setText("");
        if (object instanceof DesignObjectPlaceHolder) {
            object = ((DesignObjectPlaceHolder)object).getDesignObject();
        }
        if (object != null && this.shouldShowObjectInfo(object)) {
            if (this.belongsToLogical(object)) {
                this.showGenerator((DesignObject)object);
                if (this.showMappings.isSelected()) {
                    this.showMappings((DesignObject)object);
                }
            } else {
                this.showGeneratorRel((DesignObject)object);
            }
        }
        this.infoTab.setCaretPosition(0);
    }

    public void showInfo() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null) {
            Object object = treePath.getLastPathComponent();
            this.infoTab.setText("");
            if (object instanceof DesignObjectPlaceHolder) {
                object = ((DesignObjectPlaceHolder)object).getDesignObject();
            }
            if (object != null && this.shouldShowObjectInfo(object)) {
                if (this.belongsToLogical(object)) {
                    this.showGenerator((DesignObject)object);
                    if (this.showMappings.isSelected()) {
                        this.showMappings((DesignObject)object);
                    }
                } else {
                    this.showGeneratorRel((DesignObject)object);
                }
            }
            this.infoTab.setCaretPosition(0);
        }
    }

    private boolean shouldShowObjectInfo(Object object) {
        if (this.belongsToLogical(object)) {
            return true;
        }
        return this.belongsToPhysical(object);
    }

    private boolean belongsToLogical(Object object) {
        return object instanceof Entity || object instanceof Attribute || object instanceof Relation || object instanceof CandidateKey;
    }

    private boolean belongsToPhysical(Object object) {
        return object instanceof Table || object instanceof Column || object instanceof FKIndexAssociation || object instanceof Index;
    }

    private void showGenerator(DesignObject designObject) {
        String string = this.infoTab.getText();
        StringBuffer stringBuffer = new StringBuffer(string);
        if ("None".equalsIgnoreCase(designObject.getGeneratorLongName())) {
            stringBuffer.append(Messages.getString("EngineeringStatusDialog.GeneratorNameNone"));
        } else {
            stringBuffer.append(Messages.getString("EngineeringStatusDialog.GeneratorName")).append(designObject.getGeneratorLongName());
        }
        this.infoTab.setText(stringBuffer.toString());
    }

    private void showGeneratorRel(DesignObject designObject) {
        Relation relation;
        String string = this.infoTab.getText();
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(Messages.getString("EngineeringStatusDialog.GeneratorName")).append(designObject.getGeneratorLongName());
        if (designObject instanceof Column) {
            Attribute attribute = ((Column)designObject).getEngAttribute();
            if (attribute != null) {
                stringBuffer.append(Messages.getString("EngineeringStatusDialog.CorrespondingAttribute")).append(attribute.getLongName());
            }
        } else if (designObject instanceof Table) {
            Entity entity = ((Table)designObject).getEngEntity();
            if (entity != null) {
                stringBuffer.append(Messages.getString("EngineeringStatusDialog.CorrespondingEntity")).append(entity.getLongName());
            }
        } else if (designObject instanceof FKIndexAssociation && (relation = ((FKIndexAssociation)designObject).getEngRelation()) != null) {
            stringBuffer.append(Messages.getString("EngineeringStatusDialog.CorrespondingRelation")).append(relation.getLongName());
        }
        this.infoTab.setText(stringBuffer.toString());
    }

    private void showMappings(DesignObject designObject) {
        List list = this.getDesign().getExtendedMap().getOrCreateCollector(designObject).getAllMappings();
        if (list.size() > 0) {
            String string = this.infoTab.getText();
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(Messages.getString("EngineeringStatusDialog.Targets"));
            Iterator iterator = list.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                XtdMapping xtdMapping = (XtdMapping)iterator.next();
                DesignObject designObject2 = xtdMapping.getOwnerObject();
                if (designObject2 == null || designObject2 != designObject) continue;
                bl = true;
                DesignObject designObject3 = xtdMapping.getObjectMappedTo(designObject);
                if (designObject3 == null) continue;
                if (designObject instanceof Attribute) {
                    if (!(designObject3 instanceof Column)) continue;
                    stringBuffer.append("\n   ").append(designObject3.getDesignPart().getName() + "." + ((ContainedObject)designObject3).getContainer().getName() + ".").append(designObject3.getName());
                    continue;
                }
                stringBuffer.append("\n   ").append(designObject3.getDesignPart().getName() + ".").append(designObject3.getName());
            }
            if (!bl) {
                stringBuffer.append(" NONE");
            }
            this.infoTab.setText(stringBuffer.toString());
        }
    }

    private String getDelTablesText(RelationalDesign relationalDesign) {
        StringBuffer stringBuffer = new StringBuffer(Messages.getString("EngineeringStatusDialog.Tables"));
        Iterator iterator = relationalDesign.getTableSet().iterator();
        while (iterator.hasNext()) {
            DesignObject designObject = (DesignObject)iterator.next();
            if (designObject.hasAliveGenerator()) continue;
            stringBuffer.append("  " + designObject.getLongName() + "\n");
        }
        return stringBuffer.toString();
    }

    private String getDelColumnsText(RelationalDesign relationalDesign) {
        StringBuffer stringBuffer = new StringBuffer(Messages.getString("EngineeringStatusDialog.ColumnsThatDontBelongToDeletedTables"));
        Iterator iterator = relationalDesign.getColumnSet().iterator();
        while (iterator.hasNext()) {
            FKIndexAssociation fKIndexAssociation;
            Column column = (Column)iterator.next();
            if (column.getContainer().hasAliveGenerator() && !column.hasAliveGenerator()) {
                stringBuffer.append("  " + column.getLongName() + "\n");
                continue;
            }
            if (!column.isFKColumn() || column.getAssociationsCount() != 1 || (fKIndexAssociation = column.getFKIndexAssociation()) == null || fKIndexAssociation.hasAliveGenerator() && fKIndexAssociation.getRemoteTable().hasAliveGenerator() && fKIndexAssociation.getKeyObject().hasAliveGenerator()) continue;
            stringBuffer.append("  " + column.getLongName() + "\n");
        }
        return stringBuffer.toString();
    }

    private String getDelFKeysText(RelationalDesign relationalDesign) {
        StringBuffer stringBuffer = new StringBuffer(Messages.getString("EngineeringStatusDialog.ForeignKeys"));
        Iterator iterator = relationalDesign.getFKIndexAssociationSet().iterator();
        while (iterator.hasNext()) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)iterator.next();
            if (!fKIndexAssociation.hasAliveGenerator()) {
                stringBuffer.append("  " + fKIndexAssociation.getLongName() + "\n");
                continue;
            }
            if (fKIndexAssociation.getContainerWithKeyObject().hasAliveGenerator() && fKIndexAssociation.getRemoteTable().hasAliveGenerator() && fKIndexAssociation.getKeyObject().hasAliveGenerator()) continue;
            stringBuffer.append("  " + fKIndexAssociation.getLongName() + "\n");
        }
        return stringBuffer.toString();
    }

    private String getDelIndexesText(RelationalDesign relationalDesign) {
        StringBuffer stringBuffer = new StringBuffer(Messages.getString("EngineeringStatusDialog.Indexes"));
        Iterator iterator = relationalDesign.getGlobalIndexSet().iterator();
        while (iterator.hasNext()) {
            Index index = (Index)iterator.next();
            if (index.isFK() || !index.getContainerWithKeyObject().hasAliveGenerator() || index.hasAliveGenerator()) continue;
            stringBuffer.append("  " + index.getLongName() + "\n");
        }
        return stringBuffer.toString();
    }

    private String getDelEntitiesText(LogicalDesign logicalDesign) {
        StringBuffer stringBuffer = new StringBuffer(Messages.getString("EngineeringStatusDialog.Entities"));
        Iterator iterator = logicalDesign.getEntitySet().iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            if (entity.hasAliveGenerator()) continue;
            stringBuffer.append("  " + entity.getLongName() + "\n");
        }
        return stringBuffer.toString();
    }

    private String getDelAttributesText(LogicalDesign logicalDesign) {
        StringBuffer stringBuffer = new StringBuffer(Messages.getString("EngineeringStatusDialog.AttributesThatDontBelongToDeletedEntities"));
        Iterator iterator = logicalDesign.getAttributeSet().iterator();
        while (iterator.hasNext()) {
            Relation relation;
            Attribute attribute = (Attribute)iterator.next();
            if (!attribute.isFKAttribute() && attribute.getContainer().hasAliveGenerator() && !attribute.hasAliveGenerator()) {
                stringBuffer.append("  " + attribute.getLongName() + "\n");
                continue;
            }
            if (attribute.isFKAttribute() && !attribute.getDelegateElement().hasAliveGenerator()) {
                stringBuffer.append("  " + attribute.getLongName() + "\n");
                continue;
            }
            if (!attribute.isFKAttribute() || (relation = attribute.getRelation()) == null) continue;
            if (!relation.hasAliveGenerator()) {
                stringBuffer.append("  " + attribute.getLongName() + "\n");
                continue;
            }
            int n = relation.getEndPointFor((Entity)attribute.getContainerWithKeyObject());
            Entity entity = relation.getEntity(relation.getOtherEndPoint(n));
            if (entity.hasAliveGenerator()) continue;
            stringBuffer.append("  " + attribute.getLongName() + "\n");
        }
        return stringBuffer.toString();
    }

    private String getDelCandidateKey(LogicalDesign logicalDesign) {
        StringBuffer stringBuffer = new StringBuffer(Messages.getString("EngineeringStatusDialog.CnadidateKeys"));
        Iterator iterator = logicalDesign.getGlobalCandidateKeySet().iterator();
        while (iterator.hasNext()) {
            CandidateKey candidateKey = (CandidateKey)iterator.next();
            if (!candidateKey.getContainerWithKeyObject().hasAliveGenerator() || candidateKey.hasAliveGenerator()) continue;
            stringBuffer.append("  " + candidateKey.getLongName() + "\n");
        }
        return stringBuffer.toString();
    }

    private String getDelRelationsText(LogicalDesign logicalDesign) {
        StringBuffer stringBuffer = new StringBuffer(Messages.getString("EngineeringStatusDialog.Relations"));
        Iterator iterator = logicalDesign.getRelationSet().iterator();
        while (iterator.hasNext()) {
            Relation relation = (Relation)iterator.next();
            if (!relation.hasAliveGenerator()) {
                stringBuffer.append("  " + relation.getLongName() + "\n");
                continue;
            }
            if (relation.getEntity(0).hasAliveGenerator() && relation.getEntity(1).hasAliveGenerator()) continue;
            stringBuffer.append("  " + relation.getLongName() + "\n");
        }
        return stringBuffer.toString();
    }

    private void fillComboWithDPVs(DesignPart designPart, JComboBox jComboBox) {
        jComboBox.addItem(designPart.getMainView());
        Iterator iterator = designPart.getDesignSubviews().iterator();
        while (iterator.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
            jComboBox.addItem(designPartViewPlaceHolder.getDesignPartView());
        }
        jComboBox.setSelectedItem(this.appView.getCurrentDPV());
    }

    private class EngineerAction
    implements ActionListener {
        private EngineerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EngineeringStatusDialog.this.engineer();
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EngineeringStatusDialog.this.dispose();
        }
    }

    class ClosingListener
    extends WindowAdapter {
        ClosingListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            EngineeringStatusDialog.this.stdes.unregisterAsListener();
        }
    }
}

