/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.viewbuilder.tester;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.MenuElement;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.crest.swingui.editor.viewbuilder.Messages;
import oracle.dbtools.crest.swingui.editor.viewbuilder.tester.DMDatabasePicker;
import oracle.dbtools.crest.swingui.editor.viewbuilder.tester.TestSQLQueryPanel;
import oracle.ide.Context;
import oracle.ide.db.panels.sql.tester.TesterComponent;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.controls.DatabasePicker;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Database;
import oracle.jdeveloper.db.controls.ConnectionPickerButton;
import oracle.jdeveloper.db.panels.GlobalConnectionPanelUI;

public class SQLTesterPanel
extends JPanel {
    private final DatabasePicker m_picker = new DMDatabasePicker();
    private final JTextArea m_txtSQL = new JTextArea();
    private final JSplitPane m_pane;
    private final JTabbedPane m_tabPane = new JTabbedPane();
    private final DBUIResourceHelper m_reshelp = new DBUIResourceHelper("SQLTesterPanel");
    private final List<TesterComponent> m_queryComps = new ArrayList<TesterComponent>();
    private static Database m_db;
    private static int currentTab;
    private String m_queryTxt;
    private boolean m_listen;

    public SQLTesterPanel() {
        this.setLayout(new GridBagLayout());
        this.m_reshelp.setName((Component)this.m_tabPane, "TesterTabPane");
        this.m_tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SQLTesterPanel.this.panelChanged();
            }
        });
        this.addPanel(new TestSQLQueryPanel(this.m_txtSQL));
        this.m_txtSQL.setFont(Font.decode("Monospaced"));
        this.m_pane = new JSplitPane(0, SQLTesterPanel.newChildPanel(this.m_txtSQL, UIBundle.get((String)"TESTSQL_SQL_LABEL"), "SQL", this.m_reshelp, this), this.m_tabPane);
        this.m_reshelp.setName((Component)this.m_pane, "Split");
        this.m_pane.setResizeWeight(0.5);
        if (this.m_picker != null) {
            Object object;
            this.m_picker.setContext(Context.newIdeContext());
            Component component = this.m_picker.getComponent();
            try {
                object = (ConnectionPickerButton)((GlobalConnectionPanelUI)component).getPicker();
                MenuElement[] menuElementArray = object.getPopupMenu().getSubElements();
                Arrays.sort(menuElementArray, new MenuItemComparator());
                object.getPopupMenu().removeAll();
                boolean bl = false;
                String string = null;
                if (m_db != null) {
                    string = m_db.getConnectionName();
                }
                if (menuElementArray.length > 0) {
                    for (int i = 0; i < menuElementArray.length; ++i) {
                        JMenuItem jMenuItem = (JMenuItem)menuElementArray[i].getComponent();
                        object.getPopupMenu().add(jMenuItem);
                        if (string == null || !string.equals(jMenuItem.getText())) continue;
                        bl = true;
                    }
                } else {
                    object.getPopupMenu().add(new JLabel(Messages.getString("SQLTesterPanel.NoConnections")));
                    ((GlobalConnectionPanelUI)component).setEnabled(false);
                    ((GlobalConnectionPanelUI)component).setEnabled(true);
                }
                if (!bl) {
                    m_db = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0);
            ++object.gridx;
            object.insets.right = 0;
            object.weightx = 1.0;
            object.fill = 2;
            this.add(component, object);
            this.m_picker.addListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    m_db = SQLTesterPanel.this.m_picker.getDatabase();
                    SQLTesterPanel.this.panelChanged();
                }
            });
        }
        this.add((Component)this.m_pane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    Component getDefaultFocusComponent() {
        return this.m_txtSQL;
    }

    void addPanel(TesterComponent testerComponent) {
        this.m_queryComps.add(testerComponent);
        this.m_tabPane.add(testerComponent.getName(), testerComponent.getComponent());
    }

    public JSplitPane getSplitPane() {
        return this.m_pane;
    }

    public JTabbedPane getTabbedPane() {
        return this.m_tabPane;
    }

    public static int getCurrentTab() {
        return currentTab;
    }

    public static void setCurrentTab(int n) {
        currentTab = n;
    }

    void testSQL(Database database, String string) {
        this.m_listen = true;
        this.m_queryTxt = string;
        if (database != null) {
            this.m_picker.setDatabase(database);
        } else if (m_db != null) {
            this.m_picker.setDatabase(m_db);
            GlobalConnectionPanelUI globalConnectionPanelUI = (GlobalConnectionPanelUI)this.m_picker.getComponent();
            ConnectionPickerButton connectionPickerButton = (ConnectionPickerButton)globalConnectionPanelUI.getPicker();
            connectionPickerButton.setText(m_db.getConnectionName());
            globalConnectionPanelUI.enableActiveComponents(true);
        }
        m_db = this.m_picker.getDatabase();
        if (this.m_tabPane.getSelectedIndex() != 0) {
            this.m_tabPane.setSelectedIndex(0);
        } else {
            this.panelChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void panelChanged() {
        if (this.m_listen) {
            int n = this.m_tabPane.getSelectedIndex();
            if (m_db == null) {
                this.enableTabs(false);
                if (n != 0) {
                    try {
                        this.m_listen = false;
                        this.m_tabPane.setSelectedIndex(0);
                    }
                    finally {
                        this.m_listen = true;
                    }
                }
            } else {
                this.enableTabs(true);
                this.m_queryComps.get(n).testSQL(m_db, this.m_queryTxt);
            }
        }
    }

    private void enableTabs(boolean bl) {
        for (int i = 1; i < this.m_tabPane.getTabCount(); ++i) {
            this.m_tabPane.setEnabledAt(i, bl);
        }
    }

    static JPanel newChildPanel(JTextArea jTextArea, String string, String string2, DBUIResourceHelper dBUIResourceHelper, Component component) {
        JLabel jLabel = new JLabel();
        dBUIResourceHelper.resLabel(jLabel, (Component)jTextArea, string, string2);
        jTextArea.setEditable(false);
        jTextArea.setBackground(component.getBackground());
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        dBUIResourceHelper.setName((Component)jScrollPane, string2 + "Scroll");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    static {
        currentTab = 0;
    }

    class MenuItemComparator
    implements Comparator {
        MenuItemComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = ((JMenuItem)object).getText();
            String string2 = ((JMenuItem)object2).getText();
            return string.compareToIgnoreCase(string2);
        }
    }
}

