/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.viewbuilder;

import com.adbs.ast.KeywordFormat;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.ParsingException;
import com.adbs.querybuilder.ActiveSubQueryChangedEvent;
import com.adbs.querybuilder.ActiveSubQueryChangedEventListener;
import com.adbs.querybuilder.ActiveUnionSubQueryChangedEvent;
import com.adbs.querybuilder.ActiveUnionSubQueryChangedEventListener;
import com.adbs.querybuilder.CriteriaList;
import com.adbs.querybuilder.CriteriaListControl;
import com.adbs.querybuilder.CriteriaListOptions;
import com.adbs.querybuilder.CustomExpressionBuilderColumns;
import com.adbs.querybuilder.CustomExpressionBuilderEvent;
import com.adbs.querybuilder.CustomExpressionBuilderEventListener;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkPlace;
import com.adbs.querybuilder.LinkSideType;
import com.adbs.querybuilder.ObjectsGroupingType;
import com.adbs.querybuilder.PlainTextSQLBuilder;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.QueryPart;
import com.adbs.querybuilder.SQLUpdatedEvent;
import com.adbs.querybuilder.SQLUpdatedEventListener;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.querybuilder.UnionSubQueryPanel;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.OracleSyntaxProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.StyledEditorKit;
import oracle.dbtools.crest.imports.metadata.DBMOConstants;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.ddl.SyntaxDocument;
import oracle.dbtools.crest.swingui.editor.StringEditor;
import oracle.dbtools.crest.swingui.editor.viewbuilder.Messages;
import oracle.dbtools.crest.swingui.editor.viewbuilder.QBUtils;
import oracle.dbtools.crest.swingui.editor.viewbuilder.tester.DMSQLQueryTester;
import oracle.dbtools.crest.swingui.editor.viewbuilder.tester.ResultTesterComponent;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class QueryBuilderPanel
extends JPanel
implements DBMOConstants {
    private ContainerObject contObject;
    protected JDialog dialog;
    protected JPanel buttonPanel;
    protected JPanel general;
    private QueryBuilder queryBuilder;
    private ApplicationView applView;
    private PlainTextSQLBuilder plainTextSQLBuilder;
    private JTextPane jTextPane;
    private AbstractView tableView;
    private static GUIConfiguration conf = GUIConfiguration.getInstance();
    private boolean includeSchema = false;
    private DesignPartView usedDPV = null;
    private JComboBox cbFilter;
    private boolean isOpened = false;
    private JCheckBox chbShowCurrentQuerySQLOnly;
    private boolean loaded = false;
    private JComboBox cbSyntaxProviders;
    private JCheckBox chbJoins;
    private JButton bnANSIJoins;
    private JButton bnOracleJoins;
    private static final GUIConfiguration configuration = GUIConfiguration.getInstance();
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            QueryBuilderPanel.this.close();
        }
    };

    public QueryBuilderPanel(ContainerObject containerObject) {
        this.contObject = containerObject;
    }

    public void initProperties(ContainerObject containerObject) {
        if (this.contObject instanceof AbstractView) {
            this.tableView = (AbstractView)this.contObject;
            this.cbSyntaxProviders.setSelectedItem(this.tableView.getSyntaxProvider());
            this.cbFilter.removeAllItems();
            if (this.usedDPV == null) {
                this.cbFilter.setEnabled(true);
                this.cbFilter.addItem(this.tableView.getDesignPart().getMainView());
                Iterator iterator = this.tableView.getDesignPart().getDesignSubviews().iterator();
                while (iterator.hasNext()) {
                    DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
                    DesignPartView designPartView = designPartViewPlaceHolder.getDesignPartView();
                    this.cbFilter.addItem(designPartView);
                }
            } else {
                this.cbFilter.setEnabled(false);
            }
            QBUtils.initProperties(this.tableView, this.queryBuilder, this.plainTextSQLBuilder, this.jTextPane, this.usedDPV, this.includeSchema);
        }
    }

    private void updateJoinsControls() {
        BaseSyntaxProvider baseSyntaxProvider = this.queryBuilder.getSyntaxProvider();
        if (baseSyntaxProvider instanceof OracleSyntaxProvider) {
            OracleSyntaxProvider oracleSyntaxProvider = (OracleSyntaxProvider)baseSyntaxProvider;
            this.chbJoins.setSelected(oracleSyntaxProvider.isCreateWhereJoinsByDefault());
            this.chbJoins.setEnabled(!this.hasLinks());
            this.bnANSIJoins.setEnabled(this.hasJoins(false));
            this.bnOracleJoins.setEnabled(this.hasJoins(true) && !this.hasFullOuterJoin());
        } else {
            this.chbJoins.setEnabled(false);
            this.bnANSIJoins.setEnabled(false);
            this.bnOracleJoins.setEnabled(false);
        }
    }

    private void setCreateOracleJoins(boolean bl) {
        BaseSyntaxProvider baseSyntaxProvider = this.queryBuilder.getSyntaxProvider();
        if (baseSyntaxProvider instanceof OracleSyntaxProvider) {
            OracleSyntaxProvider oracleSyntaxProvider = (OracleSyntaxProvider)baseSyntaxProvider;
            oracleSyntaxProvider.setCreateWhereJoinsByDefault(bl);
        }
    }

    private boolean hasLinks() {
        for (UnionSubQuery unionSubQuery : this.queryBuilder.getUnionSubQueryList()) {
            ArrayList arrayList = new ArrayList();
            unionSubQuery.getFromClause().getLinksRecursive(arrayList);
            if (arrayList.size() <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean hasJoins(boolean bl) {
        for (UnionSubQuery unionSubQuery : this.queryBuilder.getUnionSubQueryList()) {
            ArrayList arrayList = new ArrayList();
            unionSubQuery.getFromClause().getLinksRecursive(arrayList);
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Link link = (Link)arrayList.get(i);
                LinkPlace linkPlace = bl ? LinkPlace.From : LinkPlace.Where;
                if (link.getPlace() != linkPlace) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasFullOuterJoin() {
        for (UnionSubQuery unionSubQuery : this.queryBuilder.getUnionSubQueryList()) {
            ArrayList arrayList = new ArrayList();
            unionSubQuery.getFromClause().getLinksRecursive(arrayList);
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Link link = (Link)arrayList.get(i);
                if (link.getLeftType() != LinkSideType.Outer || link.getRightType() != LinkSideType.Outer) continue;
                return true;
            }
        }
        return false;
    }

    protected static int getIntValue(String string) {
        if (string != null && !"".equalsIgnoreCase(string)) {
            try {
                String[] stringArray = string.split(" ");
                if (stringArray.length == 2) {
                    string = stringArray[0].trim();
                }
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    private void setProperties() {
        if (this.tableView != null) {
            this.updateSQL();
            if (!QBUtils.isIncorrectSQL) {
                QBUtils.updateColumns(this.tableView, this.queryBuilder);
                QBUtils.setViewSQL(this.tableView, this.queryBuilder, this.plainTextSQLBuilder, true);
                this.tableView.setValidSQL(true);
                this.tableView.setParsed(true);
            } else {
                QBUtils.incorrectSQL = this.jTextPane.getText();
                QBUtils.setViewSQL(this.tableView, this.queryBuilder, this.plainTextSQLBuilder, false);
                this.tableView.setParsed(false);
            }
            this.tableView.setSyntaxProvider((String)this.cbSyntaxProviders.getSelectedItem());
        }
    }

    protected int getMinimumWidth() {
        return 920;
    }

    protected int getMinimumHeight() {
        return 600;
    }

    private void close() {
        Rectangle rectangle = new Rectangle(this.dialog.getLocation(), this.dialog.getSize());
        this.applView.getSettings().setDialogSettings(this.getClass().getName(), rectangle);
        this.dialog.dispose();
    }

    public JDialog getDialog(ApplicationView applicationView, boolean bl, DesignPartView designPartView) {
        this.includeSchema = bl;
        this.usedDPV = designPartView;
        return this.getDialog(applicationView);
    }

    public JDialog getDialog(ApplicationView applicationView) {
        Serializable serializable;
        Object object;
        JSplitPane jSplitPane = null;
        this.loaded = false;
        if (this.dialog == null) {
            JComponent jComponent;
            this.isOpened = false;
            this.applView = applicationView;
            this.dialog = new JDialog((Frame)applicationView.getFrame(), Messages.getString("QueryBuilder.QueryBuilder"));
            this.general = new JPanel(new BorderLayout());
            this.dialog.getContentPane().add((Component)this.general, "Center");
            this.dialog.getContentPane().add((Component)this.getButtonPanel(), "South");
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    if (QBUtils.isIncorrectSQL) {
                        QBUtils.setSQL(QueryBuilderPanel.this.queryBuilder, QBUtils.incorrectSQL);
                    }
                    QueryBuilderPanel.this.isOpened = true;
                    QueryBuilderPanel.this.queryBuilder.getMetadataTree().updateUI();
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout());
            this.dialog.getContentPane().add((Component)jPanel, "North");
            object = new JPanel();
            serializable = new JCheckBox(Messages.getString("QueryBuilderPanel.ShowStructureTree"));
            ((AbstractButton)serializable).addActionListener(new ActionListener((JCheckBox)serializable){
                final /* synthetic */ JCheckBox val$cbShowStructureTree;
                {
                    this.val$cbShowStructureTree = jCheckBox;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    QueryBuilderPanel.this.queryBuilder.getQueryStructureTreeOptions().setTreeVisible(this.val$cbShowStructureTree.isSelected());
                }
            });
            ((Container)object).add((Component)serializable);
            jPanel.add((Component)object, "West");
            ((Container)object).add(new JPanel());
            final JCheckBox jCheckBox = new JCheckBox(Messages.getString("QueryBuilderPanel.ShowCriteriaList"));
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    QueryBuilderPanel.this.queryBuilder.getCriteriaListOptions().setCriteriaListVisible(jCheckBox.isSelected());
                    if (jCheckBox.isSelected()) {
                        QueryBuilderPanel.this.addCriteriaListToolbar();
                    }
                }
            });
            ((Container)object).add(jCheckBox);
            jCheckBox.setSelected(true);
            JPanel jPanel2 = new JPanel();
            JLabel jLabel = new JLabel(Messages.getString("QueryBuilderPanel.SyntaxProvider"));
            jPanel2.add(jLabel);
            this.cbSyntaxProviders = new JComboBox<Object>(QBUtils.SYNTAX_PROVIDERS.keySet().toArray());
            this.cbSyntaxProviders.setPreferredSize(new Dimension(150, 20));
            this.cbSyntaxProviders.setMaximumRowCount(QBUtils.SYNTAX_PROVIDERS.size());
            this.cbSyntaxProviders.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = QueryBuilderPanel.this.jTextPane.getText();
                    QueryBuilderPanel.this.queryBuilder.setSyntaxProvider(QBUtils.SYNTAX_PROVIDERS.get(QueryBuilderPanel.this.cbSyntaxProviders.getSelectedItem()));
                    QueryBuilderPanel.this.jTextPane.setText(string);
                    QueryBuilderPanel.this.jTextPane.setCaretPosition(0);
                    QueryBuilderPanel.this.updateSQL();
                }
            });
            jPanel2.add(this.cbSyntaxProviders);
            ((Container)object).add((Component)jPanel2, "East");
            this.chbJoins = new JCheckBox(Messages.getString("QueryBuilderPanel.CreateOracleJoins"));
            this.chbJoins.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    QueryBuilderPanel.this.setCreateOracleJoins(QueryBuilderPanel.this.chbJoins.isSelected());
                }
            });
            ((Container)object).add(this.chbJoins);
            JPanel jPanel3 = new JPanel(new BorderLayout());
            JLabel jLabel2 = new JLabel(Messages.getString("QueryBuilderPanel.FilterMetadataObjectsByDiagram"));
            this.cbFilter = new JComboBox();
            this.cbFilter.setPreferredSize(new Dimension(200, 20));
            JPanel jPanel4 = new JPanel(new BorderLayout(0, 3));
            jPanel4.add((Component)jLabel2, "West");
            jPanel4.add((Component)this.cbFilter, "South");
            JPanel jPanel5 = new JPanel();
            jPanel5.add(jPanel4);
            jPanel3.add((Component)jPanel5, "North");
            this.cbFilter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (QueryBuilderPanel.this.loaded) {
                        int n = QueryBuilderPanel.this.cbFilter.getSelectedIndex();
                        DesignPartView designPartView = (DesignPartView)QueryBuilderPanel.this.cbFilter.getSelectedItem();
                        for (int i = QueryBuilderPanel.this.queryBuilder.getMetadataContainer().getCount() - 1; i >= 0; --i) {
                            MetadataObject metadataObject = QueryBuilderPanel.this.queryBuilder.getMetadataContainer().get(i);
                            if (n == 0) {
                                metadataObject.setVisible(true);
                                continue;
                            }
                            DesignObject designObject = QueryBuilderPanel.this.tableView.getDesign().getDesignObject(metadataObject.getShortDescription());
                            if (designObject == null) continue;
                            TopView topView = designObject.getTopViewByID(designPartView, designObject.getObjectID());
                            if (topView != null) {
                                metadataObject.setVisible(true);
                                continue;
                            }
                            metadataObject.setVisible(false);
                        }
                        QueryBuilderPanel.this.queryBuilder.getMetadataTree().reloadNodes(true);
                    }
                }
            });
            jPanel.add((Component)jPanel3, "East");
            this.queryBuilder = new QueryBuilder();
            this.queryBuilder.getQueryStructureTreeOptions().beginUpdate();
            this.queryBuilder.getQueryStructureTreeOptions().setTreeVisible(false);
            this.queryBuilder.getQueryStructureTreeOptions().endUpdate();
            this.queryBuilder.getMetadataTreeOptions().beginUpdate();
            this.queryBuilder.getMetadataTreeOptions().setGroupingType(ObjectsGroupingType.DatabaseSchemaType);
            this.queryBuilder.getMetadataTreeOptions().setSchemaIcon(conf.getIcon("SCHEMA_ICON", 16));
            this.queryBuilder.getMetadataTreeOptions().setTablesNodeIcon(conf.getIcon("TABLE_FOLDER_ICON", 16));
            this.queryBuilder.getMetadataTreeOptions().setUserTablesIcon(conf.getIcon("TABLE_ICON", 16));
            this.queryBuilder.getMetadataTreeOptions().setViewsNodeIcon(conf.getIcon("VIEW_FOLDER_ICON", 16));
            this.queryBuilder.getMetadataTreeOptions().setUserViewsIcon(conf.getIcon("VIEW_ICON", 16));
            if (this.contObject instanceof EntityView) {
                this.queryBuilder.getMetadataTreeOptions().setTablesNodeText("Entities");
                this.queryBuilder.getMetadataTreeOptions().setViewsNodeText("Entity Views");
            }
            this.queryBuilder.getMetadataTreeOptions().endUpdate();
            CriteriaListOptions criteriaListOptions = this.queryBuilder.getCriteriaListOptions();
            criteriaListOptions.beginUpdate();
            criteriaListOptions.setExpressionColumnWidth(200);
            criteriaListOptions.setAggregateColumnWidth(100);
            criteriaListOptions.setAliasColumnWidth(100);
            criteriaListOptions.setConditionColumnWidth(100);
            criteriaListOptions.setRowControllerVisible(false);
            criteriaListOptions.setUseCustomExpressionBuilderFor(EnumSet.of(CustomExpressionBuilderColumns.Expression, CustomExpressionBuilderColumns.Conditions));
            criteriaListOptions.endUpdate();
            this.queryBuilder.addCustomExpressionBuilderEventListener(new CustomExpressionBuilderEventListener(){

                public void customExpressionBuilderEventOccurred(CustomExpressionBuilderEvent customExpressionBuilderEvent) {
                    QueryBuilderPanel.this.showConditionEditor(customExpressionBuilderEvent);
                }
            });
            this.jTextPane = new JTextPane();
            this.jTextPane.setPreferredSize(new Dimension(800, 100));
            this.jTextPane.setEditorKit(new StyledEditorKit());
            this.jTextPane.setDocument(new SyntaxDocument());
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            JButton jButton = new JButton(conf.getIcon("CUT_ICON", 16));
            jButton.setToolTipText(Messages.getString("QueryBuilderPanel.Cut"));
            jButton.addActionListener(new CutAction());
            jToolBar.add(jButton);
            JButton jButton2 = new JButton(conf.getIcon("COPY_ICON", 16));
            jButton2.setToolTipText(Messages.getString("QueryBuilderPanel.Copy"));
            jButton2.addActionListener(new CopyAction());
            jToolBar.add(jButton2);
            JButton jButton3 = new JButton(conf.getIcon("PASTE_ICON", 16));
            jButton3.setToolTipText(Messages.getString("QueryBuilderPanel.Paste"));
            jButton3.addActionListener(new PasteAction());
            jToolBar.add(jButton3);
            jToolBar.addSeparator();
            JButton jButton4 = new JButton(conf.getIcon("REFRESH_ICON", 16));
            jButton4.setToolTipText(Messages.getString("QueryBuilderPanel.UpdateDiagram"));
            jButton4.addActionListener(new UpdateAction());
            jToolBar.add(jButton4);
            jToolBar.addSeparator();
            this.chbShowCurrentQuerySQLOnly = new JCheckBox(Messages.getString("QueryBuilderPanel.ShowCurrentQuerySQLOnly"));
            this.chbShowCurrentQuerySQLOnly.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (QueryBuilderPanel.this.chbShowCurrentQuerySQLOnly.isSelected()) {
                        QueryBuilderPanel.this.queryChangedEventOccurred();
                    } else {
                        QueryBuilderPanel.this.queryBuilder.setFilterTabsByActiveQueryPart(QueryPart.Query);
                        QueryBuilderPanel.this.plainTextSQLBuilder.setTargetQueryPart(QueryPart.Query);
                        QueryBuilderPanel.this.updatedSQLEventOccurred();
                    }
                }
            });
            jToolBar.add(this.chbShowCurrentQuerySQLOnly);
            if (this.contObject instanceof TableView) {
                jToolBar.addSeparator();
                jComponent = new JButton(conf.getIcon("CHECKOUT_ICON", 16));
                jComponent.setToolTipText(Messages.getString("QueryBuilderPanel.TestQuery"));
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = QueryBuilderPanel.this.jTextPane.getSelectedText();
                        if (string == null) {
                            string = QueryBuilderPanel.this.jTextPane.getText();
                        }
                        DMSQLQueryTester.registerComponent(ResultTesterComponent.class);
                        DMSQLQueryTester dMSQLQueryTester = new DMSQLQueryTester(null);
                        dMSQLQueryTester.showDialog(QueryBuilderPanel.this, string);
                    }
                });
                jToolBar.add(jComponent);
            }
            this.bnANSIJoins = new JButton(Messages.getString("QueryBuilderPanel.ConvertToANSIJoins"));
            this.bnANSIJoins.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    QueryBuilderPanel.this.convertJoins(false);
                }
            });
            jToolBar.addSeparator();
            jToolBar.add(this.bnANSIJoins);
            this.bnOracleJoins = new JButton(Messages.getString("QueryBuilderPanel.ConvertToOracleJoins"));
            this.bnOracleJoins.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    QueryBuilderPanel.this.convertJoins(true);
                }
            });
            jToolBar.addSeparator();
            jToolBar.add(this.bnOracleJoins);
            jComponent = new JPanel(new BorderLayout());
            jComponent.add((Component)jToolBar, "North");
            jComponent.add((Component)new JScrollPane(this.jTextPane), "Center");
            jSplitPane = new JSplitPane(0, (Component)this.queryBuilder, jComponent);
            jSplitPane.setDividerLocation(400);
            this.general.add((Component)jSplitPane, "Center");
            this.plainTextSQLBuilder = new PlainTextSQLBuilder();
            this.plainTextSQLBuilder.setKeywordFormat(KeywordFormat.UpperCase);
            this.plainTextSQLBuilder.setQueryBuilder(this.queryBuilder);
            this.plainTextSQLBuilder.addSQLUpdatedEventListener(new SQLUpdatedEventListener(){

                public void sqlUpdatedEventOccurred(SQLUpdatedEvent sQLUpdatedEvent) {
                    if (QueryBuilderPanel.this.chbShowCurrentQuerySQLOnly.isSelected()) {
                        QueryBuilderPanel.this.queryChangedEventOccurred();
                    } else {
                        QueryBuilderPanel.this.updatedSQLEventOccurred();
                    }
                    QueryBuilderPanel.this.updateJoinsControls();
                }
            });
            this.queryBuilder.addActiveSubQueryChangedEventListener(new ActiveSubQueryChangedEventListener(){

                public void activeSubQueryChangedEventOccurred(ActiveSubQueryChangedEvent activeSubQueryChangedEvent) {
                    QueryBuilderPanel.this.queryChangedEventOccurred();
                }
            });
            this.queryBuilder.addActiveUnionSubQueryChangedEventListener(new ActiveUnionSubQueryChangedEventListener(){

                public void activeUnionSubQueryChangedEventOccurred(ActiveUnionSubQueryChangedEvent activeUnionSubQueryChangedEvent) {
                    QueryBuilderPanel.this.queryChangedEventOccurred();
                }
            });
            this.dialog.setModal(true);
            int n = 1;
            JComponent jComponent2 = (JComponent)this.dialog.getContentPane();
            jComponent2.getInputMap(n).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
            jComponent2.getActionMap().put("ESCAPE", this.escapeAction);
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    int n = QueryBuilderPanel.this.dialog.getWidth();
                    int n2 = QueryBuilderPanel.this.dialog.getHeight();
                    n = Math.max(QueryBuilderPanel.this.getMinimumWidth(), n);
                    n2 = Math.max(QueryBuilderPanel.this.getMinimumHeight(), n2);
                    QueryBuilderPanel.this.dialog.setSize(n, n2);
                }
            });
        }
        int n = 0x100000;
        object = Runtime.getRuntime();
        System.out.println("memory  total  " + ((Runtime)object).totalMemory() / (long)n + "  /memory  fre  " + ((Runtime)object).freeMemory() / (long)n + "  /used memory  " + (((Runtime)object).totalMemory() - ((Runtime)object).freeMemory()) / (long)n);
        System.out.println("init  start  " + System.currentTimeMillis());
        this.initProperties(this.contObject);
        if (!this.tableView.isValidSQL()) {
            System.out.println("update start  " + System.currentTimeMillis());
            QBUtils.updateMetadata(this.tableView, this.queryBuilder, this.plainTextSQLBuilder, this.includeSchema);
            System.out.println("update end  " + System.currentTimeMillis());
        } else {
            long l = System.currentTimeMillis();
            QBUtils.setIncludeSchema(this.tableView, this.queryBuilder, this.plainTextSQLBuilder, this.includeSchema);
            System.out.println("setIncludeSchema  " + (System.currentTimeMillis() - l));
            QBUtils.updateDSPositions(this.queryBuilder);
        }
        System.out.println("END memory  total  " + ((Runtime)object).totalMemory() / (long)n + "  /memory  fre  " + ((Runtime)object).freeMemory() / (long)n + "  /used memory  " + (((Runtime)object).totalMemory() - ((Runtime)object).freeMemory()) / (long)n);
        this.dialog.pack();
        serializable = applicationView.getSettings().getDialogSettings(this.getClass().getName());
        if (serializable == null) {
            this.dialog.setSize(this.getMinimumWidth(), this.getMinimumHeight());
            CommonUtil.centerOnScreen(this.dialog);
        } else {
            this.dialog.setSize(((Rectangle)serializable).getSize());
            this.dialog.setLocation(((Rectangle)serializable).getLocation());
            jSplitPane.setDividerLocation((int)(((Rectangle)serializable).getHeight() - 250.0));
        }
        this.loaded = true;
        return this.dialog;
    }

    private void queryChangedEventOccurred() {
        if (this.isOpened && this.chbShowCurrentQuerySQLOnly.isSelected() && this.jTextPane != null && this.queryBuilder.getActiveSubquery() != null && this.queryBuilder.getActiveSubquery().getActiveUnionSubquery() != null) {
            this.queryBuilder.setFilterTabsByActiveQueryPart(QueryPart.UnionSubQuery);
            this.plainTextSQLBuilder.setTargetQueryPart(QueryPart.UnionSubQuery);
            this.jTextPane.setText(QBUtils.formatSQL(this.queryBuilder.getActiveSubquery().getActiveUnionSubquery().getSQL()));
            this.jTextPane.setCaretPosition(0);
        }
        this.addCriteriaListToolbar();
    }

    private void updatedSQLEventOccurred() {
        if (!QBUtils.isIncorrectSQL) {
            try {
                this.jTextPane.setText(QBUtils.formatSQL(this.plainTextSQLBuilder.getSQL()));
                this.jTextPane.setCaretPosition(0);
            }
            catch (QueryBuilderException queryBuilderException) {
                // empty catch block
            }
        }
        this.addCriteriaListToolbar();
    }

    private void showConditionEditor(CustomExpressionBuilderEvent customExpressionBuilderEvent) {
        StringEditor stringEditor = new StringEditor(ApplicationView.getInstance(), QBUtils.formatSQL(customExpressionBuilderEvent.value), "Condition Editor", 600, 400, true);
        stringEditor.show();
        if (!stringEditor.cancel) {
            customExpressionBuilderEvent.value = stringEditor.getText();
        }
    }

    private void updateSQL() {
        block10: {
            String string = this.jTextPane.getText();
            QBUtils.isIncorrectSQL = false;
            try {
                if (this.chbShowCurrentQuerySQLOnly.isSelected()) {
                    this.queryBuilder.getActiveSubquery().getActiveUnionSubquery().setSQL(string);
                } else {
                    this.plainTextSQLBuilder.setSQL(string);
                }
            }
            catch (Exception exception) {
                QBUtils.isIncorrectSQL = true;
                QBUtils.incorrectSQL = string;
                this.queryBuilder.setSQL("");
                if (this.jTextPane == null) break block10;
                MessageDialogs.showErrorMessage(exception.getMessage());
                int n = -1;
                for (Throwable throwable = exception; throwable != null; throwable = throwable.getCause()) {
                    if (throwable instanceof ParsingException) {
                        n = ((ParsingException)throwable).errorPos.pos;
                        break;
                    }
                    if (throwable.getCause() == throwable) break;
                }
                if (n > -1) {
                    try {
                        this.jTextPane.requestFocus();
                        this.jTextPane.setCaretPosition(n);
                        this.jTextPane.setSelectionStart(n);
                        int n2 = string.indexOf(" ", n);
                        if (n2 == -1) {
                            n2 = string.length();
                        }
                        this.jTextPane.setSelectionEnd(n2);
                    }
                    catch (Exception exception2) {}
                }
                this.jTextPane.setCaretPosition(0);
            }
        }
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new FlowLayout(2));
            JButton jButton = new JButton(Messages.getString("ViewBuilder.OK"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (QueryBuilderPanel.this.canExit()) {
                        QueryBuilderPanel.this.setProperties();
                        QueryBuilderPanel.this.close();
                    }
                }
            });
            jButton.setCursor(Cursor.getPredefinedCursor(12));
            jButton.setMnemonic(79);
            JButton jButton2 = new JButton(Messages.getString("ViewBuilder.Apply"));
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (QueryBuilderPanel.this.canExit()) {
                        QueryBuilderPanel.this.setProperties();
                    }
                }
            });
            jButton2.setCursor(Cursor.getPredefinedCursor(12));
            jButton2.setMnemonic(65);
            JButton jButton3 = new JButton(Messages.getString("ViewBuilder.Cancel"));
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    QueryBuilderPanel.this.close();
                }
            });
            jButton3.setMnemonic(67);
            jButton3.setCursor(Cursor.getPredefinedCursor(12));
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton3.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(jButton);
            this.buttonPanel.add(jButton2);
            this.buttonPanel.add(jButton3);
        }
        return this.buttonPanel;
    }

    protected boolean canExit() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertJoins(boolean bl) {
        this.queryBuilder.beginUpdate();
        try {
            this.setCreateOracleJoins(bl);
            for (UnionSubQuery unionSubQuery : this.queryBuilder.getUnionSubQueryList()) {
                Object object;
                ArrayList arrayList = new ArrayList();
                ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>();
                unionSubQuery.getFromClause().getLinksRecursive(arrayList);
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    Link link = (Link)arrayList.get(i);
                    object = bl ? LinkPlace.From : LinkPlace.Where;
                    if (link.getPlace() != object) continue;
                    arrayList2.add(new Object[]{link.getLeftDatasource(), link.getRightDatasource(), link.getLinkExpressionString(), link.getLeftType(), link.getRightType()});
                    link.dispose();
                }
                LinkPlace linkPlace = bl ? LinkPlace.Where : LinkPlace.From;
                for (int i = arrayList2.size() - 1; i >= 0; --i) {
                    object = (Object[])arrayList2.get(i);
                    String string = (String)object[2];
                    Link link = unionSubQuery.addLink((DataSource)object[0], (DataSource)object[1], string, linkPlace);
                    link.beginUpdate();
                    link.setLeftType((LinkSideType)object[3]);
                    link.setRightType((LinkSideType)object[4]);
                    link.endUpdate();
                }
            }
        }
        finally {
            this.queryBuilder.endUpdate();
        }
    }

    private JScrollPane getCriteriaListControlScrollPane(CriteriaList criteriaList) {
        if (criteriaList.getControlsCount() >= 1) {
            Container container;
            for (container = criteriaList.getControl(0).getParent(); container != null && !(container instanceof JScrollPane); container = container.getParent()) {
            }
            return (JScrollPane)container;
        }
        return null;
    }

    private void addCriteriaListToolbar() {
        try {
            UnionSubQueryPanel unionSubQueryPanel;
            if (this.queryBuilder.getActiveSubquery() != null && this.queryBuilder.getActiveSubquery().getActiveUnionSubquery() != null && this.queryBuilder.getActiveSubquery().getActiveUnionSubquery().getControlsCount() > 0 && (unionSubQueryPanel = (UnionSubQueryPanel)this.queryBuilder.getActiveSubquery().getActiveUnionSubquery().getControl(0)) != null && unionSubQueryPanel.getBottomComponent() instanceof JScrollPane) {
                final CriteriaList criteriaList = this.queryBuilder.getActiveSubquery().getActiveUnionSubquery().getCriteriaList();
                JScrollPane jScrollPane = this.getCriteriaListControlScrollPane(criteriaList);
                JPanel jPanel = new JPanel(new BorderLayout());
                JToolBar jToolBar = new JToolBar();
                jPanel.add((Component)jToolBar, "North");
                jPanel.add((Component)jScrollPane, "Center");
                final JButton jButton = new JButton(configuration.getIcon("ADD_ICON", 16));
                final JButton jButton2 = new JButton(configuration.getIcon("REMOVE_ICON", 16));
                final JButton jButton3 = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
                final JButton jButton4 = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
                jToolBar.add(jButton);
                jToolBar.add(jButton2);
                jToolBar.add(jButton3);
                jToolBar.add(jButton4);
                final CriteriaListControl criteriaListControl = criteriaList.getCriteriaListControl();
                criteriaListControl.setRowSelectionAllowed(true);
                criteriaListControl.setSelectionMode(2);
                int[] nArray = criteriaListControl.getSelectedRows();
                if (nArray.length > 0) {
                    jButton.setEnabled(true);
                    jButton2.setEnabled(true);
                    jButton3.setEnabled(nArray[0] > 0);
                    jButton4.setEnabled(nArray[nArray.length - 1] < criteriaList.getCount() - 2);
                } else {
                    jButton.setEnabled(false);
                    jButton2.setEnabled(false);
                    jButton3.setEnabled(false);
                    jButton4.setEnabled(false);
                }
                criteriaListControl.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        int[] nArray = criteriaListControl.getSelectedRows();
                        if (nArray.length > 0) {
                            jButton.setEnabled(true);
                            jButton2.setEnabled(true);
                            jButton3.setEnabled(nArray[0] > 0);
                            jButton4.setEnabled(nArray[nArray.length - 1] < criteriaList.getCount() - 2);
                        } else {
                            jButton.setEnabled(false);
                            jButton2.setEnabled(false);
                            jButton3.setEnabled(false);
                            jButton4.setEnabled(false);
                        }
                    }
                });
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = criteriaListControl.getSelectedRow();
                        if (n >= 0 && n < criteriaList.getCount() - 1) {
                            criteriaList.get(n).actionPerformed(new ActionEvent(criteriaListControl, 0, "insert"));
                        }
                    }
                });
                jButton2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int[] nArray = criteriaListControl.getSelectedRows();
                        for (int i = nArray.length - 1; i >= 0; --i) {
                            int n = nArray[i];
                            if (n < 0 || n >= criteriaList.getCount() - 1) continue;
                            criteriaList.get(n).dispose();
                        }
                    }
                });
                jButton3.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int[] nArray;
                        for (int n : nArray = criteriaListControl.getSelectedRows()) {
                            if (n <= 0 || n >= criteriaList.getCount() - 1) continue;
                            criteriaList.moveRow(n, n - 1);
                        }
                        for (int n : nArray) {
                            criteriaListControl.getSelectionModel().addSelectionInterval(n - 1, n - 1);
                        }
                    }
                });
                jButton4.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int[] nArray = criteriaListControl.getSelectedRows();
                        for (int i = nArray.length - 1; i >= 0; --i) {
                            int n = nArray[i];
                            if (n < 0 || n >= criteriaList.getCount() - 2) continue;
                            criteriaList.moveRow(n, n + 1);
                        }
                        for (int n : nArray) {
                            criteriaListControl.getSelectionModel().addSelectionInterval(n + 1, n + 1);
                        }
                    }
                });
                unionSubQueryPanel.setBottomComponent((JComponent)jPanel);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    private class UpdateAction
    extends AbstractAction {
        private UpdateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            QueryBuilderPanel.this.updateSQL();
        }
    }

    private class PasteAction
    extends AbstractAction {
        private PasteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            QueryBuilderPanel.this.jTextPane.paste();
        }
    }

    private class CopyAction
    extends AbstractAction {
        private CopyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            QueryBuilderPanel.this.jTextPane.copy();
        }
    }

    private class CutAction
    extends AbstractAction {
        private CutAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            QueryBuilderPanel.this.jTextPane.cut();
            QBUtils.setSQL(QueryBuilderPanel.this.queryBuilder, QueryBuilderPanel.this.jTextPane.getText());
        }
    }
}

