/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb.v81;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.IndexProxyUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.SchemaUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.ColumnsSortOrderModel;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class IndexPropertyDialogUDBv81
extends AbstractUDBPropertyDialog {
    private IndexProxyUDBv81 index;
    private JTextField tfTable;
    private JComboBox cbScheme;
    private JTextField tfOwner;
    private JTextField tfUnique;
    private JComboBox cbCluster;
    private JIntegerField ifPCtFree;
    private JIntegerField ifMinPercentUsed;
    private JComboBox cbReverseScan;
    private JComboBox cbCollectStatistics;
    private JPanel columns;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JList allColumnsList;
    private JList selectedColumnsList;
    private JButton bnAdd;
    private JButton bnRemove;
    private JPanel columnsView;
    private JTable columnsTable;
    private ColumnsSortOrderModel sortModel;
    private String comment;
    private String commentInRDBMS;
    private JPanel usePrivilegesPanel;
    protected DefaultListModel allUsersModel;
    protected DefaultListModel selectedUsersModel;
    private JList allUsersList;
    private JList selectedUsersList;
    private JButton bnAddUser;
    private JButton bnRemoveUser;
    protected DefaultListModel allGroupsModel;
    protected DefaultListModel selectedGroupsModel;
    private JList allGroupsList;
    private JList selectedGroupsList;
    private JButton bnAddGroup;
    private JButton bnRemoveGroup;

    public IndexPropertyDialogUDBv81(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.index = (IndexProxyUDBv81)storageObject;
        this.setHeight(405);
        this.initCommentsView(140);
        this.initCommentsInRDBMS(140);
        this.initColumnsView(this.getPane().getPreferredSize().height - 70);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("IndexPropertyDialogUDBv81.IndexProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initScheme();
        this.initOwner();
        this.initUnique();
        this.initCluster();
        this.initPctFree();
        this.initMinPercentageUsed();
        this.initReverseScan();
        this.initCollectStatistics();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
    }

    private void initTable() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogUDBv81.Table"));
        this.general.add(jLabel);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEditable(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initScheme() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogUDBv81.Scheme"));
        this.general.add(jLabel);
        this.cbScheme = new JComboBox();
        this.setBG(this.cbScheme);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSchemaSet().toArray(), this.cbScheme);
        }
        this.cbScheme.addActionListener(new SchemeListener());
        this.cbScheme.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbScheme);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbScheme, 80);
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogUDBv81.Owner"));
        this.general.add(jLabel);
        this.tfOwner = new JTextField("", 26);
        this.setBG(this.tfOwner);
        this.tfOwner.setEditable(false);
        this.tfOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfOwner);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.tfOwner, 110);
    }

    private void initUnique() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogUDBv81.Unique"));
        this.general.add(jLabel);
        this.tfUnique = new JTextField("", 26);
        this.tfUnique.setEditable(false);
        this.general.add(this.tfUnique);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.tfUnique, 140);
    }

    private void initCluster() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogUDBv81.Cluster"));
        this.general.add(jLabel);
        this.cbCluster = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCluster);
        this.cbCluster.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCluster);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbCluster, 170);
    }

    private void initPctFree() {
        JLabel jLabel = new JLabel("PCTFREE:");
        this.general.add(jLabel);
        this.ifPCtFree = new JIntegerField(0, 26);
        this.general.add(this.ifPCtFree);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.ifPCtFree, 200);
    }

    private void initMinPercentageUsed() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogUDBv81.MinUsed"));
        this.general.add(jLabel);
        this.ifMinPercentUsed = new JIntegerField(0, 26);
        this.general.add(this.ifMinPercentUsed);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.ifMinPercentUsed, 230);
    }

    private void initReverseScan() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogUDBv81.ReverseScan"));
        this.general.add(jLabel);
        this.cbReverseScan = new JComboBox<String>(YES_NO);
        this.setBG(this.cbReverseScan);
        this.cbReverseScan.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbReverseScan);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbReverseScan, 260);
    }

    private void initCollectStatistics() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogUDBv81.CollectStatistics"));
        this.general.add(jLabel);
        this.cbCollectStatistics = new JComboBox<String>(IndexProxyUDBv81.COLLECT_STATISTICS_STATES);
        this.setBG(this.cbCollectStatistics);
        this.cbCollectStatistics.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCollectStatistics);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.cbCollectStatistics, 290);
    }

    private void initPropagatePropsButton() {
        JButton jButton = new JButton(Messages.getString("IndexPropertyDialogUDBv81.PropagateProperties"));
        jButton.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(IndexPropertyDialogUDBv81.this.getStorageDesign().getIndexProxySet().getElements());
                arrayList.remove(IndexPropertyDialogUDBv81.this.index);
                new PropertiesPropagationDialog(IndexPropertyDialogUDBv81.this.getAppView(), IndexPropertyDialogUDBv81.this.index, arrayList).showDialog();
            }
        });
        this.general.add(jButton);
        this.setObjectConstraints(jButton, 10, 330);
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
        this.initUsePrivilegesView();
    }

    protected void initUsePrivilegesView() {
        this.usePrivilegesPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogUDBv81.IndexPrivileges"), this.usePrivilegesPanel);
        this.initUsePrivileges();
    }

    protected void initUsePrivileges() {
        this.initToUsers();
        this.initToUserGroups();
    }

    private void initToUsers() {
        this.initAllUsersList();
        this.initSelectedUsersList();
        this.initUserButtons();
    }

    private void initAllUsersList() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogUDBv81.AllUsers"));
        this.usePrivilegesPanel.add(jLabel);
        this.allUsersModel = new DefaultListModel();
        this.allUsersList = new JList(this.allUsersModel);
        ListSelectionModel listSelectionModel = this.allUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllUserListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allUsersList);
        jScrollPane.setPreferredSize(new Dimension(144, 130));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(jScrollPane);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), jLabel, 12, 4);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), jScrollPane, 10, 22);
    }

    private void initSelectedUsersList() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogUDBv81.SelectedUsers"));
        this.usePrivilegesPanel.add(jLabel);
        this.selectedUsersModel = new DefaultListModel();
        this.selectedUsersList = new JList(this.selectedUsersModel);
        ListSelectionModel listSelectionModel = this.selectedUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedUserListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedUsersList);
        jScrollPane.setPreferredSize(new Dimension(145, 130));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(jScrollPane);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), jLabel, 292, 4);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), jScrollPane, 290, 22);
    }

    private void initUserButtons() {
        this.bnAddUser = new JButton(Messages.getString("IndexPropertyDialogUDBv81.Add"));
        this.bnAddUser.addActionListener(new AddUsersActionListener());
        this.bnAddUser.setEnabled(false);
        this.usePrivilegesPanel.add(this.bnAddUser);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnAddUser, 175, 55);
        this.bnRemoveUser = new JButton(Messages.getString("IndexPropertyDialogUDBv81.Remove"));
        this.bnRemoveUser.setEnabled(false);
        this.bnRemoveUser.addActionListener(new RemoveUsersActionListener());
        this.usePrivilegesPanel.add(this.bnRemoveUser);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnRemoveUser, 175, 85);
        IndexPropertyDialogUDBv81.equalizeButtonSizes(this.bnAddUser, this.bnRemoveUser);
    }

    private void initToUserGroups() {
        this.initAllUserGroupsList();
        this.initSelectedUserGroupsList();
        this.initGroupsButtons();
    }

    private void initAllUserGroupsList() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogUDBv81.AllUsersGroups"));
        this.usePrivilegesPanel.add(jLabel);
        this.allGroupsModel = new DefaultListModel();
        this.allGroupsList = new JList(this.allGroupsModel);
        ListSelectionModel listSelectionModel = this.allGroupsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllGroupListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allGroupsList);
        jScrollPane.setPreferredSize(new Dimension(144, 130));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(jScrollPane);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), jLabel, 12, 164);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), jScrollPane, 10, 182);
    }

    private void initSelectedUserGroupsList() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogUDBv81.SelectedUserGroups"));
        this.usePrivilegesPanel.add(jLabel);
        this.selectedGroupsModel = new DefaultListModel();
        this.selectedGroupsList = new JList(this.selectedGroupsModel);
        ListSelectionModel listSelectionModel = this.selectedGroupsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedGroupListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedGroupsList);
        jScrollPane.setPreferredSize(new Dimension(145, 130));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(jScrollPane);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), jLabel, 292, 164);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), jScrollPane, 290, 182);
    }

    private void initGroupsButtons() {
        this.bnAddGroup = new JButton(Messages.getString("IndexPropertyDialogUDBv81.Add"));
        this.bnAddGroup.addActionListener(new AddGroupsActionListener());
        this.bnAddGroup.setEnabled(false);
        this.usePrivilegesPanel.add(this.bnAddGroup);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnAddGroup, 175, 215);
        this.bnRemoveGroup = new JButton(Messages.getString("IndexPropertyDialogUDBv81.Remove"));
        this.bnRemoveGroup.setEnabled(false);
        this.bnRemoveGroup.addActionListener(new RemoveGroupsActionListener());
        this.usePrivilegesPanel.add(this.bnRemoveGroup);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnRemoveGroup, 175, 245);
        IndexPropertyDialogUDBv81.equalizeButtonSizes(this.bnAddGroup, this.bnRemoveGroup);
    }

    protected SpringLayout getUsePrivilegesLayout() {
        return (SpringLayout)this.usePrivilegesPanel.getLayout();
    }

    private void initColumnsView() {
        this.columns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogUDBv81.IncludeColumns"), this.columns);
        this.initColumns();
    }

    private void initColumns() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initButtons();
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.columns.getLayout();
    }

    private void initAllColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogUDBv81.AllColumns"));
        this.columns.add(jLabel);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allColumnsList);
        jScrollPane.setPreferredSize(new Dimension(144, 290));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(jScrollPane);
        this.setLabelConstraints(this.getColumnsLayout(), jLabel, 12, 4);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 10, 22);
    }

    private void initSelectedColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogUDBv81.SelectedColumns"));
        this.columns.add(jLabel);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedColumnsList);
        jScrollPane.setPreferredSize(new Dimension(145, 290));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(jScrollPane);
        this.setLabelConstraints(this.getColumnsLayout(), jLabel, 292, 4);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 290, 22);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("IndexPropertyDialogUDBv81.Add"));
        this.bnAdd.addActionListener(new AddColumnsActionListener());
        this.bnAdd.setEnabled(false);
        this.columns.add(this.bnAdd);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnAdd, 175, 125);
        this.bnRemove = new JButton(Messages.getString("IndexPropertyDialogUDBv81.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveColumnsActionListener());
        this.columns.add(this.bnRemove);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnRemove, 175, 155);
        IndexPropertyDialogUDBv81.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    @Override
    public void initProperties() {
        Object object;
        this.initCaption(this.index.getName());
        this.tfName.setText(this.index.getName());
        this.tfTable.setText(this.index.getTable().getName());
        this.selectObject(this.cbScheme, this.index.getSchema());
        this.tfUnique.setText(this.index.isUnique() ? YES_NO[0] : YES_NO[1]);
        this.cbCluster.setSelectedItem(this.index.getCluster() ? YES_NO[0] : YES_NO[1]);
        this.ifPCtFree.setValue((long)this.index.getPercentageFree());
        this.ifMinPercentUsed.setValue((long)this.index.getMinimumPercentageUsed());
        this.cbReverseScan.setSelectedItem(this.index.getReverseScanSupport() ? YES_NO[0] : YES_NO[1]);
        this.cbCollectStatistics.setSelectedItem(this.index.getCollectStatistics());
        if (this.index.isUnique()) {
            this.selectedColumnsList.setEnabled(true);
            this.allColumnsList.setEnabled(true);
        } else {
            this.selectedColumnsList.setEnabled(false);
            this.allColumnsList.setEnabled(false);
            this.bnAdd.setEnabled(false);
            this.bnRemove.setEnabled(false);
        }
        RelationalObjectProxy[] relationalObjectProxyArray = (RelationalObjectProxy[])this.getStorageDesign().getColumnProxySet().toArray();
        for (int i = 0; i < relationalObjectProxyArray.length; ++i) {
            RelationalObjectProxy relationalObjectProxy = relationalObjectProxyArray[i];
            object = this.index.getColumnProxies();
            boolean bl = false;
            for (int j = 0; j < ((ColumnProxy[])object).length; ++j) {
                if (object[j] != relationalObjectProxy) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            if (this.index.getColumnSet().contains(relationalObjectProxy.getName())) {
                this.selectedColumnsModel.addElement(relationalObjectProxy);
                continue;
            }
            this.allColumnsModel.addElement(relationalObjectProxy);
        }
        Owner[] ownerArray = (Owner[])this.getStorageDesign().getOwnerSet().toArray();
        for (int i = 0; i < ownerArray.length; ++i) {
            object = ownerArray[i];
            if (this.index.getUserSet().contains(((StorageObject)object).getName())) {
                this.selectedUsersModel.addElement(object);
                continue;
            }
            this.allUsersModel.addElement(object);
        }
        Object[] objectArray = this.getStorageDesign().getUserGroupSet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            UserGroupUDB userGroupUDB = (UserGroupUDB)objectArray[i];
            if (this.index.getUserGroupSet().contains(userGroupUDB.getName())) {
                this.selectedGroupsModel.addElement(userGroupUDB);
                continue;
            }
            this.allGroupsModel.addElement(userGroupUDB);
        }
        this.comment = ((Index)this.index.getObject()).getComment();
        this.commentInRDBMS = ((Index)this.index.getObject()).getCommentInRDBMS();
        if (this.index.isCommentChanged()) {
            this.getCommentsList().insert(this.index.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.index.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.index.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
        this.initColumnsSortOrder();
    }

    @Override
    protected void setProperties() {
        if (this.index != null) {
            Object object;
            this.index.setName(this.tfName.getText());
            Object object2 = this.cbScheme.getSelectedItem();
            if (object2 instanceof SchemaUDBv81) {
                this.index.setSchema((SchemaUDBv81)object2);
                this.index.setOwner(((SchemaUDBv81)object2).getOwner());
            } else {
                this.index.setSchema(null);
                this.index.setOwner(null);
            }
            object2 = this.cbCluster.getSelectedItem();
            boolean bl = String.valueOf(object2).equalsIgnoreCase(YES_NO[0]);
            this.index.setCluster(bl);
            this.index.setPercentageFree(this.ifPCtFree.getIntValue());
            this.index.setMinimumPercentageUsed(this.ifMinPercentUsed.getIntValue());
            object2 = this.cbReverseScan.getSelectedItem();
            bl = String.valueOf(object2).equalsIgnoreCase(YES_NO[0]);
            this.index.setReverseScanSupport(bl);
            this.index.setCollectStatistics((String)this.cbCollectStatistics.getSelectedItem());
            Object[] objectArray = this.selectedColumnsModel.toArray();
            this.index.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object3 = objectArray[i];
                if (!(object3 instanceof RelationalObjectProxy)) continue;
                this.index.setColumnList(((RelationalObjectProxy)object3).getName());
            }
            Object[] objectArray2 = this.selectedUsersModel.toArray();
            this.index.clearUsers();
            for (int i = 0; i < objectArray2.length; ++i) {
                Object object4 = objectArray2[i];
                if (!(object4 instanceof Owner)) continue;
                this.index.setUsers(((Owner)object4).getName());
            }
            Object[] objectArray3 = this.selectedGroupsModel.toArray();
            for (int i = 0; i < objectArray3.length; ++i) {
                object = objectArray3[i];
                if (!(object instanceof UserGroupUDB)) continue;
                this.index.setGroups(((UserGroupUDB)object).getName());
            }
            String string = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(string) && !this.comment.equalsIgnoreCase(string)) {
                this.index.setComment(string);
                this.index.setCommentChanged(true);
            } else {
                this.index.setComment("");
                this.index.setCommentChanged(false);
            }
            object = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty((String)object) && !this.commentInRDBMS.equalsIgnoreCase((String)object)) {
                this.index.setCommentInRDBMS((String)object);
                this.index.setCommentInRDBMSChanged(true);
            } else {
                this.index.setCommentInRDBMS("");
                this.index.setCommentInRDBMSChanged(false);
            }
            this.applyColumnsSortOrder();
        }
    }

    protected void initColumnsView(int n) {
        this.columnsView = new JPanel(new BorderLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogUDBv81.ColumnsSortOrder"), this.columnsView);
        this.columnsTable = new JTable();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet, 0);
        JScrollPane jScrollPane = new JScrollPane(this.columnsTable);
        jScrollPane.setPreferredSize(new Dimension(395, n));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columnsView.add(jScrollPane);
    }

    protected void initColumnsSortOrder() {
        this.sortModel = new ColumnsSortOrderModel((Index)this.index.getObject());
        this.columnsTable.setModel(this.sortModel);
        this.sortModel.setUpSortOrderColumn(this.columnsTable.getColumnModel().getColumn(1));
    }

    protected void applyColumnsSortOrder() {
        Collection collection = this.sortModel.getColumnsSortOrederColl();
        Iterator iterator = collection.iterator();
        Index index = (Index)this.index.getObject();
        while (iterator.hasNext()) {
            ColumnsSortOrderModel.ColumnNode columnNode = (ColumnsSortOrderModel.ColumnNode)iterator.next();
            Column column = (Column)index.getElementByID(columnNode.objectId);
            if (column == null) continue;
            index.setColumnSortOrder(column, columnNode.sortOrder);
        }
    }

    public class SchemeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SchemaUDBv81 schemaUDBv81 = (SchemaUDBv81)IndexPropertyDialogUDBv81.this.cbScheme.getSelectedItem();
            try {
                if (schemaUDBv81 != null) {
                    IndexPropertyDialogUDBv81.this.tfOwner.setText(schemaUDBv81.getOwner().toString());
                }
            }
            catch (NullPointerException nullPointerException) {
                IndexPropertyDialogUDBv81.this.tfOwner.setText("");
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!IndexPropertyDialogUDBv81.this.selectedColumnsModel.isEmpty()) {
                Object[] objectArray = IndexPropertyDialogUDBv81.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (IndexPropertyDialogUDBv81.this.allColumnsModel.contains(object)) continue;
                    IndexPropertyDialogUDBv81.this.allColumnsModel.addElement(object);
                    IndexPropertyDialogUDBv81.this.selectedColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!IndexPropertyDialogUDBv81.this.allColumnsModel.isEmpty()) {
                Object[] objectArray = IndexPropertyDialogUDBv81.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (IndexPropertyDialogUDBv81.this.selectedColumnsModel.contains(object)) continue;
                    IndexPropertyDialogUDBv81.this.selectedColumnsModel.addElement(object);
                    IndexPropertyDialogUDBv81.this.allColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (IndexPropertyDialogUDBv81.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (IndexPropertyDialogUDBv81.this.selectedColumnsList.getSelectedIndex() == -1) {
                    IndexPropertyDialogUDBv81.this.bnRemove.setEnabled(false);
                } else {
                    IndexPropertyDialogUDBv81.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (IndexPropertyDialogUDBv81.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (IndexPropertyDialogUDBv81.this.allColumnsList.getSelectedIndex() == -1) {
                    IndexPropertyDialogUDBv81.this.bnAdd.setEnabled(false);
                } else {
                    IndexPropertyDialogUDBv81.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class SelectedGroupListSelectionHandler
    implements ListSelectionListener {
        private SelectedGroupListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (IndexPropertyDialogUDBv81.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (IndexPropertyDialogUDBv81.this.selectedGroupsList.getSelectedIndex() == -1) {
                    IndexPropertyDialogUDBv81.this.bnRemoveGroup.setEnabled(false);
                } else {
                    IndexPropertyDialogUDBv81.this.bnRemoveGroup.setEnabled(true);
                }
            }
        }
    }

    private class AllGroupListSelectionHandler
    implements ListSelectionListener {
        private AllGroupListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (IndexPropertyDialogUDBv81.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (IndexPropertyDialogUDBv81.this.allGroupsList.getSelectedIndex() == -1) {
                    IndexPropertyDialogUDBv81.this.bnAddGroup.setEnabled(false);
                } else {
                    IndexPropertyDialogUDBv81.this.bnAddGroup.setEnabled(true);
                }
            }
        }
    }

    private class RemoveGroupsActionListener
    implements ActionListener {
        private RemoveGroupsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!IndexPropertyDialogUDBv81.this.selectedGroupsModel.isEmpty()) {
                Object[] objectArray = IndexPropertyDialogUDBv81.this.selectedGroupsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (IndexPropertyDialogUDBv81.this.allGroupsModel.contains(object)) continue;
                    IndexPropertyDialogUDBv81.this.allGroupsModel.addElement(object);
                    IndexPropertyDialogUDBv81.this.selectedGroupsModel.removeElement(object);
                }
            }
        }
    }

    private class AddGroupsActionListener
    implements ActionListener {
        private AddGroupsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!IndexPropertyDialogUDBv81.this.allGroupsModel.isEmpty()) {
                Object[] objectArray = IndexPropertyDialogUDBv81.this.allGroupsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (IndexPropertyDialogUDBv81.this.selectedGroupsModel.contains(object)) continue;
                    IndexPropertyDialogUDBv81.this.selectedGroupsModel.addElement(object);
                    IndexPropertyDialogUDBv81.this.allGroupsModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedUserListSelectionHandler
    implements ListSelectionListener {
        private SelectedUserListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (IndexPropertyDialogUDBv81.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (IndexPropertyDialogUDBv81.this.selectedUsersList.getSelectedIndex() == -1) {
                    IndexPropertyDialogUDBv81.this.bnRemoveUser.setEnabled(false);
                } else {
                    IndexPropertyDialogUDBv81.this.bnRemoveUser.setEnabled(true);
                }
            }
        }
    }

    private class AllUserListSelectionHandler
    implements ListSelectionListener {
        private AllUserListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (IndexPropertyDialogUDBv81.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (IndexPropertyDialogUDBv81.this.allUsersList.getSelectedIndex() == -1) {
                    IndexPropertyDialogUDBv81.this.bnAddUser.setEnabled(false);
                } else {
                    IndexPropertyDialogUDBv81.this.bnAddUser.setEnabled(true);
                }
            }
        }
    }

    private class RemoveUsersActionListener
    implements ActionListener {
        private RemoveUsersActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!IndexPropertyDialogUDBv81.this.selectedUsersModel.isEmpty()) {
                Object[] objectArray = IndexPropertyDialogUDBv81.this.selectedUsersList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (IndexPropertyDialogUDBv81.this.allUsersModel.contains(object)) continue;
                    IndexPropertyDialogUDBv81.this.allUsersModel.addElement(object);
                    IndexPropertyDialogUDBv81.this.selectedUsersModel.removeElement(object);
                }
            }
        }
    }

    private class AddUsersActionListener
    implements ActionListener {
        private AddUsersActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!IndexPropertyDialogUDBv81.this.allUsersModel.isEmpty()) {
                Object[] objectArray = IndexPropertyDialogUDBv81.this.allUsersList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (IndexPropertyDialogUDBv81.this.selectedUsersModel.contains(object)) continue;
                    IndexPropertyDialogUDBv81.this.selectedUsersModel.addElement(object);
                    IndexPropertyDialogUDBv81.this.allUsersModel.removeElement(object);
                }
            }
        }
    }
}

