/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb.v81;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.FKProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.FKProxyUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class FKPropertyDialogUDBv81
extends AbstractUDBPropertyDialog {
    private FKProxyUDBv81 fkIndex;
    private JTextField tfTable;
    private JTextField tfRefTable;
    private JTextField tfOnDelete;
    private JComboBox cbOnUpdate;
    private JComboBox cbValidation;
    private JComboBox cbQueryOptimization;
    private JPanel columns;
    private JPanel refColumns;
    private JList columnList;
    private JList refColumnsList;
    private DefaultListModel columnListModel;
    private DefaultListModel refColumnsListModel;

    public FKPropertyDialogUDBv81(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.fkIndex = (FKProxyUDBv81)storageObject;
        this.setHeight(260);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("FKPropertyDialogUDBv81.ForeignKeyProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initRefTable();
        this.initOnDelete();
        this.initOnUpdate();
        this.initValidation();
        this.initQueryOptimization();
    }

    private void initTable() {
        JLabel jLabel = new JLabel(Messages.getString("FKPropertyDialogUDBv81.Table"));
        this.general.add(jLabel);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEditable(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initRefTable() {
        JLabel jLabel = new JLabel(Messages.getString("FKPropertyDialogUDBv81.RefTable"));
        this.general.add(jLabel);
        this.tfRefTable = new JTextField("", 26);
        this.tfRefTable.setEditable(false);
        this.general.add(this.tfRefTable);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfRefTable, 80);
    }

    private void initOnDelete() {
        JLabel jLabel = new JLabel(Messages.getString("FKPropertyDialogUDBv81.OnDelete"));
        this.general.add(jLabel);
        this.tfOnDelete = new JTextField();
        this.setBG(this.tfOnDelete);
        this.tfOnDelete.setPreferredSize(this.tfName.getPreferredSize());
        this.tfOnDelete.setEnabled(false);
        this.general.add(this.tfOnDelete);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.tfOnDelete, 110);
    }

    private void initOnUpdate() {
        JLabel jLabel = new JLabel(Messages.getString("FKPropertyDialogUDBv81.OnUpdate"));
        this.general.add(jLabel);
        this.cbOnUpdate = new JComboBox<String>(FKProxyUDB.getOnUpdateChoices());
        this.setBG(this.cbOnUpdate);
        this.cbOnUpdate.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOnUpdate);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbOnUpdate, 140);
    }

    private void initValidation() {
        JLabel jLabel = new JLabel(Messages.getString("FKPropertyDialogUDBv81.Validation"));
        this.general.add(jLabel);
        this.cbValidation = new JComboBox<String>(FKProxyUDBv81.validationChoices);
        this.setBG(this.cbValidation);
        this.cbValidation.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbValidation);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbValidation, 170);
    }

    private void initQueryOptimization() {
        JLabel jLabel = new JLabel(Messages.getString("FKPropertyDialogUDBv81.QueryOptimization"));
        this.general.add(jLabel);
        this.cbQueryOptimization = new JComboBox<String>(FKProxyUDBv81.queryOptimizationChoices);
        this.setBG(this.cbQueryOptimization);
        this.cbQueryOptimization.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbQueryOptimization);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbQueryOptimization, 200);
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
        this.initRefColumnsView();
    }

    private void initColumnsView() {
        this.columns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("FKPropertyDialogUDBv81.Columns"), this.columns);
        this.initColumns();
    }

    private void initColumns() {
        this.columnListModel = new DefaultListModel();
        this.columnList = new JList(this.columnListModel);
        this.columnList.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.columnList);
        jScrollPane.setPreferredSize(new Dimension(395, 210));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(jScrollPane);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.columns.getLayout();
    }

    protected SpringLayout getRefColumnsLayout() {
        return (SpringLayout)this.refColumns.getLayout();
    }

    private void initRefColumnsView() {
        this.refColumns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("FKPropertyDialogUDBv81.ReferencedColumns"), this.refColumns);
        this.initRefColumns();
    }

    private void initRefColumns() {
        this.refColumnsListModel = new DefaultListModel();
        this.refColumnsList = new JList(this.refColumnsListModel);
        this.refColumnsList.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.refColumnsList);
        jScrollPane.setPreferredSize(new Dimension(395, 210));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.refColumns.add(jScrollPane);
        this.setObjectConstraints(this.getRefColumnsLayout(), jScrollPane, 10, 12);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.fkIndex.getName());
        this.tfName.setText(this.fkIndex.getName());
        this.tfTable.setText(this.fkIndex.getTable().getName());
        this.tfRefTable.setText(this.fkIndex.getReferenceTable());
        this.cbValidation.setSelectedItem(this.fkIndex.getValidation());
        this.cbQueryOptimization.setSelectedItem(this.fkIndex.getQueryOptimization());
        ColumnProxy[] columnProxyArray = this.fkIndex.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxy columnProxy = columnProxyArray[i];
            this.columnListModel.addElement(columnProxy);
        }
        Column[] columnArray = this.fkIndex.getRefColumns();
        for (int i = 0; i < columnArray.length; ++i) {
            Column column = columnArray[i];
            this.refColumnsListModel.addElement(column);
        }
        String string = ((Index)this.fkIndex.getObject()).getFKAssociation().getDeleteRule();
        if (string.equalsIgnoreCase("SET DEFAULT")) {
            string = ((Index)this.fkIndex.getObject()).getFKAssociation().isMandatory() ? "RESTRICT" : "SET NULL";
        }
        this.tfOnDelete.setText(string);
        this.cbOnUpdate.setSelectedItem(this.fkIndex.getOnUpdate());
        this.getCommentsList().insert(this.fkIndex.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.fkIndex != null) {
            this.fkIndex.setName(this.tfName.getText());
            this.fkIndex.setOnUpdate((String)this.cbOnUpdate.getSelectedItem());
            this.fkIndex.setValidation((String)this.cbValidation.getSelectedItem());
            this.fkIndex.setQueryOptimization((String)this.cbQueryOptimization.getSelectedItem());
            this.fkIndex.setComment(this.getCommentsList().getText());
        }
    }
}

