/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb.v81;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.datatype.udb.MDBlobUDB;
import oracle.dbtools.crest.model.datatype.udb.MDClobUDB;
import oracle.dbtools.crest.model.datatype.udb.MDDBClobUDB;
import oracle.dbtools.crest.model.datatype.udb.MDDataLinkUDB;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.ColumnProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.ColumnProxyUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.ColumnPropertyDialogUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.gui.swing.JNumericField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class ColumnPropertyDialogUDBv81
extends AbstractUDBPropertyDialog {
    private static final int MAX_DIGITS = 31;
    private ColumnProxyUDBv81 column;
    private JTextField tfDataType;
    private JComboBox cbBelongsToPK;
    private JComboBox cbNullsAllowed;
    private JPanel datalinkOptions;
    private JPanel lobOptions;
    private JComboBox cbLinkControl;
    private JComboBox cbReadPermission;
    private JComboBox cbWritePermission;
    private JComboBox cbRecovery;
    private JComboBox cbUnlink;
    private JComboBox cbLogging;
    private JComboBox cbCompact;
    private JComboBox cbCompressSystemDefault;
    private JPanel columnIdentity;
    private JCheckBox chbUse;
    private JComboBox cbGenerate;
    private JTextField tfStartWith;
    private JIntegerField ifIncrementBy;
    private JTextField tfCache;
    private JComboBox cbDefault;
    private JComboBox cbDefaultValue;
    private JTextField tfDefaultConstant;
    private JComboBox cbCycle;
    private JComboBox cbOrder;
    private JNumericField ifMaxValue;
    private JNumericField ifMinValue;
    private JTextField tfGenerationExpression;
    private JPanel columnCheckOptions;
    private JTextField tfConstraintName;
    private JTextArea taConstraint;
    private JComboBox cbValidation;
    private JComboBox cbQueryOptimization;
    private boolean useIdentity;
    private String generationExpression;
    private String comment;
    private String commentInRDBMS;
    private JComboBox cbForBitData;
    private boolean generateAlways;
    private String startWith;
    private Integer incrementBy;
    private String minValue;
    private String maxValue;
    private boolean cycle;
    private Integer cache;
    private boolean order;

    public ColumnPropertyDialogUDBv81(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.column = (ColumnProxyUDBv81)storageObject;
        this.setHeight(360);
        this.initCommentsView(135);
        this.initCommentsInRDBMS(135);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("ColumnPropertyDialogUDBv81.ColumnProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDataType();
        this.initBelongsToPK();
        this.initNullsAllowed();
        this.initDefault();
        this.initDefaultValue();
        this.initDefaultConstant();
        this.initForBitData();
        this.initCompressSystemDefault();
    }

    private void initDataType() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.DataType"));
        this.general.add(jLabel);
        this.tfDataType = new JTextField("", 26);
        this.tfDataType.setEditable(false);
        this.general.add(this.tfDataType);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfDataType, 50);
    }

    private void initBelongsToPK() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.BelongsToPK"));
        this.general.add(jLabel);
        this.cbBelongsToPK = new JComboBox<String>(YES_NO);
        this.setBG(this.cbBelongsToPK);
        this.cbBelongsToPK.setEnabled(false);
        this.cbBelongsToPK.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbBelongsToPK);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbBelongsToPK, 80);
    }

    private void initNullsAllowed() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.NullsAllowed"));
        this.general.add(jLabel);
        this.cbNullsAllowed = new JComboBox<String>(YES_NO);
        this.setBG(this.cbNullsAllowed);
        this.cbNullsAllowed.setEnabled(false);
        this.cbNullsAllowed.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbNullsAllowed);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbNullsAllowed, 110);
    }

    private void initDefault() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.Default"));
        this.general.add(jLabel);
        this.cbDefault = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDefault);
        this.cbDefault.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDefault);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbDefault, 140);
    }

    private void initDefaultValue() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.DefaultValue"));
        this.general.add(jLabel);
        this.cbDefaultValue = new JComboBox<String>(ColumnProxyUDB.getDefaultValueChoices());
        this.setBG(this.cbDefaultValue);
        this.cbDefaultValue.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDefaultValue);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbDefaultValue, 170);
    }

    private void initDefaultConstant() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.DefaultConstant"));
        this.general.add(jLabel);
        this.tfDefaultConstant = new JTextField("", 26);
        this.general.add(this.tfDefaultConstant);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.tfDefaultConstant, 200);
    }

    private void initCompressSystemDefault() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.CompressSystem"));
        this.general.add(jLabel);
        this.cbCompressSystemDefault = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCompressSystemDefault);
        this.cbCompressSystemDefault.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCompressSystemDefault);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbCompressSystemDefault, 260);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.column.getName());
        this.tfName.setText(this.column.getName());
        this.tfDataType.setText(this.column.getDatatypeString());
        this.cbBelongsToPK.setSelectedItem(this.column.isPKElement() ? YES_NO[0] : YES_NO[1]);
        this.cbNullsAllowed.setSelectedItem(this.column.getColumn().getNullsAllowed() ? YES_NO[0] : YES_NO[1]);
        this.cbDefault.setSelectedItem(this.column.getDefault() ? YES_NO[0] : YES_NO[1]);
        this.cbDefaultValue.setSelectedItem(this.column.getDefaultValue());
        this.tfDefaultConstant.setText(this.column.getDefaultValueConstant());
        this.cbCompressSystemDefault.setSelectedItem(ColumnPropertyDialogUDBv81.translateYesNoForDisplay(this.column.getCompressSystemDefault()));
        this.cbForBitData.setSelectedItem(this.column.isForBitData() ? YES_NO[0] : YES_NO[1]);
        this.cbForBitData.setEnabled(ColumnPropertyDialogUDB.dataTypeIsCharacter(this.column));
        this.enableDatalinkOptions(false);
        this.enableLobOptions(false);
        if (this.column.getDataType() instanceof MDDataLinkUDB) {
            this.enableDatalinkOptions(true);
            this.cbLinkControl.setSelectedItem(this.column.getLinkControl());
            this.cbReadPermission.setSelectedItem(this.column.getReadPermission());
            this.cbWritePermission.setSelectedItem(this.column.getWritePermission());
            this.cbRecovery.setSelectedItem(ColumnPropertyDialogUDBv81.translateYesNoForDisplay(this.column.getRecovery()));
            this.cbUnlink.setSelectedItem(this.column.getOnUnlink());
            if (this.column.getWritePermission().equalsIgnoreCase("FS")) {
                this.cbUnlink.setEnabled(false);
            } else {
                this.cbUnlink.setEnabled(true);
            }
        } else if (this.isLobColumn(this.column.getDataType())) {
            this.enableLobOptions(true);
            this.cbLogging.setSelectedItem(this.column.getLogging());
            this.cbCompact.setSelectedItem(ColumnPropertyDialogUDBv81.translateYesNoForDisplay(this.column.getCompact()));
        }
        this.initColumnIdentityProperties();
        CheckConstraint checkConstraint = this.column.getColumn().getCheck();
        if (checkConstraint != null) {
            this.tfConstraintName.setText(checkConstraint.getName());
            this.taConstraint.setText(checkConstraint.getImplementation(new Integer(3)));
        }
        this.cbValidation.setSelectedItem(this.column.getValidation());
        this.cbQueryOptimization.setSelectedItem(this.column.getQueryOptimization());
        this.comment = this.column.getObject().getComment();
        this.commentInRDBMS = this.column.getObject().getCommentInRDBMS();
        if (this.column.isCommentChanged()) {
            this.getCommentsList().insert(this.column.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.column.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.column.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
    }

    private void initColumnObjectProperties() {
        Column column = (Column)this.column.getObject();
        this.useIdentity = column.isIdentityColumn();
        this.generateAlways = column.isAutoIncrementGenerateAlways();
        this.startWith = column.getAutoIncrementStartWith();
        this.incrementBy = column.getAutoIncrementIncrementBy();
        this.minValue = column.getAutoIncrementMinValue();
        this.maxValue = column.getAutoIncrementMaxValue();
        this.cycle = column.isAutoIncrementCycle();
        this.cache = column.getAutoIncrementCache();
        this.order = column.isAutoIncrementOrder();
    }

    protected void initColumnIdentityProperties() {
        boolean bl;
        this.initColumnObjectProperties();
        boolean bl2 = bl = this.column.isUseIdentityChanged() ? this.column.getUseIdentity() : this.useIdentity;
        if (!this.column.isNumericDataType()) {
            this.chbUse.setEnabled(this.useIdentity || bl);
        }
        if (!this.column.isUseIdentityChanged() && !this.useIdentity) {
            this.chbUse.setEnabled(false);
        }
        this.chbUse.setSelected(bl);
        this.setIdentityUse(bl);
        if (this.column.isGenerateAlwaysChanged()) {
            this.cbGenerate.setSelectedItem(this.column.getGenerate());
        } else {
            this.cbGenerate.setSelectedItem(this.generateAlways ? ColumnProxyUDB.getGenerateValues()[0] : ColumnProxyUDB.getGenerateValues()[1]);
        }
        if (this.column.isStartWithChanged()) {
            this.tfStartWith.setText(this.column.getStartWith());
        } else {
            this.tfStartWith.setText(this.startWith);
        }
        if (this.column.isIncrementByChanged()) {
            this.ifIncrementBy.setValue((long)this.column.getIncrementBy());
        } else {
            this.ifIncrementBy.setValue(this.incrementBy);
        }
        if (this.column.isMaxValueChanged()) {
            this.ifMaxValue.setText(this.column.getMaxValue());
        } else {
            this.ifMaxValue.setText(this.maxValue);
        }
        if (this.column.isMinValueChanged()) {
            this.ifMinValue.setText(this.column.getMinValue());
        } else {
            this.ifMinValue.setText(this.minValue);
        }
        if (this.column.isCycleChanged()) {
            this.cbCycle.setSelectedItem(ColumnPropertyDialogUDBv81.translateYesNoForDisplay(this.column.getCycle()));
        } else {
            this.cbCycle.setSelectedItem(this.cycle ? YES_NO[0] : YES_NO[1]);
        }
        if (this.column.isOrderChanged()) {
            this.cbOrder.setSelectedItem(ColumnPropertyDialogUDBv81.translateYesNoForDisplay(this.column.getOrder()));
        } else {
            this.cbOrder.setSelectedItem(this.order ? YES_NO[0] : YES_NO[1]);
        }
        if (this.column.isCacheChanged()) {
            this.tfCache.setText(this.column.getCache());
        } else {
            this.tfCache.setText(this.cache == null ? null : String.valueOf(this.cache));
        }
        this.generationExpression = this.column.getGenerationExpression();
        this.tfGenerationExpression.setText(this.generationExpression);
    }

    @Override
    protected void setProperties() {
        if (this.column != null) {
            this.column.setName(this.tfName.getText());
            if (this.column.getDataType() instanceof MDDataLinkUDB) {
                this.column.setLinkControl((String)this.cbLinkControl.getSelectedItem());
                this.column.setReadPermission((String)this.cbReadPermission.getSelectedItem());
                this.column.setWritePermission((String)this.cbWritePermission.getSelectedItem());
                this.column.setRecovery(ColumnPropertyDialogUDBv81.translateYesNoForStorage((String)this.cbRecovery.getSelectedItem()));
                this.column.setOnUnlink((String)this.cbUnlink.getSelectedItem());
            } else if (this.isLobColumn(this.column.getDataType())) {
                this.column.setLogging((String)this.cbLogging.getSelectedItem());
                this.column.setCompact(ColumnPropertyDialogUDBv81.translateYesNoForStorage((String)this.cbCompact.getSelectedItem()));
            }
            this.setColumnIdentityProperties();
            Object object = this.cbDefault.getSelectedItem();
            boolean bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.column.setDefault(bl);
            this.column.setDefaultValue((String)this.cbDefaultValue.getSelectedItem());
            String string = this.column.getColumn().getDefaultValue();
            if (string.equals(this.tfDefaultConstant.getText())) {
                this.column.setDefaultValueConstant(null);
            } else {
                this.column.setDefaultValueConstant(this.tfDefaultConstant.getText());
            }
            this.column.setCompressSystemDefault(ColumnPropertyDialogUDBv81.translateYesNoForStorage((String)this.cbCompressSystemDefault.getSelectedItem()));
            object = this.cbForBitData.getSelectedItem();
            bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.column.setForBitData(bl);
            this.column.setValidation((String)this.cbValidation.getSelectedItem());
            this.column.setQueryOptimization((String)this.cbQueryOptimization.getSelectedItem());
            String string2 = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(string2) && !this.comment.equals(string2)) {
                this.column.setComment(string2);
                this.column.setCommentChanged(true);
            } else {
                this.column.setComment("");
                this.column.setCommentChanged(false);
            }
            String string3 = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(string3) && !this.commentInRDBMS.equals(string3)) {
                this.column.setCommentInRDBMS(string3);
                this.column.setCommentInRDBMSChanged(true);
            } else {
                this.column.setCommentInRDBMS("");
                this.column.setCommentInRDBMSChanged(false);
            }
        }
    }

    protected void setColumnIdentityProperties() {
        this.initColumnObjectProperties();
        if (this.chbUse.isSelected() != this.useIdentity) {
            this.column.setUseIdentity(this.chbUse.isSelected());
            this.column.setUseIdentityChanged(true);
        } else {
            this.column.setUseIdentityChanged(false);
        }
        if (this.chbUse.isSelected()) {
            int n;
            int n2;
            if (this.notEquals(this.generateAlways, this.cbGenerate, ColumnProxyUDB.getGenerateValues()[0], ColumnProxyUDB.getGenerateValues()[1])) {
                this.column.setGenerate((String)this.cbGenerate.getSelectedItem());
                this.column.setGenerateAlwaysChanged(true);
            } else {
                this.column.setGenerateAlwaysChanged(false);
            }
            if (this.notEquals(this.startWith, this.tfStartWith)) {
                this.column.setStartWith(this.tfStartWith.getText());
                this.column.setStartWithChanged(true);
            } else {
                this.column.setStartWithChanged(false);
            }
            if (this.notEquals(this.incrementBy, this.ifIncrementBy)) {
                this.column.setIncrementBy(this.ifIncrementBy.getIntValue());
                this.column.setIncrementByChanged(true);
            } else {
                this.column.setIncrementByChanged(false);
            }
            if (this.notEquals(this.minValue, this.ifMinValue)) {
                this.column.setMinValue(this.ifMinValue.getText());
                this.column.setMinValueChanged(true);
            } else {
                this.column.setMinValueChanged(false);
            }
            if (this.notEquals(this.maxValue, this.ifMaxValue)) {
                this.column.setMaxValue(this.ifMaxValue.getText());
                this.column.setMaxValueChanged(true);
            } else {
                this.column.setMaxValueChanged(false);
            }
            if (this.notEquals(this.cycle, this.cbCycle, YES, NO)) {
                this.column.setCycle(ColumnPropertyDialogUDBv81.translateYesNoForStorage((String)this.cbCycle.getSelectedItem()));
                this.column.setCycleChanged(true);
            } else {
                this.column.setCycleChanged(false);
            }
            if (this.notEquals(this.order, this.cbOrder, YES, NO)) {
                this.column.setOrder(ColumnPropertyDialogUDBv81.translateYesNoForStorage((String)this.cbOrder.getSelectedItem()));
                this.column.setOrderChanged(true);
            } else {
                this.column.setOrderChanged(false);
            }
            String string = this.tfCache.getText().trim();
            int n3 = n2 = this.cache == null ? 0 : this.cache;
            if (string.equalsIgnoreCase(NO)) {
                n = 0;
            } else if (string.equalsIgnoreCase(YES)) {
                string = "20";
                n = 20;
            } else {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n = n2;
                }
            }
            if (n != n2) {
                this.column.setCache(string);
                this.column.setCacheChanged(true);
            } else {
                this.column.setCacheChanged(false);
            }
            this.column.setGenerationExpression(this.tfGenerationExpression.getText());
            if (!this.tfGenerationExpression.getText().equals(this.generationExpression)) {
                this.column.setGenerationExpressionChanged(true);
            }
        }
    }

    @Override
    protected void addTabs() {
        this.initDatalinkOptionsView();
        this.initLobOptionsView();
        this.initColumnIdentityView();
        this.initColumnCheckOptionsView();
    }

    private void initDatalinkOptionsView() {
        this.datalinkOptions = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ColumnPropertyDialogUDBv81.DatalinkOptions"), this.datalinkOptions);
        this.initDatalinkOptions();
    }

    private void initLobOptionsView() {
        this.lobOptions = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ColumnPropertyDialogUDBv81.LobOptions"), this.lobOptions);
        this.initLobOptions();
    }

    private void initColumnIdentityView() {
        this.columnIdentity = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ColumnPropertyDialogUDBv81.ColumnIdentity"), this.columnIdentity);
        this.initColumnIdentity();
    }

    private void initColumnCheckOptionsView() {
        this.columnCheckOptions = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ColumnPropertyDialogUDBv81.ColumnCheckOptions"), this.columnCheckOptions);
        this.initColumnCheckOptions();
    }

    private void initDatalinkOptions() {
        this.initLinkControl();
        this.initReadPermission();
        this.initWritePermission();
        this.initRecovery();
        this.initUnlink();
    }

    private void initLobOptions() {
        this.initLogging();
        this.initCompact();
    }

    private void initColumnIdentity() {
        this.initUseIdentity();
        this.initGenerate();
        this.initStartWith();
        this.initIncremetBy();
        this.initMaxValue();
        this.initMinValue();
        this.initCycle();
        this.initCache();
        this.initOrder();
        this.initGenerationExpression();
        this.setIdentityUse(false);
    }

    private void initColumnCheckOptions() {
        this.initConstraintName();
        this.initConstraint();
        this.initValidation();
        this.initQueryOptimization();
    }

    private void initConstraintName() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.ConstraintName"));
        this.columnCheckOptions.add(jLabel);
        this.tfConstraintName = new JTextField(26);
        this.columnCheckOptions.add(this.tfConstraintName);
        this.tfConstraintName.setEnabled(false);
        this.setLabelConstraints(this.getColumnCheckOptionsLayout(), jLabel, 20);
        this.setObjectConstraints(this.getColumnCheckOptionsLayout(), this.tfConstraintName, 20);
    }

    private void initConstraint() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.Constraint"));
        this.columnCheckOptions.add(jLabel);
        this.taConstraint = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.taConstraint);
        jScrollPane.setPreferredSize(new Dimension(395, 160));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.taConstraint.setLineWrap(true);
        this.taConstraint.setEnabled(false);
        this.columnCheckOptions.add(jScrollPane);
        this.setLabelConstraints(this.getColumnCheckOptionsLayout(), jLabel, 50);
        this.setObjectConstraints(this.getColumnCheckOptionsLayout(), jScrollPane, 10, 70);
    }

    private void initValidation() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.Validation"));
        this.columnCheckOptions.add(jLabel);
        this.cbValidation = new JComboBox<String>(ColumnProxyUDBv81.validationChoices);
        this.setBG(this.cbValidation);
        this.cbValidation.setPreferredSize(this.tfName.getPreferredSize());
        this.columnCheckOptions.add(this.cbValidation);
        this.setLabelConstraints(this.getColumnCheckOptionsLayout(), jLabel, 250);
        this.setObjectConstraints(this.getColumnCheckOptionsLayout(), this.cbValidation, 250);
    }

    private void initQueryOptimization() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.QueryOptimization"));
        this.columnCheckOptions.add(jLabel);
        this.cbQueryOptimization = new JComboBox<String>(ColumnProxyUDBv81.queryOptimizationChoices);
        this.setBG(this.cbQueryOptimization);
        this.cbQueryOptimization.setPreferredSize(this.tfName.getPreferredSize());
        this.columnCheckOptions.add(this.cbQueryOptimization);
        this.setLabelConstraints(this.getColumnCheckOptionsLayout(), jLabel, 280);
        this.setObjectConstraints(this.getColumnCheckOptionsLayout(), this.cbQueryOptimization, 280);
    }

    protected SpringLayout getDatalinkLayout() {
        return (SpringLayout)this.datalinkOptions.getLayout();
    }

    protected SpringLayout getLobLayout() {
        return (SpringLayout)this.lobOptions.getLayout();
    }

    protected SpringLayout getColumnIdentityLayout() {
        return (SpringLayout)this.columnIdentity.getLayout();
    }

    protected SpringLayout getColumnCheckOptionsLayout() {
        return (SpringLayout)this.columnCheckOptions.getLayout();
    }

    private void initLinkControl() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.LinkControl"));
        this.datalinkOptions.add(jLabel);
        this.cbLinkControl = new JComboBox<String>(ColumnProxyUDB.getLinkControlChoices());
        this.setBG(this.cbLinkControl);
        this.cbLinkControl.setPreferredSize(this.tfName.getPreferredSize());
        this.datalinkOptions.add(this.cbLinkControl);
        this.setLabelConstraints(this.getDatalinkLayout(), jLabel, 20);
        this.setObjectConstraints(this.getDatalinkLayout(), this.cbLinkControl, 20);
    }

    private void initReadPermission() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.ReadPermission"));
        this.datalinkOptions.add(jLabel);
        this.cbReadPermission = new JComboBox<String>(ColumnProxyUDB.getReadPermissionChoices());
        this.setBG(this.cbReadPermission);
        this.cbReadPermission.setPreferredSize(this.tfName.getPreferredSize());
        this.datalinkOptions.add(this.cbReadPermission);
        this.setLabelConstraints(this.getDatalinkLayout(), jLabel, 50);
        this.setObjectConstraints(this.getDatalinkLayout(), this.cbReadPermission, 50);
    }

    private void initWritePermission() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.WritePermission"));
        this.datalinkOptions.add(jLabel);
        this.cbWritePermission = new JComboBox<String>(ColumnProxyUDBv81.getWritePermissionChoices());
        this.cbWritePermission.addActionListener(new WritePermissionListener());
        this.setBG(this.cbWritePermission);
        this.cbWritePermission.setPreferredSize(this.tfName.getPreferredSize());
        this.datalinkOptions.add(this.cbWritePermission);
        this.setLabelConstraints(this.getDatalinkLayout(), jLabel, 80);
        this.setObjectConstraints(this.getDatalinkLayout(), this.cbWritePermission, 80);
    }

    private void initRecovery() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.Recovery"));
        this.datalinkOptions.add(jLabel);
        this.cbRecovery = new JComboBox<String>(YES_NO);
        this.setBG(this.cbRecovery);
        this.cbRecovery.setPreferredSize(this.tfName.getPreferredSize());
        this.datalinkOptions.add(this.cbRecovery);
        this.setLabelConstraints(this.getDatalinkLayout(), jLabel, 110);
        this.setObjectConstraints(this.getDatalinkLayout(), this.cbRecovery, 110);
    }

    private void initUnlink() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.Unlink"));
        this.datalinkOptions.add(jLabel);
        this.cbUnlink = new JComboBox<String>(ColumnProxyUDB.getOnUnlinkChoices());
        this.setBG(this.cbUnlink);
        this.cbUnlink.setPreferredSize(this.tfName.getPreferredSize());
        this.datalinkOptions.add(this.cbUnlink);
        this.setLabelConstraints(this.getDatalinkLayout(), jLabel, 140);
        this.setObjectConstraints(this.getDatalinkLayout(), this.cbUnlink, 140);
    }

    private void initLogging() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.Logging"));
        this.lobOptions.add(jLabel);
        this.cbLogging = new JComboBox<String>(ColumnProxyUDB.getloggingChoices());
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.lobOptions.add(this.cbLogging);
        this.setLabelConstraints(this.getLobLayout(), jLabel, 20);
        this.setObjectConstraints(this.getLobLayout(), this.cbLogging, 20);
    }

    private void initCompact() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.Compact"));
        this.lobOptions.add(jLabel);
        this.cbCompact = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCompact);
        this.cbCompact.setPreferredSize(this.tfName.getPreferredSize());
        this.lobOptions.add(this.cbCompact);
        this.setLabelConstraints(this.getLobLayout(), jLabel, 50);
        this.setObjectConstraints(this.getLobLayout(), this.cbCompact, 50);
    }

    private void enableDatalinkOptions(boolean bl) {
        this.cbLinkControl.setEnabled(bl);
        this.cbReadPermission.setEnabled(bl);
        this.cbWritePermission.setEnabled(bl);
        this.cbRecovery.setEnabled(bl);
        this.cbUnlink.setEnabled(bl);
    }

    private void enableLobOptions(boolean bl) {
        this.cbLogging.setEnabled(bl);
        this.cbCompact.setEnabled(bl);
    }

    private boolean isLobColumn(Datatype datatype) {
        return datatype instanceof MDBlobUDB || datatype instanceof MDClobUDB || datatype instanceof MDDBClobUDB;
    }

    private void initUseIdentity() {
        this.chbUse = new JCheckBox(Messages.getString("ColumnPropertyDialogUDBv81.Use"));
        this.chbUse.addActionListener(new CheckBoxListener());
        this.columnIdentity.add(this.chbUse);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.chbUse, 7, 10);
    }

    private void initGenerate() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.Generate"));
        this.columnIdentity.add(jLabel);
        this.cbGenerate = new JComboBox<String>(ColumnProxyUDB.getGenerateValues());
        this.setBG(this.cbGenerate);
        this.cbGenerate.setPreferredSize(this.tfName.getPreferredSize());
        this.columnIdentity.add(this.cbGenerate);
        this.setLabelConstraints(this.getColumnIdentityLayout(), jLabel, 40);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.cbGenerate, 40);
    }

    private void initStartWith() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.StartWith"));
        this.columnIdentity.add(jLabel);
        this.tfStartWith = new JNumericField(31, 26);
        this.columnIdentity.add(this.tfStartWith);
        this.setLabelConstraints(this.getColumnIdentityLayout(), jLabel, 70);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.tfStartWith, 70);
    }

    private void initIncremetBy() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.IncrementBy"));
        this.columnIdentity.add(jLabel);
        this.ifIncrementBy = new JIntegerField(0, 26);
        this.columnIdentity.add(this.ifIncrementBy);
        this.setLabelConstraints(this.getColumnIdentityLayout(), jLabel, 100);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.ifIncrementBy, 100);
    }

    private void initMaxValue() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.MaxValue"));
        this.columnIdentity.add(jLabel);
        this.ifMaxValue = new JNumericField(31, 26);
        this.columnIdentity.add(this.ifMaxValue);
        this.setLabelConstraints(this.getColumnIdentityLayout(), jLabel, 130);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.ifMaxValue, 130);
    }

    private void initMinValue() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.MinValue"));
        this.columnIdentity.add(jLabel);
        this.ifMinValue = new JNumericField(31, 26);
        this.columnIdentity.add(this.ifMinValue);
        this.setLabelConstraints(this.getColumnIdentityLayout(), jLabel, 160);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.ifMinValue, 160);
    }

    private void initCycle() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.Cycle"));
        this.columnIdentity.add(jLabel);
        this.cbCycle = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCycle);
        this.cbCycle.setPreferredSize(this.tfName.getPreferredSize());
        this.columnIdentity.add(this.cbCycle);
        this.setLabelConstraints(this.getColumnIdentityLayout(), jLabel, 190);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.cbCycle, 190);
    }

    private void initCache() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.Cache"));
        this.columnIdentity.add(jLabel);
        this.tfCache = new JTextField(26);
        this.columnIdentity.add(this.tfCache);
        this.setLabelConstraints(this.getColumnIdentityLayout(), jLabel, 220);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.tfCache, 220);
    }

    private void initOrder() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.Order"));
        this.columnIdentity.add(jLabel);
        this.cbOrder = new JComboBox<String>(YES_NO);
        this.setBG(this.cbOrder);
        this.cbOrder.setPreferredSize(this.tfName.getPreferredSize());
        this.columnIdentity.add(this.cbOrder);
        this.setLabelConstraints(this.getColumnIdentityLayout(), jLabel, 250);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.cbOrder, 250);
    }

    private void initGenerationExpression() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.GenerationExpr"));
        this.columnIdentity.add(jLabel);
        this.tfGenerationExpression = new JTextField(26);
        this.columnIdentity.add(this.tfGenerationExpression);
        this.setLabelConstraints(this.getColumnIdentityLayout(), jLabel, 280);
        this.setObjectConstraints(this.getColumnIdentityLayout(), this.tfGenerationExpression, 280);
    }

    private void setIdentityUse(boolean bl) {
        this.cbGenerate.setEnabled(bl);
        this.tfStartWith.setEditable(bl);
        this.ifIncrementBy.setEditable(bl);
        this.tfCache.setEditable(bl);
        this.ifMaxValue.setEditable(bl);
        this.ifMinValue.setEditable(bl);
        this.cbCycle.setEnabled(bl);
        this.cbOrder.setEnabled(bl);
        this.tfGenerationExpression.setEditable(bl);
    }

    private void initForBitData() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogUDBv81.ForBitData"));
        this.general.add(jLabel);
        this.cbForBitData = new JComboBox<String>(YES_NO);
        this.setBG(this.cbForBitData);
        this.cbForBitData.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbForBitData);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbForBitData, 230);
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnPropertyDialogUDBv81.this.setIdentityUse(ColumnPropertyDialogUDBv81.this.chbUse.isSelected());
        }
    }

    private class WritePermissionListener
    implements ActionListener {
        private WritePermissionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ColumnPropertyDialogUDBv81.this.cbWritePermission.isEnabled()) {
                if (((String)ColumnPropertyDialogUDBv81.this.cbWritePermission.getSelectedItem()).equalsIgnoreCase("FS")) {
                    ColumnPropertyDialogUDBv81.this.cbUnlink.setEnabled(false);
                } else {
                    ColumnPropertyDialogUDBv81.this.cbUnlink.setEnabled(true);
                }
            }
        }
    }
}

