/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb.v81;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.BufferPoolUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.BufferPoolUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.DBPartitionGroupUDBv81;
import oracle.dbtools.crest.model.design.storage.udb.v81.TableSpaceUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.swingui.editor.storage.udb.v81.TableSpacePropertyDialogUDBv81;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class BufferPoolPropertyDialogUDBv81
extends AbstractUDBPropertyDialog {
    private BufferPoolUDBv81 bufferPool;
    private JIntegerField ifSize;
    private JTextField tfDBPartitionsWithDiffSize;
    private JComboBox cbCreateImmediate;
    private JComboBox cbPageSize;
    private JComboBox cbExtendedStorage;
    private JPanel scope;
    private DefaultListModel allDBPartitionsModel;
    private DefaultListModel selectedDBPartitionsModel;
    private JList allDBPartitionsList;
    private JList selectedDBPartitionsList;
    private JButton bnAdd;
    private JButton bnRemove;
    private JPanel tableSpaces;
    private DefaultListModel tsListModel;
    private JList tsList;

    public BufferPoolPropertyDialogUDBv81(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.bufferPool = (BufferPoolUDBv81)storageObject;
        this.setHeight(230);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("BufferPoolPropertyDialogUDBv81.BufferPoolProperties");
    }

    @Override
    public void initProperties() {
        this.initCaption(this.bufferPool.getName());
        this.tfName.setText(this.bufferPool.getName());
        this.cbCreateImmediate.setSelectedItem(BufferPoolPropertyDialogUDBv81.translateYesNoForDisplay(this.bufferPool.getCreateImmediate()));
        this.ifSize.setValue((long)this.bufferPool.getSize());
        this.tfDBPartitionsWithDiffSize.setText(this.bufferPool.getNodesWithDiffSize());
        this.cbPageSize.setSelectedItem(new Integer(this.bufferPool.getPageSize()));
        if (this.bufferPool.getExtendedStorage()) {
            this.cbExtendedStorage.setSelectedItem(YES);
        } else {
            this.cbExtendedStorage.setSelectedItem(NO);
        }
        Object[] objectArray = this.getStorageDesign().getNodeGroupSet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            DBPartitionGroupUDBv81 dBPartitionGroupUDBv81 = (DBPartitionGroupUDBv81)objectArray[i];
            if (this.bufferPool.getScopeSet().contains(dBPartitionGroupUDBv81.getName())) {
                this.selectedDBPartitionsModel.addElement(dBPartitionGroupUDBv81);
                continue;
            }
            this.allDBPartitionsModel.addElement(dBPartitionGroupUDBv81);
        }
        Object[] objectArray2 = this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < objectArray2.length; ++i) {
            if (((TableSpaceUDBv81)objectArray2[i]).getBufferPool() != this.bufferPool) continue;
            this.tsListModel.addElement(objectArray2[i]);
        }
        this.getCommentsList().insert(this.bufferPool.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.bufferPool != null) {
            this.bufferPool.setCreateImmediate(BufferPoolPropertyDialogUDBv81.translateYesNoForStorage((String)this.cbCreateImmediate.getSelectedItem()));
            this.bufferPool.setSize(this.ifSize.getIntValue());
            this.bufferPool.setNodesWithDiffSize(this.tfDBPartitionsWithDiffSize.getText());
            Object object = this.cbPageSize.getSelectedItem();
            if (object instanceof Integer) {
                this.bufferPool.setPageSize((Integer)object);
            }
            object = this.cbExtendedStorage.getSelectedItem();
            boolean bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.bufferPool.setExtendedStorage(bl);
            Object[] objectArray = this.selectedDBPartitionsModel.toArray();
            this.bufferPool.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = objectArray[i];
                if (!(object2 instanceof DBPartitionGroupUDBv81)) continue;
                this.bufferPool.setScope(((DBPartitionGroupUDBv81)object2).getName());
            }
            this.bufferPool.setComment(this.getCommentsList().getText());
        }
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.tfName.setEditable(false);
        this.initCreateImmediate();
        this.initSize();
        this.initDBPartitionsWithDiffSize();
        this.initPageSize();
        this.initExtendedStorage();
    }

    private void initCreateImmediate() {
        JLabel jLabel = new JLabel(Messages.getString("BufferPoolPropertyDialogUDBv81.CreateImmediate"));
        this.general.add(jLabel);
        this.cbCreateImmediate = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCreateImmediate);
        this.cbCreateImmediate.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCreateImmediate);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbCreateImmediate, 50);
    }

    private void initSize() {
        JLabel jLabel = new JLabel(Messages.getString("BufferPoolPropertyDialogUDBv81.Size"));
        this.general.add(jLabel);
        this.ifSize = new JIntegerField(0, 26);
        this.general.add(this.ifSize);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.ifSize, 80);
    }

    private void initDBPartitionsWithDiffSize() {
        JLabel jLabel = new JLabel(Messages.getString("BufferPoolPropertyDialogUDBv81.DiffSizePartitions"));
        this.general.add(jLabel);
        this.tfDBPartitionsWithDiffSize = new JTextField("", 26);
        this.general.add(this.tfDBPartitionsWithDiffSize);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.tfDBPartitionsWithDiffSize, 110);
    }

    private void initPageSize() {
        JLabel jLabel = new JLabel(Messages.getString("BufferPoolPropertyDialogUDBv81.PageSize"));
        this.general.add(jLabel);
        this.cbPageSize = new JComboBox<Object>(BufferPoolUDB.getAvailablePageSizes());
        this.setBG(this.cbPageSize);
        this.cbPageSize.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPageSize);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbPageSize, 140);
    }

    private void initExtendedStorage() {
        JLabel jLabel = new JLabel(Messages.getString("BufferPoolPropertyDialogUDBv81.ExtendedStorage"));
        this.general.add(jLabel);
        this.cbExtendedStorage = new JComboBox<String>(YES_NO);
        this.setBG(this.cbExtendedStorage);
        this.cbExtendedStorage.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbExtendedStorage);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbExtendedStorage, 170);
    }

    @Override
    protected void addTabs() {
        this.initScopeView();
        this.initTableSpacesView();
    }

    private void initScopeView() {
        this.scope = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("BufferPoolPropertyDialogUDBv81.Scope"), this.scope);
        this.initScope();
    }

    private void initScope() {
        this.initAllVolumesList();
        this.initSelectedVolumesList();
        this.initButtons();
    }

    protected SpringLayout getScopeLayout() {
        return (SpringLayout)this.scope.getLayout();
    }

    private void initAllVolumesList() {
        JLabel jLabel = new JLabel(Messages.getString("BufferPoolPropertyDialogUDBv81.AllDBPartitions"));
        this.scope.add(jLabel);
        this.allDBPartitionsModel = new DefaultListModel();
        this.allDBPartitionsList = new JList(this.allDBPartitionsModel);
        ListSelectionModel listSelectionModel = this.allDBPartitionsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allDBPartitionsList);
        jScrollPane.setPreferredSize(new Dimension(144, 170));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.scope.add(jScrollPane);
        this.setLabelConstraints(this.getScopeLayout(), jLabel, 12, 4);
        this.setObjectConstraints(this.getScopeLayout(), jScrollPane, 10, 22);
    }

    private void initSelectedVolumesList() {
        JLabel jLabel = new JLabel(Messages.getString("BufferPoolPropertyDialogUDBv81.SelectedDBPartitions"));
        this.scope.add(jLabel);
        this.selectedDBPartitionsModel = new DefaultListModel();
        this.selectedDBPartitionsList = new JList(this.selectedDBPartitionsModel);
        ListSelectionModel listSelectionModel = this.selectedDBPartitionsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedDBPartitionsList);
        jScrollPane.setPreferredSize(new Dimension(145, 170));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.scope.add(jScrollPane);
        this.setLabelConstraints(this.getScopeLayout(), jLabel, 292, 4);
        this.setObjectConstraints(this.getScopeLayout(), jScrollPane, 290, 22);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("BufferPoolPropertyDialogUDBv81.Add"));
        this.bnAdd.addActionListener(new AddNodesActionListener());
        this.bnAdd.setEnabled(false);
        this.scope.add(this.bnAdd);
        this.setObjectConstraints(this.getScopeLayout(), this.bnAdd, 175, 80);
        this.bnRemove = new JButton(Messages.getString("BufferPoolPropertyDialogUDBv81.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveNodesActionListener());
        this.scope.add(this.bnRemove);
        this.setObjectConstraints(this.getScopeLayout(), this.bnRemove, 175, 110);
        BufferPoolPropertyDialogUDBv81.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    private void initTableSpacesView() {
        this.tableSpaces = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("BufferPoolPropertyDialogUDBv81.TableSpaces"), this.tableSpaces);
        this.initTableSpaces();
    }

    private void initTableSpaces() {
        this.tsListModel = new DefaultListModel();
        this.tsList = new JList(this.tsListModel);
        this.tsList.addMouseListener(new ListMouseListenerTS());
        JScrollPane jScrollPane = new JScrollPane(this.tsList);
        jScrollPane.setPreferredSize(new Dimension(395, 180));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.tableSpaces.add(jScrollPane);
        this.setObjectConstraints(this.getTSLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getTSLayout() {
        return (SpringLayout)this.tableSpaces.getLayout();
    }

    private class ListMouseListenerTS
    extends MouseAdapter {
        private ListMouseListenerTS() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TableSpaceUDBv81 tableSpaceUDBv81;
            if (mouseEvent.getClickCount() == 2 && (tableSpaceUDBv81 = (TableSpaceUDBv81)BufferPoolPropertyDialogUDBv81.this.tsList.getSelectedValue()) != null && !tableSpaceUDBv81.isDialogVisible()) {
                TableSpacePropertyDialogUDBv81 tableSpacePropertyDialogUDBv81 = new TableSpacePropertyDialogUDBv81(BufferPoolPropertyDialogUDBv81.this.bufferPool.getDesign().getAppView(), BufferPoolPropertyDialogUDBv81.this.getStorageDesign(), tableSpaceUDBv81);
                tableSpacePropertyDialogUDBv81.show();
            }
        }
    }

    private class RemoveNodesActionListener
    implements ActionListener {
        private RemoveNodesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!BufferPoolPropertyDialogUDBv81.this.selectedDBPartitionsModel.isEmpty()) {
                Object[] objectArray = BufferPoolPropertyDialogUDBv81.this.selectedDBPartitionsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (BufferPoolPropertyDialogUDBv81.this.allDBPartitionsModel.contains(object)) continue;
                    BufferPoolPropertyDialogUDBv81.this.allDBPartitionsModel.addElement(object);
                    BufferPoolPropertyDialogUDBv81.this.selectedDBPartitionsModel.removeElement(object);
                }
            }
        }
    }

    private class AddNodesActionListener
    implements ActionListener {
        private AddNodesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!BufferPoolPropertyDialogUDBv81.this.allDBPartitionsModel.isEmpty()) {
                Object[] objectArray = BufferPoolPropertyDialogUDBv81.this.allDBPartitionsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (BufferPoolPropertyDialogUDBv81.this.selectedDBPartitionsModel.contains(object)) continue;
                    BufferPoolPropertyDialogUDBv81.this.selectedDBPartitionsModel.addElement(object);
                    BufferPoolPropertyDialogUDBv81.this.allDBPartitionsModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (BufferPoolPropertyDialogUDBv81.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (BufferPoolPropertyDialogUDBv81.this.selectedDBPartitionsList.getSelectedIndex() == -1) {
                    BufferPoolPropertyDialogUDBv81.this.bnRemove.setEnabled(false);
                } else {
                    BufferPoolPropertyDialogUDBv81.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (BufferPoolPropertyDialogUDBv81.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (BufferPoolPropertyDialogUDBv81.this.allDBPartitionsList.getSelectedIndex() == -1) {
                    BufferPoolPropertyDialogUDBv81.this.bnAdd.setEnabled(false);
                } else {
                    BufferPoolPropertyDialogUDBv81.this.bnAdd.setEnabled(true);
                }
            }
        }
    }
}

