/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.PermissionsUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxySetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxySetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class UserAndGroupPermissionsDialogUDB
extends CustomDialog
implements AbstractEditorConstants {
    private static final long serialVersionUID = -5507810685639529816L;
    private static String EMPTY_VALUE = "";
    private static String CHECKED = "v";
    private static String CHECKED_WITH_GRANT_OPTION = "v->";
    protected static final String EDIT = Messages.getString("UserAndGroupPermissionsDialogUDB.Edit");
    private StorageObject storageObject;
    private TableProxySetUDB tablesSet;
    private TableViewProxySetUDB viewSet;
    private StorageDesignUDB storageDesign;
    private JButton bnCancel;
    private JTabbedPane tpane;
    private JPanel jpanel;
    private JPanel objectsPanel;
    private TableTable tablesTable;
    private ViewsTable viewsTable;
    private JDialog dialog;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UserAndGroupPermissionsDialogUDB.this.bnCancel.doClick();
        }
    };

    public UserAndGroupPermissionsDialogUDB(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView);
        this.storageDesign = (StorageDesignUDB)storageDesign;
        this.storageObject = storageObject;
        this.jpanel = new JPanel(new BorderLayout());
        this.jpanel.add((Component)this.getTabbedPane(), "Center");
        JPanel jPanel = new JPanel();
        if (this.isEditable()) {
            JButton jButton = new JButton(Messages.getString("UserAndGroupPermissionsDialogUDB.OK"));
            jButton.addActionListener(new OKAction());
            jButton.setCursor(Cursor.getPredefinedCursor(12));
            jButton.setMnemonic(79);
            jPanel.add(jButton);
            JButton jButton2 = new JButton(Messages.getString("UserAndGroupPermissionsDialogUDB.Apply"));
            jButton2.addActionListener(new ApplyAction());
            jButton2.setCursor(Cursor.getPredefinedCursor(12));
            jButton2.setMnemonic(65);
            jPanel.add(jButton2);
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        }
        this.bnCancel = new JButton(this.isEditable() ? Messages.getString("UserAndGroupPermissionsDialogUDB.Cancel") : Messages.getString("UserAndGroupPermissionsDialogUDB.Close"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        boolean bl = true;
        jPanel.add(this.bnCancel);
        this.jpanel.add((Component)jPanel, "South");
        this.addTabs();
        this.initProperties();
        this.add((Component)this.jpanel, "Center");
    }

    @Override
    protected boolean isEditable() {
        return !ApplicationView.IS_VIEWER && !ApplicationView.LOGICAL_MODEL_ONLY;
    }

    protected void addTabs() {
        this.initTables();
        this.initViews();
    }

    private JTabbedPane getTabbedPane() {
        if (this.tpane == null) {
            this.tpane = new JTabbedPane();
            this.tpane.setPreferredSize(new Dimension(820, 320));
            this.tpane.setTabPlacement(3);
        }
        return this.tpane;
    }

    private void initTables() {
        this.tablesSet = (TableProxySetUDB)this.storageDesign.getTableProxySet();
        this.tablesTable = new TableTable();
        JScrollPane jScrollPane = new JScrollPane(this.tablesTable);
        jScrollPane.setPreferredSize(new Dimension(800, 320));
        jScrollPane.setHorizontalScrollBar(new JScrollBar());
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.objectsPanel = new JPanel();
        this.objectsPanel.add(jScrollPane);
        this.getTabbedPane().addTab(Messages.getString("UserAndGroupPermissionsDialogUDB.Tables"), this.objectsPanel);
        this.tablesTable.updateUI();
        TablesModel tablesModel = (TablesModel)this.tablesTable.getModel();
        Iterator iterator = this.tablesSet.iterator();
        while (iterator.hasNext()) {
            TableProxyUDB tableProxyUDB = (TableProxyUDB)iterator.next();
            String[] stringArray = PermissionsUDB.getTablePrivilegesValues();
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(tableProxyUDB);
            for (int i = 0; i < stringArray.length; ++i) {
                JButton jButton = new JButton();
                vector.addElement(jButton);
            }
            Object[] objectArray = vector.toArray();
            tablesModel.addRow(objectArray);
        }
    }

    private void initViews() {
        this.viewSet = (TableViewProxySetUDB)this.storageDesign.getTableViewProxySet();
        this.viewsTable = new ViewsTable();
        this.viewsTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.viewsTable);
        jScrollPane.setPreferredSize(new Dimension(800, 320));
        jScrollPane.setHorizontalScrollBar(new JScrollBar());
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.objectsPanel = new JPanel();
        this.objectsPanel.add(jScrollPane);
        this.getTabbedPane().addTab(Messages.getString("UserAndGroupPermissionsDialogUDB.Views"), this.objectsPanel);
        this.viewsTable.updateUI();
        ViewsModel viewsModel = (ViewsModel)this.viewsTable.getModel();
        Iterator iterator = this.viewSet.iterator();
        while (iterator.hasNext()) {
            TableViewProxyUDB tableViewProxyUDB = (TableViewProxyUDB)iterator.next();
            String[] stringArray = PermissionsUDB.getViewPrivilegesValues();
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(tableViewProxyUDB);
            for (int i = 0; i < stringArray.length; ++i) {
                JButton jButton = new JButton();
                vector.addElement(jButton);
            }
            Object[] objectArray = vector.toArray();
            viewsModel.addRow(objectArray);
        }
    }

    private boolean hasSelectedTablePrivileges(int n) {
        for (int i = 1; i < this.tablesTable.getColumnCount(); ++i) {
            if (!(this.tablesTable.getValueAt(n, i) instanceof JButton)) continue;
            JButton jButton = (JButton)this.tablesTable.getValueAt(n, i);
            if (jButton.getText().equals(CHECKED)) {
                return true;
            }
            if (!jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSelectedViewPrivileges(int n) {
        for (int i = 1; i < this.viewsTable.getColumnCount(); ++i) {
            if (!(this.viewsTable.getValueAt(n, i) instanceof JButton)) continue;
            JButton jButton = (JButton)this.viewsTable.getValueAt(n, i);
            if (jButton.getText().equals(CHECKED)) {
                return true;
            }
            if (!jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
            return true;
        }
        return false;
    }

    public String getCaption() {
        return Messages.getString("UserAndGroupPermissionsDialogUDB.Permissions");
    }

    private PermissionsUDB getPermission(StorageObject storageObject, StorageObject storageObject2) {
        Iterator iterator = this.storageDesign.getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsUDB permissionsUDB = (PermissionsUDB)iterator.next();
            if (permissionsUDB.getUser() != storageObject && permissionsUDB.getGroup() != storageObject || permissionsUDB.getTable() != storageObject2 && permissionsUDB.getView() != storageObject2) continue;
            return permissionsUDB;
        }
        return null;
    }

    public void initProperties() {
        int n;
        PermissionsUDB permissionsUDB;
        RelationalObjectProxy relationalObjectProxy;
        int n2;
        for (n2 = 0; n2 < this.tablesTable.getRowCount(); ++n2) {
            relationalObjectProxy = (TableProxyUDB)this.tablesTable.getValueAt(n2, 0);
            permissionsUDB = this.getPermission(this.storageObject, relationalObjectProxy);
            for (n = 0; n < this.tablesTable.getColumnCount(); ++n) {
                if (!(this.tablesTable.getValueAt(n2, n) instanceof JButton)) continue;
                JButton jButton = (JButton)this.tablesTable.getValueAt(n2, n);
                if (permissionsUDB != null) {
                    if (permissionsUDB.getPrivileges().indexOf(this.tablesTable.getColumnName(n)) > -1) {
                        jButton.setText(CHECKED);
                        jButton.updateUI();
                        continue;
                    }
                    if (permissionsUDB.getPrivilegesWithGrantOption().indexOf(this.tablesTable.getColumnName(n)) > -1) {
                        jButton.setText(CHECKED_WITH_GRANT_OPTION);
                        jButton.updateUI();
                        continue;
                    }
                    jButton.setText(EMPTY_VALUE);
                    jButton.updateUI();
                    continue;
                }
                jButton.setText(EMPTY_VALUE);
                jButton.updateUI();
            }
        }
        for (n2 = 0; n2 < this.viewsTable.getRowCount(); ++n2) {
            relationalObjectProxy = (TableViewProxyUDB)this.viewsTable.getValueAt(n2, 0);
            permissionsUDB = this.getPermission(this.storageObject, relationalObjectProxy);
            for (n = 0; n < this.viewsTable.getColumnCount(); ++n) {
                if (!(this.viewsTable.getValueAt(n2, n) instanceof JButton)) continue;
                JButton jButton = (JButton)this.viewsTable.getValueAt(n2, n);
                if (permissionsUDB != null) {
                    if (permissionsUDB.getPrivileges().indexOf(this.viewsTable.getColumnName(n)) > -1) {
                        jButton.setText(CHECKED);
                        jButton.updateUI();
                        continue;
                    }
                    if (permissionsUDB.getPrivilegesWithGrantOption().indexOf(this.viewsTable.getColumnName(n)) > -1) {
                        jButton.setText(CHECKED_WITH_GRANT_OPTION);
                        jButton.updateUI();
                        continue;
                    }
                    jButton.setText(EMPTY_VALUE);
                    jButton.updateUI();
                    continue;
                }
                jButton.setText(EMPTY_VALUE);
                jButton.updateUI();
            }
        }
    }

    protected void setProperties() {
        JButton jButton;
        int n;
        PermissionsUDB permissionsUDB;
        RelationalObjectProxy relationalObjectProxy;
        int n2;
        for (n2 = 0; n2 < this.tablesTable.getRowCount(); ++n2) {
            relationalObjectProxy = (TableProxyUDB)this.tablesTable.getValueAt(n2, 0);
            permissionsUDB = this.getPermission(this.storageObject, relationalObjectProxy);
            if (this.hasSelectedTablePrivileges(n2)) {
                if (permissionsUDB == null) {
                    permissionsUDB = this.storageDesign.getPermissionsSet().createPermissions();
                    permissionsUDB.setTable((TableProxyUDB)relationalObjectProxy);
                    if (this.storageObject instanceof OwnerUDB) {
                        permissionsUDB.setUser((OwnerUDB)this.storageObject);
                    } else if (this.storageObject instanceof UserGroupUDB) {
                        permissionsUDB.setGroup((UserGroupUDB)this.storageObject);
                    }
                }
                permissionsUDB.clear();
                for (n = 0; n < this.tablesTable.getColumnCount(); ++n) {
                    if (!(this.tablesTable.getValueAt(n2, n) instanceof JButton)) continue;
                    jButton = (JButton)this.tablesTable.getValueAt(n2, n);
                    if (jButton.getText().equals(CHECKED)) {
                        permissionsUDB.setPrivileges(this.tablesTable.getColumnName(n));
                        continue;
                    }
                    if (!jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
                    permissionsUDB.setPrivilegesWithGrantOption(this.tablesTable.getColumnName(n));
                }
                continue;
            }
            if (permissionsUDB == null) continue;
            this.storageDesign.getPermissionsSet().remove(permissionsUDB);
        }
        for (n2 = 0; n2 < this.viewsTable.getRowCount(); ++n2) {
            relationalObjectProxy = (TableViewProxyUDB)this.viewsTable.getValueAt(n2, 0);
            permissionsUDB = this.getPermission(this.storageObject, relationalObjectProxy);
            if (this.hasSelectedViewPrivileges(n2)) {
                if (permissionsUDB == null) {
                    permissionsUDB = this.storageDesign.getPermissionsSet().createPermissions();
                    permissionsUDB.setView((TableViewProxyUDB)relationalObjectProxy);
                    if (this.storageObject instanceof OwnerUDB) {
                        permissionsUDB.setUser((OwnerUDB)this.storageObject);
                    } else if (this.storageObject instanceof UserGroupUDB) {
                        permissionsUDB.setGroup((UserGroupUDB)this.storageObject);
                    }
                }
                permissionsUDB.clear();
                for (n = 0; n < this.viewsTable.getColumnCount(); ++n) {
                    if (!(this.viewsTable.getValueAt(n2, n) instanceof JButton)) continue;
                    jButton = (JButton)this.viewsTable.getValueAt(n2, n);
                    if (jButton.getText().equals(CHECKED)) {
                        permissionsUDB.setPrivileges(this.viewsTable.getColumnName(n));
                        continue;
                    }
                    if (!jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
                    permissionsUDB.setPrivilegesWithGrantOption(this.viewsTable.getColumnName(n));
                }
                continue;
            }
            if (permissionsUDB == null) continue;
            this.storageDesign.getPermissionsSet().remove(permissionsUDB);
        }
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("UserAndGroupPermissionsDialogUDB.Permissions"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    class ButtonTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton button;

        ButtonTableCellEditor() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                JButton jButton = (JButton)actionEvent.getSource();
                if (jButton.getText() == null) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(CHECKED)) {
                    jButton.setText(CHECKED_WITH_GRANT_OPTION);
                } else if (jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(EMPTY_VALUE)) {
                    jButton.setText(CHECKED);
                }
            } else {
                this.button.setText(this.button.getText().toString());
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.button = (JButton)object;
            this.button.setOpaque(true);
            this.button.setBackground(jTable.getBackground());
            this.button.setActionCommand(EDIT);
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
            return this.button;
        }
    }

    class ButtonTableCellRenderer
    extends JButton
    implements TableCellRenderer {
        ButtonTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setBackground(jTable.getBackground());
            this.setText(object == null ? "" : "  " + ((JButton)object).getText());
            return this;
        }
    }

    class LabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setBackground(jTable.getBackground());
            this.setHorizontalAlignment(2);
            this.setText(object == null ? "" : "  " + object.toString());
            return this;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UserAndGroupPermissionsDialogUDB.this.close();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UserAndGroupPermissionsDialogUDB.this.setProperties();
            UserAndGroupPermissionsDialogUDB.this.storageObject.setDirty(true);
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UserAndGroupPermissionsDialogUDB.this.setProperties();
            UserAndGroupPermissionsDialogUDB.this.storageObject.setDirty(true);
            UserAndGroupPermissionsDialogUDB.this.close();
        }
    }

    public class ViewsModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return PermissionsUDB.getViewPrivilegesValues().length + 1;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int n) {
            String[] stringArray = PermissionsUDB.getViewPrivilegesValues();
            if (n == 0) {
                return Messages.getString("UserAndGroupPermissionsDialogUDB.View");
            }
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (n != i) continue;
                return stringArray[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!UserAndGroupPermissionsDialogUDB.this.isEditable()) {
                return false;
            }
            return n2 > 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }

    class ViewsTable
    extends JTable {
        ViewsModel dataModel;

        public ViewsTable() {
            this.dataModel = new ViewsModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 0) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                return super.getCellEditor();
            }
            return new ButtonTableCellEditor();
        }
    }

    class TableTable
    extends JTable {
        TablesModel dataModel;

        public TableTable() {
            this.dataModel = new TablesModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 0) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                return super.getCellEditor();
            }
            return new ButtonTableCellEditor();
        }
    }

    public class TablesModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return PermissionsUDB.getTablePrivilegesValues().length + 1;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int n) {
            String[] stringArray = PermissionsUDB.getTablePrivilegesValues();
            if (n == 0) {
                return Messages.getString("UserAndGroupPermissionsDialogUDB.Table");
            }
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (n != i) continue;
                return stringArray[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!UserAndGroupPermissionsDialogUDB.this.isEditable()) {
                return false;
            }
            return n2 > 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }
}

