/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.datatypes.DataTypeObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TempDataTypeObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxyUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.datatypes.SelectDataTypeDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class StructuredTypePropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private static final String[] INVALID_DATATYPES = new String[]{"LONG VARCHAR", "LONG VARGRAPHIC", "BLOB", "CLOB", "DBCLOB", "DATALINK"};
    private StructuredTypeProxyUDB structuredType;
    private JComboBox cbScheme;
    private JTextField tfOwner;
    private JTextField tfSuperType;
    private JTextField tfFinal;
    private JTextField tfInstantiable;
    private JButton bnDataType;
    private SelectDataTypeDialog datatypeDialog = null;
    private TempDataTypeObject tempDTO;
    private JTextField tfRef2RefType;
    private JTextField tfRefType2Ref;
    private JTextField tfInlineLength;
    private JComboBox cbWithFunctionAccess;

    public StructuredTypePropertyDialogUDB(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.structuredType = (StructuredTypeProxyUDB)storageObject;
        this.setHeight(400);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
        this.tempDTO = new TempDataTypeObject(this.structuredType.getDesign());
        this.structuredType.copyDataType(this.tempDTO);
    }

    @Override
    public String getCaption() {
        return Messages.getString("StructuredTypePropertyDialogUDB.StructuredTypeProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.setObjectConstraints(this.tfName, 20);
        this.initScheme();
        this.initOwner();
        this.initSuperType();
        this.initFinal();
        this.initInstantiable();
        this.initUsingType();
        this.initRef2RefType();
        this.initRefType2Ref();
        this.initInlineLength();
        this.initWithFunctionAccess();
    }

    private void initScheme() {
        JLabel jLabel = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.Scheme"));
        this.general.add(jLabel);
        this.cbScheme = new JComboBox();
        this.setBG(this.cbScheme);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSchemaSet().toArray(), this.cbScheme);
        }
        this.cbScheme.addActionListener(new SchemeListener());
        this.cbScheme.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbScheme);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbScheme, 50);
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.Owner"));
        this.general.add(jLabel);
        this.tfOwner = new JTextField("", 26);
        this.setBG(this.tfOwner);
        this.tfOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.tfOwner.setEditable(false);
        this.tfOwner.setEnabled(false);
        this.general.add(this.tfOwner);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfOwner, 80);
    }

    private void initSuperType() {
        JLabel jLabel = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.SuperType"));
        this.general.add(jLabel);
        this.tfSuperType = new JTextField("", 26);
        this.tfSuperType.setEditable(false);
        this.general.add(this.tfSuperType);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.tfSuperType, 110);
    }

    private void initFinal() {
        JLabel jLabel = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.Final"));
        this.general.add(jLabel);
        this.tfFinal = new JTextField("", 26);
        this.tfFinal.setEditable(false);
        this.general.add(this.tfFinal);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.tfFinal, 140);
    }

    private void initInstantiable() {
        JLabel jLabel = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.Instantiable"));
        this.general.add(jLabel);
        this.tfInstantiable = new JTextField("", 26);
        this.tfInstantiable.setEditable(false);
        this.general.add(this.tfInstantiable);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.tfInstantiable, 170);
    }

    private void initUsingType() {
        JLabel jLabel = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.RefUsingType"));
        this.general.add(jLabel);
        this.bnDataType = new JButton();
        this.bnDataType.setFont(new Font(this.bnDataType.getFont().getName(), 0, this.bnDataType.getFont().getSize()));
        this.bnDataType.setHorizontalAlignment(0);
        this.bnDataType.setPreferredSize(this.tfName.getPreferredSize());
        this.bnDataType.setEnabled(this.isEditable());
        this.bnDataType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TempDataTypeObject tempDataTypeObject = new TempDataTypeObject(StructuredTypePropertyDialogUDB.this.structuredType.getDesign());
                StructuredTypePropertyDialogUDB.this.tempDTO.copyDataType(tempDataTypeObject);
                StructuredTypePropertyDialogUDB.this.datatypeDialog = new SelectDataTypeDialog(StructuredTypePropertyDialogUDB.this.getAppView(), tempDataTypeObject, StructuredTypePropertyDialogUDB.this.bnDataType);
                StructuredTypePropertyDialogUDB.this.datatypeDialog.initProperties(false);
                int n = StructuredTypePropertyDialogUDB.this.datatypeDialog.showDialog();
                if (n == 1 && StructuredTypePropertyDialogUDB.this.checkDatatype(tempDataTypeObject)) {
                    tempDataTypeObject.copyDataType(StructuredTypePropertyDialogUDB.this.tempDTO);
                } else {
                    StructuredTypePropertyDialogUDB.this.bnDataType.setText(StructuredTypePropertyDialogUDB.this.tempDTO.getDataType());
                }
            }
        });
        this.general.add(this.bnDataType);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.bnDataType, 200);
    }

    private void initRef2RefType() {
        JLabel jLabel = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.RefToRefTypeCastFunction"));
        this.general.add(jLabel);
        this.tfRef2RefType = new JTextField("", 26);
        this.general.add(this.tfRef2RefType);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.tfRef2RefType, 230);
    }

    private void initRefType2Ref() {
        JLabel jLabel = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.RefTypeToRefTypeCastFunction"));
        this.general.add(jLabel);
        this.tfRefType2Ref = new JTextField("", 26);
        this.general.add(this.tfRefType2Ref);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.tfRefType2Ref, 260);
    }

    private void initInlineLength() {
        JLabel jLabel = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.InlineLength"));
        this.general.add(jLabel);
        this.tfInlineLength = new JTextField("", 26);
        this.general.add(this.tfInlineLength);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.tfInlineLength, 290);
    }

    private void initWithFunctionAccess() {
        JLabel jLabel = new JLabel(Messages.getString("StructuredTypePropertyDialogUDB.WithFunctionAccess"));
        this.general.add(jLabel);
        this.cbWithFunctionAccess = new JComboBox<String>(StructuredTypeProxyUDB.YES_NO);
        this.setBG(this.cbWithFunctionAccess);
        this.cbWithFunctionAccess.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbWithFunctionAccess);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.cbWithFunctionAccess, 320);
    }

    private boolean checkDatatype(DataTypeObject dataTypeObject) {
        if (dataTypeObject.getType() instanceof StructuredType) {
            JOptionPane.showMessageDialog(this, Messages.getString("StructuredTypePropertyDialogUDB.PropertyCantBeStructuredType"), Messages.getString("StructuredTypePropertyDialogUDB.Error"), 0);
            return false;
        }
        String string = dataTypeObject.getDataType();
        if (string.indexOf(40) > -1) {
            string = string.substring(0, string.indexOf(40)).trim();
        }
        for (int i = 0; i < INVALID_DATATYPES.length; ++i) {
            if (!string.equalsIgnoreCase(INVALID_DATATYPES[i])) continue;
            JOptionPane.showMessageDialog(this, MessageFormat.format(Messages.getString("StructuredTypePropertyDialogUDB.PropertyCantBeDatatype"), INVALID_DATATYPES[i]), Messages.getString("StructuredTypePropertyDialogUDB.Error"), 0);
            return false;
        }
        return true;
    }

    @Override
    public void initProperties() {
        StructuredType structuredType = (StructuredType)this.structuredType.getObject();
        this.initCaption(this.structuredType.getName());
        this.tfName.setText(this.structuredType.getName());
        this.cbScheme.setSelectedItem(this.structuredType.getSchema());
        this.tfSuperType.setText(this.structuredType.hasParentType() ? this.structuredType.getParentType().getName() : Messages.getString("StructuredTypePropertyDialogUDB.NONE"));
        this.tfFinal.setText(structuredType.isFinal() ? "YES" : "NO");
        this.tfInstantiable.setText(structuredType.isInstantiable() ? "YES" : "NO");
        this.bnDataType.setText(this.structuredType.getDataType());
        this.bnDataType.setEnabled(this.isEditable() && structuredType.getParentType() == null);
        this.tfRef2RefType.setText(this.structuredType.getRef2RefTypeCastFunction());
        this.tfRefType2Ref.setText(this.structuredType.getRefType2RefCastFunction());
        this.tfInlineLength.setText(this.structuredType.getInlineLength());
        this.cbWithFunctionAccess.setSelectedItem(this.structuredType.getWithFunctionAccess());
        this.getCommentsList().insert(this.structuredType.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.structuredType != null) {
            this.structuredType.setName(this.tfName.getText());
            this.tempDTO.copyDataType(this.structuredType);
            Object object = this.cbScheme.getSelectedItem();
            if (object instanceof SchemaUDB) {
                this.structuredType.setSchema((SchemaUDB)object);
            } else {
                this.structuredType.setSchema(null);
                this.structuredType.setOwner(null);
            }
            this.structuredType.setRef2RefTypeCastFunction(this.tfRef2RefType.getText());
            this.structuredType.setRefType2RefCastFunction(this.tfRefType2Ref.getText());
            this.structuredType.setInlineLength(this.tfInlineLength.getText());
            this.structuredType.setWithFunctionAccess((String)this.cbWithFunctionAccess.getSelectedItem());
            this.structuredType.setComment(this.getCommentsList().getText());
        }
    }

    private class SchemeListener
    implements ActionListener {
        private SchemeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SchemaUDB schemaUDB = (SchemaUDB)StructuredTypePropertyDialogUDB.this.cbScheme.getSelectedItem();
            try {
                if (schemaUDB != null) {
                    StructuredTypePropertyDialogUDB.this.tfOwner.setText(schemaUDB.getOwner().toString());
                }
            }
            catch (NullPointerException nullPointerException) {
                StructuredTypePropertyDialogUDB.this.tfOwner.setText("");
            }
        }
    }
}

