/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StoredProcedureUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class StoredProcedurePropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private StoredProcedureUDB proc;
    private JTextField tfOwner;
    private JTextArea bodyArea;
    private JComboBox cbScheme;
    private JTextField tfSpecificName;

    public StoredProcedurePropertyDialogUDB(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.proc = (StoredProcedureUDB)storageObject;
        this.setHeight(350);
        this.initCommentsView(105);
        this.initCommentsInRDBMS(105);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("StoredProcedurePropertyDialogUDB.StoredProcedureProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initSpecificName();
        this.initScheme();
        this.initOwner();
        this.initBody();
    }

    private void initSpecificName() {
        JLabel jLabel = new JLabel(Messages.getString("StoredProcedurePropertyDialogUDB.SpecificName"));
        this.general.add(jLabel);
        this.tfSpecificName = new JTextField("", 26);
        this.general.add(this.tfSpecificName);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfSpecificName, 50);
    }

    private void initScheme() {
        JLabel jLabel = new JLabel(Messages.getString("StoredProcedurePropertyDialogUDB.Scheme"));
        this.general.add(jLabel);
        this.cbScheme = new JComboBox();
        this.setBG(this.cbScheme);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSchemaSet().toArray(), this.cbScheme);
        }
        this.cbScheme.addActionListener(new SchemeListener());
        this.cbScheme.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbScheme);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbScheme, 80);
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("StoredProcedurePropertyDialogUDB.Owner"));
        this.general.add(jLabel);
        this.tfOwner = new JTextField("", 26);
        this.setBG(this.tfOwner);
        this.tfOwner.setEditable(false);
        this.tfOwner.setEnabled(false);
        this.tfOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfOwner);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.tfOwner, 110);
    }

    private void initBody() {
        JLabel jLabel = new JLabel(Messages.getString("StoredProcedurePropertyDialogUDB.Body"));
        this.general.add(jLabel);
        this.setLabelConstraints(jLabel, 140);
        this.bodyArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.bodyArea);
        jScrollPane.setPreferredSize(new Dimension(395, 160));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.bodyArea.setLineWrap(true);
        this.general.add(jScrollPane);
        this.setObjectConstraints(jScrollPane, 10, 160);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.proc.getName());
        this.tfName.setText(this.proc.getName());
        this.tfSpecificName.setText(this.proc.getSpecificName());
        this.cbScheme.setSelectedItem(this.proc.getSchema());
        this.bodyArea.setText(this.proc.getBody());
        this.getCommentsList().insert(this.proc.getComment(), 0);
        this.getCommentsInRDBMSList().insert(this.proc.getCommentInRDBMS(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.proc != null) {
            Object object = this.cbScheme.getSelectedItem();
            if (object instanceof SchemaUDB) {
                this.proc.setOwner(((SchemaUDB)object).getOwner());
                this.proc.setSchema((SchemaUDB)object);
            } else {
                this.proc.setOwner(null);
                this.proc.setSchema(null);
            }
            this.proc.setName(this.tfName.getText());
            this.proc.setSpecificName(this.tfSpecificName.getText());
            this.proc.setBody(this.bodyArea.getText());
            this.proc.setComment(this.getCommentsList().getText());
            this.proc.setCommentInRDBMS(this.getCommentsInRDBMSList().getText());
        }
    }

    @Override
    protected boolean allowName(String string) {
        Object object = this.cbScheme.getSelectedItem();
        if (object instanceof SchemaUDB) {
            string = ((SchemaUDB)object).getName() + '.' + string;
        }
        return this.getStorageObject().allowName(string, true);
    }

    private class SchemeListener
    implements ActionListener {
        private SchemeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SchemaUDB schemaUDB = (SchemaUDB)StoredProcedurePropertyDialogUDB.this.cbScheme.getSelectedItem();
            try {
                if (schemaUDB != null) {
                    StoredProcedurePropertyDialogUDB.this.tfOwner.setText(schemaUDB.getOwner().toString());
                } else {
                    StoredProcedurePropertyDialogUDB.this.tfOwner.setText("");
                }
            }
            catch (NullPointerException nullPointerException) {
                StoredProcedurePropertyDialogUDB.this.tfOwner.setText("");
            }
        }
    }
}

