/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.IndexProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.PrivilegesUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.IndexPropertyDialogUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.swingui.editor.storage.udb.TablePropertyDialogUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.TableViewPropertyDialogUDB;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SchemaPropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private SchemaUDB schema;
    private JComboBox cbOwner;
    private JComboBox cbSchemaObject;
    private JPanel tables;
    private DefaultListModel tableListModel;
    private JList tableList;
    private JPanel views;
    private DefaultListModel viewListModel;
    private JList viewList;
    private JPanel indexes;
    private DefaultListModel indexListModel;
    private JList indexList;
    private JPanel privs;
    private JComboBox cbUser;
    private JComboBox cbGrantOption;
    private DefaultListModel allPrivsModel;
    private DefaultListModel selectedPrivsModel;
    private JList allPrivsList;
    private JList selectedPrivsList;
    private JButton bnPrivsAdd;
    private JButton bnPrivsRemove;

    public SchemaPropertyDialogUDB(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.schema = (SchemaUDB)storageObject;
        this.setHeight(210);
        this.initCommentsView(70);
        this.initCommentsInRDBMS(70);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("SchemaPropertyDialogUDB.SchemaProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initSchemaObject();
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("SchemaPropertyDialogUDB.Owner"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getOwnerSet().toArray(), this.cbOwner);
        }
        this.cbOwner.removeItem(this.getStorageDesign().getOwnerSet().getByName("PUBLIC"));
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbOwner, 50);
    }

    private void initSchemaObject() {
        JLabel jLabel = new JLabel(Messages.getString("SchemaPropertyDialogUDB.ImplementsSchema"));
        this.general.add(jLabel);
        this.cbSchemaObject = new JComboBox();
        this.setBG(this.cbSchemaObject);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getPhysicalDesign().getSchemaObjectSet().toArray(), this.cbSchemaObject);
        }
        this.cbSchemaObject.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSchemaObject);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbSchemaObject, 80);
    }

    @Override
    protected void addTabs() {
        this.initPrivilegesView();
        this.initTablesView();
        this.initViewsView();
        this.initIndexesView();
    }

    private void initPrivilegesView() {
        this.privs = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SchemaPropertyDialogUDB.Privileges"), this.privs);
        this.initPrivileges();
    }

    private void initPrivileges() {
        this.initUser();
        this.initGrantOption();
        this.initAllPrivsList();
        this.initSelectedPrivsList();
        this.initPrivsButtons();
    }

    protected SpringLayout getPrivsLayout() {
        return (SpringLayout)this.privs.getLayout();
    }

    private void initUser() {
        JLabel jLabel = new JLabel(Messages.getString("SchemaPropertyDialogUDB.User"));
        this.privs.add(jLabel);
        this.cbUser = new JComboBox();
        this.setBG(this.cbUser);
        this.cbUser.addActionListener(new UserListener());
        this.cbUser.setPreferredSize(this.tfName.getPreferredSize());
        this.privs.add(this.cbUser);
        this.setLabelConstraints(this.getPrivsLayout(), jLabel, 20);
        this.setObjectConstraints(this.getPrivsLayout(), this.cbUser, 20);
    }

    private void initGrantOption() {
        JLabel jLabel = new JLabel(Messages.getString("SchemaPropertyDialogUDB.GrantOption"));
        this.privs.add(jLabel);
        this.cbGrantOption = new JComboBox<String>(YES_NO);
        this.setBG(this.cbGrantOption);
        this.cbGrantOption.setPreferredSize(this.tfName.getPreferredSize());
        this.privs.add(this.cbGrantOption);
        this.setLabelConstraints(this.getPrivsLayout(), jLabel, 50);
        this.setObjectConstraints(this.getPrivsLayout(), this.cbGrantOption, 50);
    }

    private void initAllPrivsList() {
        JLabel jLabel = new JLabel(Messages.getString("SchemaPropertyDialogUDB.AllPrivileges"));
        this.privs.add(jLabel);
        this.allPrivsModel = new DefaultListModel();
        this.allPrivsList = new JList(this.allPrivsModel);
        ListSelectionModel listSelectionModel = this.allPrivsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allPrivsList);
        jScrollPane.setPreferredSize(new Dimension(144, 70));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.privs.add(jScrollPane);
        this.setLabelConstraints(this.getPrivsLayout(), jLabel, 12, 84);
        this.setObjectConstraints(this.getPrivsLayout(), jScrollPane, 10, 102);
    }

    private void initSelectedPrivsList() {
        JLabel jLabel = new JLabel(Messages.getString("SchemaPropertyDialogUDB.SelectedPrivileges"));
        this.privs.add(jLabel);
        this.selectedPrivsModel = new DefaultListModel();
        this.selectedPrivsList = new JList(this.selectedPrivsModel);
        ListSelectionModel listSelectionModel = this.selectedPrivsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedPrivsList);
        jScrollPane.setPreferredSize(new Dimension(145, 70));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.privs.add(jScrollPane);
        this.setLabelConstraints(this.getPrivsLayout(), jLabel, 292, 84);
        this.setObjectConstraints(this.getPrivsLayout(), jScrollPane, 290, 102);
    }

    private void initPrivsButtons() {
        this.bnPrivsAdd = new JButton(Messages.getString("SchemaPropertyDialogUDB.Add"));
        this.bnPrivsAdd.addActionListener(new AddPrivsActionListener());
        this.bnPrivsAdd.setEnabled(false);
        this.privs.add(this.bnPrivsAdd);
        this.setObjectConstraints(this.getPrivsLayout(), this.bnPrivsAdd, 175, 110);
        this.bnPrivsRemove = new JButton(Messages.getString("SchemaPropertyDialogUDB.Remove"));
        this.bnPrivsRemove.setEnabled(false);
        this.bnPrivsRemove.addActionListener(new RemovePrivsActionListener());
        this.privs.add(this.bnPrivsRemove);
        this.setObjectConstraints(this.getPrivsLayout(), this.bnPrivsRemove, 175, 140);
        SchemaPropertyDialogUDB.equalizeButtonSizes(this.bnPrivsAdd, this.bnPrivsRemove);
    }

    private void initTablesView() {
        this.tables = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SchemaPropertyDialogUDB.Tables"), this.tables);
        this.initTables();
    }

    private void initTables() {
        this.tableListModel = new DefaultListModel();
        this.tableList = new JList(this.tableListModel);
        this.tableList.addMouseListener(new TableListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.tableList);
        jScrollPane.setPreferredSize(new Dimension(395, 160));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.tables.add(jScrollPane);
        this.setObjectConstraints(this.getTableLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getTableLayout() {
        return (SpringLayout)this.tables.getLayout();
    }

    private void initViewsView() {
        this.views = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SchemaPropertyDialogUDB.Views"), this.views);
        this.initViews();
    }

    private void initViews() {
        this.viewListModel = new DefaultListModel();
        this.viewList = new JList(this.viewListModel);
        this.viewList.addMouseListener(new ViewListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.viewList);
        jScrollPane.setPreferredSize(new Dimension(395, 160));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.views.add(jScrollPane);
        this.setObjectConstraints(this.getViewLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getViewLayout() {
        return (SpringLayout)this.views.getLayout();
    }

    private void initIndexesView() {
        this.indexes = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SchemaPropertyDialogUDB.Indexes"), this.indexes);
        this.initIndexes();
    }

    private void initIndexes() {
        this.indexListModel = new DefaultListModel();
        this.indexList = new JList(this.indexListModel);
        this.indexList.addMouseListener(new IndexListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.indexList);
        jScrollPane.setPreferredSize(new Dimension(395, 160));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.indexes.add(jScrollPane);
        this.setObjectConstraints(this.getIndexLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getIndexLayout() {
        return (SpringLayout)this.indexes.getLayout();
    }

    private PrivilegesUDB getPrivileges(Object object) {
        PrivilegesUDB privilegesUDB;
        Iterator iterator = this.getStorageDesign().getPrivilegesSet().iterator();
        while (iterator.hasNext()) {
            privilegesUDB = (PrivilegesUDB)iterator.next();
            if (privilegesUDB.getUser() != object && privilegesUDB.getGroup() != object) continue;
            return privilegesUDB;
        }
        privilegesUDB = this.getStorageDesign().getPrivilegesSet().createPriv();
        privilegesUDB.setSchema(this.schema);
        if (object instanceof OwnerUDB) {
            privilegesUDB.setUser((OwnerUDB)object);
        } else if (object instanceof UserGroupUDB) {
            privilegesUDB.setGroup((UserGroupUDB)object);
        }
        return privilegesUDB;
    }

    @Override
    public void initProperties() {
        int n;
        this.initCaption(this.schema.getName());
        this.tfName.setText(this.schema.getName());
        this.cbOwner.setSelectedItem(this.schema.getOwner());
        for (n = 0; n < this.getStorageDesign().getOwnerSet().toArray().length; ++n) {
            this.cbUser.addItem(this.getStorageDesign().getOwnerSet().toArray()[n]);
        }
        for (n = 0; n < this.getStorageDesign().getUserGroupSet().toArray().length; ++n) {
            this.cbUser.addItem(this.getStorageDesign().getUserGroupSet().toArray()[n]);
        }
        PrivilegesUDB privilegesUDB = this.getPrivilegesForSchema(this.schema);
        if (privilegesUDB != null) {
            this.cbUser.setSelectedItem(this.getUserPriv(privilegesUDB));
        }
        this.getCommentsList().insert(this.schema.getComment(), 0);
        Object[] objectArray = this.getStorageDesign().getTableProxySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (((TableProxyUDB)objectArray[i]).getSchema() != this.schema) continue;
            this.tableListModel.addElement(objectArray[i]);
        }
        Object[] objectArray2 = this.getStorageDesign().getTableViewProxySet().toArray();
        for (int i = 0; i < objectArray2.length; ++i) {
            if (((TableViewProxyUDB)objectArray2[i]).getSchema() != this.schema) continue;
            this.viewListModel.addElement(objectArray2[i]);
        }
        Object[] objectArray3 = this.getStorageDesign().getIndexProxySet().toArray();
        for (int i = 0; i < objectArray3.length; ++i) {
            if (((IndexProxyUDB)objectArray3[i]).getSchema() != this.schema) continue;
            this.indexListModel.addElement(objectArray3[i]);
        }
        this.cbSchemaObject.setSelectedItem(this.schema.getSchemaObject());
        this.getCommentsList().insert(this.schema.getComment(), 0);
        this.getCommentsInRDBMSList().insert(this.schema.getCommentInRDBMS(), 0);
    }

    private Object getUserPriv(PrivilegesUDB privilegesUDB) {
        if (privilegesUDB.getUser() != null) {
            return privilegesUDB.getUser();
        }
        if (privilegesUDB.getGroup() != null) {
            return privilegesUDB.getGroup();
        }
        return null;
    }

    private PrivilegesUDB getPrivilegesForSchema(SchemaUDB schemaUDB) {
        Iterator iterator = this.getStorageDesign().getPrivilegesSet().iterator();
        while (iterator.hasNext()) {
            PrivilegesUDB privilegesUDB = (PrivilegesUDB)iterator.next();
            if (privilegesUDB.getSchema() != schemaUDB) continue;
            return privilegesUDB;
        }
        return null;
    }

    @Override
    protected void setProperties() {
        if (this.schema != null) {
            this.schema.setName(this.tfName.getText());
            Object object = this.cbOwner.getSelectedItem();
            if (object instanceof OwnerUDB) {
                this.schema.setOwner((OwnerUDB)object);
            } else {
                this.schema.setOwner(null);
            }
            Object object2 = this.cbUser.getSelectedItem();
            PrivilegesUDB privilegesUDB = this.getPrivileges(object2);
            privilegesUDB.clear();
            Object[] objectArray = this.selectedPrivsModel.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                privilegesUDB.setSystemPrivileges((String)objectArray[i]);
            }
            privilegesUDB.setGrantOption(SchemaPropertyDialogUDB.translateYesNoForStorage((String)this.cbGrantOption.getSelectedItem()));
            this.schema.setSchemaObject((SchemaObject)this.cbSchemaObject.getSelectedItem());
            this.schema.setComment(this.getCommentsList().getText());
            this.schema.setCommentInRDBMS(this.getCommentsInRDBMSList().getText());
        }
    }

    private class UserListener
    implements ActionListener {
        private UserListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (SchemaPropertyDialogUDB.this.cbUser.getSelectedItem() != null) {
                Object object = SchemaPropertyDialogUDB.this.cbUser.getSelectedItem();
                PrivilegesUDB privilegesUDB = SchemaPropertyDialogUDB.this.getPrivileges(object);
                SchemaPropertyDialogUDB.this.allPrivsModel.removeAllElements();
                SchemaPropertyDialogUDB.this.selectedPrivsModel.removeAllElements();
                SchemaPropertyDialogUDB.this.cbGrantOption.setSelectedItem(AbstractPropertyDialog.translateYesNoForDisplay(privilegesUDB.getGrantOption()));
                String[] stringArray = (String[])PrivilegesUDB.getPrivilegesValues().toArray();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (privilegesUDB.getSystemPrivilegesSet().contains(stringArray[i])) {
                        SchemaPropertyDialogUDB.this.selectedPrivsModel.addElement(stringArray[i]);
                        continue;
                    }
                    SchemaPropertyDialogUDB.this.allPrivsModel.addElement(stringArray[i]);
                }
            } else {
                SchemaPropertyDialogUDB.this.allPrivsModel.removeAllElements();
                SchemaPropertyDialogUDB.this.selectedPrivsModel.removeAllElements();
            }
        }
    }

    private class IndexListMouseListener
    extends MouseAdapter {
        private IndexListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            IndexProxyUDB indexProxyUDB;
            if (mouseEvent.getClickCount() == 2 && (indexProxyUDB = (IndexProxyUDB)SchemaPropertyDialogUDB.this.indexList.getSelectedValue()) != null && !indexProxyUDB.isDialogVisible()) {
                IndexPropertyDialogUDB indexPropertyDialogUDB = new IndexPropertyDialogUDB(SchemaPropertyDialogUDB.this.schema.getDesign().getAppView(), SchemaPropertyDialogUDB.this.getStorageDesign(), indexProxyUDB);
                indexPropertyDialogUDB.show();
            }
        }
    }

    private class ViewListMouseListener
    extends MouseAdapter {
        private ViewListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TableViewProxyUDB tableViewProxyUDB;
            if (mouseEvent.getClickCount() == 2 && (tableViewProxyUDB = (TableViewProxyUDB)SchemaPropertyDialogUDB.this.viewList.getSelectedValue()) != null && !tableViewProxyUDB.isDialogVisible()) {
                TableViewPropertyDialogUDB tableViewPropertyDialogUDB = new TableViewPropertyDialogUDB(SchemaPropertyDialogUDB.this.schema.getDesign().getAppView(), SchemaPropertyDialogUDB.this.getStorageDesign(), tableViewProxyUDB);
                tableViewPropertyDialogUDB.show();
            }
        }
    }

    private class TableListMouseListener
    extends MouseAdapter {
        private TableListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TableProxyUDB tableProxyUDB;
            if (mouseEvent.getClickCount() == 2 && (tableProxyUDB = (TableProxyUDB)SchemaPropertyDialogUDB.this.tableList.getSelectedValue()) != null && !tableProxyUDB.isDialogVisible()) {
                TablePropertyDialogUDB tablePropertyDialogUDB = new TablePropertyDialogUDB(SchemaPropertyDialogUDB.this.schema.getDesign().getAppView(), SchemaPropertyDialogUDB.this.getStorageDesign(), tableProxyUDB);
                tablePropertyDialogUDB.show();
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (SchemaPropertyDialogUDB.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (SchemaPropertyDialogUDB.this.selectedPrivsList.getSelectedIndex() == -1) {
                    SchemaPropertyDialogUDB.this.bnPrivsRemove.setEnabled(false);
                } else {
                    SchemaPropertyDialogUDB.this.bnPrivsRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (SchemaPropertyDialogUDB.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (SchemaPropertyDialogUDB.this.allPrivsList.getSelectedIndex() == -1) {
                    SchemaPropertyDialogUDB.this.bnPrivsAdd.setEnabled(false);
                } else {
                    SchemaPropertyDialogUDB.this.bnPrivsAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemovePrivsActionListener
    implements ActionListener {
        private RemovePrivsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SchemaPropertyDialogUDB.this.selectedPrivsModel.isEmpty()) {
                Object[] objectArray = SchemaPropertyDialogUDB.this.selectedPrivsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (SchemaPropertyDialogUDB.this.allPrivsModel.contains(object)) continue;
                    SchemaPropertyDialogUDB.this.allPrivsModel.addElement(object);
                    SchemaPropertyDialogUDB.this.selectedPrivsModel.removeElement(object);
                }
            }
        }
    }

    private class AddPrivsActionListener
    implements ActionListener {
        private AddPrivsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SchemaPropertyDialogUDB.this.allPrivsModel.isEmpty()) {
                Object[] objectArray = SchemaPropertyDialogUDB.this.allPrivsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (SchemaPropertyDialogUDB.this.selectedPrivsModel.contains(object)) continue;
                    SchemaPropertyDialogUDB.this.selectedPrivsModel.addElement(object);
                    SchemaPropertyDialogUDB.this.allPrivsModel.removeElement(object);
                }
            }
        }
    }
}

