/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.OwnerSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.PermissionsUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableViewProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupSetUDB;
import oracle.dbtools.crest.model.design.storage.udb.UserGroupUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.storage.udb.ColumnsPermissionsDialogUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class PermissionsPropertyDialogUDB
extends JDialog
implements AbstractEditorConstants {
    private static String EMPTY_VALUE = "";
    private static String CHECKED = "v";
    private static String CHECKED_WITH_GRANT_OPTION = "v->";
    protected static final String EDIT = Messages.getString("PermissionsPropertyDialogUDB.Edit");
    private static String COLUMN_CHECKED = "c";
    private StorageObject storageObject;
    private JPanel objectsPanel;
    private OwnerSetUDB usersSet;
    private UserGroupSetUDB groupsSet;
    private ApplicationView appView;
    private StorageDesignUDB storageDesign;
    private JButton bnCancel;
    private JTabbedPane tpane;
    private JPanel jpanel;
    private ColumnsPermissionsDialogUDB dialog;
    private UsersTable usersTable;
    private GroupsTable groupsTable;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PermissionsPropertyDialogUDB.this.bnCancel.doClick();
        }
    };

    public PermissionsPropertyDialogUDB(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView.getFrame());
        JComponent jComponent;
        this.appView = applicationView;
        this.storageDesign = (StorageDesignUDB)storageDesign;
        this.storageObject = storageObject;
        this.setResizable(false);
        this.storageObject.setDialogVisible(true, this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                PermissionsPropertyDialogUDB.this.storageObject.setDialogVisible(false, null);
            }
        });
        this.jpanel = new JPanel(new BorderLayout());
        this.jpanel.add((Component)this.getTabbedPane(), "Center");
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel();
        if (this.isEditable()) {
            JButton jButton;
            if (this.storageObject instanceof TableProxyUDB) {
                jButton = new JButton(Messages.getString("PermissionsPropertyDialogUDB.Columns"));
                jButton.addActionListener(new ColumnsPermissionsListener(this));
                jButton.setCursor(Cursor.getPredefinedCursor(12));
                jButton.setMnemonic(79);
                jPanel.add((Component)jButton, "Before");
            }
            jButton = new JButton(Messages.getString("PermissionsPropertyDialogUDB.OK"));
            jButton.addActionListener(new OKAction());
            jButton.setMnemonic(79);
            jPanel.add(jButton);
            this.getRootPane().setDefaultButton(jButton);
            jComponent = new JButton(Messages.getString("PermissionsPropertyDialogUDB.Apply"));
            ((AbstractButton)jComponent).addActionListener(new ApplyAction());
            ((AbstractButton)jComponent).setMnemonic(65);
            jPanel.add(jComponent);
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jComponent.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        }
        this.bnCancel = new JButton(this.isEditable() ? Messages.getString("PermissionsPropertyDialogUDB.Cancel") : Messages.getString("PermissionsPropertyDialogUDB.Close"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        int n = 1;
        jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        jComponent.getActionMap().put("ESCAPE", this.escape);
        jPanel.add(this.bnCancel);
        this.jpanel.add((Component)jPanel, "South");
        this.getContentPane().add(this.jpanel);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.addTabs();
        this.initProperties();
        this.setModal(true);
    }

    protected boolean isEditable() {
        return !ApplicationView.IS_VIEWER && !ApplicationView.LOGICAL_MODEL_ONLY;
    }

    public void initProperties() {
        int n;
        StorageObject storageObject;
        int n2;
        for (n2 = 0; n2 < this.usersTable.getRowCount(); ++n2) {
            storageObject = (OwnerUDB)this.usersTable.getValueAt(n2, 0);
            for (n = 0; n < this.usersTable.getColumnCount(); ++n) {
                if (!(this.usersTable.getValueAt(n2, n) instanceof JButton)) continue;
                JButton jButton = (JButton)this.usersTable.getValueAt(n2, n);
                if (this.getPermission(storageObject, this.storageObject) != null) {
                    if (this.getPermission(storageObject, this.storageObject).getPrivileges().indexOf(this.usersTable.getColumnName(n)) > -1) {
                        jButton.setText(CHECKED);
                        jButton.updateUI();
                        continue;
                    }
                    if (this.getPermission(storageObject, this.storageObject).getPrivilegesWithGrantOption().indexOf(this.usersTable.getColumnName(n)) > -1) {
                        jButton.setText(CHECKED_WITH_GRANT_OPTION);
                        jButton.updateUI();
                        continue;
                    }
                    if (this.getPermission(storageObject, this.storageObject).hasColPrivilege(this.usersTable.getColumnName(n))) {
                        jButton.setText(COLUMN_CHECKED);
                        jButton.updateUI();
                        continue;
                    }
                    jButton.setText(EMPTY_VALUE);
                    jButton.updateUI();
                    continue;
                }
                jButton.setText(EMPTY_VALUE);
                jButton.updateUI();
            }
        }
        for (n2 = 0; n2 < this.groupsTable.getRowCount(); ++n2) {
            storageObject = (UserGroupUDB)this.groupsTable.getValueAt(n2, 0);
            for (n = 0; n < this.groupsTable.getColumnCount(); ++n) {
                if (!(this.groupsTable.getValueAt(n2, n) instanceof JButton)) continue;
                JButton jButton = (JButton)this.groupsTable.getValueAt(n2, n);
                if (this.getPermission(storageObject, this.storageObject) != null) {
                    if (this.getPermission(storageObject, this.storageObject).getPrivileges().indexOf(this.groupsTable.getColumnName(n)) > -1) {
                        jButton.setText(CHECKED);
                        jButton.updateUI();
                        continue;
                    }
                    if (this.getPermission(storageObject, this.storageObject).getPrivilegesWithGrantOption().indexOf(this.groupsTable.getColumnName(n)) > -1) {
                        jButton.setText(CHECKED_WITH_GRANT_OPTION);
                        jButton.updateUI();
                        continue;
                    }
                    if (this.getPermission(storageObject, this.storageObject).hasColPrivilege(this.groupsTable.getColumnName(n))) {
                        jButton.setText(COLUMN_CHECKED);
                        jButton.updateUI();
                        continue;
                    }
                    jButton.setText(EMPTY_VALUE);
                    jButton.updateUI();
                    continue;
                }
                jButton.setText(EMPTY_VALUE);
                jButton.updateUI();
            }
        }
    }

    protected void addTabs() {
        this.initUsersTable();
        this.initGroupsTable();
    }

    private void initGroupsTable() {
        this.groupsSet = this.storageDesign.getUserGroupSet();
        this.groupsTable = new GroupsTable();
        this.groupsTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.groupsTable);
        jScrollPane.setPreferredSize(new Dimension(800, 280));
        jScrollPane.setHorizontalScrollBar(new JScrollBar());
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.objectsPanel = new JPanel();
        this.objectsPanel.add(jScrollPane);
        this.getTabbedPane().addTab(Messages.getString("PermissionsPropertyDialogUDB.UserGroups"), this.objectsPanel);
        this.groupsTable.updateUI();
        GroupsModel groupsModel = (GroupsModel)this.groupsTable.getModel();
        for (int i = 0; i < this.groupsSet.size(); ++i) {
            UserGroupUDB userGroupUDB = (UserGroupUDB)this.groupsSet.getElement(i);
            String[] stringArray = this.storageObject instanceof TableProxyUDB ? (String[])PermissionsUDB.getTablePermissionsValues().toArray() : (String[])PermissionsUDB.getViewPermissionsValues().toArray();
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(userGroupUDB);
            for (int j = 0; j < stringArray.length; ++j) {
                JButton jButton = new JButton();
                vector.addElement(jButton);
            }
            Object[] objectArray = vector.toArray();
            groupsModel.addRow(objectArray);
        }
    }

    private JTabbedPane getTabbedPane() {
        if (this.tpane == null) {
            this.tpane = new JTabbedPane();
            this.tpane.setPreferredSize(new Dimension(820, 320));
            this.tpane.setTabPlacement(3);
        }
        return this.tpane;
    }

    private void initUsersTable() {
        this.usersTable = new UsersTable();
        this.usersTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.usersTable);
        jScrollPane.setPreferredSize(new Dimension(800, 280));
        jScrollPane.setHorizontalScrollBar(new JScrollBar());
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.objectsPanel = new JPanel();
        this.objectsPanel.add(jScrollPane);
        this.getTabbedPane().addTab(Messages.getString("PermissionsPropertyDialogUDB.Users"), this.objectsPanel);
        this.usersTable.updateUI();
        UsersModel usersModel = (UsersModel)this.usersTable.getModel();
        for (int i = 0; i < this.storageDesign.getOwnerSet().size(); ++i) {
            OwnerUDB ownerUDB = (OwnerUDB)this.storageDesign.getOwnerSet().getElement(i);
            String[] stringArray = this.storageObject instanceof TableProxyUDB ? (String[])PermissionsUDB.getTablePermissionsValues().toArray() : (String[])PermissionsUDB.getViewPermissionsValues().toArray();
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(ownerUDB);
            for (int j = 0; j < stringArray.length; ++j) {
                JButton jButton = new JButton();
                vector.addElement(jButton);
            }
            Object[] objectArray = vector.toArray();
            usersModel.addRow(objectArray);
        }
    }

    protected void setProperties() {
        JButton jButton;
        int n;
        PermissionsUDB permissionsUDB;
        StorageObject storageObject;
        int n2;
        for (n2 = 0; n2 < this.usersTable.getRowCount(); ++n2) {
            storageObject = (OwnerUDB)this.usersTable.getValueAt(n2, 0);
            permissionsUDB = this.getPermission(storageObject, this.storageObject);
            if (this.hasSelectedUserPrivileges(n2)) {
                if (permissionsUDB == null) {
                    permissionsUDB = this.storageDesign.getPermissionsSet().createPermissions();
                    permissionsUDB.setUser((OwnerUDB)storageObject);
                    if (this.storageObject instanceof TableProxyUDB) {
                        permissionsUDB.setTable((TableProxyUDB)this.storageObject);
                    } else if (this.storageObject instanceof TableViewProxyUDB) {
                        permissionsUDB.setView((TableViewProxyUDB)this.storageObject);
                    }
                }
                permissionsUDB.clear();
                for (n = 0; n < this.usersTable.getColumnCount(); ++n) {
                    if (!(this.usersTable.getValueAt(n2, n) instanceof JButton)) continue;
                    jButton = (JButton)this.usersTable.getValueAt(n2, n);
                    if (jButton.getText().equals(CHECKED)) {
                        permissionsUDB.setPrivileges(this.usersTable.getColumnName(n));
                        continue;
                    }
                    if (!jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
                    permissionsUDB.setPrivilegesWithGrantOption(this.usersTable.getColumnName(n));
                }
                continue;
            }
            if (permissionsUDB == null) continue;
            this.storageDesign.getPermissionsSet().remove(permissionsUDB);
        }
        for (n2 = 0; n2 < this.groupsTable.getRowCount(); ++n2) {
            storageObject = (UserGroupUDB)this.groupsTable.getValueAt(n2, 0);
            permissionsUDB = this.getPermission(storageObject, this.storageObject);
            if (this.hasSelectedGroupPrivileges(n2)) {
                if (permissionsUDB == null) {
                    permissionsUDB = this.storageDesign.getPermissionsSet().createPermissions();
                    permissionsUDB.setGroup((UserGroupUDB)storageObject);
                    if (this.storageObject instanceof TableProxyUDB) {
                        permissionsUDB.setTable((TableProxyUDB)this.storageObject);
                    } else if (this.storageObject instanceof TableViewProxyUDB) {
                        permissionsUDB.setView((TableViewProxyUDB)this.storageObject);
                    }
                }
                permissionsUDB.clear();
                for (n = 0; n < this.groupsTable.getColumnCount(); ++n) {
                    if (!(this.groupsTable.getValueAt(n2, n) instanceof JButton)) continue;
                    jButton = (JButton)this.groupsTable.getValueAt(n2, n);
                    if (jButton.getText().equals(CHECKED)) {
                        permissionsUDB.setPrivileges(this.groupsTable.getColumnName(n));
                        continue;
                    }
                    if (!jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
                    permissionsUDB.setPrivilegesWithGrantOption(this.groupsTable.getColumnName(n));
                }
                continue;
            }
            if (permissionsUDB == null) continue;
            this.storageDesign.getPermissionsSet().remove(permissionsUDB);
        }
    }

    public String getCaption() {
        return Messages.getString("PermissionsPropertyDialogUDB.Permissions");
    }

    public OwnerSetUDB getUsersSet() {
        return this.usersSet;
    }

    private PermissionsUDB getPermission(StorageObject storageObject, StorageObject storageObject2) {
        Iterator iterator = this.storageDesign.getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsUDB permissionsUDB = (PermissionsUDB)iterator.next();
            if (permissionsUDB.getUser() != storageObject && permissionsUDB.getGroup() != storageObject || permissionsUDB.getTable() != storageObject2 && permissionsUDB.getView() != storageObject2) continue;
            return permissionsUDB;
        }
        return null;
    }

    private boolean hasSelectedUserPrivileges(int n) {
        for (int i = 1; i < this.usersTable.getColumnCount(); ++i) {
            if (!(this.usersTable.getValueAt(n, i) instanceof JButton)) continue;
            JButton jButton = (JButton)this.usersTable.getValueAt(n, i);
            if (jButton.getText().equals(CHECKED)) {
                return true;
            }
            if (jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                return true;
            }
            if (!jButton.getText().equals(COLUMN_CHECKED)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSelectedGroupPrivileges(int n) {
        for (int i = 1; i < this.groupsTable.getColumnCount(); ++i) {
            if (!(this.groupsTable.getValueAt(n, i) instanceof JButton)) continue;
            JButton jButton = (JButton)this.groupsTable.getValueAt(n, i);
            if (jButton.getText().equals(CHECKED)) {
                return true;
            }
            if (jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                return true;
            }
            if (!jButton.getText().equals(COLUMN_CHECKED)) continue;
            return true;
        }
        return false;
    }

    public void setColumnPermissions(StorageObject storageObject, String string) {
        block5: {
            int n;
            int n2;
            block4: {
                int n3;
                n2 = 0;
                if (!(storageObject instanceof OwnerUDB)) break block4;
                for (n3 = 0; n3 < this.usersTable.getRowCount(); ++n3) {
                    if (this.usersTable.getValueAt(n3, 0) != storageObject) continue;
                    n2 = n3;
                    break;
                }
                for (n3 = 1; n3 < this.usersTable.getColumnCount(); ++n3) {
                    if (!((UsersModel)this.usersTable.getModel()).getColumnName(n3).equalsIgnoreCase(string)) continue;
                    JButton jButton = (JButton)this.usersTable.getValueAt(n2, n3);
                    jButton.setText(COLUMN_CHECKED);
                    this.usersTable.updateUI();
                }
                break block5;
            }
            if (!(storageObject instanceof UserGroupUDB)) break block5;
            for (n = 0; n < this.groupsTable.getRowCount(); ++n) {
                if (this.groupsTable.getValueAt(n, 0) != storageObject) continue;
                n2 = n;
                break;
            }
            for (n = 1; n < this.groupsTable.getColumnCount(); ++n) {
                if (!((GroupsModel)this.groupsTable.getModel()).getColumnName(n).equalsIgnoreCase(string)) continue;
                JButton jButton = (JButton)this.groupsTable.getValueAt(n2, n);
                jButton.setText(COLUMN_CHECKED);
                this.groupsTable.updateUI();
            }
        }
    }

    public void clearColumnPermissions(StorageObject storageObject, String string) {
        block5: {
            int n;
            int n2;
            block4: {
                int n3;
                n2 = 0;
                if (!(storageObject instanceof OwnerUDB)) break block4;
                for (n3 = 0; n3 < this.usersTable.getRowCount(); ++n3) {
                    if (this.usersTable.getValueAt(n3, 0) != storageObject) continue;
                    n2 = n3;
                    break;
                }
                for (n3 = 1; n3 < this.usersTable.getColumnCount(); ++n3) {
                    JButton jButton;
                    if (!((UsersModel)this.usersTable.getModel()).getColumnName(n3).equalsIgnoreCase(string) || !(jButton = (JButton)this.usersTable.getValueAt(n2, n3)).getText().equalsIgnoreCase(COLUMN_CHECKED)) continue;
                    jButton.setText(EMPTY_VALUE);
                }
                break block5;
            }
            if (!(storageObject instanceof UserGroupUDB)) break block5;
            for (n = 0; n < this.groupsTable.getRowCount(); ++n) {
                if (this.groupsTable.getValueAt(n, 0) != storageObject) continue;
                n2 = n;
                break;
            }
            for (n = 1; n < this.groupsTable.getColumnCount(); ++n) {
                JButton jButton;
                if (!((GroupsModel)this.groupsTable.getModel()).getColumnName(n).equalsIgnoreCase(string) || !(jButton = (JButton)this.groupsTable.getValueAt(n2, n)).getText().equalsIgnoreCase(COLUMN_CHECKED)) continue;
                jButton.setText(EMPTY_VALUE);
            }
        }
    }

    class ButtonTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton button;

        ButtonTableCellEditor() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                JButton jButton = (JButton)actionEvent.getSource();
                if (jButton.getText() == null) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(CHECKED)) {
                    jButton.setText(CHECKED_WITH_GRANT_OPTION);
                } else if (jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(EMPTY_VALUE)) {
                    jButton.setText(CHECKED);
                }
            } else {
                this.button.setText(this.button.getText().toString());
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.button = (JButton)object;
            if (this.button != null) {
                this.button.setOpaque(true);
                this.button.setBackground(jTable.getBackground());
                this.button.setActionCommand(EDIT);
                this.button.addActionListener(this);
                this.button.setBorderPainted(true);
                return this.button;
            }
            return null;
        }
    }

    class ButtonTableCellRenderer
    extends JButton
    implements TableCellRenderer {
        ButtonTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.setText(object == null ? "" : "  " + ((JButton)object).getText());
            return this;
        }
    }

    class LabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.setHorizontalAlignment(2);
            this.setText(object == null ? "" : "  " + object.toString());
            return this;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PermissionsPropertyDialogUDB.this.dispose();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PermissionsPropertyDialogUDB.this.setProperties();
            PermissionsPropertyDialogUDB.this.storageObject.setDirty(true);
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PermissionsPropertyDialogUDB.this.setProperties();
            PermissionsPropertyDialogUDB.this.storageObject.setDirty(true);
            PermissionsPropertyDialogUDB.this.dispose();
        }
    }

    private class ColumnsPermissionsListener
    implements ActionListener {
        PermissionsPropertyDialogUDB permDialog;

        public ColumnsPermissionsListener(PermissionsPropertyDialogUDB permissionsPropertyDialogUDB2) {
            this.permDialog = permissionsPropertyDialogUDB2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StorageObject storageObject = null;
            if (PermissionsPropertyDialogUDB.this.tpane.getSelectedIndex() == 0) {
                if (PermissionsPropertyDialogUDB.this.usersTable.getSelectedRow() > -1) {
                    storageObject = (StorageObject)PermissionsPropertyDialogUDB.this.usersTable.getValueAt(PermissionsPropertyDialogUDB.this.usersTable.getSelectedRow(), 0);
                }
            } else if (PermissionsPropertyDialogUDB.this.groupsTable.getSelectedRow() > -1) {
                storageObject = (StorageObject)PermissionsPropertyDialogUDB.this.groupsTable.getValueAt(PermissionsPropertyDialogUDB.this.groupsTable.getSelectedRow(), 0);
            }
            if (storageObject != null && (PermissionsPropertyDialogUDB.this.dialog == null || PermissionsPropertyDialogUDB.this.dialog.getUser() != storageObject)) {
                PermissionsPropertyDialogUDB.this.dialog = new ColumnsPermissionsDialogUDB(PermissionsPropertyDialogUDB.this.appView, PermissionsPropertyDialogUDB.this.storageDesign, PermissionsPropertyDialogUDB.this.storageObject, storageObject, this.permDialog);
            }
            if (PermissionsPropertyDialogUDB.this.dialog != null) {
                PermissionsPropertyDialogUDB.this.dialog.show();
            }
        }
    }

    public class GroupsModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            String[] stringArray = PermissionsPropertyDialogUDB.this.storageObject instanceof TableProxyUDB ? PermissionsUDB.getTablePrivilegesValues() : PermissionsUDB.getViewPrivilegesValues();
            return stringArray.length + 1;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int n) {
            Object[] objectArray = PermissionsPropertyDialogUDB.this.storageObject instanceof TableProxyUDB ? PermissionsUDB.getTablePermissionsValues().toArray() : PermissionsUDB.getViewPermissionsValues().toArray();
            if (n == 0) {
                return Messages.getString("PermissionsPropertyDialogUDB.Group");
            }
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (n != i) continue;
                return objectArray[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!PermissionsPropertyDialogUDB.this.isEditable()) {
                return false;
            }
            return n2 > 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }

    class GroupsTable
    extends JTable {
        GroupsModel dataModel;

        public GroupsTable() {
            this.dataModel = new GroupsModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 0) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                return super.getCellEditor();
            }
            return new ButtonTableCellEditor();
        }
    }

    class UsersTable
    extends JTable {
        UsersModel dataModel;

        public UsersTable() {
            this.dataModel = new UsersModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 0) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                return super.getCellEditor();
            }
            return new ButtonTableCellEditor();
        }
    }

    public class UsersModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            Object[] objectArray = PermissionsPropertyDialogUDB.this.storageObject instanceof TableProxyUDB ? PermissionsUDB.getTablePermissionsValues().toArray() : PermissionsUDB.getViewPermissionsValues().toArray();
            return objectArray.length + 1;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int n) {
            Object[] objectArray = PermissionsPropertyDialogUDB.this.storageObject instanceof TableProxyUDB ? PermissionsUDB.getTablePermissionsValues().toArray() : PermissionsUDB.getViewPermissionsValues().toArray();
            if (n == 0) {
                return Messages.getString("PermissionsPropertyDialogUDB.User");
            }
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (n != i) continue;
                return objectArray[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!PermissionsPropertyDialogUDB.this.isEditable()) {
                return false;
            }
            return n2 > 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }
}

