/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.MethodParamProxyUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class MethodParamPropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private MethodParamProxyUDB methodParam;
    private JComboBox cbAsLocator;

    public MethodParamPropertyDialogUDB(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.methodParam = (MethodParamProxyUDB)storageObject;
        this.setHeight(120);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("MethodParamPropertyDialogUDB.MethodParamProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initAsLocator();
    }

    private void initAsLocator() {
        JLabel jLabel = new JLabel(Messages.getString("MethodParamPropertyDialogUDB.AsLocator"));
        this.general.add(jLabel);
        this.cbAsLocator = new JComboBox<String>(YES_NO);
        this.setBG(this.cbAsLocator);
        this.cbAsLocator.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAsLocator);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbAsLocator, 50);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.methodParam.getName());
        this.tfName.setText(this.methodParam.getName());
        this.cbAsLocator.setSelectedItem(this.methodParam.isAsLocator() ? YES_NO[0] : YES_NO[1]);
        this.getCommentsList().insert(this.methodParam.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.methodParam != null) {
            this.methodParam.setName(this.tfName.getText());
            this.methodParam.setAsLocator(this.cbAsLocator.getSelectedIndex() == 0);
            this.methodParam.setComment(this.getCommentsList().getText());
        }
    }
}

