/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.ColumnProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.PermissionsUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.swingui.editor.storage.udb.PermissionsPropertyDialogUDB;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class ColumnsPermissionsDialogUDB
extends JDialog
implements AbstractEditorConstants {
    private static String EMPTY_VALUE = "";
    private static String CHECKED = "v";
    protected static final String EDIT = Messages.getString("ColumnsPermissionsDialogUDB.Edit");
    private StorageObject storageObject;
    private Object[] columnsSet;
    private StorageObject user;
    private StorageDesignUDB storageDesign;
    private JButton bnCancel;
    private JPanel jpanel;
    private PermissionsPropertyDialogUDB permDialog;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnsPermissionsDialogUDB.this.bnCancel.doClick();
        }
    };
    private ColumnsTable columnsTable;

    public ColumnsPermissionsDialogUDB(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject, StorageObject storageObject2, PermissionsPropertyDialogUDB permissionsPropertyDialogUDB) {
        super(applicationView.getFrame());
        this.storageDesign = (StorageDesignUDB)storageDesign;
        this.storageObject = storageObject;
        this.user = storageObject2;
        this.storageObject.setDialogVisible(true, this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                ColumnsPermissionsDialogUDB.this.storageObject.setDialogVisible(false, null);
            }
        });
        this.jpanel = new JPanel(new BorderLayout());
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(Messages.getString("ColumnsPermissionsDialogUDB.OK"));
        jButton.addActionListener(new OKAction());
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setMnemonic(79);
        jPanel.add(jButton);
        this.getRootPane().setDefaultButton(jButton);
        JButton jButton2 = new JButton(Messages.getString("ColumnsPermissionsDialogUDB.Apply"));
        jButton2.addActionListener(new ApplyAction());
        jButton2.setCursor(Cursor.getPredefinedCursor(12));
        jButton2.setMnemonic(65);
        jPanel.add(jButton2);
        this.bnCancel = new JButton(Messages.getString("ColumnsPermissionsDialogUDB.Cancel"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setCursor(Cursor.getPredefinedCursor(12));
        AbstractPropertyDialog.equalizeButtonSizes(jButton2, this.bnCancel);
        AbstractPropertyDialog.equalizeButtonSizes(jButton, this.bnCancel);
        int n = 1;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        jComponent.getActionMap().put("ESCAPE", this.escape);
        jPanel.add(this.bnCancel);
        this.jpanel.add((Component)jPanel, "South");
        this.getContentPane().add(this.jpanel);
        this.initColumnsTable();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
        this.setModal(true);
        this.setResizable(false);
        this.permDialog = permissionsPropertyDialogUDB;
    }

    public void initProperties() {
        for (int i = 0; i < this.columnsTable.getRowCount(); ++i) {
            ColumnProxyUDB columnProxyUDB = (ColumnProxyUDB)this.columnsTable.getValueAt(i, 0);
            for (int j = 0; j < this.columnsTable.getColumnCount(); ++j) {
                if (!(this.columnsTable.getValueAt(i, j) instanceof JButton)) continue;
                JButton jButton = (JButton)this.columnsTable.getValueAt(i, j);
                if (this.getPermission(this.user, this.storageObject, columnProxyUDB) != null) {
                    if (this.getPermission(this.user, this.storageObject, columnProxyUDB).getPrivs(columnProxyUDB).indexOf(this.columnsTable.getColumnName(j)) > -1) {
                        jButton.setText(CHECKED);
                        jButton.setBackground(Color.WHITE);
                        jButton.updateUI();
                        continue;
                    }
                    jButton.setText(EMPTY_VALUE);
                    jButton.setBackground(Color.WHITE);
                    jButton.updateUI();
                    continue;
                }
                jButton.setText(EMPTY_VALUE);
                jButton.setBackground(Color.WHITE);
                jButton.updateUI();
            }
        }
    }

    private void initColumnsTable() {
        this.columnsSet = ((TableProxyUDB)this.storageObject).getColumnProxies();
        this.columnsTable = new ColumnsTable();
        JScrollPane jScrollPane = new JScrollPane(this.columnsTable);
        jScrollPane.setPreferredSize(new Dimension(440, 180));
        jScrollPane.setHorizontalScrollBar(new JScrollBar());
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.jpanel.add(jScrollPane);
        this.columnsTable.updateUI();
        ColumnsModel columnsModel = (ColumnsModel)this.columnsTable.getModel();
        for (int i = 0; i < this.columnsSet.length; ++i) {
            ColumnProxyUDB columnProxyUDB = (ColumnProxyUDB)this.columnsSet[i];
            String[] stringArray = (String[])PermissionsUDB.getColumnPermissionsValues().toArray();
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(columnProxyUDB);
            for (int j = 0; j < stringArray.length; ++j) {
                JButton jButton = new JButton();
                vector.addElement(jButton);
            }
            Object[] objectArray = vector.toArray();
            columnsModel.addRow(objectArray);
        }
    }

    private boolean hasSelectedColumnsPrivileges(int n) {
        for (int i = 1; i < this.columnsTable.getColumnCount(); ++i) {
            JButton jButton;
            if (!(this.columnsTable.getValueAt(n, i) instanceof JButton) || !(jButton = (JButton)this.columnsTable.getValueAt(n, i)).getText().equals(CHECKED)) continue;
            return true;
        }
        return false;
    }

    protected void setProperties() {
        int n;
        PermissionsUDB permissionsUDB = this.getPermission(this.user, this.storageObject);
        if (permissionsUDB != null) {
            permissionsUDB.clearColPermissions();
        }
        for (n = 0; n < this.columnsTable.getRowCount(); ++n) {
            ColumnProxyUDB columnProxyUDB = (ColumnProxyUDB)this.columnsTable.getValueAt(n, 0);
            if (this.hasSelectedColumnsPrivileges(n)) {
                if (permissionsUDB == null) {
                    permissionsUDB = this.storageDesign.getPermissionsSet().createPermissions();
                    if (this.user instanceof OwnerUDB) {
                        permissionsUDB.setUser((OwnerUDB)this.user);
                    }
                    permissionsUDB.setTable((TableProxyUDB)this.storageObject);
                }
                String string = "";
                string = string.concat(columnProxyUDB.getName());
                for (int i = 0; i < this.columnsTable.getColumnCount(); ++i) {
                    JButton jButton;
                    if (!(this.columnsTable.getValueAt(n, i) instanceof JButton) || !(jButton = (JButton)this.columnsTable.getValueAt(n, i)).getText().equals(CHECKED)) continue;
                    string = string.concat(", ").concat(this.columnsTable.getColumnName(i));
                    this.permDialog.setColumnPermissions(this.user, this.columnsTable.getColumnName(i));
                }
                permissionsUDB.setColumnList(string);
                continue;
            }
            if (permissionsUDB == null || !permissionsUDB.getColumns().isEmpty()) continue;
            this.storageDesign.getPermissionsSet().remove(permissionsUDB);
            for (int i = 0; i < this.columnsTable.getColumnCount(); ++i) {
                if (!(this.columnsTable.getValueAt(n, i) instanceof JButton)) continue;
                this.permDialog.clearColumnPermissions(this.user, this.columnsTable.getColumnName(i));
            }
        }
        for (n = 1; n < this.columnsTable.getColumnCount(); ++n) {
            boolean bl = false;
            for (int i = 0; i < this.columnsTable.getRowCount(); ++i) {
                if (!((JButton)this.columnsTable.getValueAt(i, n)).getText().equalsIgnoreCase(CHECKED)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.permDialog.clearColumnPermissions(this.user, this.columnsTable.getColumnName(n));
        }
    }

    public String getCaption() {
        return Messages.getString("ColumnsPermissionsDialogUDB.Permissions");
    }

    private PermissionsUDB getPermission(StorageObject storageObject, StorageObject storageObject2, StorageObject storageObject3) {
        Iterator iterator = this.storageDesign.getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsUDB permissionsUDB = (PermissionsUDB)iterator.next();
            if (permissionsUDB.getUser() != storageObject && permissionsUDB.getGroup() != storageObject || permissionsUDB.getTable() != storageObject2 && permissionsUDB.getView() != storageObject2 || !permissionsUDB.getColumns().contains(storageObject3.getName())) continue;
            return permissionsUDB;
        }
        return null;
    }

    private PermissionsUDB getPermission(StorageObject storageObject, StorageObject storageObject2) {
        Iterator iterator = this.storageDesign.getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsUDB permissionsUDB = (PermissionsUDB)iterator.next();
            if (permissionsUDB.getUser() != storageObject && permissionsUDB.getGroup() != storageObject || permissionsUDB.getTable() != storageObject2 && permissionsUDB.getView() != storageObject2) continue;
            return permissionsUDB;
        }
        return null;
    }

    public StorageObject getUser() {
        return this.user;
    }

    class ButtonTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton button;

        ButtonTableCellEditor() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                JButton jButton = (JButton)actionEvent.getSource();
                if (jButton.getText() == null) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(CHECKED)) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(EMPTY_VALUE)) {
                    jButton.setText(CHECKED);
                }
            } else {
                this.button.setText(this.button.getText().toString());
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.button = (JButton)object;
            if (object != null) {
                this.button.setOpaque(true);
                this.button.setBackground(jTable.getBackground());
                this.button.setActionCommand(EDIT);
                this.button.addActionListener(this);
                this.button.setBorderPainted(false);
                return this.button;
            }
            return null;
        }
    }

    class ButtonTableCellRenderer
    extends JButton
    implements TableCellRenderer {
        ButtonTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setBackground(jTable.getBackground());
            try {
                this.setText(object == null ? "" : "  " + ((JButton)object).getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this;
        }
    }

    class LabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setBackground(jTable.getBackground());
            if (object == null) {
                this.setText("");
            } else if (object instanceof ColumnProxyUDB) {
                this.setText(" " + ((ColumnProxyUDB)object).getName());
            } else {
                this.setText(object.toString());
            }
            return this;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnsPermissionsDialogUDB.this.dispose();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnsPermissionsDialogUDB.this.setProperties();
            ColumnsPermissionsDialogUDB.this.storageObject.setDirty(true);
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnsPermissionsDialogUDB.this.setProperties();
            ColumnsPermissionsDialogUDB.this.storageObject.setDirty(true);
            ColumnsPermissionsDialogUDB.this.dispose();
        }
    }

    class ColumnsTable
    extends JTable {
        ColumnsModel dataModel;

        public ColumnsTable() {
            this.dataModel = new ColumnsModel();
            this.setModel(this.dataModel);
            this.initColumnSizes();
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        private void initColumnSizes() {
            TableColumn tableColumn = null;
            for (int i = 0; i < 3; ++i) {
                tableColumn = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    tableColumn.setPreferredWidth(220);
                    continue;
                }
                tableColumn.setPreferredWidth(80);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 0) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                return super.getCellEditor();
            }
            return new ButtonTableCellEditor();
        }
    }

    public class ColumnsModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            Object[] objectArray = PermissionsUDB.getColumnPermissionsValues().toArray();
            return objectArray.length + 1;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int n) {
            Object[] objectArray = PermissionsUDB.getColumnPermissionsValues().toArray();
            if (n == 0) {
                return Messages.getString("ColumnsPermissionsDialogUDB.Column");
            }
            for (int i = 1; i < this.getColumnCount(); ++i) {
                if (n != i) continue;
                return objectArray[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }
}

