/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.BufferPoolUDB;
import oracle.dbtools.crest.model.design.storage.udb.NodeGroupUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableSpaceUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.swingui.editor.storage.udb.TableSpacePropertyDialogUDB;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class BufferPoolPropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private BufferPoolUDB bufferPool;
    private JIntegerField ifSize;
    private JTextField tfNodesWithDiffSize;
    private JComboBox cbPageSize;
    private JComboBox cbExtendedStorage;
    private JPanel scope;
    private DefaultListModel allNodesModel;
    private DefaultListModel selectedNodesModel;
    private JList allNodesList;
    private JList selectedNodesList;
    private JButton bnAdd;
    private JButton bnRemove;
    private JPanel tableSpaces;
    private DefaultListModel tsListModel;
    private JList tsList;

    public BufferPoolPropertyDialogUDB(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.bufferPool = (BufferPoolUDB)storageObject;
        this.setHeight(200);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("BufferPoolPropertyDialogUDB.BufferPoolProperties");
    }

    @Override
    public void initProperties() {
        this.initCaption(this.bufferPool.getName());
        this.tfName.setText(this.bufferPool.getName());
        this.ifSize.setValue((long)this.bufferPool.getSize());
        this.tfNodesWithDiffSize.setText(this.bufferPool.getNodesWithDiffSize());
        this.cbPageSize.setSelectedItem(new Integer(this.bufferPool.getPageSize()));
        if (this.bufferPool.getExtendedStorage()) {
            this.cbExtendedStorage.setSelectedItem(YES);
        } else {
            this.cbExtendedStorage.setSelectedItem(NO);
        }
        NodeGroupUDB[] nodeGroupUDBArray = (NodeGroupUDB[])this.getStorageDesign().getNodeGroupSet().toArray();
        for (int i = 0; i < nodeGroupUDBArray.length; ++i) {
            NodeGroupUDB nodeGroupUDB = nodeGroupUDBArray[i];
            if (this.bufferPool.getScopeSet().contains(nodeGroupUDB.getName())) {
                this.selectedNodesModel.addElement(nodeGroupUDB);
                continue;
            }
            this.allNodesModel.addElement(nodeGroupUDB);
        }
        TableSpaceUDB[] tableSpaceUDBArray = (TableSpaceUDB[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tableSpaceUDBArray.length; ++i) {
            if (tableSpaceUDBArray[i].getBufferPool() != this.bufferPool) continue;
            this.tsListModel.addElement(tableSpaceUDBArray[i]);
        }
        this.getCommentsList().insert(this.bufferPool.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.bufferPool != null) {
            this.bufferPool.setSize(this.ifSize.getIntValue());
            this.bufferPool.setNodesWithDiffSize(this.tfNodesWithDiffSize.getText());
            Object object = this.cbPageSize.getSelectedItem();
            if (object instanceof Integer) {
                this.bufferPool.setPageSize((Integer)object);
            }
            object = this.cbExtendedStorage.getSelectedItem();
            boolean bl = String.valueOf(object).equalsIgnoreCase(YES_NO[0]);
            this.bufferPool.setExtendedStorage(bl);
            Object[] objectArray = this.selectedNodesModel.toArray();
            this.bufferPool.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = objectArray[i];
                if (!(object2 instanceof NodeGroupUDB)) continue;
                this.bufferPool.setScope(((NodeGroupUDB)object2).getName());
            }
            this.bufferPool.setComment(this.getCommentsList().getText());
        }
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.tfName.setEditable(false);
        this.initSize();
        this.initNodesWithDiffSize();
        this.initPageSize();
        this.initExtendedStorage();
    }

    private void initSize() {
        JLabel jLabel = new JLabel(Messages.getString("BufferPoolPropertyDialogUDB.Size"));
        this.general.add(jLabel);
        this.ifSize = new JIntegerField(0, 26);
        this.general.add(this.ifSize);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.ifSize, 50);
    }

    private void initNodesWithDiffSize() {
        JLabel jLabel = new JLabel(Messages.getString("BufferPoolPropertyDialogUDB.DiffSizeNodes"));
        this.general.add(jLabel);
        this.tfNodesWithDiffSize = new JTextField("", 26);
        this.general.add(this.tfNodesWithDiffSize);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfNodesWithDiffSize, 80);
    }

    private void initPageSize() {
        JLabel jLabel = new JLabel(Messages.getString("BufferPoolPropertyDialogUDB.PageSize"));
        this.general.add(jLabel);
        this.cbPageSize = new JComboBox<Object>(BufferPoolUDB.getAvailablePageSizes());
        this.setBG(this.cbPageSize);
        this.cbPageSize.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPageSize);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbPageSize, 110);
    }

    private void initExtendedStorage() {
        JLabel jLabel = new JLabel(Messages.getString("BufferPoolPropertyDialogUDB.ExtendedStorage"));
        this.general.add(jLabel);
        this.cbExtendedStorage = new JComboBox<String>(YES_NO);
        this.setBG(this.cbExtendedStorage);
        this.cbExtendedStorage.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbExtendedStorage);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbExtendedStorage, 140);
    }

    @Override
    protected void addTabs() {
        this.initScopeView();
        this.initTableSpacesView();
    }

    private void initScopeView() {
        this.scope = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("BufferPoolPropertyDialogUDB.Scope"), this.scope);
        this.initScope();
    }

    private void initScope() {
        this.initAllVolumesList();
        this.initSelectedVolumesList();
        this.initButtons();
    }

    protected SpringLayout getScopeLayout() {
        return (SpringLayout)this.scope.getLayout();
    }

    private void initAllVolumesList() {
        JLabel jLabel = new JLabel(Messages.getString("BufferPoolPropertyDialogUDB.AllNodes"));
        this.scope.add(jLabel);
        this.allNodesModel = new DefaultListModel();
        this.allNodesList = new JList(this.allNodesModel);
        ListSelectionModel listSelectionModel = this.allNodesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allNodesList);
        jScrollPane.setPreferredSize(new Dimension(144, 140));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.scope.add(jScrollPane);
        this.setLabelConstraints(this.getScopeLayout(), jLabel, 12, 4);
        this.setObjectConstraints(this.getScopeLayout(), jScrollPane, 10, 22);
    }

    private void initSelectedVolumesList() {
        JLabel jLabel = new JLabel(Messages.getString("BufferPoolPropertyDialogUDB.SelectedNodes"));
        this.scope.add(jLabel);
        this.selectedNodesModel = new DefaultListModel();
        this.selectedNodesList = new JList(this.selectedNodesModel);
        ListSelectionModel listSelectionModel = this.selectedNodesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedNodesList);
        jScrollPane.setPreferredSize(new Dimension(145, 140));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.scope.add(jScrollPane);
        this.setLabelConstraints(this.getScopeLayout(), jLabel, 292, 4);
        this.setObjectConstraints(this.getScopeLayout(), jScrollPane, 290, 22);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("BufferPoolPropertyDialogUDB.Add"));
        this.bnAdd.addActionListener(new AddNodesActionListener());
        this.bnAdd.setEnabled(false);
        this.scope.add(this.bnAdd);
        this.setObjectConstraints(this.getScopeLayout(), this.bnAdd, 175, 60);
        this.bnRemove = new JButton(Messages.getString("BufferPoolPropertyDialogUDB.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveNodesActionListener());
        this.scope.add(this.bnRemove);
        this.setObjectConstraints(this.getScopeLayout(), this.bnRemove, 175, 90);
        BufferPoolPropertyDialogUDB.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    private void initTableSpacesView() {
        this.tableSpaces = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("BufferPoolPropertyDialogUDB.TableSpaces"), this.tableSpaces);
        this.initTableSpaces();
    }

    private void initTableSpaces() {
        this.tsListModel = new DefaultListModel();
        this.tsList = new JList(this.tsListModel);
        this.tsList.addMouseListener(new ListMouseListenerTS());
        JScrollPane jScrollPane = new JScrollPane(this.tsList);
        jScrollPane.setPreferredSize(new Dimension(395, 150));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.tableSpaces.add(jScrollPane);
        this.setObjectConstraints(this.getTSLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getTSLayout() {
        return (SpringLayout)this.tableSpaces.getLayout();
    }

    private class ListMouseListenerTS
    extends MouseAdapter {
        private ListMouseListenerTS() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TableSpaceUDB tableSpaceUDB;
            if (mouseEvent.getClickCount() == 2 && (tableSpaceUDB = (TableSpaceUDB)BufferPoolPropertyDialogUDB.this.tsList.getSelectedValue()) != null && !tableSpaceUDB.isDialogVisible()) {
                TableSpacePropertyDialogUDB tableSpacePropertyDialogUDB = new TableSpacePropertyDialogUDB(BufferPoolPropertyDialogUDB.this.bufferPool.getDesign().getAppView(), BufferPoolPropertyDialogUDB.this.getStorageDesign(), tableSpaceUDB);
                tableSpacePropertyDialogUDB.show();
            }
        }
    }

    private class RemoveNodesActionListener
    implements ActionListener {
        private RemoveNodesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!BufferPoolPropertyDialogUDB.this.selectedNodesModel.isEmpty()) {
                Object[] objectArray = BufferPoolPropertyDialogUDB.this.selectedNodesList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (BufferPoolPropertyDialogUDB.this.allNodesModel.contains(object)) continue;
                    BufferPoolPropertyDialogUDB.this.allNodesModel.addElement(object);
                    BufferPoolPropertyDialogUDB.this.selectedNodesModel.removeElement(object);
                }
            }
        }
    }

    private class AddNodesActionListener
    implements ActionListener {
        private AddNodesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!BufferPoolPropertyDialogUDB.this.allNodesModel.isEmpty()) {
                Object[] objectArray = BufferPoolPropertyDialogUDB.this.allNodesList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (BufferPoolPropertyDialogUDB.this.selectedNodesModel.contains(object)) continue;
                    BufferPoolPropertyDialogUDB.this.selectedNodesModel.addElement(object);
                    BufferPoolPropertyDialogUDB.this.allNodesModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (BufferPoolPropertyDialogUDB.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (BufferPoolPropertyDialogUDB.this.selectedNodesList.getSelectedIndex() == -1) {
                    BufferPoolPropertyDialogUDB.this.bnRemove.setEnabled(false);
                } else {
                    BufferPoolPropertyDialogUDB.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (BufferPoolPropertyDialogUDB.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (BufferPoolPropertyDialogUDB.this.allNodesList.getSelectedIndex() == -1) {
                    BufferPoolPropertyDialogUDB.this.bnAdd.setEnabled(false);
                } else {
                    BufferPoolPropertyDialogUDB.this.bnAdd.setEnabled(true);
                }
            }
        }
    }
}

