/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.AliasUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class AliasPropertyDialogUDB
extends AbstractUDBPropertyDialog {
    private JComboBox cbScheme;
    private JComboBox cbView;
    private JComboBox cbTable;
    private JComboBox cbAnotherAlias;
    private AliasUDB alias;

    public AliasPropertyDialogUDB(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.alias = (AliasUDB)storageObject;
        this.setHeight(200);
        this.initCommentsView(65);
        this.initCommentsInRDBMS(65);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("AliasPropertyDialogUDB.AliasProperties");
    }

    @Override
    public void initProperties() {
        this.initCaption(this.alias.getName());
        this.tfName.setText(this.alias.getName());
        if (this.alias.getSchema() != null) {
            this.selectObject(this.cbScheme, this.alias.getSchema());
        }
        if (this.cbView != null) {
            this.selectObject(this.cbView, this.alias.getReferencedObject());
        }
        if (this.cbTable != null) {
            this.selectObject(this.cbTable, this.alias.getReferencedObject());
        }
        this.cbAnotherAlias.removeItem(this.alias);
        this.selectObject(this.cbAnotherAlias, this.alias.getReferencedObject());
        this.getCommentsList().insert(this.alias.getComment(), 0);
        this.getCommentsInRDBMSList().insert(this.alias.getCommentInRDBMS(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.alias != null) {
            Object object = this.cbScheme.getSelectedItem();
            if (object instanceof SchemaUDB) {
                this.alias.setSchema((SchemaUDB)object);
            } else {
                this.alias.setSchema(null);
            }
            this.alias.setName(this.tfName.getText());
            object = this.cbView.getSelectedItem();
            if (object instanceof StorageObject) {
                this.alias.setReferencedObject((StorageObject)object);
            } else {
                object = this.cbTable.getSelectedItem();
                if (object instanceof StorageObject) {
                    this.alias.setReferencedObject((StorageObject)object);
                } else {
                    object = this.cbAnotherAlias.getSelectedItem();
                    if (object instanceof StorageObject) {
                        this.alias.setReferencedObject((StorageObject)object);
                    }
                }
            }
            this.alias.setComment(this.getCommentsList().getText());
            this.alias.setCommentInRDBMS(this.getCommentsInRDBMSList().getText());
        }
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initScheme();
        this.initView();
        this.initTable();
        this.initAnotherAlias();
    }

    private void initScheme() {
        JLabel jLabel = new JLabel(Messages.getString("AliasPropertyDialogUDB.Scheme"));
        this.general.add(jLabel);
        this.cbScheme = new JComboBox();
        this.setBG(this.cbScheme);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSchemaSet().toArray(), this.cbScheme);
        }
        this.cbScheme.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbScheme);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbScheme, 50);
    }

    private void initView() {
        JLabel jLabel = new JLabel(Messages.getString("AliasPropertyDialogUDB.View"));
        this.general.add(jLabel);
        this.cbView = new JComboBox();
        this.setBG(this.cbView);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableViewProxySet().toArray(), this.cbView);
        }
        this.cbView.setPreferredSize(this.tfName.getPreferredSize());
        this.cbView.addActionListener(new ComboListener());
        this.general.add(this.cbView);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbView, 80);
    }

    private void initTable() {
        JLabel jLabel = new JLabel(Messages.getString("AliasPropertyDialogUDB.Table"));
        this.general.add(jLabel);
        this.cbTable = new JComboBox();
        this.setBG(this.cbTable);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableProxySet().toArray(), this.cbTable);
        }
        this.cbTable.setPreferredSize(this.tfName.getPreferredSize());
        this.cbTable.addActionListener(new ComboListener());
        this.general.add(this.cbTable);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbTable, 110);
    }

    private void initAnotherAlias() {
        JLabel jLabel = new JLabel(Messages.getString("AliasPropertyDialogUDB.AnotherAlias"));
        this.general.add(jLabel);
        this.cbAnotherAlias = new JComboBox();
        this.setBG(this.cbAnotherAlias);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getAliasSet().toArray(), this.cbAnotherAlias);
        }
        this.cbAnotherAlias.setPreferredSize(this.tfName.getPreferredSize());
        this.cbAnotherAlias.addActionListener(new ComboListener());
        this.general.add(this.cbAnotherAlias);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbAnotherAlias, 140);
    }

    @Override
    protected boolean allowName(String string) {
        Object object = this.cbScheme.getSelectedItem();
        if (object instanceof SchemaUDB) {
            string = ((SchemaUDB)object).getName() + '.' + string;
        }
        return this.getStorageObject().allowName(string, true);
    }

    class ComboListener
    implements ActionListener {
        ComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            Object object = jComboBox.getSelectedItem();
            if (object instanceof StorageObject) {
                if (AliasPropertyDialogUDB.this.cbView.equals(jComboBox)) {
                    AliasPropertyDialogUDB.this.cbTable.setSelectedIndex(0);
                    AliasPropertyDialogUDB.this.cbAnotherAlias.setSelectedIndex(0);
                } else if (AliasPropertyDialogUDB.this.cbTable.equals(jComboBox)) {
                    AliasPropertyDialogUDB.this.cbView.setSelectedIndex(0);
                    AliasPropertyDialogUDB.this.cbAnotherAlias.setSelectedIndex(0);
                } else if (AliasPropertyDialogUDB.this.cbAnotherAlias.equals(jComboBox)) {
                    AliasPropertyDialogUDB.this.cbView.setSelectedIndex(0);
                    AliasPropertyDialogUDB.this.cbTable.setSelectedIndex(0);
                }
            }
        }
    }
}

