/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.PermissionsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class UserAndRolePermissionsDialogSqlServerv2k5
extends CustomDialog
implements AbstractEditorConstants {
    private static String EMPTY_VALUE = "";
    private static String CHECKED = "v";
    private static String CHECKED_WITH_GRANT_OPTION = "v->";
    protected static final String EDIT = Messages.getString("UserAndRolePermissionsDialogSqlServerv2k5.Edit");
    private StorageObject storageObject;
    private TableProxySetSqlServer tablesSet;
    private TableViewProxySetSqlServer viewSet;
    private StorageDesignSqlServer storageDesign;
    private JButton bnCancel;
    private JTabbedPane tpane;
    private JPanel jpanel;
    private JPanel objectsPanel;
    private TableTable tablesTable;
    private ViewsTable viewsTable;
    private JDialog dialog;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UserAndRolePermissionsDialogSqlServerv2k5.this.bnCancel.doClick();
        }
    };

    public UserAndRolePermissionsDialogSqlServerv2k5(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView);
        this.storageDesign = (StorageDesignSqlServer)storageDesign;
        this.storageObject = storageObject;
        this.jpanel = new JPanel(new BorderLayout());
        this.jpanel.add((Component)this.getTabbedPane(), "Center");
        JPanel jPanel = new JPanel();
        if (this.isEditable()) {
            JButton jButton = new JButton(Messages.getString("UserAndRolePermissionsDialogSqlServerv2k5.OK"));
            jButton.addActionListener(new OKAction());
            jButton.setCursor(Cursor.getPredefinedCursor(12));
            jButton.setMnemonic(79);
            jPanel.add(jButton);
            JButton jButton2 = new JButton(Messages.getString("UserAndRolePermissionsDialogSqlServerv2k5.Apply"));
            jButton2.addActionListener(new ApplyAction());
            jButton2.setCursor(Cursor.getPredefinedCursor(12));
            jButton2.setMnemonic(65);
            jPanel.add(jButton2);
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jButton2.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        }
        this.bnCancel = new JButton(this.isEditable() ? Messages.getString("UserAndRolePermissionsDialogSqlServerv2k5.Cancel") : Messages.getString("UserAndRolePermissionsDialogSqlServerv2k5.Close"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        boolean bl = true;
        jPanel.add(this.bnCancel);
        this.jpanel.add((Component)jPanel, "South");
        this.addTabs();
        this.initProperties();
        this.add(this.jpanel);
    }

    @Override
    protected boolean isEditable() {
        return !ApplicationView.IS_VIEWER && !ApplicationView.LOGICAL_MODEL_ONLY;
    }

    protected void addTabs() {
        this.initTables();
        this.initViews();
    }

    private JTabbedPane getTabbedPane() {
        if (this.tpane == null) {
            this.tpane = new JTabbedPane();
            this.tpane.setPreferredSize(new Dimension(820, 320));
            this.tpane.setTabPlacement(3);
        }
        return this.tpane;
    }

    private void initTables() {
        this.tablesSet = (TableProxySetSqlServer)this.storageDesign.getTableProxySet();
        this.tablesTable = new TableTable();
        JScrollPane jScrollPane = new JScrollPane(this.tablesTable);
        jScrollPane.setPreferredSize(new Dimension(800, 320));
        jScrollPane.setHorizontalScrollBar(new JScrollBar());
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.objectsPanel = new JPanel();
        this.objectsPanel.add(jScrollPane);
        this.getTabbedPane().addTab(Messages.getString("UserAndRolePermissionsDialogSqlServerv2k5.Tables"), this.objectsPanel);
        this.tablesTable.updateUI();
        TablesModel tablesModel = (TablesModel)this.tablesTable.getModel();
        Iterator iterator = this.tablesSet.iterator();
        while (iterator.hasNext()) {
            TableProxySqlServer tableProxySqlServer = (TableProxySqlServer)iterator.next();
            String[] stringArray = PermissionsSqlServer.getTablePrivilegesValues();
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(tableProxySqlServer);
            for (int i = 0; i < stringArray.length; ++i) {
                JButton jButton = new JButton();
                vector.addElement(jButton);
            }
            Object[] objectArray = vector.toArray();
            tablesModel.addRow(objectArray);
        }
    }

    private void initViews() {
        this.viewSet = (TableViewProxySetSqlServer)this.storageDesign.getTableViewProxySet();
        this.viewsTable = new ViewsTable();
        this.viewsTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.viewsTable);
        jScrollPane.setPreferredSize(new Dimension(800, 320));
        jScrollPane.setHorizontalScrollBar(new JScrollBar());
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.objectsPanel = new JPanel();
        this.objectsPanel.add(jScrollPane);
        this.getTabbedPane().addTab(Messages.getString("UserAndRolePermissionsDialogSqlServerv2k5.Views"), this.objectsPanel);
        this.viewsTable.updateUI();
        ViewsModel viewsModel = (ViewsModel)this.viewsTable.getModel();
        Iterator iterator = this.viewSet.iterator();
        while (iterator.hasNext()) {
            TableViewProxySqlServer tableViewProxySqlServer = (TableViewProxySqlServer)iterator.next();
            String[] stringArray = PermissionsSqlServer.getViewPrivilegesValues();
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(tableViewProxySqlServer);
            for (int i = 0; i < stringArray.length; ++i) {
                JButton jButton = new JButton();
                vector.addElement(jButton);
            }
            Object[] objectArray = vector.toArray();
            viewsModel.addRow(objectArray);
        }
    }

    private boolean hasSelectedTablePrivileges(int n) {
        for (int i = 1; i < this.tablesTable.getColumnCount(); ++i) {
            if (!(this.tablesTable.getValueAt(n, i) instanceof JButton)) continue;
            JButton jButton = (JButton)this.tablesTable.getValueAt(n, i);
            if (jButton.getText().equals(CHECKED)) {
                return true;
            }
            if (!jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSelectedViewPrivileges(int n) {
        for (int i = 1; i < this.viewsTable.getColumnCount(); ++i) {
            if (!(this.viewsTable.getValueAt(n, i) instanceof JButton)) continue;
            JButton jButton = (JButton)this.viewsTable.getValueAt(n, i);
            if (jButton.getText().equals(CHECKED)) {
                return true;
            }
            if (!jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
            return true;
        }
        return false;
    }

    private PermissionsSqlServer getPermission(StorageObject storageObject, StorageObject storageObject2) {
        Iterator iterator = this.storageDesign.getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsSqlServer permissionsSqlServer = (PermissionsSqlServer)iterator.next();
            if (permissionsSqlServer.getUser() != storageObject && permissionsSqlServer.getRole() != storageObject || permissionsSqlServer.getTable() != storageObject2 && permissionsSqlServer.getView() != storageObject2) continue;
            return permissionsSqlServer;
        }
        return null;
    }

    public void initProperties() {
        int n;
        PermissionsSqlServer permissionsSqlServer;
        RelationalObjectProxy relationalObjectProxy;
        int n2;
        for (n2 = 0; n2 < this.tablesTable.getRowCount(); ++n2) {
            relationalObjectProxy = (TableProxySqlServer)this.tablesTable.getValueAt(n2, 0);
            permissionsSqlServer = this.getPermission(this.storageObject, relationalObjectProxy);
            for (n = 0; n < this.tablesTable.getColumnCount(); ++n) {
                if (this.tablesTable.getValueAt(n2, n) instanceof JButton) {
                    JButton jButton = (JButton)this.tablesTable.getValueAt(n2, n);
                    if (permissionsSqlServer != null) {
                        if (permissionsSqlServer.getPrivileges().indexOf(this.tablesTable.getColumnName(n)) > -1) {
                            jButton.setText(CHECKED);
                            jButton.updateUI();
                            continue;
                        }
                        if (permissionsSqlServer.getPrivilegesWithGrantOption().indexOf(this.tablesTable.getColumnName(n)) > -1) {
                            jButton.setText(CHECKED_WITH_GRANT_OPTION);
                            jButton.updateUI();
                            continue;
                        }
                        jButton.setText(EMPTY_VALUE);
                        jButton.updateUI();
                        continue;
                    }
                    jButton.setText(EMPTY_VALUE);
                    jButton.updateUI();
                    continue;
                }
                if (n != this.tablesTable.getColumnCount() - 1 || permissionsSqlServer == null) continue;
                if (permissionsSqlServer.getAsRole() != null) {
                    this.tablesTable.setValueAt(permissionsSqlServer.getAsRole(), n2, n);
                    continue;
                }
                this.tablesTable.setValueAt("", n2, n);
            }
        }
        for (n2 = 0; n2 < this.viewsTable.getRowCount(); ++n2) {
            relationalObjectProxy = (TableViewProxySqlServer)this.viewsTable.getValueAt(n2, 0);
            permissionsSqlServer = this.getPermission(this.storageObject, relationalObjectProxy);
            for (n = 0; n < this.viewsTable.getColumnCount(); ++n) {
                if (this.viewsTable.getValueAt(n2, n) instanceof JButton) {
                    JButton jButton = (JButton)this.viewsTable.getValueAt(n2, n);
                    if (permissionsSqlServer != null) {
                        if (permissionsSqlServer.getPrivileges().indexOf(this.viewsTable.getColumnName(n)) > -1) {
                            jButton.setText(CHECKED);
                            jButton.updateUI();
                            continue;
                        }
                        if (permissionsSqlServer.getPrivilegesWithGrantOption().indexOf(this.viewsTable.getColumnName(n)) > -1) {
                            jButton.setText(CHECKED_WITH_GRANT_OPTION);
                            jButton.updateUI();
                            continue;
                        }
                        jButton.setText(EMPTY_VALUE);
                        jButton.updateUI();
                        continue;
                    }
                    jButton.setText(EMPTY_VALUE);
                    jButton.updateUI();
                    continue;
                }
                if (n != this.viewsTable.getColumnCount() - 1 || permissionsSqlServer == null) continue;
                if (permissionsSqlServer.getAsRole() != null) {
                    this.viewsTable.setValueAt(permissionsSqlServer.getAsRole(), n2, n);
                    continue;
                }
                this.viewsTable.setValueAt("", n2, n);
            }
        }
    }

    protected void setProperties() {
        RoleSqlServer roleSqlServer;
        JButton jButton;
        int n;
        PermissionsSqlServer permissionsSqlServer;
        RelationalObjectProxy relationalObjectProxy;
        int n2;
        for (n2 = 0; n2 < this.tablesTable.getRowCount(); ++n2) {
            relationalObjectProxy = (TableProxySqlServer)this.tablesTable.getValueAt(n2, 0);
            permissionsSqlServer = this.getPermission(this.storageObject, relationalObjectProxy);
            if (this.hasSelectedTablePrivileges(n2)) {
                if (permissionsSqlServer == null) {
                    permissionsSqlServer = this.storageDesign.getPermissionsSet().createPermissions();
                    permissionsSqlServer.setTable((TableProxySqlServer)relationalObjectProxy);
                    if (this.storageObject instanceof UserSqlServer) {
                        permissionsSqlServer.setUser((UserSqlServer)this.storageObject);
                    } else if (this.storageObject instanceof RoleSqlServer) {
                        permissionsSqlServer.setRole((RoleSqlServer)this.storageObject);
                    }
                }
                permissionsSqlServer.clear();
                for (n = 0; n < this.tablesTable.getColumnCount(); ++n) {
                    if (this.tablesTable.getValueAt(n2, n) instanceof JButton) {
                        jButton = (JButton)this.tablesTable.getValueAt(n2, n);
                        if (jButton.getText().equals(CHECKED)) {
                            permissionsSqlServer.setPrivileges(this.tablesTable.getColumnName(n));
                            continue;
                        }
                        if (!jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
                        permissionsSqlServer.setPrivilegesWithGrantOption(this.tablesTable.getColumnName(n));
                        continue;
                    }
                    if (!(this.tablesTable.getValueAt(n2, n) instanceof RoleSqlServer) || permissionsSqlServer == null) continue;
                    roleSqlServer = (RoleSqlServer)this.tablesTable.getValueAt(n2, n);
                    permissionsSqlServer.setAsRole(roleSqlServer);
                }
                continue;
            }
            if (permissionsSqlServer == null) continue;
            this.storageDesign.getPermissionsSet().remove(permissionsSqlServer);
        }
        for (n2 = 0; n2 < this.viewsTable.getRowCount(); ++n2) {
            relationalObjectProxy = (TableViewProxySqlServer)this.viewsTable.getValueAt(n2, 0);
            permissionsSqlServer = this.getPermission(this.storageObject, relationalObjectProxy);
            if (this.hasSelectedViewPrivileges(n2)) {
                if (permissionsSqlServer == null) {
                    permissionsSqlServer = this.storageDesign.getPermissionsSet().createPermissions();
                    permissionsSqlServer.setView((TableViewProxySqlServer)relationalObjectProxy);
                    if (this.storageObject instanceof UserSqlServer) {
                        permissionsSqlServer.setUser((UserSqlServer)this.storageObject);
                    } else if (this.storageObject instanceof RoleSqlServer) {
                        permissionsSqlServer.setRole((RoleSqlServer)this.storageObject);
                    }
                }
                permissionsSqlServer.clear();
                for (n = 0; n < this.viewsTable.getColumnCount(); ++n) {
                    if (this.viewsTable.getValueAt(n2, n) instanceof JButton) {
                        jButton = (JButton)this.viewsTable.getValueAt(n2, n);
                        if (jButton.getText().equals(CHECKED)) {
                            permissionsSqlServer.setPrivileges(this.viewsTable.getColumnName(n));
                            continue;
                        }
                        if (!jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
                        permissionsSqlServer.setPrivilegesWithGrantOption(this.viewsTable.getColumnName(n));
                        continue;
                    }
                    if (!(this.viewsTable.getValueAt(n2, n) instanceof RoleSqlServer) || permissionsSqlServer == null) continue;
                    roleSqlServer = (RoleSqlServer)this.viewsTable.getValueAt(n2, n);
                    permissionsSqlServer.setAsRole(roleSqlServer);
                }
                continue;
            }
            if (permissionsSqlServer == null) continue;
            this.storageDesign.getPermissionsSet().remove(permissionsSqlServer);
        }
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("UserAndRolePermissionsDialogSqlServerv2k5.Permissions"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    class ButtonRoleTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton button;

        ButtonRoleTableCellEditor() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                JButton jButton = (JButton)actionEvent.getSource();
                if (jButton.getText() == null) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(CHECKED)) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(EMPTY_VALUE)) {
                    jButton.setText(CHECKED);
                }
            } else {
                this.button.setText(this.button.getText().toString());
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.button = (JButton)object;
            this.button.setOpaque(true);
            this.button.setBackground(jTable.getBackground());
            this.button.setActionCommand(EDIT);
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
            return this.button;
        }
    }

    class ButtonUserTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton button;

        ButtonUserTableCellEditor() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                JButton jButton = (JButton)actionEvent.getSource();
                if (jButton.getText() == null) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(CHECKED)) {
                    jButton.setText(CHECKED_WITH_GRANT_OPTION);
                } else if (jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(EMPTY_VALUE)) {
                    jButton.setText(CHECKED);
                }
            } else {
                this.button.setText(this.button.getText().toString());
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.button = (JButton)object;
            this.button.setOpaque(true);
            this.button.setBackground(jTable.getBackground());
            this.button.setActionCommand(EDIT);
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
            return this.button;
        }
    }

    class ButtonTableCellRenderer
    extends JButton
    implements TableCellRenderer {
        ButtonTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setBackground(jTable.getBackground());
            this.setText(object == null ? "" : "  " + ((JButton)object).getText());
            return this;
        }
    }

    class LabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setBackground(jTable.getBackground());
            this.setHorizontalAlignment(2);
            this.setText(object == null ? "" : "  " + object.toString());
            return this;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UserAndRolePermissionsDialogSqlServerv2k5.this.close();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UserAndRolePermissionsDialogSqlServerv2k5.this.setProperties();
            UserAndRolePermissionsDialogSqlServerv2k5.this.storageObject.setDirty(true);
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UserAndRolePermissionsDialogSqlServerv2k5.this.setProperties();
            UserAndRolePermissionsDialogSqlServerv2k5.this.storageObject.setDirty(true);
            UserAndRolePermissionsDialogSqlServerv2k5.this.close();
        }
    }

    public class ViewsModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return PermissionsSqlServer.getViewPrivilegesValues().length + 2;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int n) {
            String[] stringArray = PermissionsSqlServer.getViewPrivilegesValues();
            if (n == 0) {
                return Messages.getString("UserAndRolePermissionsDialogSqlServerv2k5.View");
            }
            if (n == this.getColumnCount() - 1) {
                return Messages.getString("UserAndRolePermissionsDialogSqlServerv2k5.AsRole");
            }
            for (int i = 1; i < this.getColumnCount(); ++i) {
                if (n != i) continue;
                return stringArray[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!UserAndRolePermissionsDialogSqlServerv2k5.this.isEditable()) {
                return false;
            }
            return n2 > 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }

    class ViewsTable
    extends JTable {
        ViewsModel dataModel;

        public ViewsTable() {
            this.dataModel = new ViewsModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 0 || n2 == this.getColumnCount() - 1) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                return super.getCellEditor();
            }
            if (n2 == this.getColumnCount() - 1) {
                TableViewProxySqlServer tableViewProxySqlServer;
                RoleSetSqlServer roleSetSqlServer = UserAndRolePermissionsDialogSqlServerv2k5.this.storageDesign.getRoleSet();
                Vector<Object> vector = new Vector<Object>();
                vector.addElement("");
                String string = "";
                Object object = this.getValueAt(n, 0);
                if (object instanceof TableViewProxySqlServer && (tableViewProxySqlServer = (TableViewProxySqlServer)object).getDataBase() != null) {
                    string = tableViewProxySqlServer.getDataBase().getName();
                }
                for (int i = 0; i < roleSetSqlServer.size(); ++i) {
                    String string2;
                    RoleSqlServer roleSqlServer = (RoleSqlServer)roleSetSqlServer.getElement(i);
                    String string3 = string2 = roleSqlServer.getDatabase() != null ? roleSqlServer.getDatabase().getName() : "";
                    if (!"".equals(string) && !string2.equalsIgnoreCase(string)) continue;
                    vector.addElement(roleSqlServer);
                }
                JComboBox jComboBox = new JComboBox();
                jComboBox.setModel(new DefaultComboBoxModel(vector));
                return new DefaultCellEditor(jComboBox);
            }
            if (UserAndRolePermissionsDialogSqlServerv2k5.this.storageObject instanceof UserSqlServer) {
                return new ButtonUserTableCellEditor();
            }
            return new ButtonRoleTableCellEditor();
        }
    }

    class TableTable
    extends JTable {
        TablesModel dataModel;

        public TableTable() {
            this.dataModel = new TablesModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 0 || n2 == this.getColumnCount() - 1) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                return super.getCellEditor();
            }
            if (n2 == this.getColumnCount() - 1) {
                TableProxySqlServer tableProxySqlServer;
                RoleSetSqlServer roleSetSqlServer = UserAndRolePermissionsDialogSqlServerv2k5.this.storageDesign.getRoleSet();
                Vector<Object> vector = new Vector<Object>();
                vector.addElement("");
                String string = "";
                Object object = this.getValueAt(n, 0);
                if (object instanceof TableProxySqlServer && (tableProxySqlServer = (TableProxySqlServer)object).getDatabase() != null) {
                    string = tableProxySqlServer.getDatabase().getName();
                }
                for (int i = 0; i < roleSetSqlServer.size(); ++i) {
                    String string2;
                    RoleSqlServer roleSqlServer = (RoleSqlServer)roleSetSqlServer.getElement(i);
                    String string3 = string2 = roleSqlServer.getDatabase() != null ? roleSqlServer.getDatabase().getName() : "";
                    if (!"".equals(string) && !string2.equalsIgnoreCase(string)) continue;
                    vector.addElement(roleSqlServer);
                }
                JComboBox jComboBox = new JComboBox();
                jComboBox.setModel(new DefaultComboBoxModel(vector));
                return new DefaultCellEditor(jComboBox);
            }
            if (UserAndRolePermissionsDialogSqlServerv2k5.this.storageObject instanceof UserSqlServer) {
                return new ButtonUserTableCellEditor();
            }
            return new ButtonRoleTableCellEditor();
        }
    }

    public class TablesModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return PermissionsSqlServer.getTablePrivilegesValues().length + 2;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int n) {
            String[] stringArray = PermissionsSqlServer.getTablePrivilegesValues();
            if (n == 0) {
                return Messages.getString("UserAndRolePermissionsDialogSqlServerv2k5.Table");
            }
            if (n == this.getColumnCount() - 1) {
                return Messages.getString("UserAndRolePermissionsDialogSqlServerv2k5.AsRole");
            }
            for (int i = 1; i < this.getColumnCount(); ++i) {
                if (n != i) continue;
                return stringArray[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!UserAndRolePermissionsDialogSqlServerv2k5.this.isEditable()) {
                return false;
            }
            return n2 > 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }
}

