/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import java.awt.Dimension;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StoredProcedureSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class StoredProcedurePropertyDialogSqlServerv2k5
extends AbstractSqlServerPropertyDialog {
    private StoredProcedureSqlServer proc;
    private JComboBox cbOwner;
    private JTextField tfDatabase;
    private JTextArea bodyArea;

    public StoredProcedurePropertyDialogSqlServerv2k5(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.proc = (StoredProcedureSqlServer)storageObject;
        this.setHeight(300);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("StoredProcedurePropertyDialogSqlServerv2k5.StoredProcedureProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDatabase();
        this.initOwner();
        this.initBody();
    }

    private void initDatabase() {
        JLabel jLabel = new JLabel(Messages.getString("StoredProcedurePropertyDialogSqlServerv2k5.Database"));
        this.general.add(jLabel);
        this.tfDatabase = new JTextField("", 26);
        this.tfDatabase.setEnabled(false);
        this.general.add(this.tfDatabase);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfDatabase, 50);
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("StoredProcedurePropertyDialogSqlServerv2k5.Owner"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbOwner, 80);
    }

    private void initBody() {
        JLabel jLabel = new JLabel(Messages.getString("StoredProcedurePropertyDialogSqlServerv2k5.Body"));
        this.general.add(jLabel);
        this.setLabelConstraints(jLabel, 110);
        this.bodyArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.bodyArea);
        jScrollPane.setPreferredSize(new Dimension(395, 130));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.bodyArea.setLineWrap(true);
        this.general.add(jScrollPane);
        this.setObjectConstraints(jScrollPane, 10, 130);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.proc.getName());
        this.tfName.setText(this.proc.getName());
        Iterator iterator = this.proc.getDatabase().getSchemas().iterator();
        while (iterator.hasNext()) {
            SchemaSqlServer schemaSqlServer = (SchemaSqlServer)iterator.next();
            this.cbOwner.addItem(schemaSqlServer);
        }
        this.tfDatabase.setText(this.proc.getDatabase().getName());
        this.cbOwner.setSelectedItem(this.proc.getSchema());
        this.bodyArea.setText(this.proc.getBody());
        this.getCommentsList().insert(this.proc.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.proc != null) {
            this.proc.setName(this.tfName.getText());
            this.proc.setSchema((SchemaSqlServer)this.cbOwner.getSelectedItem());
            this.proc.setBody(this.bodyArea.getText());
            this.proc.setComment(this.getCommentsList().getText());
        }
    }
}

