/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.RoleSqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5.UserAndRolePermissionsDialogSqlServerv2k5;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class RolePropertyDialogSqlServerv2k5
extends AbstractSqlServerPropertyDialog {
    private RoleSqlServerv2k5 role;
    private ButtonGroup bGroup;
    private JRadioButton rbIsApplication;
    private JRadioButton rbIsDB;
    private JPasswordField passField;
    private JComboBox cbOwner;
    private DefaultListModel allUsersModel;
    private DefaultListModel selectedUsersModel;
    private JList allUsersList;
    private JList selectedUsersList;
    private JButton bnAdd;
    private JButton bnRemove;
    private JPanel panelPrivileges;
    private JList allPrivilegesList;
    private JList selectedPrivilegesList;
    private DefaultListModel allPrivilegesModel;
    private DefaultListModel selectedPrivilegesModel;
    private JButton bnAddPrivileges;
    private JButton bnRemovePrivileges;
    private JButton bnPermissions;
    private UserAndRolePermissionsDialogSqlServerv2k5 dialog;
    private JTextField defaultSchema;

    public RolePropertyDialogSqlServerv2k5(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.role = (RoleSqlServerv2k5)storageObject;
        this.setHeight(440);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("RolePropertyDialogSqlServerv2k5.RoleProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.bGroup = new ButtonGroup();
        this.initIsApplRole();
        this.initPassword();
        this.initDefaultSchema();
        this.initIsDBRole();
        this.initUsers();
        this.initOwner();
        this.initPermissionsButton();
    }

    private void initPassword() {
        JLabel jLabel = new JLabel(Messages.getString("RolePropertyDialogSqlServerv2k5.Password"));
        this.general.add(jLabel);
        this.passField = new JPasswordField();
        this.setBG(this.passField);
        this.passField.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.passField);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.passField, 80);
    }

    private void initDefaultSchema() {
        JLabel jLabel = new JLabel(Messages.getString("RolePropertyDialogSqlServerv2k5.DefaultSchema"));
        this.general.add(jLabel);
        this.defaultSchema = new JTextField();
        this.setBG(this.defaultSchema);
        this.defaultSchema.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.defaultSchema);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.defaultSchema, 110);
    }

    private void initUsers() {
        this.initAllUsersList();
        this.initSelectedUsersList();
        this.initButtons();
    }

    private void initAllUsersList() {
        JLabel jLabel = new JLabel(Messages.getString("RolePropertyDialogSqlServerv2k5.AllUsers"));
        this.general.add(jLabel);
        this.allUsersModel = new DefaultListModel();
        this.allUsersList = new JList(this.allUsersModel);
        ListSelectionModel listSelectionModel = this.allUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allUsersList);
        jScrollPane.setPreferredSize(new Dimension(144, 120));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(jScrollPane);
        this.setLabelConstraints(this.getUsersLayout(), jLabel, 12, 214);
        this.setObjectConstraints(this.getUsersLayout(), jScrollPane, 10, 232);
    }

    private void initSelectedUsersList() {
        JLabel jLabel = new JLabel(Messages.getString("RolePropertyDialogSqlServerv2k5.SelectedUsers"));
        this.general.add(jLabel);
        this.selectedUsersModel = new DefaultListModel();
        this.selectedUsersList = new JList(this.selectedUsersModel);
        ListSelectionModel listSelectionModel = this.selectedUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedUsersList);
        jScrollPane.setPreferredSize(new Dimension(145, 120));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(jScrollPane);
        this.setLabelConstraints(this.getUsersLayout(), jLabel, 267, 214);
        this.setObjectConstraints(this.getUsersLayout(), jScrollPane, 265, 232);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("RolePropertyDialogSqlServerv2k5.Add"));
        this.bnAdd.addActionListener(new AddUsersActionListener());
        this.bnAdd.setEnabled(false);
        this.general.add(this.bnAdd);
        this.setObjectConstraints(this.getUsersLayout(), this.bnAdd, 160, 265);
        this.bnRemove = new JButton(Messages.getString("RolePropertyDialogSqlServerv2k5.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveUsersActionListener());
        this.general.add(this.bnRemove);
        this.setObjectConstraints(this.getUsersLayout(), this.bnRemove, 160, 295);
        RolePropertyDialogSqlServerv2k5.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    protected SpringLayout getUsersLayout() {
        return (SpringLayout)this.general.getLayout();
    }

    private void setIsApplication(boolean bl) {
        this.passField.setEnabled(bl);
        this.allUsersList.setEnabled(!bl);
        this.selectedUsersList.setEnabled(!bl);
        this.cbOwner.setEnabled(!bl);
        this.defaultSchema.setEnabled(bl);
    }

    private void setIsDB(boolean bl) {
        this.passField.setEnabled(!bl);
        this.allUsersList.setEnabled(bl);
        this.selectedUsersList.setEnabled(bl);
        this.cbOwner.setEnabled(bl);
        this.defaultSchema.setEnabled(!bl);
    }

    private void initIsApplRole() {
        this.rbIsApplication = new JRadioButton(Messages.getString("RolePropertyDialogSqlServerv2k5.ApplicationRole"));
        this.rbIsApplication.addActionListener(new AppRoleListener());
        this.bGroup.add(this.rbIsApplication);
        this.general.add(this.rbIsApplication);
        this.setObjectConstraints(this.rbIsApplication, 8, 50);
    }

    private void initIsDBRole() {
        this.rbIsDB = new JRadioButton(Messages.getString("RolePropertyDialogSqlServerv2k5.DatabaseRole"));
        this.rbIsDB.addActionListener(new DBRoleListener());
        this.bGroup.add(this.rbIsDB);
        this.general.add(this.rbIsDB);
        this.setObjectConstraints(this.rbIsDB, 8, 140);
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("RolePropertyDialogSqlServerv2k5.Owner"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 180);
        this.setObjectConstraints(this.cbOwner, 180);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("RolePropertyDialogSqlServerv2k5.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 370);
    }

    @Override
    protected void addTabs() {
        this.initPrivilegesView();
    }

    private void initPrivilegesView() {
        this.panelPrivileges = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("RolePropertyDialogSqlServerv2k5.Privileges"), this.panelPrivileges);
        this.initPrivileges();
    }

    private void initPrivileges() {
        this.initAllPrivilegesList();
        this.initSelectedPrivilegesList();
        this.initPrivilegesButtons();
    }

    private void initPrivilegesButtons() {
        this.bnAddPrivileges = new JButton(Messages.getString("RolePropertyDialogSqlServerv2k5.Add"));
        this.bnAddPrivileges.addActionListener(new AddPrivilegesActionListener());
        this.bnAddPrivileges.setEnabled(false);
        this.panelPrivileges.add(this.bnAddPrivileges);
        this.setObjectConstraints(this.getPrivilegesLayout(), this.bnAddPrivileges, 160, 160);
        this.bnRemovePrivileges = new JButton(Messages.getString("RolePropertyDialogSqlServerv2k5.Remove"));
        this.bnRemovePrivileges.setEnabled(false);
        this.bnRemovePrivileges.addActionListener(new RemovePrivilegesActionListener());
        this.panelPrivileges.add(this.bnRemovePrivileges);
        this.setObjectConstraints(this.getPrivilegesLayout(), this.bnRemovePrivileges, 160, 190);
        RolePropertyDialogSqlServerv2k5.equalizeButtonSizes(this.bnAddPrivileges, this.bnRemovePrivileges);
    }

    private void initAllPrivilegesList() {
        JLabel jLabel = new JLabel(Messages.getString("RolePropertyDialogSqlServerv2k5.AllPrivileges"));
        this.panelPrivileges.add(jLabel);
        this.allPrivilegesModel = new DefaultListModel();
        this.allPrivilegesList = new JList(this.allPrivilegesModel);
        ListSelectionModel listSelectionModel = this.allPrivilegesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllPrivilegesListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allPrivilegesList);
        jScrollPane.setPreferredSize(new Dimension(144, 360));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelPrivileges.add(jScrollPane);
        this.setLabelConstraints(this.getPrivilegesLayout(), jLabel, 12, 14);
        this.setObjectConstraints(this.getPrivilegesLayout(), jScrollPane, 10, 32);
    }

    private void initSelectedPrivilegesList() {
        JLabel jLabel = new JLabel(Messages.getString("RolePropertyDialogSqlServerv2k5.SelectedPrivileges"));
        this.panelPrivileges.add(jLabel);
        this.selectedPrivilegesModel = new DefaultListModel();
        this.selectedPrivilegesList = new JList(this.selectedPrivilegesModel);
        ListSelectionModel listSelectionModel = this.selectedPrivilegesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedPrivilegesListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedPrivilegesList);
        jScrollPane.setPreferredSize(new Dimension(145, 360));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelPrivileges.add(jScrollPane);
        this.setLabelConstraints(this.getPrivilegesLayout(), jLabel, 267, 14);
        this.setObjectConstraints(this.getPrivilegesLayout(), jScrollPane, 265, 32);
    }

    protected SpringLayout getPrivilegesLayout() {
        return (SpringLayout)this.panelPrivileges.getLayout();
    }

    @Override
    public void initProperties() {
        Object[] objectArray;
        this.initCaption(this.role.getName());
        this.tfName.setText(this.role.getName());
        this.rbIsApplication.setSelected(this.role.getIsApplicationRole());
        this.passField.setText(this.role.decodePassword());
        this.defaultSchema.setText(this.role.getDefaultSchema());
        this.rbIsDB.setSelected(!this.role.getIsApplicationRole());
        Iterator iterator = this.role.getDatabase().getUsers().iterator();
        while (iterator.hasNext()) {
            objectArray = (Object[])iterator.next();
            if (objectArray.getName().equalsIgnoreCase("GUEST")) continue;
            this.cbOwner.addItem(objectArray);
        }
        this.cbOwner.setSelectedItem(this.role.getOwner());
        objectArray = this.role.getDatabase().getUsers().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            UserSqlServer userSqlServer = (UserSqlServer)objectArray[i];
            if (userSqlServer.getName().equalsIgnoreCase("GUEST")) continue;
            if (this.role.getUserSet().contains(userSqlServer.getName())) {
                this.addElementToSortedListModel(this.selectedUsersModel, userSqlServer);
                continue;
            }
            this.addElementToSortedListModel(this.allUsersModel, userSqlServer);
        }
        this.passField.setEnabled(this.role.getIsApplicationRole());
        this.defaultSchema.setEnabled(this.role.getIsApplicationRole());
        this.allUsersList.setEnabled(!this.role.getIsApplicationRole());
        this.selectedUsersList.setEnabled(!this.role.getIsApplicationRole());
        this.cbOwner.setEnabled(!this.role.getIsApplicationRole());
        if (this.role.isNullInstance()) {
            this.tfName.setEnabled(false);
            this.rbIsApplication.setEnabled(false);
            this.passField.setEnabled(false);
            this.defaultSchema.setEnabled(false);
            this.rbIsDB.setEnabled(false);
            this.cbOwner.setEnabled(false);
            this.allUsersList.setEnabled(false);
            this.selectedUsersList.setEnabled(false);
            this.selectedPrivilegesList.setEnabled(false);
            this.allPrivilegesList.setEnabled(false);
        }
        String[] stringArray = (String[])UserSqlServer.getPrivilegesValues().toArray();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (this.role.getPrivilegesSet().contains(string)) {
                this.addElementToSortedListModel(this.selectedPrivilegesModel, string);
                continue;
            }
            this.addElementToSortedListModel(this.allPrivilegesModel, string);
        }
        this.getCommentsList().insert(this.role.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.role != null) {
            this.role.setName(this.tfName.getText());
            this.role.setIsApplicationRole(this.rbIsApplication.isSelected());
            this.role.encodePassword(String.valueOf(this.passField.getPassword()));
            this.role.setDefaultSchema(this.defaultSchema.getText());
            this.role.setOwner((UserSqlServer)this.cbOwner.getSelectedItem());
            Object[] objectArray = this.selectedUsersModel.toArray();
            this.role.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (!(object instanceof UserSqlServer)) continue;
                this.role.setUsers(((UserSqlServer)object).getName());
            }
            Object[] objectArray2 = this.selectedPrivilegesModel.toArray();
            for (int i = 0; i < objectArray2.length; ++i) {
                Object object = objectArray2[i];
                if (!(object instanceof String)) continue;
                this.role.setSystemPrivileges((String)object);
            }
            this.role.setComment(this.getCommentsList().getText());
        }
    }

    private class SelectedPrivilegesListSelectionHandler
    implements ListSelectionListener {
        private SelectedPrivilegesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (RolePropertyDialogSqlServerv2k5.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (RolePropertyDialogSqlServerv2k5.this.selectedPrivilegesList.getSelectedIndex() == -1) {
                    RolePropertyDialogSqlServerv2k5.this.bnRemovePrivileges.setEnabled(false);
                } else {
                    RolePropertyDialogSqlServerv2k5.this.bnRemovePrivileges.setEnabled(true);
                }
            }
        }
    }

    private class AllPrivilegesListSelectionHandler
    implements ListSelectionListener {
        private AllPrivilegesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (RolePropertyDialogSqlServerv2k5.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (RolePropertyDialogSqlServerv2k5.this.allPrivilegesList.getSelectedIndex() == -1) {
                    RolePropertyDialogSqlServerv2k5.this.bnAddPrivileges.setEnabled(false);
                } else {
                    RolePropertyDialogSqlServerv2k5.this.bnAddPrivileges.setEnabled(true);
                }
            }
        }
    }

    private class RemovePrivilegesActionListener
    implements ActionListener {
        private RemovePrivilegesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!RolePropertyDialogSqlServerv2k5.this.selectedPrivilegesModel.isEmpty()) {
                Object[] objectArray = RolePropertyDialogSqlServerv2k5.this.selectedPrivilegesList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (RolePropertyDialogSqlServerv2k5.this.allPrivilegesModel.contains(object)) continue;
                    RolePropertyDialogSqlServerv2k5.this.addElementToSortedListModel(RolePropertyDialogSqlServerv2k5.this.allPrivilegesModel, object);
                    RolePropertyDialogSqlServerv2k5.this.selectedPrivilegesModel.removeElement(object);
                }
            }
        }
    }

    private class AddPrivilegesActionListener
    implements ActionListener {
        private AddPrivilegesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!RolePropertyDialogSqlServerv2k5.this.allPrivilegesModel.isEmpty()) {
                Object[] objectArray = RolePropertyDialogSqlServerv2k5.this.allPrivilegesList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (RolePropertyDialogSqlServerv2k5.this.selectedPrivilegesModel.contains(object)) continue;
                    RolePropertyDialogSqlServerv2k5.this.addElementToSortedListModel(RolePropertyDialogSqlServerv2k5.this.selectedPrivilegesModel, object);
                    RolePropertyDialogSqlServerv2k5.this.allPrivilegesModel.removeElement(object);
                }
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (RolePropertyDialogSqlServerv2k5.this.dialog == null) {
                RolePropertyDialogSqlServerv2k5.this.dialog = new UserAndRolePermissionsDialogSqlServerv2k5(RolePropertyDialogSqlServerv2k5.this.getAppView(), RolePropertyDialogSqlServerv2k5.this.getStorageDesign(), RolePropertyDialogSqlServerv2k5.this.role);
            }
            RolePropertyDialogSqlServerv2k5.this.dialog.showDialog();
        }
    }

    private class DBRoleListener
    implements ActionListener {
        private DBRoleListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RolePropertyDialogSqlServerv2k5.this.setIsDB(RolePropertyDialogSqlServerv2k5.this.rbIsDB.isSelected());
        }
    }

    private class AppRoleListener
    implements ActionListener {
        private AppRoleListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RolePropertyDialogSqlServerv2k5.this.setIsApplication(RolePropertyDialogSqlServerv2k5.this.rbIsApplication.isSelected());
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (RolePropertyDialogSqlServerv2k5.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (RolePropertyDialogSqlServerv2k5.this.selectedUsersList.getSelectedIndex() == -1) {
                    RolePropertyDialogSqlServerv2k5.this.bnRemove.setEnabled(false);
                } else {
                    RolePropertyDialogSqlServerv2k5.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (RolePropertyDialogSqlServerv2k5.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (RolePropertyDialogSqlServerv2k5.this.allUsersList.getSelectedIndex() == -1) {
                    RolePropertyDialogSqlServerv2k5.this.bnAdd.setEnabled(false);
                } else {
                    RolePropertyDialogSqlServerv2k5.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveUsersActionListener
    implements ActionListener {
        private RemoveUsersActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!RolePropertyDialogSqlServerv2k5.this.selectedUsersModel.isEmpty()) {
                Object[] objectArray = RolePropertyDialogSqlServerv2k5.this.selectedUsersList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (RolePropertyDialogSqlServerv2k5.this.allUsersModel.contains(object)) continue;
                    RolePropertyDialogSqlServerv2k5.this.addElementToSortedListModel(RolePropertyDialogSqlServerv2k5.this.allUsersModel, object);
                    RolePropertyDialogSqlServerv2k5.this.selectedUsersModel.removeElement(object);
                }
            }
        }
    }

    private class AddUsersActionListener
    implements ActionListener {
        private AddUsersActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!RolePropertyDialogSqlServerv2k5.this.allUsersModel.isEmpty()) {
                Object[] objectArray = RolePropertyDialogSqlServerv2k5.this.allUsersList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (RolePropertyDialogSqlServerv2k5.this.selectedUsersModel.contains(object)) continue;
                    RolePropertyDialogSqlServerv2k5.this.addElementToSortedListModel(RolePropertyDialogSqlServerv2k5.this.selectedUsersModel, object);
                    RolePropertyDialogSqlServerv2k5.this.allUsersModel.removeElement(object);
                }
            }
        }
    }
}

