/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.AbstractStorageObjectSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PermissionsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RoleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableViewProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5.ColumnsPermissionsDialogSqlServerv2k5;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class PermissionsPropertiesDialogSqlServerv2k5
extends JDialog
implements AbstractEditorConstants {
    private static String EMPTY_VALUE = "";
    private static String CHECKED = "v";
    private static String CHECKED_WITH_GRANT_OPTION = "v->";
    protected static final String EDIT = Messages.getString("PermissionsPropertiesDialogSqlServerv2k5.Edit");
    private static String COLUMN_CHECKED = "c";
    private StorageObject storageObject;
    private JPanel objectsPanel;
    private UserSetSqlServer usersSet;
    private RoleSetSqlServer rolesSet;
    private ApplicationView appView;
    private StorageDesignSqlServer storageDesign;
    private JButton bnCancel;
    private JTabbedPane tpane;
    private JPanel jpanel;
    private ColumnsPermissionsDialogSqlServerv2k5 dialog;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PermissionsPropertiesDialogSqlServerv2k5.this.bnCancel.doClick();
        }
    };
    private UsersTable usersTable;
    private RolesTable rolesTable;

    public PermissionsPropertiesDialogSqlServerv2k5(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView.getFrame());
        JButton jButton;
        this.appView = applicationView;
        this.storageDesign = (StorageDesignSqlServer)storageDesign;
        this.storageObject = storageObject;
        this.storageObject.setDialogVisible(true, this);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                PermissionsPropertiesDialogSqlServerv2k5.this.storageObject.setDialogVisible(false, null);
            }
        });
        this.jpanel = new JPanel(new BorderLayout());
        this.jpanel.add((Component)this.getTabbedPane(), "Center");
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel();
        if (this.storageObject instanceof TableProxySqlServer) {
            jButton = new JButton(Messages.getString("PermissionsPropertiesDialogSqlServerv2k5.Columns"));
            jButton.addActionListener(new ColumnsPermissionsListener(this));
            jButton.setCursor(Cursor.getPredefinedCursor(12));
            jButton.setMnemonic(79);
            jPanel.add((Component)jButton, "Before");
        }
        jButton = new JButton(Messages.getString("PermissionsPropertiesDialogSqlServerv2k5.OK"));
        jButton.addActionListener(new OKAction());
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setMnemonic(79);
        jPanel.add(jButton);
        this.getRootPane().setDefaultButton(jButton);
        JButton jButton2 = new JButton(Messages.getString("PermissionsPropertiesDialogSqlServerv2k5.Apply"));
        jButton2.addActionListener(new ApplyAction());
        jButton2.setCursor(Cursor.getPredefinedCursor(12));
        jButton2.setMnemonic(65);
        jPanel.add(jButton2);
        this.bnCancel = new JButton(Messages.getString("PermissionsPropertiesDialogSqlServerv2k5.Cancel"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setCursor(Cursor.getPredefinedCursor(12));
        AbstractPropertyDialog.equalizeButtonSizes(jButton2, this.bnCancel);
        AbstractPropertyDialog.equalizeButtonSizes(jButton, this.bnCancel);
        int n = 1;
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        jComponent.getActionMap().put("ESCAPE", this.escape);
        jPanel.add(this.bnCancel);
        this.jpanel.add((Component)jPanel, "South");
        this.getContentPane().add(this.jpanel);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.addTabs();
        this.initProperties();
        this.setModal(true);
    }

    public void initProperties() {
        int n;
        AbstractStorageObjectSqlServer abstractStorageObjectSqlServer;
        int n2;
        for (n2 = 0; n2 < this.usersTable.getRowCount(); ++n2) {
            abstractStorageObjectSqlServer = (UserSqlServer)this.usersTable.getValueAt(n2, 0);
            for (n = 0; n < this.usersTable.getColumnCount(); ++n) {
                if (this.usersTable.getValueAt(n2, n) instanceof JButton) {
                    JButton jButton = (JButton)this.usersTable.getValueAt(n2, n);
                    if (this.getPermission(abstractStorageObjectSqlServer, this.storageObject) != null) {
                        if (this.getPermission(abstractStorageObjectSqlServer, this.storageObject).getPrivileges().indexOf(this.usersTable.getColumnName(n)) > -1) {
                            jButton.setText(CHECKED);
                            jButton.updateUI();
                            continue;
                        }
                        if (this.getPermission(abstractStorageObjectSqlServer, this.storageObject).getPrivilegesWithGrantOption().indexOf(this.usersTable.getColumnName(n)) > -1) {
                            jButton.setText(CHECKED_WITH_GRANT_OPTION);
                            jButton.updateUI();
                            continue;
                        }
                        if (this.getPermission(abstractStorageObjectSqlServer, this.storageObject).hasColPrivilege(this.usersTable.getColumnName(n))) {
                            jButton.setText(COLUMN_CHECKED);
                            jButton.updateUI();
                            continue;
                        }
                        jButton.setText(EMPTY_VALUE);
                        jButton.updateUI();
                        continue;
                    }
                    jButton.setText(EMPTY_VALUE);
                    jButton.updateUI();
                    continue;
                }
                if (n != this.usersTable.getColumnCount() - 1 || this.getPermission(abstractStorageObjectSqlServer, this.storageObject) == null) continue;
                if (this.getPermission(abstractStorageObjectSqlServer, this.storageObject).getAsRole() != null) {
                    this.usersTable.setValueAt(this.getPermission(abstractStorageObjectSqlServer, this.storageObject).getAsRole(), n2, n);
                    continue;
                }
                this.usersTable.setValueAt("", n2, n);
            }
        }
        for (n2 = 0; n2 < this.rolesTable.getRowCount(); ++n2) {
            abstractStorageObjectSqlServer = (RoleSqlServer)this.rolesTable.getValueAt(n2, 0);
            for (n = 0; n < this.rolesTable.getColumnCount(); ++n) {
                if (this.rolesTable.getValueAt(n2, n) instanceof JButton) {
                    JButton jButton = (JButton)this.rolesTable.getValueAt(n2, n);
                    if (this.getPermission(abstractStorageObjectSqlServer, this.storageObject) != null) {
                        if (this.getPermission(abstractStorageObjectSqlServer, this.storageObject).getPrivileges().indexOf(this.rolesTable.getColumnName(n)) > -1) {
                            jButton.setText(CHECKED);
                            jButton.updateUI();
                            continue;
                        }
                        if (this.getPermission(abstractStorageObjectSqlServer, this.storageObject).hasColPrivilege(this.rolesTable.getColumnName(n))) {
                            jButton.setText(COLUMN_CHECKED);
                            jButton.updateUI();
                            continue;
                        }
                        jButton.setText(EMPTY_VALUE);
                        jButton.updateUI();
                        continue;
                    }
                    jButton.setText(EMPTY_VALUE);
                    jButton.updateUI();
                    continue;
                }
                if (n != this.rolesTable.getColumnCount() - 1 || this.getPermission(abstractStorageObjectSqlServer, this.storageObject) == null) continue;
                if (this.getPermission(abstractStorageObjectSqlServer, this.storageObject).getAsRole() != null) {
                    this.rolesTable.setValueAt(this.getPermission(abstractStorageObjectSqlServer, this.storageObject).getAsRole(), n2, n);
                    continue;
                }
                this.rolesTable.setValueAt("", n2, n);
            }
        }
    }

    protected void addTabs() {
        this.initUsersTable();
        this.initRolesTable();
    }

    private void initRolesTable() {
        this.rolesSet = this.storageDesign.getRoleSet();
        this.rolesTable = new RolesTable();
        this.rolesTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.rolesTable);
        jScrollPane.setPreferredSize(new Dimension(800, 280));
        jScrollPane.setHorizontalScrollBar(new JScrollBar());
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.objectsPanel = new JPanel();
        this.objectsPanel.add(jScrollPane);
        this.getTabbedPane().addTab(Messages.getString("PermissionsPropertiesDialogSqlServerv2k5.Roles"), this.objectsPanel);
        this.rolesTable.updateUI();
        RolesModel rolesModel = (RolesModel)this.rolesTable.getModel();
        for (int i = 0; i < this.rolesSet.size(); ++i) {
            RoleSqlServer roleSqlServer = (RoleSqlServer)this.rolesSet.getElement(i);
            String[] stringArray = this.storageObject instanceof TableProxySqlServer ? (String[])PermissionsSqlServer.getTablePermissionsValues().toArray() : (String[])PermissionsSqlServer.getViewPermissionsValues().toArray();
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(roleSqlServer);
            for (int j = 0; j < stringArray.length; ++j) {
                JButton jButton = new JButton();
                vector.addElement(jButton);
            }
            Object[] objectArray = vector.toArray();
            rolesModel.addRow(objectArray);
        }
    }

    private JTabbedPane getTabbedPane() {
        if (this.tpane == null) {
            this.tpane = new JTabbedPane();
            this.tpane.setPreferredSize(new Dimension(820, 320));
            this.tpane.setTabPlacement(3);
        }
        return this.tpane;
    }

    private void initUsersTable() {
        this.usersSet = this.storageDesign.getUserSet();
        if (this.storageObject instanceof TableProxySqlServer) {
            if (((TableProxySqlServer)this.storageObject).getUser() != null) {
                this.usersSet.remove(((TableProxySqlServer)this.storageObject).getUser());
            }
        } else if (this.storageObject instanceof TableViewProxySqlServer && ((TableViewProxySqlServer)this.storageObject).getUser() != null) {
            this.usersSet.remove(((TableViewProxySqlServer)this.storageObject).getUser());
        }
        this.usersTable = new UsersTable();
        this.usersTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.usersTable);
        jScrollPane.setPreferredSize(new Dimension(800, 280));
        jScrollPane.setHorizontalScrollBar(new JScrollBar());
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.objectsPanel = new JPanel();
        this.objectsPanel.add(jScrollPane);
        this.getTabbedPane().addTab(Messages.getString("PermissionsPropertiesDialogSqlServerv2k5.Users"), this.objectsPanel);
        this.usersTable.updateUI();
        UsersModel usersModel = (UsersModel)this.usersTable.getModel();
        for (int i = 0; i < this.usersSet.size(); ++i) {
            UserSqlServer userSqlServer = (UserSqlServer)this.usersSet.getElement(i);
            String[] stringArray = this.storageObject instanceof TableProxySqlServer ? (String[])PermissionsSqlServer.getTablePermissionsValues().toArray() : (String[])PermissionsSqlServer.getViewPermissionsValues().toArray();
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(userSqlServer);
            for (int j = 0; j < stringArray.length; ++j) {
                JButton jButton = new JButton();
                vector.addElement(jButton);
            }
            Object[] objectArray = vector.toArray();
            usersModel.addRow(objectArray);
        }
    }

    protected void setProperties() {
        RoleSqlServer roleSqlServer;
        JButton jButton;
        int n;
        PermissionsSqlServer permissionsSqlServer;
        AbstractStorageObjectSqlServer abstractStorageObjectSqlServer;
        int n2;
        for (n2 = 0; n2 < this.usersTable.getRowCount(); ++n2) {
            abstractStorageObjectSqlServer = (UserSqlServer)this.usersTable.getValueAt(n2, 0);
            permissionsSqlServer = this.getPermission(abstractStorageObjectSqlServer, this.storageObject);
            if (this.hasSelectedUserPrivileges(n2)) {
                if (permissionsSqlServer == null) {
                    permissionsSqlServer = this.storageDesign.getPermissionsSet().createPermissions();
                    permissionsSqlServer.setUser((UserSqlServer)abstractStorageObjectSqlServer);
                    if (this.storageObject instanceof TableProxySqlServer) {
                        permissionsSqlServer.setTable((TableProxySqlServer)this.storageObject);
                    } else if (this.storageObject instanceof TableViewProxySqlServer) {
                        permissionsSqlServer.setView((TableViewProxySqlServer)this.storageObject);
                    }
                }
                permissionsSqlServer.clear();
                for (n = 0; n < this.usersTable.getColumnCount(); ++n) {
                    if (this.usersTable.getValueAt(n2, n) instanceof JButton) {
                        jButton = (JButton)this.usersTable.getValueAt(n2, n);
                        if (jButton.getText().equals(CHECKED)) {
                            permissionsSqlServer.setPrivileges(this.usersTable.getColumnName(n));
                            continue;
                        }
                        if (!jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
                        permissionsSqlServer.setPrivilegesWithGrantOption(this.usersTable.getColumnName(n));
                        continue;
                    }
                    if (!(this.usersTable.getValueAt(n2, n) instanceof RoleSqlServer) || this.getPermission(abstractStorageObjectSqlServer, this.storageObject) == null) continue;
                    roleSqlServer = (RoleSqlServer)this.usersTable.getValueAt(n2, n);
                    this.getPermission(abstractStorageObjectSqlServer, this.storageObject).setAsRole(roleSqlServer);
                }
                continue;
            }
            if (permissionsSqlServer == null) continue;
            this.storageDesign.getPermissionsSet().remove(permissionsSqlServer);
        }
        for (n2 = 0; n2 < this.rolesTable.getRowCount(); ++n2) {
            abstractStorageObjectSqlServer = (RoleSqlServer)this.rolesTable.getValueAt(n2, 0);
            permissionsSqlServer = this.getPermission(abstractStorageObjectSqlServer, this.storageObject);
            if (this.hasSelectedRolePrivileges(n2)) {
                if (permissionsSqlServer == null) {
                    permissionsSqlServer = this.storageDesign.getPermissionsSet().createPermissions();
                    permissionsSqlServer.setRole((RoleSqlServer)abstractStorageObjectSqlServer);
                    if (this.storageObject instanceof TableProxySqlServer) {
                        permissionsSqlServer.setTable((TableProxySqlServer)this.storageObject);
                    } else if (this.storageObject instanceof TableViewProxySqlServer) {
                        permissionsSqlServer.setView((TableViewProxySqlServer)this.storageObject);
                    }
                }
                permissionsSqlServer.clear();
                for (n = 0; n < this.rolesTable.getColumnCount(); ++n) {
                    if (this.rolesTable.getValueAt(n2, n) instanceof JButton) {
                        jButton = (JButton)this.rolesTable.getValueAt(n2, n);
                        if (jButton.getText().equals(CHECKED)) {
                            permissionsSqlServer.setPrivileges(this.rolesTable.getColumnName(n));
                            continue;
                        }
                        if (!jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
                        permissionsSqlServer.setPrivilegesWithGrantOption(this.rolesTable.getColumnName(n));
                        continue;
                    }
                    if (!(this.rolesTable.getValueAt(n2, n) instanceof RoleSqlServer) || this.getPermission(abstractStorageObjectSqlServer, this.storageObject) == null) continue;
                    roleSqlServer = (RoleSqlServer)this.rolesTable.getValueAt(n2, n);
                    this.getPermission(abstractStorageObjectSqlServer, this.storageObject).setAsRole(roleSqlServer);
                }
                continue;
            }
            if (permissionsSqlServer == null) continue;
            this.storageDesign.getPermissionsSet().remove(permissionsSqlServer);
        }
    }

    public String getCaption() {
        return Messages.getString("PermissionsPropertiesDialogSqlServerv2k5.Permissions");
    }

    public UserSetSqlServer getUsersSet() {
        return this.usersSet;
    }

    private PermissionsSqlServer getPermission(StorageObject storageObject, StorageObject storageObject2) {
        Iterator iterator = this.storageDesign.getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsSqlServer permissionsSqlServer = (PermissionsSqlServer)iterator.next();
            if (permissionsSqlServer.getUser() != storageObject && permissionsSqlServer.getRole() != storageObject || permissionsSqlServer.getTable() != storageObject2 && permissionsSqlServer.getView() != storageObject2) continue;
            return permissionsSqlServer;
        }
        return null;
    }

    private boolean hasSelectedUserPrivileges(int n) {
        for (int i = 1; i < this.usersTable.getColumnCount(); ++i) {
            if (!(this.usersTable.getValueAt(n, i) instanceof JButton)) continue;
            JButton jButton = (JButton)this.usersTable.getValueAt(n, i);
            if (jButton.getText().equals(CHECKED)) {
                return true;
            }
            if (jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                return true;
            }
            if (!jButton.getText().equals(COLUMN_CHECKED)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSelectedRolePrivileges(int n) {
        for (int i = 1; i < this.rolesTable.getColumnCount(); ++i) {
            if (!(this.rolesTable.getValueAt(n, i) instanceof JButton)) continue;
            JButton jButton = (JButton)this.rolesTable.getValueAt(n, i);
            if (jButton.getText().equals(CHECKED)) {
                return true;
            }
            if (jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                return true;
            }
            if (!jButton.getText().equals(COLUMN_CHECKED)) continue;
            return true;
        }
        return false;
    }

    public void setColumnPermissions(StorageObject storageObject, String string) {
        block5: {
            int n;
            int n2;
            block4: {
                int n3;
                n2 = 0;
                if (!(storageObject instanceof UserSqlServer)) break block4;
                for (n3 = 0; n3 < this.usersTable.getRowCount(); ++n3) {
                    if (this.usersTable.getValueAt(n3, 0) != storageObject) continue;
                    n2 = n3;
                    break;
                }
                for (n3 = 1; n3 < this.usersTable.getColumnCount(); ++n3) {
                    if (!((UsersModel)this.usersTable.getModel()).getColumnName(n3).equalsIgnoreCase(string)) continue;
                    JButton jButton = (JButton)this.usersTable.getValueAt(n2, n3);
                    jButton.setText(COLUMN_CHECKED);
                    this.usersTable.updateUI();
                }
                break block5;
            }
            if (!(storageObject instanceof RoleSqlServer)) break block5;
            for (n = 0; n < this.rolesTable.getRowCount(); ++n) {
                if (this.rolesTable.getValueAt(n, 0) != storageObject) continue;
                n2 = n;
                break;
            }
            for (n = 1; n < this.rolesTable.getColumnCount(); ++n) {
                if (!((RolesModel)this.rolesTable.getModel()).getColumnName(n).equalsIgnoreCase(string)) continue;
                JButton jButton = (JButton)this.rolesTable.getValueAt(n2, n);
                jButton.setText(COLUMN_CHECKED);
                this.rolesTable.updateUI();
            }
        }
    }

    public void clearColumnPermissions(StorageObject storageObject, String string) {
        block5: {
            int n;
            int n2;
            block4: {
                int n3;
                n2 = 0;
                if (!(storageObject instanceof UserSqlServer)) break block4;
                for (n3 = 0; n3 < this.usersTable.getRowCount(); ++n3) {
                    if (this.usersTable.getValueAt(n3, 0) != storageObject) continue;
                    n2 = n3;
                    break;
                }
                for (n3 = 1; n3 < this.usersTable.getColumnCount(); ++n3) {
                    JButton jButton;
                    if (!((UsersModel)this.usersTable.getModel()).getColumnName(n3).equalsIgnoreCase(string) || !(jButton = (JButton)this.usersTable.getValueAt(n2, n3)).getText().equalsIgnoreCase(COLUMN_CHECKED)) continue;
                    jButton.setText(EMPTY_VALUE);
                }
                break block5;
            }
            if (!(storageObject instanceof RoleSqlServer)) break block5;
            for (n = 0; n < this.rolesTable.getRowCount(); ++n) {
                if (this.rolesTable.getValueAt(n, 0) != storageObject) continue;
                n2 = n;
                break;
            }
            for (n = 1; n < this.rolesTable.getColumnCount(); ++n) {
                JButton jButton;
                if (!((RolesModel)this.rolesTable.getModel()).getColumnName(n).equalsIgnoreCase(string) || !(jButton = (JButton)this.rolesTable.getValueAt(n2, n)).getText().equalsIgnoreCase(COLUMN_CHECKED)) continue;
                jButton.setText(EMPTY_VALUE);
            }
        }
    }

    class ButtonRoleTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton button;

        ButtonRoleTableCellEditor() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                JButton jButton = (JButton)actionEvent.getSource();
                if (jButton.getText() == null) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(CHECKED)) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(EMPTY_VALUE)) {
                    jButton.setText(CHECKED);
                }
            } else {
                this.button.setText(this.button.getText().toString());
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.button = (JButton)object;
            if (this.button != null) {
                this.button.setOpaque(true);
                this.button.setBackground(jTable.getBackground());
                this.button.setActionCommand(EDIT);
                this.button.addActionListener(this);
                this.button.setBorderPainted(true);
                return this.button;
            }
            return null;
        }
    }

    class ButtonUserTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton button;

        ButtonUserTableCellEditor() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                JButton jButton = (JButton)actionEvent.getSource();
                if (jButton.getText() == null) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(CHECKED)) {
                    jButton.setText(CHECKED_WITH_GRANT_OPTION);
                } else if (jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(EMPTY_VALUE)) {
                    jButton.setText(CHECKED);
                }
            } else {
                this.button.setText(this.button.getText().toString());
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.button = (JButton)object;
            if (this.button != null) {
                this.button.setOpaque(true);
                this.button.setBackground(jTable.getBackground());
                this.button.setActionCommand(EDIT);
                this.button.addActionListener(this);
                this.button.setBorderPainted(true);
                return this.button;
            }
            return null;
        }
    }

    class ButtonTableCellRenderer
    extends JButton
    implements TableCellRenderer {
        ButtonTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.setText(object == null ? "" : "  " + ((JButton)object).getText());
            return this;
        }
    }

    class LabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.setHorizontalAlignment(2);
            this.setText(object == null ? "" : "  " + object.toString());
            return this;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PermissionsPropertiesDialogSqlServerv2k5.this.dispose();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PermissionsPropertiesDialogSqlServerv2k5.this.setProperties();
            PermissionsPropertiesDialogSqlServerv2k5.this.storageObject.setDirty(true);
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PermissionsPropertiesDialogSqlServerv2k5.this.setProperties();
            PermissionsPropertiesDialogSqlServerv2k5.this.storageObject.setDirty(true);
            PermissionsPropertiesDialogSqlServerv2k5.this.dispose();
        }
    }

    private class ColumnsPermissionsListener
    implements ActionListener {
        PermissionsPropertiesDialogSqlServerv2k5 permDialog;

        public ColumnsPermissionsListener(PermissionsPropertiesDialogSqlServerv2k5 permissionsPropertiesDialogSqlServerv2k52) {
            this.permDialog = permissionsPropertiesDialogSqlServerv2k52;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StorageObject storageObject = null;
            if (PermissionsPropertiesDialogSqlServerv2k5.this.tpane.getSelectedIndex() == 0) {
                if (PermissionsPropertiesDialogSqlServerv2k5.this.usersTable.getSelectedRow() > -1) {
                    storageObject = (StorageObject)PermissionsPropertiesDialogSqlServerv2k5.this.usersTable.getValueAt(PermissionsPropertiesDialogSqlServerv2k5.this.usersTable.getSelectedRow(), 0);
                }
            } else if (PermissionsPropertiesDialogSqlServerv2k5.this.rolesTable.getSelectedRow() > -1) {
                storageObject = (StorageObject)PermissionsPropertiesDialogSqlServerv2k5.this.rolesTable.getValueAt(PermissionsPropertiesDialogSqlServerv2k5.this.rolesTable.getSelectedRow(), 0);
            }
            if (storageObject != null && (PermissionsPropertiesDialogSqlServerv2k5.this.dialog == null || PermissionsPropertiesDialogSqlServerv2k5.this.dialog.getUser() != storageObject)) {
                PermissionsPropertiesDialogSqlServerv2k5.this.dialog = new ColumnsPermissionsDialogSqlServerv2k5(PermissionsPropertiesDialogSqlServerv2k5.this.appView, PermissionsPropertiesDialogSqlServerv2k5.this.storageDesign, PermissionsPropertiesDialogSqlServerv2k5.this.storageObject, storageObject, this.permDialog);
            }
            if (PermissionsPropertiesDialogSqlServerv2k5.this.dialog != null) {
                PermissionsPropertiesDialogSqlServerv2k5.this.dialog.show();
            }
        }
    }

    public class RolesModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            String[] stringArray = PermissionsPropertiesDialogSqlServerv2k5.this.storageObject instanceof TableProxySqlServer ? PermissionsSqlServer.getTablePrivilegesValues() : PermissionsSqlServer.getViewPrivilegesValues();
            return stringArray.length + 2;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int n) {
            Object[] objectArray = PermissionsPropertiesDialogSqlServerv2k5.this.storageObject instanceof TableProxySqlServer ? PermissionsSqlServer.getTablePermissionsValues().toArray() : PermissionsSqlServer.getViewPermissionsValues().toArray();
            if (n == 0) {
                return Messages.getString("PermissionsPropertiesDialogSqlServerv2k5.Role");
            }
            if (n == this.getColumnCount() - 1) {
                return Messages.getString("PermissionsPropertiesDialogSqlServerv2k5.AsRole");
            }
            for (int i = 1; i < this.getColumnCount() - 1; ++i) {
                if (n != i) continue;
                return objectArray[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }

    class RolesTable
    extends JTable {
        RolesModel dataModel;

        public RolesTable() {
            this.dataModel = new RolesModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 0 || n2 == this.getColumnCount() - 1) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                return super.getCellEditor();
            }
            if (n2 == this.getColumnCount() - 1) {
                RoleSetSqlServer roleSetSqlServer = PermissionsPropertiesDialogSqlServerv2k5.this.storageDesign.getRoleSet();
                Vector<Object> vector = new Vector<Object>();
                vector.addElement("");
                for (int i = 0; i < roleSetSqlServer.size(); ++i) {
                    if (((RoleSqlServer)roleSetSqlServer.getElement(i)).getName().equalsIgnoreCase("PUBLIC")) continue;
                    vector.addElement(roleSetSqlServer.getElement(i));
                }
                JComboBox jComboBox = new JComboBox();
                jComboBox.setModel(new DefaultComboBoxModel(vector));
                return new DefaultCellEditor(jComboBox);
            }
            return new ButtonRoleTableCellEditor();
        }
    }

    class UsersTable
    extends JTable {
        UsersModel dataModel;

        public UsersTable() {
            this.dataModel = new UsersModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 0 || n2 == this.getColumnCount() - 1) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                return super.getCellEditor();
            }
            if (n2 == this.getColumnCount() - 1) {
                RoleSetSqlServer roleSetSqlServer = PermissionsPropertiesDialogSqlServerv2k5.this.storageDesign.getRoleSet();
                Vector<Object> vector = new Vector<Object>();
                vector.addElement("");
                for (int i = 0; i < roleSetSqlServer.size(); ++i) {
                    if (((RoleSqlServer)roleSetSqlServer.getElement(i)).getName().equalsIgnoreCase("PUBLIC")) continue;
                    vector.addElement(roleSetSqlServer.getElement(i));
                }
                JComboBox jComboBox = new JComboBox();
                jComboBox.setModel(new DefaultComboBoxModel(vector));
                return new DefaultCellEditor(jComboBox);
            }
            return new ButtonUserTableCellEditor();
        }
    }

    public class UsersModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            Object[] objectArray = PermissionsPropertiesDialogSqlServerv2k5.this.storageObject instanceof TableProxySqlServer ? PermissionsSqlServer.getTablePermissionsValues().toArray() : PermissionsSqlServer.getViewPermissionsValues().toArray();
            return objectArray.length + 2;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int n) {
            Object[] objectArray = PermissionsPropertiesDialogSqlServerv2k5.this.storageObject instanceof TableProxySqlServer ? PermissionsSqlServer.getTablePermissionsValues().toArray() : PermissionsSqlServer.getViewPermissionsValues().toArray();
            if (n == 0) {
                return Messages.getString("PermissionsPropertiesDialogSqlServerv2k5.User");
            }
            if (n == this.getColumnCount() - 1) {
                return Messages.getString("PermissionsPropertiesDialogSqlServerv2k5.AsRole");
            }
            for (int i = 1; i < this.getColumnCount() - 1; ++i) {
                if (n != i) continue;
                return objectArray[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }
}

