/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.ConstantsSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.IndexOnViewSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class IndexOnViewPropertyDialogSqlServerv2k5
extends AbstractSqlServerPropertyDialog {
    private IndexOnViewSqlServer index;
    private JTextField tfView;
    private JComboBox cbUnique;
    private JComboBox cbClustered;
    private JComboBox cbFilegroup;
    private JComboBox cbPadIndex;
    private JComboBox cbRecomputeStatistics;
    private JComboBox cbSortInTempDB;
    private JComboBox cbIgnoreDupKey;
    private JIntegerField ifFillFactor;
    private JPanel columns;
    private DefaultListModel allColumnsModel;
    private JList allColumnsList;
    private JButton bnAdd;
    private JButton bnRemove;
    private JTable selectedColumnsTable;
    private IndexTableModel selectedColumnsModel;
    private JPanel panelExtProperties;
    private JTable extProperties;
    private JButton bnAddProperty;
    private JButton bnRemoveProperty;
    private ExtPropertiesModel model;

    public IndexOnViewPropertyDialogSqlServerv2k5(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.index = (IndexOnViewSqlServer)storageObject;
        this.setHeight(350);
        this.initCommentsView(140);
        this.initCommentsInRDBMS(140);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.IndexProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initView();
        this.initUnique();
        this.initClustered();
        this.initFileGroup();
        this.initPadIndex();
        this.initFillFactor();
        this.initRecomputeStatistics();
        this.initSortInTempDB();
        this.initIgnoreDupKey();
    }

    private void initView() {
        JLabel jLabel = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.View"));
        this.general.add(jLabel);
        this.tfView = new JTextField("", 26);
        this.tfView.setEditable(false);
        this.general.add(this.tfView);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfView, 50);
    }

    private void initUnique() {
        JLabel jLabel = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.Unique"));
        this.general.add(jLabel);
        this.cbUnique = new JComboBox<String>(YES_NO);
        this.setBG(this.cbUnique);
        this.cbUnique.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUnique);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbUnique, 80);
    }

    private void initClustered() {
        JLabel jLabel = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.Clustered"));
        this.general.add(jLabel);
        this.cbClustered = new JComboBox<String>(YES_NO);
        this.setBG(this.cbClustered);
        this.cbClustered.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbClustered);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbClustered, 110);
    }

    private void initFileGroup() {
        JLabel jLabel = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.Filegroup"));
        this.general.add(jLabel);
        this.cbFilegroup = new JComboBox();
        this.setBG(this.cbFilegroup);
        this.cbFilegroup.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbFilegroup);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbFilegroup, 140);
    }

    private void initPadIndex() {
        JLabel jLabel = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.PadIndex"));
        this.general.add(jLabel);
        this.cbPadIndex = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPadIndex);
        this.cbPadIndex.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPadIndex);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbPadIndex, 170);
    }

    private void initFillFactor() {
        JLabel jLabel = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.FillFactor"));
        this.general.add(jLabel);
        this.ifFillFactor = new JIntegerField(0, 26);
        this.general.add(this.ifFillFactor);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.ifFillFactor, 200);
    }

    private void initRecomputeStatistics() {
        JLabel jLabel = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.RecomputeStat"));
        this.general.add(jLabel);
        this.cbRecomputeStatistics = new JComboBox<String>(ConstantsSqlServer.AUTO_NO_CHOICES);
        this.setBG(this.cbRecomputeStatistics);
        this.cbRecomputeStatistics.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRecomputeStatistics);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbRecomputeStatistics, 230);
    }

    private void initSortInTempDB() {
        JLabel jLabel = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.SortInTempDB"));
        this.general.add(jLabel);
        this.cbSortInTempDB = new JComboBox<String>(YES_NO);
        this.setBG(this.cbSortInTempDB);
        this.cbSortInTempDB.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSortInTempDB);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbSortInTempDB, 260);
    }

    private void initIgnoreDupKey() {
        JLabel jLabel = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.IgnoreDupKey"));
        this.general.add(jLabel);
        this.cbIgnoreDupKey = new JComboBox<String>(YES_NO);
        this.setBG(this.cbIgnoreDupKey);
        this.cbIgnoreDupKey.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIgnoreDupKey);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.cbIgnoreDupKey, 290);
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
        this.initExtProperties();
    }

    private void initColumnsView() {
        this.columns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.Columns"), this.columns);
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initButtons();
    }

    private void initAllColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.AllColumns"));
        this.columns.add(jLabel);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allColumnsList);
        jScrollPane.setPreferredSize(new Dimension(120, 280));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(jScrollPane);
        this.setLabelConstraints(this.getColumnsLayout(), jLabel, 12, 14);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 10, 32);
    }

    private void initSelectedColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.SelectedColumns"));
        this.columns.add(jLabel);
        this.selectedColumnsTable = new JTable(new IndexTableModel());
        this.selectedColumnsModel = (IndexTableModel)this.selectedColumnsTable.getModel();
        this.setUpSortOrderColumn(this.selectedColumnsTable.getColumnModel().getColumn(1));
        ListSelectionModel listSelectionModel = this.selectedColumnsTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedColumnsTable);
        jScrollPane.setPreferredSize(new Dimension(165, 280));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(jScrollPane);
        this.setLabelConstraints(this.getColumnsLayout(), jLabel, 242, 14);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 240, 36);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.AddL"));
        this.bnAdd.addActionListener(new AddColumnsActionListener());
        this.bnAdd.setEnabled(false);
        this.columns.add(this.bnAdd);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnAdd, 140, 135);
        this.bnRemove = new JButton(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.RemoveL"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveColumnsActionListener());
        this.columns.add(this.bnRemove);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnRemove, 140, 165);
        IndexOnViewPropertyDialogSqlServerv2k5.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    public void setUpSortOrderColumn(TableColumn tableColumn) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("ASC");
        jComboBox.addItem("DESC");
        jComboBox.setSelectedItem("ASC");
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setToolTipText(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.ClickForCmboBox"));
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.ClickSortOrder"));
        }
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.columns.getLayout();
    }

    protected SpringLayout getExtPropertiesLayout() {
        return (SpringLayout)this.panelExtProperties.getLayout();
    }

    private void initExtProperties() {
        this.initAllExtProperties();
        this.initExtPropertiesButtons();
    }

    private void initExtPropertiesButtons() {
        this.bnAddProperty = new JButton(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.Add"));
        this.bnRemoveProperty = new JButton(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.Remove"));
        this.bnAddProperty.addActionListener(new AddExtPropertyActionListener());
        this.panelExtProperties.add(this.bnAddProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnAddProperty, 5, 292);
        this.bnRemoveProperty.addActionListener(new RemoveExtPropertyActionListener());
        this.panelExtProperties.add(this.bnRemoveProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnRemoveProperty, 90, 292);
        IndexOnViewPropertyDialogSqlServerv2k5.equalizeButtonSizes(this.bnAddProperty, this.bnRemoveProperty);
    }

    private void initAllExtProperties() {
        this.panelExtProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.ExtendedProperties"), this.panelExtProperties);
        this.extProperties = new ExtProperties();
        this.extProperties.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.extProperties.setPreferredScrollableViewportSize(new Dimension(416, 288));
        JScrollPane jScrollPane = new JScrollPane(this.extProperties);
        jScrollPane.setPreferredSize(new Dimension(416, 288));
        this.model = (ExtPropertiesModel)this.extProperties.getModel();
        this.setBG(this.extProperties);
        this.panelExtProperties.add(jScrollPane);
    }

    @Override
    public void initProperties() {
        Object[] objectArray;
        Object object;
        this.initCaption(this.index.getName());
        this.tfName.setText(this.index.getName());
        TableView tableView = (TableView)this.index.getView().getObject();
        ContainedObject[] containedObjectArray = tableView.getColumns();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            object = containedObjectArray[i].getName();
            if (this.index.getColSet().contains(object)) {
                this.selectedColumnsModel.addRow(new Object[]{object, "ASC"});
                continue;
            }
            this.allColumnsModel.addElement(object);
        }
        this.tfView.setText(this.index.getView().getName());
        this.cbUnique.setSelectedItem(IndexOnViewPropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.index.getUnique()));
        this.cbClustered.setSelectedItem(IndexOnViewPropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.index.getClustered()));
        Iterator iterator = ((StorageObjectCollection)this.index.getView().getChild(0)).iterator();
        if (iterator.hasNext() && this.index == iterator.next()) {
            this.cbUnique.setEnabled(false);
            this.cbClustered.setEnabled(false);
        }
        if ((object = this.index.getView().getDataBase()) != null) {
            objectArray = ((StorageObjectCollection)((DataBaseSqlServer)object).getChild(0)).iterator();
            while (objectArray.hasNext()) {
                FileGroupSqlServer fileGroupSqlServer = (FileGroupSqlServer)objectArray.next();
                this.cbFilegroup.addItem(fileGroupSqlServer);
            }
        }
        this.cbFilegroup.setSelectedItem(this.index.getFilegroup());
        if (this.index.getExtPropsSet() != null) {
            objectArray = this.index.getExtPropsSet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)objectArray[i];
                String string2 = (String)objectArray[++i];
                Object[] objectArray2 = new Object[]{string, string2};
                this.model.addRow(objectArray2);
            }
        }
        this.cbPadIndex.setSelectedItem(IndexOnViewPropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.index.getPadIndex()));
        this.ifFillFactor.setValue((long)this.index.getFillFactor());
        this.cbRecomputeStatistics.setSelectedItem(this.index.getRecomputeStatistics());
        this.cbSortInTempDB.setSelectedItem(IndexOnViewPropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.index.getSortInTempDB()));
        this.cbIgnoreDupKey.setSelectedItem(IndexOnViewPropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.index.getIgnoreDupKey()));
        if (this.index.getUnique().equalsIgnoreCase("NO")) {
            this.cbIgnoreDupKey.setEnabled(false);
        }
        this.getCommentsList().insert(this.index.getComment(), 0);
        this.taCommentsInRDBMS.insert(this.index.getCommentInRDBMS(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.index != null) {
            Object object;
            this.index.setName(this.tfName.getText());
            this.index.setComment(this.getCommentsList().getText());
            this.index.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
            this.index.setUnique(IndexOnViewPropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbUnique.getSelectedItem()));
            this.index.setClustered(IndexOnViewPropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbClustered.getSelectedItem()));
            this.index.setFilegroup((FileGroupSqlServer)this.cbFilegroup.getSelectedItem());
            this.index.setPadIndex(IndexOnViewPropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbPadIndex.getSelectedItem()));
            this.index.setRecomputeStatistics((String)this.cbRecomputeStatistics.getSelectedItem());
            this.index.setSortInTempDB(IndexOnViewPropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbSortInTempDB.getSelectedItem()));
            this.index.setIgnoreDupKey(IndexOnViewPropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbIgnoreDupKey.getSelectedItem()));
            this.index.setFillFactor(this.ifFillFactor.getIntValue());
            this.ifFillFactor.setValue((long)this.index.getFillFactor());
            Object[] objectArray = this.selectedColumnsModel.getRows();
            this.index.clear();
            String string = null;
            String string2 = null;
            for (int i = 0; i < objectArray.length; ++i) {
                object = objectArray[i];
                if (!(object instanceof String)) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(object.toString(), ",");
                if (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken().trim();
                }
                if (!stringTokenizer.hasMoreTokens()) continue;
                string2 = stringTokenizer.nextToken().trim();
                if (this.index == null) continue;
                this.index.setCols(string);
                this.index.setCols(string2);
            }
            Object[] objectArray2 = this.model.getRows();
            this.index.clear();
            string = null;
            object = null;
            for (int i = 0; i < objectArray2.length; ++i) {
                Object object2 = objectArray2[i];
                if (!(object2 instanceof String)) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(object2.toString(), ",");
                if (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken().trim();
                }
                if (!stringTokenizer.hasMoreTokens()) continue;
                object = stringTokenizer.nextToken().trim();
                this.index.setProps(string);
                this.index.setProps((String)object);
            }
        }
    }

    private class RemoveExtPropertyActionListener
    implements ActionListener {
        private RemoveExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (IndexOnViewPropertyDialogSqlServerv2k5.this.model.getRowCount() >= 1) {
                for (int i = IndexOnViewPropertyDialogSqlServerv2k5.this.model.getRowCount() - 1; i >= 0; --i) {
                    if (!IndexOnViewPropertyDialogSqlServerv2k5.this.extProperties.isRowSelected(i)) continue;
                    IndexOnViewPropertyDialogSqlServerv2k5.this.model.removeRow(i);
                }
                IndexOnViewPropertyDialogSqlServerv2k5.this.extProperties.updateUI();
            }
        }
    }

    private class AddExtPropertyActionListener
    implements ActionListener {
        private AddExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = "";
            String string2 = "";
            IndexOnViewPropertyDialogSqlServerv2k5.this.model.addRow(new Object[]{string, string2});
            IndexOnViewPropertyDialogSqlServerv2k5.this.extProperties.updateUI();
            IndexOnViewPropertyDialogSqlServerv2k5.this.extProperties.changeSelection(IndexOnViewPropertyDialogSqlServerv2k5.this.model.getRowCount() - 1, 0, false, false);
            IndexOnViewPropertyDialogSqlServerv2k5.this.extProperties.requestFocus();
        }
    }

    class ExtPropertiesCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ExtPropertiesCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            this.setHorizontalAlignment(2);
            this.setText(object == null ? "" : "  " + object.toString());
            return this;
        }
    }

    class ExtProperties
    extends JTable {
        ExtPropertiesModel dataModel;

        public ExtProperties() {
            this.dataModel = new ExtPropertiesModel();
            this.setModel(this.dataModel);
            TableColumnModel tableColumnModel = this.getColumnModel();
            for (int i = 0; i < 2; ++i) {
                tableColumnModel.getColumn(i).setCellRenderer(new ExtPropertiesCellRenderer());
            }
            this.initColumnSizes();
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        private void initColumnSizes() {
            TableColumn tableColumn = null;
            for (int i = 0; i < 2; ++i) {
                tableColumn = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    tableColumn.setPreferredWidth(50);
                    continue;
                }
                if (i != 1) continue;
                tableColumn.setPreferredWidth(150);
            }
        }
    }

    class ExtPropertiesModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.PropertyName"), Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.PropertyValue")};

        ExtPropertiesModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public String getColumnName(int n) {
            return this.cNames[n];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public Object[] getColumnData(int n) {
            int n2 = IndexOnViewPropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = this.getValueAt(i, n);
            }
            return objectArray;
        }

        public Object[] getPropertyNameColumn() {
            int n = IndexOnViewPropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            return objectArray;
        }

        public Object[] getRows() {
            int n = IndexOnViewPropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                String string = (String)this.getValueAt(i, 0) + "," + (String)this.getValueAt(i, 1);
                objectArray[i] = string;
            }
            return objectArray;
        }

        public Object[] getPropertyValueColumn() {
            int n = IndexOnViewPropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                if (this.getValueAt(i, 2) == null || ((String)this.getValueAt(i, 2)).trim().equalsIgnoreCase("")) continue;
                objectArray[i] = this.getValueAt(i, 2);
            }
            return objectArray;
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.fireTableChanged(tableModelEvent);
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (IndexOnViewPropertyDialogSqlServerv2k5.this.selectedColumnsTable.getSelectedRowCount() == -1) {
                    IndexOnViewPropertyDialogSqlServerv2k5.this.bnRemove.setEnabled(false);
                } else {
                    IndexOnViewPropertyDialogSqlServerv2k5.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (IndexOnViewPropertyDialogSqlServerv2k5.this.allColumnsList.getSelectedIndex() == -1) {
                    IndexOnViewPropertyDialogSqlServerv2k5.this.bnAdd.setEnabled(false);
                } else {
                    IndexOnViewPropertyDialogSqlServerv2k5.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (IndexOnViewPropertyDialogSqlServerv2k5.this.selectedColumnsModel.getRowCount() > 0) {
                int[] nArray = IndexOnViewPropertyDialogSqlServerv2k5.this.selectedColumnsTable.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    String string = (String)IndexOnViewPropertyDialogSqlServerv2k5.this.selectedColumnsModel.getValueAt(nArray[i], 0);
                    IndexOnViewPropertyDialogSqlServerv2k5.this.allColumnsModel.addElement(string);
                    IndexOnViewPropertyDialogSqlServerv2k5.this.selectedColumnsModel.removeRow(nArray[i]);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!IndexOnViewPropertyDialogSqlServerv2k5.this.allColumnsModel.isEmpty()) {
                Object[] objectArray = IndexOnViewPropertyDialogSqlServerv2k5.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    String string = (String)objectArray[i];
                    IndexOnViewPropertyDialogSqlServerv2k5.this.allColumnsModel.removeElement(string);
                    IndexOnViewPropertyDialogSqlServerv2k5.this.selectedColumnsModel.addRow(new String[]{string, ""});
                }
            }
        }
    }

    class IndexTableModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.ColumnName"), Messages.getString("IndexOnViewPropertyDialogSqlServerv2k5.SortOrder")};

        IndexTableModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public String getColumnName(int n) {
            return this.cNames[n];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public Object[] getColumnData(int n) {
            int n2 = IndexOnViewPropertyDialogSqlServerv2k5.this.selectedColumnsModel.getRowCount();
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = this.getValueAt(i, n);
            }
            return objectArray;
        }

        public Object[] getRows() {
            int n = IndexOnViewPropertyDialogSqlServerv2k5.this.selectedColumnsModel.getRowCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                String string = this.getValueAt(i, 1) == null || ((String)this.getValueAt(i, 1)).equalsIgnoreCase("") ? (String)this.getValueAt(i, 0) + "," + "ASC" : (String)this.getValueAt(i, 0) + "," + (String)this.getValueAt(i, 1);
                objectArray[i] = string;
            }
            return objectArray;
        }
    }
}

