/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class FileGroupPropertyDialogSqlServerv2k5
extends AbstractSqlServerPropertyDialog {
    private FileGroupSqlServer fileGroup;
    private JComboBox cbState;

    public FileGroupPropertyDialogSqlServerv2k5(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.fileGroup = (FileGroupSqlServer)storageObject;
        this.setHeight(120);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("FileGroupPropertyDialogSqlServerv2k5.FilegroupProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initState();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.fileGroup.getName());
        this.tfName.setText(this.fileGroup.getName());
        if (this.fileGroup.getName().equalsIgnoreCase(Messages.getString("FileGroupPropertyDialogSqlServerv2k5.primary"))) {
            this.tfName.setEnabled(false);
        }
        this.cbState.setSelectedItem(this.fileGroup.getState());
        this.getCommentsList().insert(this.fileGroup.getComment(), 0);
    }

    private void initState() {
        JLabel jLabel = new JLabel(Messages.getString("FileGroupPropertyDialogSqlServerv2k5.State"));
        this.general.add(jLabel);
        this.cbState = new JComboBox<String>(FileGroupSqlServer.getStateChoices());
        this.setBG(this.cbState);
        this.cbState.setPreferredSize(this.tfName.getPreferredSize());
        this.cbState.setEnabled(false);
        this.general.add(this.cbState);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbState, 50);
    }

    @Override
    protected void setProperties() {
        if (this.fileGroup != null) {
            this.fileGroup.setName(this.tfName.getText());
            this.fileGroup.setState((String)this.cbState.getSelectedItem());
            this.fileGroup.setComment(this.getCommentsList().getText());
        }
    }
}

