/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.DistinctTypeProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DistinctTypeProxySqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DistinctTypeProxyPropertyDialogSqlServerv2k5
extends AbstractSqlServerPropertyDialog {
    private DistinctTypeProxySqlServerv2k5 distinctProxy;
    private JTextField tfType;
    private JComboBox cbNullSettings;

    public DistinctTypeProxyPropertyDialogSqlServerv2k5(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.distinctProxy = (DistinctTypeProxySqlServerv2k5)storageObject;
        this.initCommentsView(150);
        CommonUtil.centerOnScreen(this);
        this.initProperties();
        this.setHeight(200);
        this.pack();
    }

    @Override
    public void initProperties() {
        this.tfName.setText(this.distinctProxy.getName());
        this.tfName.setEditable(false);
        this.tfType.setText(this.distinctProxy.getDatatypeString());
        this.cbNullSettings.setSelectedItem(this.distinctProxy.getNullType());
        this.getCommentsList().insert(this.distinctProxy.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        this.distinctProxy.setNullType((String)this.cbNullSettings.getSelectedItem());
        this.distinctProxy.setComment(this.getCommentsList().getText());
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initType();
        this.initNullSettings();
    }

    private void initType() {
        JLabel jLabel = new JLabel(Messages.getString("DistinctTypeProxyPropertyDialogSqlServerv2k5.Type"));
        this.general.add(jLabel);
        this.tfType = new JTextField();
        this.tfType.setPreferredSize(this.tfName.getPreferredSize());
        this.tfType.setEditable(false);
        this.general.add(this.tfType);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfType, 50);
    }

    private void initNullSettings() {
        JLabel jLabel = new JLabel(Messages.getString("DistinctTypeProxyPropertyDialogSqlServerv2k5.NullSettings"));
        this.general.add(jLabel);
        this.cbNullSettings = new JComboBox();
        this.fillComboItems(DistinctTypeProxy.NULL_STATES, this.cbNullSettings);
        this.cbNullSettings.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbNullSettings);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbNullSettings, 80);
    }
}

