/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserDefinedTypeSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class UserDefinedTypesPropertyDialog
extends AbstractSqlServerPropertyDialog {
    private UserDefinedTypeSqlServer baseOnDomain;
    private JComboBox cbDomain;
    private JComboBox cbNullSettings;

    public UserDefinedTypesPropertyDialog(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.baseOnDomain = (UserDefinedTypeSqlServer)storageObject;
        this.initGeneral();
        this.setHeight(150);
        this.initCommentsView(100);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    private void initGeneral() {
        this.initDomain();
        this.initNullSettings();
    }

    @Override
    public void initProperties() {
        this.tfName.setText(this.baseOnDomain.getName());
        Domain domain = (Domain)this.storageDesign.getDesign().getDomainSet().getByName(this.baseOnDomain.getDomain());
        this.cbDomain.setSelectedItem(domain);
        this.cbNullSettings.setSelectedItem(this.baseOnDomain.getNullType());
        this.getCommentsList().insert(this.baseOnDomain.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        this.baseOnDomain.setName(this.tfName.getText());
        if (this.cbDomain.getSelectedItem() != null) {
            this.baseOnDomain.setDomain(((Domain)this.cbDomain.getSelectedItem()).getName());
        }
        this.baseOnDomain.setNullType((String)this.cbNullSettings.getSelectedItem());
        this.baseOnDomain.setComment(this.getCommentsList().getText());
    }

    private void initDomain() {
        JLabel jLabel = new JLabel(Messages.getString("UserDefinedTypesPropertyDialog.Domain"));
        jLabel.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(jLabel);
        this.cbDomain = new JComboBox();
        this.fillComboItems(this.getStorageDesign().getDesign().getDomainSet().toArray(), this.cbDomain);
        this.cbDomain.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDomain);
        this.setBG(this.cbDomain);
        this.cbDomain.setPreferredSize(this.tfName.getPreferredSize());
        this.cbDomain.setMaximumRowCount(8);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbDomain, 50);
    }

    private void initNullSettings() {
        JLabel jLabel = new JLabel(Messages.getString("UserDefinedTypesPropertyDialog.NullSettings"));
        this.general.add(jLabel);
        this.cbNullSettings = new JComboBox();
        this.fillComboItems(UserDefinedTypeSqlServer.NULL_STATES, this.cbNullSettings);
        this.cbNullSettings.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbNullSettings);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbNullSettings, 80);
    }
}

