/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.StoredProcedureSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class StoredProcedurePropertyDialogSqlServer
extends AbstractSqlServerPropertyDialog {
    private StoredProcedureSqlServer proc;
    private JComboBox cbOwner;
    private JTextField tfDatabase;
    private JTextArea bodyArea;

    public StoredProcedurePropertyDialogSqlServer(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.proc = (StoredProcedureSqlServer)storageObject;
        this.setHeight(300);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("StoredProcedurePropertyDialogSqlServer.StoredProcedureProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDatabase();
        this.initOwner();
        this.initBody();
    }

    private void initDatabase() {
        JLabel jLabel = new JLabel(Messages.getString("StoredProcedurePropertyDialogSqlServer.Database"));
        this.general.add(jLabel);
        this.tfDatabase = new JTextField("", 26);
        this.tfDatabase.setEnabled(false);
        this.general.add(this.tfDatabase);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfDatabase, 50);
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("StoredProcedurePropertyDialogSqlServer.Owner"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbOwner, 80);
    }

    private void initBody() {
        JLabel jLabel = new JLabel(Messages.getString("StoredProcedurePropertyDialogSqlServer.Body"));
        this.general.add(jLabel);
        this.setLabelConstraints(jLabel, 110);
        this.bodyArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.bodyArea);
        jScrollPane.setPreferredSize(new Dimension(395, 130));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.bodyArea.setLineWrap(true);
        this.general.add(jScrollPane);
        this.setObjectConstraints(jScrollPane, 10, 130);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.proc.getName());
        this.tfName.setText(this.proc.getName());
        for (int i = 0; i < this.proc.getDatabase().getUsers().toArray().length; ++i) {
            UserSqlServer userSqlServer = (UserSqlServer)this.proc.getDatabase().getUsers().toArray()[i];
            if (userSqlServer.getName().equalsIgnoreCase("GUEST")) continue;
            this.cbOwner.addItem(userSqlServer);
        }
        this.tfDatabase.setText(this.proc.getDatabase().getName());
        this.cbOwner.setSelectedItem(this.proc.getOwner());
        this.bodyArea.setText(this.proc.getBody());
        this.getCommentsList().insert(this.proc.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.proc != null) {
            this.proc.setName(this.tfName.getText());
            this.proc.setOwner((UserSqlServer)this.cbOwner.getSelectedItem());
            this.proc.setBody(this.bodyArea.getText());
            this.proc.setComment(this.getCommentsList().getText());
        }
    }
}

