/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.RuleSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class RulePropertyDialogSqlServer
extends AbstractSqlServerPropertyDialog {
    private RuleSqlServer rule;
    private JComboBox cbOwner;
    private JTextField tfExpression;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JList allColumnsList;
    private JList selectedColumnsList;
    private JButton bnAdd;
    private JButton bnRemove;

    public RulePropertyDialogSqlServer(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.rule = (RuleSqlServer)storageObject;
        this.setHeight(360);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("RulePropertyDialogSqlServer.RuleProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initExpression();
        this.initColumns();
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("RulePropertyDialogSqlServer.Owner"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbOwner, 50);
    }

    private void initExpression() {
        JLabel jLabel = new JLabel(Messages.getString("RulePropertyDialogSqlServer.Expression"));
        this.general.add(jLabel);
        this.tfExpression = new JTextField("", 26);
        this.general.add(this.tfExpression);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfExpression, 80);
    }

    private void initColumns() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initButtons();
    }

    private void initAllColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("RulePropertyDialogSqlServer.AllColumns"));
        this.general.add(jLabel);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allColumnsList);
        jScrollPane.setPreferredSize(new Dimension(144, 180));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(jScrollPane);
        this.setLabelConstraints(this.getColumnsLayout(), jLabel, 12, 114);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 10, 132);
    }

    private void initSelectedColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("RulePropertyDialogSqlServer.SelectedColumns"));
        this.general.add(jLabel);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedColumnsList);
        jScrollPane.setPreferredSize(new Dimension(145, 180));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.general.add(jScrollPane);
        this.setLabelConstraints(this.getColumnsLayout(), jLabel, 292, 114);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 290, 132);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("RulePropertyDialogSqlServer.Add"));
        this.bnAdd.addActionListener(new AddColumnsActionListener());
        this.bnAdd.setEnabled(false);
        this.general.add(this.bnAdd);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnAdd, 175, 195);
        this.bnRemove = new JButton(Messages.getString("RulePropertyDialogSqlServer.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveColumnsActionListener());
        this.general.add(this.bnRemove);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnRemove, 175, 225);
        RulePropertyDialogSqlServer.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.general.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.rule.getName());
        this.tfName.setText(this.rule.getName());
        Iterator iterator = this.rule.getDatabase().getUsers().iterator();
        while (iterator.hasNext()) {
            UserSqlServer userSqlServer = (UserSqlServer)iterator.next();
            if (userSqlServer.getName().equalsIgnoreCase("GUEST")) continue;
            this.cbOwner.addItem(userSqlServer);
        }
        this.cbOwner.setSelectedItem(this.rule.getOwner());
        this.tfExpression.setText(this.rule.getExpression());
        Iterator iterator2 = this.getStorageDesign().getColumnProxySet().iterator();
        while (iterator2.hasNext()) {
            ColumnProxySqlServer columnProxySqlServer = (ColumnProxySqlServer)iterator2.next();
            if (columnProxySqlServer.getTableProxy().getDatabase() != this.rule.getDatabase()) continue;
            if (this.rule.getColumnSet().contains(columnProxySqlServer.getName())) {
                this.addElementToSortedListModel(this.selectedColumnsModel, columnProxySqlServer);
                continue;
            }
            this.addElementToSortedListModel(this.allColumnsModel, columnProxySqlServer);
        }
        this.getCommentsList().insert(this.rule.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.rule != null) {
            this.rule.setOwner((UserSqlServer)this.cbOwner.getSelectedItem());
            this.rule.setName(this.tfName.getText());
            this.rule.setExpression(this.tfExpression.getText());
            Object[] objectArray = this.selectedColumnsModel.toArray();
            this.rule.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (!(object instanceof ColumnProxySqlServer)) continue;
                this.rule.setColumns(((ColumnProxySqlServer)object).getName());
            }
            this.rule.setComment(this.getCommentsList().getText());
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (RulePropertyDialogSqlServer.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (RulePropertyDialogSqlServer.this.selectedColumnsList.getSelectedIndex() == -1) {
                    RulePropertyDialogSqlServer.this.bnRemove.setEnabled(false);
                } else {
                    RulePropertyDialogSqlServer.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (RulePropertyDialogSqlServer.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (RulePropertyDialogSqlServer.this.allColumnsList.getSelectedIndex() == -1) {
                    RulePropertyDialogSqlServer.this.bnAdd.setEnabled(false);
                } else {
                    RulePropertyDialogSqlServer.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!RulePropertyDialogSqlServer.this.selectedColumnsModel.isEmpty()) {
                Object[] objectArray = RulePropertyDialogSqlServer.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (RulePropertyDialogSqlServer.this.allColumnsModel.contains(object)) continue;
                    RulePropertyDialogSqlServer.this.addElementToSortedListModel(RulePropertyDialogSqlServer.this.allColumnsModel, object);
                    RulePropertyDialogSqlServer.this.selectedColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!RulePropertyDialogSqlServer.this.allColumnsModel.isEmpty()) {
                Object[] objectArray = RulePropertyDialogSqlServer.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (RulePropertyDialogSqlServer.this.selectedColumnsModel.contains(object)) continue;
                    RulePropertyDialogSqlServer.this.addElementToSortedListModel(RulePropertyDialogSqlServer.this.selectedColumnsModel, object);
                    RulePropertyDialogSqlServer.this.allColumnsModel.removeElement(object);
                }
            }
        }
    }
}

