/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.LoginSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class LoginPropertyDialogSqlServer
extends AbstractSqlServerPropertyDialog {
    private LoginSqlServer login;
    private JComboBox cbAuthentication;
    private JComboBox cbDataBase;
    private JPasswordField passField;
    private JTextField tfLanguage;
    private JPanel pDBAccess;
    private JTable table;
    private UsersTableModel model;

    public LoginPropertyDialogSqlServer(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.login = (LoginSqlServer)storageObject;
        this.setHeight(200);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("LoginPropertyDialogSqlServer.LoginProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initAuthentication();
        this.initPassword();
        this.initDefaultDatabase();
        this.initDefaultLanguage();
    }

    @Override
    protected void addTabs() {
        this.initDBAccessView();
    }

    private void initDBAccessView() {
        this.pDBAccess = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("LoginPropertyDialogSqlServer.DatabaseAccess"), this.pDBAccess);
        this.table = new UsersTable();
        this.table.setPreferredScrollableViewportSize(new Dimension(398, 142));
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.model = (UsersTableModel)this.table.getModel();
        this.setBG(this.table);
        this.pDBAccess.add(jScrollPane);
    }

    private void initAuthentication() {
        JLabel jLabel = new JLabel(Messages.getString("LoginPropertyDialogSqlServer.Authentication"));
        this.general.add(jLabel);
        this.cbAuthentication = new JComboBox<String>(LoginSqlServer.AUTH_CHOICES);
        this.setBG(this.cbAuthentication);
        this.cbAuthentication.setPreferredSize(this.tfName.getPreferredSize());
        this.cbAuthentication.addActionListener(new AuthenticationListener());
        this.general.add(this.cbAuthentication);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbAuthentication, 50);
    }

    private void initPassword() {
        JLabel jLabel = new JLabel(Messages.getString("LoginPropertyDialogSqlServer.Password"));
        this.general.add(jLabel);
        this.passField = new JPasswordField();
        this.setBG(this.passField);
        this.passField.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.passField);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.passField, 80);
    }

    private void initDefaultDatabase() {
        JLabel jLabel = new JLabel(Messages.getString("LoginPropertyDialogSqlServer.DefaultDatabase"));
        this.general.add(jLabel);
        this.cbDataBase = new JComboBox();
        this.setBG(this.cbDataBase);
        this.cbDataBase.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDataBase);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbDataBase, 110);
    }

    private void initDefaultLanguage() {
        JLabel jLabel = new JLabel(Messages.getString("LoginPropertyDialogSqlServer.DefaultLanguage"));
        this.general.add(jLabel);
        this.tfLanguage = new JTextField();
        this.setBG(this.tfLanguage);
        this.tfLanguage.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfLanguage);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.tfLanguage, 140);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.login.getName());
        this.tfName.setText(this.login.getName());
        this.cbAuthentication.setSelectedItem(this.login.getAuthentication());
        this.passField.setText(this.login.decodePassword());
        if (this.login.getAuthentication().equals("SQL Server")) {
            this.passField.setEnabled(true);
        } else {
            this.passField.setEnabled(false);
        }
        Iterator iterator = this.getStorageDesign().getDataBaseSet().iterator();
        while (iterator.hasNext()) {
            DataBaseSqlServer dataBaseSqlServer = (DataBaseSqlServer)iterator.next();
            if (dataBaseSqlServer.isNullInstance()) continue;
            this.cbDataBase.addItem(dataBaseSqlServer);
        }
        this.cbDataBase.setSelectedItem(this.login.getDefaultDatabase());
        this.tfLanguage.setText(this.login.getLanguage());
        iterator = this.getStorageDesign().getDataBaseSet().iterator();
        boolean bl = false;
        String string = "";
        while (iterator.hasNext()) {
            bl = false;
            string = "";
            DataBaseSqlServer dataBaseSqlServer = (DataBaseSqlServer)iterator.next();
            Iterator iterator2 = this.getStorageDesign().getUserSet().iterator();
            while (iterator2.hasNext()) {
                UserSqlServer userSqlServer = (UserSqlServer)iterator2.next();
                if (userSqlServer.getDatabase() != dataBaseSqlServer || !this.login.getUserSet().contains(userSqlServer.getName())) continue;
                bl = true;
                string = userSqlServer.getName();
                break;
            }
            this.model.addRow(new Object[]{bl, dataBaseSqlServer, string});
        }
        this.getCommentsList().insert(this.login.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.login != null) {
            this.login.setName(this.tfName.getText());
            this.login.setAuthentication((String)this.cbAuthentication.getSelectedItem());
            this.login.encodePassword(String.valueOf(this.passField.getPassword()));
            this.login.setDefaultDatabase((DataBaseSqlServer)this.cbDataBase.getSelectedItem());
            this.login.setLanguage(this.tfLanguage.getText());
            Object[] objectArray = this.model.getUserColumn();
            this.login.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (object == null || !(object instanceof UserSqlServer)) continue;
                UserSqlServer userSqlServer = (UserSqlServer)object;
                this.login.setUsers(userSqlServer.getName());
                StorageObjectCollection storageObjectCollection = (StorageObjectCollection)userSqlServer.getDatabase().getChild(3);
                if (!storageObjectCollection.containsName(userSqlServer.getName())) {
                    storageObjectCollection.add(userSqlServer);
                }
                if (this.getStorageDesign().getUserSet().contains(userSqlServer)) continue;
                this.getStorageDesign().getUserSet().add(userSqlServer);
            }
            this.login.setComment(this.getCommentsList().getText());
        }
    }

    class CheckBoxTableCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        CheckBoxTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setBackground(jTable.getBackground());
            this.setHorizontalAlignment(0);
            this.setSelected((Boolean)object);
            return this;
        }
    }

    class UsersTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        UsersTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setBackground(jTable.getBackground());
            this.setHorizontalAlignment(2);
            this.setText(object == null ? "" : "  " + object.toString());
            return this;
        }
    }

    class UsersTable
    extends JTable {
        UsersTableModel dataModel;

        public UsersTable() {
            this.dataModel = new UsersTableModel();
            this.setModel(this.dataModel);
            TableColumnModel tableColumnModel = this.getColumnModel();
            tableColumnModel.getColumn(0).setCellRenderer(new CheckBoxTableCellRenderer());
            for (int i = 1; i < 3; ++i) {
                tableColumnModel.getColumn(i).setCellRenderer(new UsersTableCellRenderer());
            }
            this.initColumnSizes();
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        private void initColumnSizes() {
            TableColumn tableColumn = null;
            for (int i = 0; i < 3; ++i) {
                tableColumn = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    tableColumn.setPreferredWidth(50);
                    continue;
                }
                if (i == 1) {
                    tableColumn.setPreferredWidth(150);
                    continue;
                }
                tableColumn.setPreferredWidth(220);
            }
        }
    }

    class UsersTableModel
    extends DefaultTableModel
    implements TableModelListener {
        String[] cNames = new String[]{Messages.getString("LoginPropertyDialogSqlServer.Permit"), Messages.getString("LoginPropertyDialogSqlServer.Database"), Messages.getString("LoginPropertyDialogSqlServer.User")};

        public UsersTableModel() {
            this.addTableModelListener(this);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!LoginPropertyDialogSqlServer.this.isEditable()) {
                return false;
            }
            return n2 == 0;
        }

        @Override
        public String getColumnName(int n) {
            return this.cNames[n];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int n) {
            if (this.getValueAt(0, n) != null) {
                return this.getValueAt(0, n).getClass();
            }
            return null;
        }

        public Object[] getColumnData(int n) {
            int n2 = LoginPropertyDialogSqlServer.this.model.getRowCount();
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = this.getValueAt(i, n);
            }
            return objectArray;
        }

        public Object[] getUserColumn() {
            int n = LoginPropertyDialogSqlServer.this.model.getRowCount();
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                if (this.getValueAt(i, 2) == null || !((Boolean)this.getValueAt(i, 0)).booleanValue()) continue;
                if (this.getValueAt(i, 2) instanceof UserSqlServer) {
                    objectArray[i] = this.getValueAt(i, 2);
                    continue;
                }
                DataBaseSqlServer dataBaseSqlServer = (DataBaseSqlServer)this.getValueAt(i, 1);
                UserSetSqlServer userSetSqlServer = LoginPropertyDialogSqlServer.this.getStorageDesign().getUserSet();
                UserSqlServer userSqlServer = (UserSqlServer)userSetSqlServer.createElement(null);
                if (!((String)this.getValueAt(i, 2)).trim().equalsIgnoreCase("")) {
                    userSqlServer.setName((String)this.getValueAt(i, 2));
                } else {
                    userSqlServer.setName(LoginPropertyDialogSqlServer.this.login.getName());
                }
                userSqlServer.setDatabase(dataBaseSqlServer);
                userSqlServer.setLogin(LoginPropertyDialogSqlServer.this.login);
                userSetSqlServer.add(userSqlServer);
                objectArray[i] = userSqlServer;
            }
            return objectArray;
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            try {
                int n = tableModelEvent.getFirstRow();
                int n2 = tableModelEvent.getColumn();
                UsersTableModel usersTableModel = (UsersTableModel)tableModelEvent.getSource();
                Object object = usersTableModel.getValueAt(n, n2);
                if (object instanceof Boolean) {
                    Boolean bl = (Boolean)object;
                    if (bl.booleanValue()) {
                        if (LoginPropertyDialogSqlServer.this.table.getValueAt(n, 2) == null || LoginPropertyDialogSqlServer.this.table.getValueAt(n, 2) instanceof String && ((String)LoginPropertyDialogSqlServer.this.table.getValueAt(n, 2)).equalsIgnoreCase("")) {
                            DataBaseSqlServer dataBaseSqlServer = (DataBaseSqlServer)LoginPropertyDialogSqlServer.this.table.getValueAt(n, 1);
                            Iterator iterator = LoginPropertyDialogSqlServer.this.getStorageDesign().getUserSet().iterator();
                            UserSqlServer userSqlServer = null;
                            UserSqlServer userSqlServer2 = null;
                            while (iterator.hasNext()) {
                                userSqlServer2 = (UserSqlServer)iterator.next();
                                if (userSqlServer2.getDatabase() != dataBaseSqlServer || userSqlServer2.getLogin() != LoginPropertyDialogSqlServer.this.login) continue;
                                userSqlServer = userSqlServer2;
                                break;
                            }
                            if (userSqlServer != null) {
                                LoginPropertyDialogSqlServer.this.table.setValueAt(userSqlServer, n, 2);
                            } else {
                                LoginPropertyDialogSqlServer.this.table.setValueAt(LoginPropertyDialogSqlServer.this.login.getName(), n, 2);
                            }
                        }
                    } else {
                        LoginPropertyDialogSqlServer.this.table.setValueAt(null, n, 2);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class AuthenticationListener
    implements ActionListener {
        private AuthenticationListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((String)LoginPropertyDialogSqlServer.this.cbAuthentication.getSelectedItem()).equals("SQL Server")) {
                LoginPropertyDialogSqlServer.this.passField.setEnabled(true);
            } else {
                LoginPropertyDialogSqlServer.this.passField.setEnabled(false);
            }
        }
    }
}

