/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.FKProxySqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class FKPropertyDialogSqlServer
extends AbstractSqlServerPropertyDialog {
    private FKProxySqlServer fkey;
    private JTextField tfTable;
    private JTextField tfRefTable;
    private JTextField tfOnDelete;
    private JComboBox cbOnUpdate;
    private JComboBox cbForReplication;
    private JPanel columns;
    private JPanel refColumns;
    private JList columnList;
    private JList refColumnsList;
    private DefaultListModel columnListModel;
    private DefaultListModel refColumnsListModel;

    public FKPropertyDialogSqlServer(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.fkey = (FKProxySqlServer)storageObject;
        this.setHeight(230);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("FKPropertyDialogSqlServer.FKProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initRefTable();
        this.initOnDelete();
        this.initOnUpdate();
        this.initForReplication();
    }

    private void initTable() {
        JLabel jLabel = new JLabel(Messages.getString("FKPropertyDialogSqlServer.Table"));
        this.general.add(jLabel);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEditable(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initRefTable() {
        JLabel jLabel = new JLabel(Messages.getString("FKPropertyDialogSqlServer.RefTable"));
        this.general.add(jLabel);
        this.tfRefTable = new JTextField("", 26);
        this.tfRefTable.setEditable(false);
        this.general.add(this.tfRefTable);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfRefTable, 80);
    }

    private void initOnDelete() {
        JLabel jLabel = new JLabel(Messages.getString("FKPropertyDialogSqlServer.OnDelete"));
        this.general.add(jLabel);
        this.tfOnDelete = new JTextField();
        this.setBG(this.tfOnDelete);
        this.tfOnDelete.setEnabled(false);
        this.tfOnDelete.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfOnDelete);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.tfOnDelete, 110);
    }

    private void initOnUpdate() {
        JLabel jLabel = new JLabel(Messages.getString("FKPropertyDialogSqlServer.OnUpdate"));
        this.general.add(jLabel);
        this.cbOnUpdate = new JComboBox<String>(FKProxySqlServer.getOnChoices());
        this.setBG(this.cbOnUpdate);
        this.cbOnUpdate.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOnUpdate);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbOnUpdate, 140);
    }

    private void initForReplication() {
        JLabel jLabel = new JLabel(Messages.getString("FKPropertyDialogSqlServer.ApplyInReplication"));
        this.general.add(jLabel);
        this.cbForReplication = new JComboBox<String>(YES_NO);
        this.setBG(this.cbForReplication);
        this.cbForReplication.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbForReplication);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbForReplication, 170);
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
        this.initRefColumnsView();
    }

    private void initColumnsView() {
        this.columns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("FKPropertyDialogSqlServer.Columns"), this.columns);
        this.initColumns();
    }

    private void initColumns() {
        this.columnListModel = new DefaultListModel();
        this.columnList = new JList(this.columnListModel);
        this.columnList.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.columnList);
        jScrollPane.setPreferredSize(new Dimension(395, 180));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(jScrollPane);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.columns.getLayout();
    }

    protected SpringLayout getRefColumnsLayout() {
        return (SpringLayout)this.refColumns.getLayout();
    }

    private void initRefColumnsView() {
        this.refColumns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("FKPropertyDialogSqlServer.ReferencedColumns"), this.refColumns);
        this.initRefColumns();
    }

    private void initRefColumns() {
        this.refColumnsListModel = new DefaultListModel();
        this.refColumnsList = new JList(this.refColumnsListModel);
        this.refColumnsList.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.refColumnsList);
        jScrollPane.setPreferredSize(new Dimension(395, 180));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.refColumns.add(jScrollPane);
        this.setObjectConstraints(this.getRefColumnsLayout(), jScrollPane, 10, 12);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.fkey.getName());
        this.tfName.setText(this.fkey.getName());
        this.tfTable.setText(this.fkey.getTable().getName());
        this.tfRefTable.setText(this.fkey.getReferenceTable());
        ColumnProxy[] columnProxyArray = this.fkey.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxy columnProxy = columnProxyArray[i];
            this.columnListModel.addElement(columnProxy);
        }
        Column[] columnArray = this.fkey.getRefColumns();
        for (int i = 0; i < columnArray.length; ++i) {
            Column column = columnArray[i];
            this.refColumnsListModel.addElement(column);
        }
        String string = ((Index)this.fkey.getObject()).getFKAssociation().getDeleteRule();
        if (string.equalsIgnoreCase("SET DEFAULT")) {
            string = ((Index)this.fkey.getObject()).getFKAssociation().isMandatory() ? "NO ACTION" : "SET NULL";
        }
        this.tfOnDelete.setText(this.fkey.getStorageDesign().getValidFKRule(string));
        this.cbOnUpdate.setSelectedItem(this.fkey.getOnUpdate());
        this.cbForReplication.setSelectedItem(FKPropertyDialogSqlServer.translateYesNoForDisplay(this.fkey.getForReplication()));
        this.getCommentsList().insert(this.fkey.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.fkey != null) {
            this.fkey.setName(this.tfName.getText());
            this.fkey.setOnUpdate((String)this.cbOnUpdate.getSelectedItem());
            this.fkey.setForReplication(FKPropertyDialogSqlServer.translateYesNoForStorage((String)this.cbForReplication.getSelectedItem()));
            this.fkey.setComment(this.getCommentsList().getText());
        }
    }
}

