/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StructuredTypeProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TypeElementProxyOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class TypeElementPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private TypeElementProxyOraclev9i typeElement;
    private JTextField tfDatatype;
    private JTextField tfSqlJAttr;

    public TypeElementPropertyDialogOraclev9i(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.typeElement = (TypeElementProxyOraclev9i)storageObject;
        this.setHeight(150);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TypeElementPropertyDialogOraclev9i.TypeElementProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDatatype();
        this.initSqlJAttr();
    }

    private void initDatatype() {
        JLabel jLabel = new JLabel(Messages.getString("TypeElementPropertyDialogOraclev9i.Datatype"));
        this.general.add(jLabel);
        this.tfDatatype = new JTextField("", 26);
        this.tfDatatype.setEnabled(false);
        this.general.add(this.tfDatatype);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfDatatype, 50);
    }

    private void initSqlJAttr() {
        JLabel jLabel = new JLabel(Messages.getString("TypeElementPropertyDialogOraclev9i.SQLJAttribute"));
        this.general.add(jLabel);
        this.tfSqlJAttr = new JTextField("", 26);
        this.general.add(this.tfSqlJAttr);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfSqlJAttr, 80);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.typeElement.getName());
        this.tfName.setText(this.typeElement.getName());
        this.tfDatatype.setText(this.typeElement.getDatatype("Oracle9i"));
        this.tfSqlJAttr.setText(this.typeElement.getSqlJAttr());
        this.tfSqlJAttr.setEnabled("YES".equalsIgnoreCase(((StructuredTypeProxyOraclev9i)this.typeElement.getStructuredTypeProxy()).getMapToJavaClass()));
        this.getCommentsList().insert(this.typeElement.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.typeElement != null) {
            this.typeElement.setName(this.tfName.getText());
            this.typeElement.setSqlJAttr(this.tfSqlJAttr.getText());
            this.typeElement.setComment(this.getCommentsList().getText());
        }
    }
}

