/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ColumnProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TriggerOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class TriggerPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private TriggerOraclev9i trigger;
    private JComboBox cbOwner;
    private JComboBox cbTriggeringTime;
    private JComboBox cbScope;
    private JComboBox cbState;
    private JTextField tfTable;
    private JTextField tfCondition;
    private JTextField tfRef_OLD_AS;
    private JTextField tfRef_NEW_AS;
    private JTextField tfRef_PARENT_AS;
    private JPanel panelColumns;
    private JPanel panelBody = new JPanel(new SpringLayout());
    private JList allColumnsList;
    private JList selectedColumnsList;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JButton bnAddColumns;
    private JButton bnRemoveColumns;
    private JTextArea bodyArea;
    private JLabel tableLabel;
    private JCheckBox chbInsert;
    private JCheckBox chbUpdate;
    private JCheckBox chbDelete;

    public TriggerPropertyDialogOraclev9i(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.trigger = (TriggerOraclev9i)storageObject;
        this.setHeight(380);
        this.initCommentsView(330);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TriggerPropertyDialogOraclev9i.TriggerProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initOwner();
        this.initAction();
        this.initTriggeringTime();
        this.initScope();
        this.initState();
        this.initRef_OLD_AS();
        this.initRef_NEW_AS();
        this.initRef_PARENT_AS();
    }

    @Override
    protected void addTabs() {
        this.initBodyView();
    }

    private void initColumnsView() {
        this.panelColumns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TriggerPropertyDialogOraclev9i.UpdateColumns"), this.panelColumns);
        this.initColumns();
    }

    private void initColumns() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initColumnsButtons();
    }

    private void initAllColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogOraclev9i.AllColumns"));
        this.panelColumns.add(jLabel);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllColumnsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allColumnsList);
        jScrollPane.setPreferredSize(new Dimension(144, 300));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelColumns.add(jScrollPane);
        this.setLabelConstraints(this.getColumnsLayout(), jLabel, 12, 20);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 10, 38);
    }

    private void initSelectedColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogOraclev9i.SelectedColumns"));
        this.panelColumns.add(jLabel);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedColumnsList);
        jScrollPane.setPreferredSize(new Dimension(145, 300));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelColumns.add(jScrollPane);
        this.setLabelConstraints(this.getColumnsLayout(), jLabel, 292, 20);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 290, 38);
    }

    private void initColumnsButtons() {
        this.bnAddColumns = new JButton(Messages.getString("TriggerPropertyDialogOraclev9i.Add"));
        this.bnAddColumns.addActionListener(new AddColumnsActionListener());
        this.bnAddColumns.setEnabled(false);
        this.panelColumns.add(this.bnAddColumns);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnAddColumns, 175, 135);
        this.bnRemoveColumns = new JButton(Messages.getString("TriggerPropertyDialogOraclev9i.Remove"));
        this.bnRemoveColumns.setEnabled(false);
        this.bnRemoveColumns.addActionListener(new RemoveColumnsActionListener());
        this.panelColumns.add(this.bnRemoveColumns);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnRemoveColumns, 175, 165);
        TriggerPropertyDialogOraclev9i.equalizeButtonSizes(this.bnAddColumns, this.bnRemoveColumns);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.panelColumns.getLayout();
    }

    protected SpringLayout getBodyLayout() {
        return (SpringLayout)this.panelBody.getLayout();
    }

    private void initBodyView() {
        this.panelBody = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TriggerPropertyDialogOraclev9i.TriggerBody"), this.panelBody);
        this.initBody();
    }

    private void initBody() {
        this.bodyArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.bodyArea);
        jScrollPane.setPreferredSize(new Dimension(420, 330));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.bodyArea.setLineWrap(true);
        this.panelBody.add(jScrollPane);
        this.setObjectConstraints(this.getBodyLayout(), jScrollPane, 10, 12);
    }

    private void initTable() {
        this.tableLabel = new JLabel();
        this.general.add(this.tableLabel);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEnabled(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(this.tableLabel, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogOraclev9i.User"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbOwner);
        }
        this.cbOwner.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbOwner, 80);
    }

    private void initAction() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogOraclev9i.Action"));
        this.general.add(jLabel);
        this.setLabelConstraints(jLabel, 110);
        this.chbInsert = new JCheckBox(Messages.getString("TriggerPropertyDialogOraclev9i.INSERT"));
        this.chbUpdate = new JCheckBox(Messages.getString("TriggerPropertyDialogOraclev9i.UPDATE"));
        this.chbDelete = new JCheckBox(Messages.getString("TriggerPropertyDialogOraclev9i.DELETE"));
        this.general.add(this.chbInsert);
        this.general.add(this.chbUpdate);
        this.general.add(this.chbDelete);
        this.setObjectConstraints(this.chbInsert, 122, 105);
        this.setObjectConstraints(this.chbUpdate, 220, 105);
        this.setObjectConstraints(this.chbDelete, 320, 105);
    }

    private void initTriggeringTime() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogOraclev9i.TriggeringTime"));
        this.general.add(jLabel);
        this.cbTriggeringTime = new JComboBox();
        this.setBG(this.cbTriggeringTime);
        this.cbTriggeringTime.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTriggeringTime);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbTriggeringTime, 140);
    }

    private void initScope() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogOraclev9i.Scope"));
        this.general.add(jLabel);
        this.cbScope = new JComboBox();
        this.setBG(this.cbScope);
        this.cbScope.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbScope);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbScope, 170);
    }

    private void initState() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogOraclev9i.State"));
        this.general.add(jLabel);
        this.cbState = new JComboBox();
        this.setBG(this.cbState);
        this.cbState.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbState);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbState, 200);
    }

    private void initRef_OLD_AS() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogOraclev9i.RefOLDAS"));
        this.general.add(jLabel);
        this.tfRef_OLD_AS = new JTextField("", 26);
        this.general.add(this.tfRef_OLD_AS);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.tfRef_OLD_AS, 230);
    }

    private void initRef_NEW_AS() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogOraclev9i.RefNEWAS"));
        this.general.add(jLabel);
        this.tfRef_NEW_AS = new JTextField("", 26);
        this.general.add(this.tfRef_NEW_AS);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.tfRef_NEW_AS, 260);
    }

    private void initRef_PARENT_AS() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogOraclev9i.RefPARENTAS"));
        this.general.add(jLabel);
        this.tfRef_PARENT_AS = new JTextField("", 26);
        this.general.add(this.tfRef_PARENT_AS);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.tfRef_PARENT_AS, 290);
    }

    private void initCondition() {
        JLabel jLabel = new JLabel(Messages.getString("TriggerPropertyDialogOraclev9i.Condition"));
        this.general.add(jLabel);
        this.tfCondition = new JTextField("", 26);
        this.general.add(this.tfCondition);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.tfCondition, 320);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.trigger.getName());
        this.tfName.setText(this.trigger.getName());
        this.tfTable.setText(this.trigger.getTable() != null ? this.trigger.getTable().getName() : this.trigger.getView().getName());
        this.cbOwner.setSelectedItem(this.trigger.getOwner());
        if (this.trigger.getActionSet().contains(Trigger.ACTION_TYPES[0])) {
            this.chbInsert.setSelected(true);
        } else {
            this.chbInsert.setSelected(false);
        }
        if (this.trigger.getActionSet().contains(Trigger.ACTION_TYPES[1])) {
            this.chbUpdate.setSelected(true);
        } else {
            this.chbUpdate.setSelected(false);
        }
        if (this.trigger.getActionSet().contains(Trigger.ACTION_TYPES[2])) {
            this.chbDelete.setSelected(true);
        } else {
            this.chbDelete.setSelected(false);
        }
        this.initDifferences();
        this.cbTriggeringTime.setSelectedItem(this.trigger.getTriggerTime());
        this.cbScope.setSelectedItem(this.trigger.getScope());
        this.cbState.setSelectedItem(this.trigger.getState());
        this.tfRef_OLD_AS.setText(this.trigger.getRef_OLD_AS());
        this.tfRef_NEW_AS.setText(this.trigger.getRef_NEW_AS());
        this.tfRef_PARENT_AS.setText(this.trigger.getRef_PARENT_AS());
        this.bodyArea.setText(this.trigger.getBody());
        this.getCommentsList().insert(this.trigger.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.trigger != null) {
            this.trigger.setOwner((UserOracle)this.cbOwner.getSelectedItem());
            this.trigger.setName(this.tfName.getText());
            this.setDifferences();
            this.trigger.clearActions();
            if (this.chbInsert.isSelected()) {
                this.trigger.setActions(Trigger.ACTION_TYPES[0]);
            }
            if (this.chbUpdate.isSelected()) {
                this.trigger.setActions(Trigger.ACTION_TYPES[1]);
            }
            if (this.chbDelete.isSelected()) {
                this.trigger.setActions(Trigger.ACTION_TYPES[2]);
            }
            this.trigger.setRef_OLD_AS(this.tfRef_OLD_AS.getText());
            this.trigger.setRef_NEW_AS(this.tfRef_NEW_AS.getText());
            this.trigger.setRef_PARENT_AS(this.tfRef_PARENT_AS.getText());
            this.trigger.setBody(this.bodyArea.getText());
            this.trigger.setComment(this.getCommentsList().getText());
        }
    }

    private void initDifferences() {
        if (this.trigger.getTable() != null) {
            this.tableLabel.setText(Messages.getString("TriggerPropertyDialogOraclev9i.Table"));
            this.chbUpdate.addActionListener(new UpdateListener());
            this.initColumnsView();
            if (this.trigger.getTable() != null) {
                ColumnProxy[] columnProxyArray = this.trigger.getTable().getColumnProxies();
                for (int i = 0; i < columnProxyArray.length; ++i) {
                    ColumnProxy columnProxy = columnProxyArray[i];
                    if (this.trigger.getColumnSet().contains(columnProxy.getObjectID())) {
                        this.selectedColumnsModel.addElement(columnProxy);
                        continue;
                    }
                    this.allColumnsModel.addElement(columnProxy);
                }
            }
            this.allColumnsList.setEnabled(this.chbUpdate.isSelected());
            this.selectedColumnsList.setEnabled(this.chbUpdate.isSelected());
            if (!this.chbUpdate.isSelected()) {
                this.allColumnsList.setSelectedIndices(new int[0]);
                this.selectedColumnsList.setSelectedIndices(new int[0]);
            }
            this.initCondition();
            this.tfCondition.setText(this.trigger.getCondition());
            if (this.trigger.getTable() != null) {
                this.fillComboItems(TriggerOracle.TRIGGER_TIMES_TABLE, this.cbTriggeringTime);
            } else {
                this.fillComboItems(TriggerOracle.TRIGGER_TIMES, this.cbTriggeringTime);
            }
            this.fillComboItems(TriggerOracle.SCOPE_TYPES, this.cbScope);
            this.fillComboItems(TriggerOracle.STATE_TYPES, this.cbState);
        } else {
            this.tableLabel.setText(Messages.getString("TriggerPropertyDialogOraclev9i.View"));
            this.fillComboItems(new String[]{TriggerOracle.TRIGGER_TIMES[2]}, this.cbTriggeringTime);
            this.cbTriggeringTime.setSelectedItem(TriggerOracle.TRIGGER_TIMES[2]);
            this.cbTriggeringTime.setEnabled(false);
            this.fillComboItems(new String[]{TriggerOracle.SCOPE_TYPES[0]}, this.cbScope);
            this.cbScope.setSelectedItem(TriggerOracle.SCOPE_TYPES[0]);
            this.cbScope.setEnabled(false);
            this.fillComboItems(TriggerOracle.STATE_TYPES, this.cbState);
        }
    }

    private void setDifferences() {
        if (this.trigger.getTable() != null) {
            this.trigger.setTriggerTime((String)this.cbTriggeringTime.getSelectedItem());
            this.trigger.setScope((String)this.cbScope.getSelectedItem());
            this.trigger.setState((String)this.cbState.getSelectedItem());
            this.trigger.setCondition(this.tfCondition.getText());
            Object[] objectArray = this.selectedColumnsModel.toArray();
            this.trigger.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (!(object instanceof ColumnProxyOraclev9i)) continue;
                this.trigger.setColumns(((ColumnProxyOraclev9i)object).getObjectID());
            }
        }
    }

    @Override
    protected boolean allowName(String string) {
        Object object = this.cbOwner.getSelectedItem();
        if (object instanceof UserOracle) {
            string = ((UserOracle)object).getName() + '.' + string;
        }
        return this.getStorageObject().allowName(string, true);
    }

    public class UpdateListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TriggerPropertyDialogOraclev9i.this.allColumnsList.setEnabled(TriggerPropertyDialogOraclev9i.this.chbUpdate.isSelected());
            TriggerPropertyDialogOraclev9i.this.selectedColumnsList.setEnabled(TriggerPropertyDialogOraclev9i.this.chbUpdate.isSelected());
            if (!TriggerPropertyDialogOraclev9i.this.chbUpdate.isSelected()) {
                TriggerPropertyDialogOraclev9i.this.allColumnsList.setSelectedIndices(new int[0]);
                TriggerPropertyDialogOraclev9i.this.selectedColumnsList.setSelectedIndices(new int[0]);
            }
        }
    }

    private class SelectedColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TriggerPropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TriggerPropertyDialogOraclev9i.this.selectedColumnsList.getSelectedIndex() == -1) {
                    TriggerPropertyDialogOraclev9i.this.bnRemoveColumns.setEnabled(false);
                } else {
                    TriggerPropertyDialogOraclev9i.this.bnRemoveColumns.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TriggerPropertyDialogOraclev9i.this.selectedColumnsModel.isEmpty()) {
                Object[] objectArray = TriggerPropertyDialogOraclev9i.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TriggerPropertyDialogOraclev9i.this.allColumnsModel.contains(object)) continue;
                    TriggerPropertyDialogOraclev9i.this.allColumnsModel.addElement(object);
                    TriggerPropertyDialogOraclev9i.this.selectedColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class AllColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TriggerPropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TriggerPropertyDialogOraclev9i.this.allColumnsList.getSelectedIndex() == -1) {
                    TriggerPropertyDialogOraclev9i.this.bnAddColumns.setEnabled(false);
                } else {
                    TriggerPropertyDialogOraclev9i.this.bnAddColumns.setEnabled(true);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TriggerPropertyDialogOraclev9i.this.allColumnsModel.isEmpty()) {
                Object[] objectArray = TriggerPropertyDialogOraclev9i.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TriggerPropertyDialogOraclev9i.this.selectedColumnsModel.contains(object)) continue;
                    TriggerPropertyDialogOraclev9i.this.selectedColumnsModel.addElement(object);
                    TriggerPropertyDialogOraclev9i.this.allColumnsModel.removeElement(object);
                }
            }
        }
    }
}

