/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableViewProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UserOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ObjectPermissionsDialogOracle;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.string.StringUtilities;

public class TableViewPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private TableViewProxyOraclev9i view;
    private JComboBox cbOwner;
    private JComboBox cbForce;
    private JComboBox cbReadOnly;
    private JComboBox cbCheckOption;
    private JComboBox cbUseOid;
    private JTextField cbCheckOptionName;
    private JTextField tfOidAttributes;
    private JTextArea taDefinition;
    private String commentInRDBMS;
    private String comment;
    private JButton bnPermissions;
    private ObjectPermissionsDialogOracle dialog;

    public TableViewPropertyDialogOraclev9i(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.view = (TableViewProxyOraclev9i)storageObject;
        this.setHeight(510);
        this.initCommentsView(220);
        this.initCommentsInRDBMS(220);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initCheckOption();
        this.initForce();
        this.initReadOnly();
        this.initCheckOptionName();
        this.initUseOID();
        this.initOIDAttributes();
        this.initDefinition();
        this.initPermissionsButton();
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogOraclev9i.User"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbOwner);
        }
        this.cbOwner.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbOwner, 50);
    }

    private void initCheckOption() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogOraclev9i.CheckOption"));
        this.general.add(jLabel);
        this.cbCheckOption = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCheckOption);
        this.cbCheckOption.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCheckOption);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbCheckOption, 80);
    }

    private void initForce() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogOraclev9i.Force"));
        this.general.add(jLabel);
        this.cbForce = new JComboBox<String>(YES_NO);
        this.setBG(this.cbForce);
        this.cbForce.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbForce);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbForce, 110);
    }

    private void initReadOnly() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogOraclev9i.ReadOnly"));
        this.general.add(jLabel);
        this.cbReadOnly = new JComboBox<String>(YES_NO);
        this.setBG(this.cbReadOnly);
        this.cbReadOnly.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbReadOnly);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbReadOnly, 140);
    }

    private void initUseOID() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogOraclev9i.UseOID"));
        this.general.add(jLabel);
        this.cbUseOid = new JComboBox<String>(TableViewProxyOracle.USE_OID_CHOICES);
        this.setBG(this.cbUseOid);
        this.cbUseOid.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUseOid);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbUseOid, 170);
    }

    private void initOIDAttributes() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogOraclev9i.OIDAttributes"));
        this.general.add(jLabel);
        this.tfOidAttributes = new JTextField();
        this.setBG(this.tfOidAttributes);
        this.tfOidAttributes.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfOidAttributes);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.tfOidAttributes, 200);
    }

    private void initCheckOptionName() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogOraclev9i.CheckOptionName"));
        this.general.add(jLabel);
        this.cbCheckOptionName = new JTextField();
        this.setBG(this.cbCheckOptionName);
        this.cbCheckOptionName.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCheckOptionName);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbCheckOptionName, 230);
    }

    private void initDefinition() {
        JLabel jLabel = new JLabel(Messages.getString("TableViewPropertyDialogOraclev9i.Definition"));
        this.general.add(jLabel);
        this.setLabelConstraints(jLabel, 260);
        this.taDefinition = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.taDefinition);
        jScrollPane.setPreferredSize(new Dimension(395, 150));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.taDefinition.setLineWrap(true);
        this.general.add(jScrollPane);
        this.setObjectConstraints(jScrollPane, 10, 280);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("TableViewPropertyDialogOraclev9i.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 450);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.view.getName());
        this.tfName.setText(this.view.getName());
        this.cbOwner.setSelectedItem(this.view.getUser());
        this.cbForce.setSelectedItem(TableViewPropertyDialogOraclev9i.translateYesNoForDisplay(this.view.getForce()));
        this.cbReadOnly.setSelectedItem(TableViewPropertyDialogOraclev9i.translateYesNoForDisplay(this.view.getReadOnly()));
        this.cbCheckOptionName.setText(this.view.getCheckOptionName());
        if (this.view.getCheckOption()) {
            this.cbCheckOption.setSelectedItem(YES);
        } else {
            this.cbCheckOption.setSelectedItem(NO);
        }
        this.taDefinition.setText(this.view.getDefinition());
        this.comment = this.view.getObject().getComment();
        this.commentInRDBMS = this.view.getObject().getCommentInRDBMS();
        if (this.view.isCommentChanged()) {
            this.getCommentsList().insert(this.view.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.view.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.view.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
    }

    @Override
    protected void setProperties() {
        if (this.view != null) {
            this.view.setName(this.tfName.getText());
            this.view.setUser((UserOraclev9i)this.cbOwner.getSelectedItem());
            this.view.setForce(TableViewPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbForce.getSelectedItem()));
            this.view.setReadOnly(TableViewPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbReadOnly.getSelectedItem()));
            this.view.setCheckOptionName(this.cbCheckOptionName.getText());
            if (((String)this.cbCheckOption.getSelectedItem()).equalsIgnoreCase(YES)) {
                this.view.setCheckOption(true);
            } else {
                this.view.setCheckOption(false);
            }
            this.view.setDefinition(this.taDefinition.getText());
            String string = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(string) && !this.comment.equals(string)) {
                this.view.setComment(string);
                this.view.setCommentChanged(true);
            } else {
                this.view.setComment("");
                this.view.setCommentChanged(false);
            }
            String string2 = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(string2) && !this.commentInRDBMS.equals(string2)) {
                this.view.setCommentInRDBMS(string2);
                this.view.setCommentInRDBMSChanged(true);
            } else {
                this.view.setCommentInRDBMS("");
                this.view.setCommentInRDBMSChanged(false);
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TableViewPropertyDialogOraclev9i.this.dialog = new ObjectPermissionsDialogOracle(TableViewPropertyDialogOraclev9i.this.getAppView(), TableViewPropertyDialogOraclev9i.this.getStorageDesign(), TableViewPropertyDialogOraclev9i.this.view);
            TableViewPropertyDialogOraclev9i.this.dialog.showDialog();
        }
    }
}

