/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.BitmapJoinIndexOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.LocalIndexPropertyDialogOraclev9i;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class TBPartitionPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog
implements ListSelectionListener {
    private PartitionOraclev9i partition;
    private JTextField tfValueList;
    private JIntegerField ifPosition;
    private JComboBox cbTableSpace;
    private JComboBox cbLogging;
    private JComboBox cbSegment;
    private JIntegerField ifIotCompress;
    private JComboBox cbIotOverflowSegment;
    private JComboBox cbSegmentCompression;
    private JIntegerField ifSubPartQuantity;
    private JPanel subPartTS;
    private JList allSubPartTSList;
    private JList selectedSubPartTSList;
    private DefaultListModel allSubPartTSModel;
    private DefaultListModel selectedSubPartTSModel;
    private JButton bnAddSubPartTS;
    private JButton bnRemoveSubPartTS;
    private JList list;
    private JPanel indexesButtonPanel;
    private DefaultListModel listModel;
    private JButton edit;

    public TBPartitionPropertyDialogOraclev9i(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.partition = (PartitionOraclev9i)storageObject;
        this.setHeight(350);
        this.initCommentsView(300);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TBPartitionPropertyDialogOracle.PartitionProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initValueList();
        this.initPosition();
        this.initTableSpace();
        this.initLogging();
        this.initSegment();
        this.initSegmentCompression();
        this.initIOTCompress();
        this.initIOTOverflowSegment();
        this.initSubPartQuantity();
    }

    private void initValueList() {
        JLabel jLabel = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.ValueList"));
        this.general.add(jLabel);
        this.tfValueList = new JTextField("", 26);
        this.general.add(this.tfValueList);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfValueList, 50);
    }

    private void initPosition() {
        JLabel jLabel = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.Position"));
        this.general.add(jLabel);
        this.ifPosition = new JIntegerField(0, 26);
        this.general.add(this.ifPosition);
        this.ifPosition.setEnabled(false);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.ifPosition, 80);
    }

    private void initTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.TableSpace"));
        this.general.add(jLabel);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbTableSpace, 110);
    }

    private void initLogging() {
        JLabel jLabel = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.Logging"));
        this.general.add(jLabel);
        this.cbLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLogging);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbLogging, 140);
    }

    private void initSegment() {
        JLabel jLabel = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.Segment"));
        this.general.add(jLabel);
        this.cbSegment = new JComboBox();
        this.setBG(this.cbSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegment);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbSegment, 170);
    }

    private void initSegmentCompression() {
        JLabel jLabel = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.SegCompression"));
        this.general.add(jLabel);
        this.cbSegmentCompression = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbSegmentCompression);
        this.cbSegmentCompression.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegmentCompression);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbSegmentCompression, 200);
    }

    private void initIOTCompress() {
        JLabel jLabel = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.IOTCompress"));
        this.general.add(jLabel);
        this.ifIotCompress = new JIntegerField(0, 26);
        this.general.add(this.ifIotCompress);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.ifIotCompress, 230);
    }

    private void initIOTOverflowSegment() {
        JLabel jLabel = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.OverflowSegment"));
        this.general.add(jLabel);
        this.cbIotOverflowSegment = new JComboBox();
        this.setBG(this.cbIotOverflowSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbIotOverflowSegment);
        }
        this.cbIotOverflowSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIotOverflowSegment);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbIotOverflowSegment, 260);
    }

    private void initSubPartQuantity() {
        JLabel jLabel = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.SubPartQuantity"));
        this.general.add(jLabel);
        this.ifSubPartQuantity = new JIntegerField(0, 26);
        this.ifSubPartQuantity.setToolTipText(Messages.getString("TBPartitionPropertyDialogOracle.PropertyAvailableIf"));
        this.general.add(this.ifSubPartQuantity);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.ifSubPartQuantity, 290);
    }

    private DefaultListModel getLocIndexes() {
        if (this.listModel == null) {
            this.listModel = new DefaultListModel();
        }
        return this.listModel;
    }

    private void initIndexesTab() {
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane(this.getList());
        jScrollPane.setPreferredSize(new Dimension(390, 270));
        jPanel.add((Component)this.getIndexesButtonPanel(), "North");
        jPanel.add((Component)jScrollPane, "Center");
        this.getPane().addTab(Messages.getString("TBPartitionPropertyDialogOracle.LocalIndexes"), jPanel);
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    protected JPanel getIndexesButtonPanel() {
        if (this.indexesButtonPanel == null) {
            this.indexesButtonPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration gUIConfiguration = GUIConfiguration.getInstance();
            this.edit = new JButton(gUIConfiguration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.edit.setToolTipText(Messages.getString("TBPartitionPropertyDialogOracle.Properties"));
            this.edit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TBPartitionPropertyDialogOraclev9i.this.editSelected();
                }
            });
            this.edit.setEnabled(false);
            JToolBar jToolBar = new JToolBar(0);
            jToolBar.setFloatable(false);
            jToolBar.add(this.edit);
            jToolBar.addSeparator();
            this.indexesButtonPanel.add(jToolBar);
            this.indexesButtonPanel.setPreferredSize(new Dimension(390, 30));
        }
        return this.indexesButtonPanel;
    }

    private void editSelected() {
        Object e = this.list.getSelectedValue();
        LocalIndexPropertyDialogOraclev9i localIndexPropertyDialogOraclev9i = new LocalIndexPropertyDialogOraclev9i(this.partition.getDesign().getAppView(), this.getStorageDesign(), this.partition, (StorageObject)e);
        localIndexPropertyDialogOraclev9i.show();
    }

    private JList getList() {
        this.list = new JList(this.getLocIndexes());
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new IndexesCellRenderer());
        this.list.addMouseListener(new listMouseListener());
        this.list.addListSelectionListener(this);
        return this.list;
    }

    @Override
    protected void addTabs() {
        this.initSubPartTSView();
        this.initIndexesTab();
    }

    private void initSubPartTSView() {
        this.subPartTS = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TBPartitionPropertyDialogOracle.SubPartTableSpaces"), this.subPartTS);
        this.initSubPartTS();
    }

    protected SpringLayout getSubPartTSLayout() {
        return (SpringLayout)this.subPartTS.getLayout();
    }

    private void initSubPartTS() {
        this.initAllSubPartTSList();
        this.initSelectedSubPartTSList();
        this.initSubPartTSButtons();
    }

    private void initAllSubPartTSList() {
        JLabel jLabel = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.AllTableSpaces"));
        this.subPartTS.add(jLabel);
        this.allSubPartTSModel = new DefaultListModel();
        this.allSubPartTSList = new JList(this.allSubPartTSModel);
        ListSelectionModel listSelectionModel = this.allSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllSubPartTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allSubPartTSList);
        jScrollPane.setPreferredSize(new Dimension(144, 290));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartTS.add(jScrollPane);
        this.setLabelConstraints(this.getSubPartTSLayout(), jLabel, 8, 4);
        this.setObjectConstraints(this.getSubPartTSLayout(), jScrollPane, 6, 22);
    }

    private void initSelectedSubPartTSList() {
        JLabel jLabel = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.SelectedTableSpaces"));
        this.subPartTS.add(jLabel);
        this.selectedSubPartTSModel = new DefaultListModel();
        this.selectedSubPartTSList = new JList(this.selectedSubPartTSModel);
        ListSelectionModel listSelectionModel = this.selectedSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedSubPartTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedSubPartTSList);
        jScrollPane.setPreferredSize(new Dimension(145, 290));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartTS.add(jScrollPane);
        this.setLabelConstraints(this.getSubPartTSLayout(), jLabel, 292, 4);
        this.setObjectConstraints(this.getSubPartTSLayout(), jScrollPane, 290, 22);
    }

    private void initSubPartTSButtons() {
        this.bnAddSubPartTS = new JButton(Messages.getString("TBPartitionPropertyDialogOracle.Add"));
        this.bnAddSubPartTS.addActionListener(new AddSubPartTSActionListener());
        this.bnAddSubPartTS.setEnabled(false);
        this.subPartTS.add(this.bnAddSubPartTS);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.bnAddSubPartTS, 175, 135);
        this.bnRemoveSubPartTS = new JButton(Messages.getString("TBPartitionPropertyDialogOracle.Remove"));
        this.bnRemoveSubPartTS.setEnabled(false);
        this.bnRemoveSubPartTS.addActionListener(new RemoveSubPartTSActionListener());
        this.subPartTS.add(this.bnRemoveSubPartTS);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.bnRemoveSubPartTS, 175, 165);
        TBPartitionPropertyDialogOraclev9i.equalizeButtonSizes(this.bnAddSubPartTS, this.bnRemoveSubPartTS);
    }

    @Override
    public void initProperties() {
        Object object;
        StorageObject storageObject;
        int n;
        this.initCaption(this.partition.getName());
        this.tfName.setText(this.partition.getName());
        this.tfValueList.setText(this.partition.getValueList());
        this.ifPosition.setValue((long)this.partition.getPosition());
        this.selectObject(this.cbTableSpace, this.partition.getTableSpace());
        this.cbLogging.setSelectedItem(TBPartitionPropertyDialogOraclev9i.translateYesNoForDisplay(this.partition.getLogging()));
        this.selectObject(this.cbSegment, this.partition.getSegment());
        this.cbSegmentCompression.setSelectedItem(TBPartitionPropertyDialogOraclev9i.translateYesNoForDisplay(this.partition.getDataSegmentCompression()));
        this.ifIotCompress.setValue((long)this.partition.getIOTCompress());
        this.selectObject(this.cbIotOverflowSegment, this.partition.getIOTOverflowSegment());
        PartitionListOracle partitionListOracle = this.partition.getPartitionList();
        if (this.partition.hasSubPartitions() || !partitionListOracle.getPartitionType().equalsIgnoreCase("COMPOSITE BY HASH")) {
            this.ifSubPartQuantity.setEnabled(false);
            n = this.getPane().indexOfComponent(this.subPartTS);
            if (n > -1) {
                this.getPane().setEnabledAt(n, false);
            }
        } else {
            this.ifSubPartQuantity.setValue((long)this.partition.getSubPartitionsQuantity());
        }
        if (partitionListOracle != null) {
            TableProxyOracle tableProxyOracle = partitionListOracle.getTable();
            if (tableProxyOracle == null && (storageObject = partitionListOracle.getSnapshot()) != null) {
                tableProxyOracle = storageObject.getImplementedTable();
            }
            if (tableProxyOracle != null) {
                Object object2;
                Object object3;
                boolean bl = tableProxyOracle.getOrganization().equals(TableProxyOracle.getOrganizationChoices()[1]);
                this.ifIotCompress.setEnabled(bl);
                this.cbIotOverflowSegment.setEnabled(bl);
                object = tableProxyOracle.getIndexProxies();
                for (int i = 0; i < ((Object)object).length; ++i) {
                    object3 = (IndexProxyOracle)object[i];
                    if (object3 == null || !((IndexProxyOracle)object3).getIndexPartitioned().equalsIgnoreCase(IndexProxyOracle.getPartitionedChoices()[1])) continue;
                    this.listModel.addElement(object3);
                }
                Iterator iterator = tableProxyOracle.getUniqueKeys().iterator();
                while (iterator.hasNext()) {
                    object3 = (UniqueOraclev9i)iterator.next();
                    if (!((UniqueOraclev9i)object3).getUsingIndex().equalsIgnoreCase(UniqueOraclev9i.getUsingIndexChoices()[1])) continue;
                    this.listModel.addElement(object3);
                }
                object3 = tableProxyOracle.getPrimaryKeys().iterator();
                while (object3.hasNext()) {
                    object2 = (PKProxyOraclev9i)object3.next();
                    if (!((PKProxyOraclev9i)object2).getUsingIndex().equalsIgnoreCase(PKProxyOraclev9i.getUsingIndexChoices()[1])) continue;
                    this.listModel.addElement(object2);
                }
                object2 = tableProxyOracle.getBjIndexes().iterator();
                while (object2.hasNext()) {
                    BitmapJoinIndexOraclev9i bitmapJoinIndexOraclev9i = (BitmapJoinIndexOraclev9i)object2.next();
                    if (!bitmapJoinIndexOraclev9i.getLocalPartitioning().equalsIgnoreCase("YES")) continue;
                    this.listModel.addElement(bitmapJoinIndexOraclev9i);
                }
            }
        }
        for (n = 0; n < this.listModel.size(); ++n) {
            if (this.listModel.get(n) instanceof IndexProxyOraclev9i) {
                storageObject = (IndexProxyOraclev9i)this.listModel.get(n);
                object = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.partition, storageObject);
                if (object != null) continue;
                object = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
                ((LocalIndexProperties)object).setIndex(storageObject);
                ((LocalIndexProperties)object).setPartition(this.partition);
                continue;
            }
            if (!(this.listModel.get(n) instanceof BitmapJoinIndexOraclev9i)) continue;
            storageObject = (BitmapJoinIndexOraclev9i)this.listModel.get(n);
            object = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.partition, storageObject);
            if (object != null) continue;
            object = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
            ((LocalIndexProperties)object).setIndex(storageObject);
            ((LocalIndexProperties)object).setPartition(this.partition);
        }
        TableSpaceOracle[] tableSpaceOracleArray = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tableSpaceOracleArray.length; ++i) {
            object = tableSpaceOracleArray[i];
            if (this.partition.getSubPartTSSet().contains(((ModelIDObject)object).getObjectID())) {
                this.selectedSubPartTSModel.addElement(object);
                continue;
            }
            this.allSubPartTSModel.addElement(object);
        }
        this.getCommentsList().insert(this.partition.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.partition != null) {
            this.partition.setName(this.tfName.getText());
            this.partition.setValueList(this.tfValueList.getText());
            Object object = this.cbTableSpace.getSelectedItem();
            if (object instanceof TableSpaceOraclev9i) {
                this.partition.setTableSpace((TableSpaceOraclev9i)object);
            } else {
                this.partition.setTableSpace(null);
            }
            this.partition.setLogging(TBPartitionPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            object = this.cbSegment.getSelectedItem();
            if (object instanceof SegmentOraclev9i) {
                this.partition.setSegment((SegmentOraclev9i)object);
            } else {
                this.partition.setSegment(null);
            }
            this.partition.setDataSegmentCompression(TBPartitionPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbSegmentCompression.getSelectedItem()));
            this.partition.setIOTCompress(this.ifIotCompress.getIntValue());
            object = this.cbIotOverflowSegment.getSelectedItem();
            if (object instanceof SegmentOraclev9i) {
                this.partition.setIOTOverflowSegment((SegmentOraclev9i)object);
            } else {
                this.partition.setIOTOverflowSegment(null);
            }
            this.partition.setSubPartitionsQuantity(this.ifSubPartQuantity.getIntValue());
            this.partition.getSubPartTSSet().clear();
            Object[] objectArray = this.selectedSubPartTSModel.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = objectArray[i];
                if (!(object2 instanceof TableSpaceOraclev9i)) continue;
                this.partition.setSubPartitionsTableSpaces(((TableSpaceOraclev9i)object2).getObjectID());
            }
            this.partition.setComment(this.getCommentsList().getText());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (this.list.getSelectedIndex() == -1) {
                this.edit.setEnabled(false);
            } else {
                this.edit.setEnabled(true);
            }
        }
    }

    private class RemoveSubPartTSActionListener
    implements ActionListener {
        private RemoveSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TBPartitionPropertyDialogOraclev9i.this.selectedSubPartTSModel.isEmpty()) {
                Object[] objectArray = TBPartitionPropertyDialogOraclev9i.this.selectedSubPartTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TBPartitionPropertyDialogOraclev9i.this.allSubPartTSModel.contains(object)) continue;
                    TBPartitionPropertyDialogOraclev9i.this.allSubPartTSModel.addElement(object);
                    TBPartitionPropertyDialogOraclev9i.this.selectedSubPartTSModel.removeElement(object);
                }
            }
        }
    }

    private class AddSubPartTSActionListener
    implements ActionListener {
        private AddSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!TBPartitionPropertyDialogOraclev9i.this.allSubPartTSModel.isEmpty()) {
                Object[] objectArray = TBPartitionPropertyDialogOraclev9i.this.allSubPartTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (TBPartitionPropertyDialogOraclev9i.this.selectedSubPartTSModel.contains(object)) continue;
                    TBPartitionPropertyDialogOraclev9i.this.selectedSubPartTSModel.addElement(object);
                    TBPartitionPropertyDialogOraclev9i.this.allSubPartTSModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TBPartitionPropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TBPartitionPropertyDialogOraclev9i.this.selectedSubPartTSList.getSelectedIndex() == -1) {
                    TBPartitionPropertyDialogOraclev9i.this.bnRemoveSubPartTS.setEnabled(false);
                } else {
                    TBPartitionPropertyDialogOraclev9i.this.bnRemoveSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class AllSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private AllSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (TBPartitionPropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (TBPartitionPropertyDialogOraclev9i.this.allSubPartTSList.getSelectedIndex() == -1) {
                    TBPartitionPropertyDialogOraclev9i.this.bnAddSubPartTS.setEnabled(false);
                } else {
                    TBPartitionPropertyDialogOraclev9i.this.bnAddSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class listMouseListener
    extends MouseAdapter {
        private listMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                TBPartitionPropertyDialogOraclev9i.this.editSelected();
            }
        }
    }

    class IndexesCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public IndexesCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof Index) {
                this.setText(((Index)object).getName());
            } else {
                this.setText(object.toString());
            }
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            return this;
        }
    }
}

