/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SynonymOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SynonymPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private SynonymOraclev9i synonym;
    private JComboBox cbUser;
    private JComboBox cbPublic;
    private JComboBox cbObjectUser;
    private JTextField tfObject;
    private JTextField tfDBLink;

    public SynonymPropertyDialogOraclev9i(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.synonym = (SynonymOraclev9i)storageObject;
        this.setHeight(230);
        this.initCommentsView();
        this.initNotesView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("SynonymPropertyDialogOraclev9i.SynonymProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initUser();
        this.initPublic();
        this.initObjectUser();
        this.initObject();
        this.initDBLink();
    }

    private void initUser() {
        JLabel jLabel = new JLabel(Messages.getString("SynonymPropertyDialogOraclev9i.User"));
        this.general.add(jLabel);
        this.cbUser = new JComboBox();
        this.setBG(this.cbUser);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbUser);
        }
        this.cbUser.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.cbUser.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUser);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbUser, 50);
    }

    private void initPublic() {
        JLabel jLabel = new JLabel(Messages.getString("SynonymPropertyDialogOraclev9i.Public"));
        this.general.add(jLabel);
        this.cbPublic = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPublic);
        this.cbPublic.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPublic);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbPublic, 80);
    }

    private void initObjectUser() {
        JLabel jLabel = new JLabel(Messages.getString("SynonymPropertyDialogOraclev9i.ObjectOwner"));
        this.general.add(jLabel);
        this.cbObjectUser = new JComboBox();
        this.setBG(this.cbObjectUser);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbObjectUser);
        }
        this.cbObjectUser.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbObjectUser);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbObjectUser, 110);
    }

    private void initObject() {
        JLabel jLabel = new JLabel(Messages.getString("SynonymPropertyDialogOraclev9i.ObjectName"));
        this.general.add(jLabel);
        this.tfObject = new JTextField("", 26);
        this.general.add(this.tfObject);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.tfObject, 140);
    }

    private void initDBLink() {
        JLabel jLabel = new JLabel(Messages.getString("SynonymPropertyDialogOraclev9i.DBLink"));
        this.general.add(jLabel);
        this.tfDBLink = new JTextField("", 26);
        this.general.add(this.tfDBLink);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.tfDBLink, 170);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.synonym.getName());
        this.tfName.setText(this.synonym.getName());
        this.selectObject(this.cbUser, this.synonym.getUser());
        this.cbPublic.setSelectedItem(SynonymPropertyDialogOraclev9i.translateYesNoForDisplay(this.synonym.getPublic()));
        this.selectObject(this.cbObjectUser, this.synonym.getObjectUser());
        this.tfObject.setText(this.synonym.getObject());
        this.tfDBLink.setText(this.synonym.getDBLink());
        this.getCommentsList().insert(this.synonym.getComment(), 0);
        this.taNotes.setText(this.synonym.getNotes());
    }

    @Override
    protected void setProperties() {
        if (this.synonym != null) {
            Object object = this.cbUser.getSelectedItem();
            if (object instanceof UserOracle) {
                this.synonym.setUser((UserOracle)object);
            } else {
                this.synonym.setUser(null);
            }
            this.synonym.setName(this.tfName.getText());
            this.synonym.setPublic(SynonymPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbPublic.getSelectedItem()));
            object = this.cbObjectUser.getSelectedItem();
            if (object instanceof UserOracle) {
                this.synonym.setObjectUser((UserOracle)object);
            } else {
                this.synonym.setObjectUser(null);
            }
            this.synonym.setObject(this.tfObject.getText());
            this.synonym.setDBLink(this.tfDBLink.getText());
            this.synonym.setComment(this.getCommentsList().getText());
            this.synonym.setNotes(this.taNotes.getText());
        }
    }

    @Override
    protected boolean allowName(String string) {
        Object object = this.cbUser.getSelectedItem();
        if (object instanceof UserOracle) {
            string = ((UserOracle)object).getName() + '.' + string;
        }
        return this.getStorageObject().allowName(string, true);
    }
}

