/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RollbackSegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SnapshotOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ObjectPermissionsDialogOracle;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class SnapshotPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private SnapshotOraclev9i snapshot;
    private JComboBox cbOwner;
    private JTextField tfStartDate;
    private JTextField tfNextDate;
    private JTextArea taBody;
    private JComboBox cbPartitioned;
    private JComboBox cbSegment;
    private JComboBox cbCluster;
    private JComboBox cbParalelClause;
    private JComboBox cbBuild;
    private JComboBox cbReducedPrecision;
    private JComboBox cbOnPrebuild;
    private JComboBox cbUseIndex;
    private JComboBox cbForUpdate;
    private JComboBox cbQueryRewrite;
    private JComboBox cbRefresh;
    private JComboBox cbLobStorage;
    private JComboBox cbRefreshType;
    private JComboBox cbAction;
    private JComboBox cbWith;
    private JComboBox cbDefaultSegment;
    private JComboBox cbSegmentType;
    private JComboBox cbRollbackSegment;
    private JComboBox cbTablespace;
    private JComboBox cbIndexTablespace;
    private JComboBox cbLogging;
    private JComboBox cbCache;
    private JPanel pnPartitioning;
    private JPanel pnPartGeneral;
    private JTabbedPane tpPartitions;
    private JComboBox cbPartType;
    private JIntegerField ifHashPQuantity;
    private JIntegerField ifSubPartQuantity;
    private JComboBox cbLocIndexTableSpace;
    private JComboBox cbLocIndexLogging;
    private JComboBox cbIndexSegment;
    private JPanel subPartColumns;
    private JPanel subPartTS;
    private JList allSubPartTSList;
    private JList selectedSubPartTSList;
    private DefaultListModel allSubPartTSModel;
    private DefaultListModel selectedSubPartTSModel;
    private JButton bnAddSubPartTS;
    private JButton bnRemoveSubPartTS;
    private JPanel hashPTS;
    private JList allHashPTSList;
    private JList selectedHashPTSList;
    private DefaultListModel allHashPTSModel;
    private DefaultListModel selectedHashPTSModel;
    private JButton bnAddHashPTS;
    private JButton bnRemoveHashPTS;
    private JTextArea taColumns;
    private JTextArea taSubPartColumns;
    private JTextArea clusterColumnsBody;
    private JPanel refreshPanel;
    private JPanel bodyPanel;
    private JPanel clusterColumnsPanel;
    protected JScrollPane spBody;
    private JButton bnPermissions;
    private ObjectPermissionsDialogOracle dialog;
    private JTextField tfImplementedTable;

    public SnapshotPropertyDialogOraclev9i(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.snapshot = (SnapshotOraclev9i)storageObject;
        this.setHeight(650);
        this.initCommentsView(280);
        this.initCommentsInRDBMS(280);
        this.initNotesView(560);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    protected int getDialogWidth() {
        return 480;
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initImplementedTable();
        this.initOwner();
        this.initLobStorage();
        this.initPartitioned();
        this.initSegment();
        this.initCluster();
        this.initParalelClause();
        this.initBuild();
        this.initReducedPrecision();
        this.initOnPrebuild();
        this.initUseIndex();
        this.initForUpdate();
        this.initQueryRewrite();
        this.initTablespace();
        this.initIndexTablespace();
        this.initLogging();
        this.initCache();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
        this.initPermissionsButton();
    }

    @Override
    protected void addTabs() {
        this.initBodyView();
        this.initClusterColumnsView();
        this.initPartitioningView();
        this.initRefreshView();
    }

    private void initBodyView() {
        this.bodyPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SnapshotPropertyDialogOracle.Body"), this.bodyPanel);
        this.taBody = new JTextArea();
        this.spBody = new JScrollPane(this.taBody);
        this.spBody.setPreferredSize(new Dimension(395, 580));
        this.spBody.setBorder(BorderFactory.createEtchedBorder(0));
        this.taBody.setLineWrap(true);
        this.bodyPanel.add(this.spBody);
        this.setObjectConstraints(this.getBodyLayout(), this.spBody, 10, 12);
    }

    private void initClusterColumnsView() {
        this.clusterColumnsPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SnapshotPropertyDialogOracle.ClusterColumns"), this.clusterColumnsPanel);
        this.clusterColumnsBody = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.clusterColumnsBody);
        jScrollPane.setPreferredSize(new Dimension(395, 580));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.clusterColumnsBody.setLineWrap(true);
        this.clusterColumnsPanel.add(jScrollPane);
        this.setObjectConstraints(this.getClusterColumnsLayout(), jScrollPane, 10, 12);
    }

    private void initRefreshView() {
        this.refreshPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SnapshotPropertyDialogOracle.RefreshClause"), this.refreshPanel);
        this.initRefresh();
        this.initRefreshType();
        this.initAction();
        this.initStartDate();
        this.initNextDate();
        this.initWith();
        this.initDefaultSegment();
        this.initSegmentType();
        this.initRollbackSegment();
    }

    private void initImplementedTable() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.ImplementsTable"));
        this.general.add(jLabel);
        this.tfImplementedTable = new JTextField();
        this.tfImplementedTable.setEnabled(false);
        this.setBG(this.tfImplementedTable);
        this.tfImplementedTable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfImplementedTable);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfImplementedTable, 50);
    }

    private void initOwner() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.User"));
        this.general.add(jLabel);
        this.cbOwner = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbOwner);
        }
        this.cbOwner.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.setBG(this.cbOwner);
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbOwner, 80);
    }

    private void initLobStorage() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.LobStorage"));
        this.general.add(jLabel);
        this.cbLobStorage = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getLobStorageSet().toArray(), this.cbLobStorage);
        }
        this.setBG(this.cbLobStorage);
        this.cbLobStorage.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLobStorage);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.cbLobStorage, 110);
    }

    private void initPartitioned() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Partitioned"));
        this.general.add(jLabel);
        this.cbPartitioned = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPartitioned);
        this.cbPartitioned.setPreferredSize(this.tfName.getPreferredSize());
        this.cbPartitioned.addActionListener(new PartitionedAction());
        this.general.add(this.cbPartitioned);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbPartitioned, 140);
    }

    private void initSegment() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Segment"));
        this.general.add(jLabel);
        this.cbSegment = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.setBG(this.cbSegment);
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegment);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbSegment, 260);
    }

    private void clusterStateChanged() {
        boolean bl;
        boolean bl2 = bl = this.cbCluster.getSelectedItem() == null;
        if (this.cbTablespace != null) {
            this.cbTablespace.setEnabled(bl);
        }
        if (this.cbSegment != null) {
            this.cbSegment.setEnabled(bl);
        }
    }

    private void initCluster() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Cluster"));
        this.general.add(jLabel);
        this.cbCluster = new JComboBox();
        this.cbCluster.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotPropertyDialogOraclev9i.this.clusterStateChanged();
            }
        });
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getClusterSet().toArray(), this.cbCluster);
        }
        this.setBG(this.cbCluster);
        this.cbCluster.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCluster);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbCluster, 170);
    }

    private void initParalelClause() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.ParalelClause"));
        this.general.add(jLabel);
        this.cbParalelClause = new JComboBox<String>(YES_NO);
        this.setBG(this.cbParalelClause);
        this.cbParalelClause.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbParalelClause);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.cbParalelClause, 290);
    }

    private void initBuild() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Build"));
        this.general.add(jLabel);
        this.cbBuild = new JComboBox<String>(SnapshotOracle.BUILD_STATES);
        this.setBG(this.cbBuild);
        this.cbBuild.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbBuild);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.cbBuild, 320);
    }

    private void initReducedPrecision() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.ReducedPrecision"));
        this.general.add(jLabel);
        this.cbReducedPrecision = new JComboBox<String>(YES_NO);
        this.setBG(this.cbReducedPrecision);
        this.cbReducedPrecision.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbReducedPrecision);
        this.setLabelConstraints(jLabel, 380);
        this.setObjectConstraints(this.cbReducedPrecision, 380);
    }

    private void initOnPrebuild() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.OnPrebuildTable"));
        this.general.add(jLabel);
        this.cbOnPrebuild = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableProxySet().getElements().toArray(), this.cbOnPrebuild);
        }
        this.cbOnPrebuild.addItem(Messages.getString("SnapshotPropertyDialogOracle.None"));
        this.cbOnPrebuild.addActionListener(new PrebuildListener());
        this.setBG(this.cbOnPrebuild);
        this.cbOnPrebuild.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOnPrebuild);
        this.setLabelConstraints(jLabel, 350);
        this.setObjectConstraints(this.cbOnPrebuild, 350);
    }

    private void initUseIndex() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.UseIndex"));
        this.general.add(jLabel);
        this.cbUseIndex = new JComboBox<String>(NONE_YES_NO);
        this.setBG(this.cbUseIndex);
        this.cbUseIndex.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUseIndex);
        this.setLabelConstraints(jLabel, 470);
        this.setObjectConstraints(this.cbUseIndex, 470);
    }

    private void initForUpdate() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.ForUpdate"));
        this.general.add(jLabel);
        this.cbForUpdate = new JComboBox<String>(YES_NO);
        this.setBG(this.cbForUpdate);
        this.cbForUpdate.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbForUpdate);
        this.setLabelConstraints(jLabel, 410);
        this.setObjectConstraints(this.cbForUpdate, 410);
    }

    private void initQueryRewrite() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.QueryRewrite"));
        this.general.add(jLabel);
        this.cbQueryRewrite = new JComboBox<String>(SnapshotOracle.QUERY_REWRITE_STATES);
        this.setBG(this.cbQueryRewrite);
        this.cbQueryRewrite.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbQueryRewrite);
        this.setLabelConstraints(jLabel, 440);
        this.setObjectConstraints(this.cbQueryRewrite, 440);
    }

    private void initTablespace() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Tablespace"));
        this.general.add(jLabel);
        this.cbTablespace = new JComboBox();
        this.setBG(this.cbTablespace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTablespace);
        }
        this.cbTablespace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTablespace);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbTablespace, 200);
    }

    private void initIndexTablespace() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.IndexTablespace"));
        this.general.add(jLabel);
        this.cbIndexTablespace = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbIndexTablespace);
        }
        this.setBG(this.cbIndexTablespace);
        this.cbIndexTablespace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIndexTablespace);
        this.setLabelConstraints(jLabel, 500);
        this.setObjectConstraints(this.cbIndexTablespace, 500);
    }

    private void initLogging() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Logging"));
        this.general.add(jLabel);
        this.cbLogging = new JComboBox<String>(NONE_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLogging);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbLogging, 230);
    }

    private void initCache() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Cache"));
        this.general.add(jLabel);
        this.cbCache = new JComboBox<String>(NONE_YES_NO);
        this.setBG(this.cbCache);
        this.cbCache.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCache);
        this.setLabelConstraints(jLabel, 530);
        this.setObjectConstraints(this.cbCache, 530);
    }

    private void initPropagatePropsButton() {
        JButton jButton = new JButton(Messages.getString("SnapshotPropertyDialogOracle.PropagateProperties"));
        jButton.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(SnapshotPropertyDialogOraclev9i.this.getStorageDesign().getSnapshotSet().getElementsList());
                arrayList.remove(SnapshotPropertyDialogOraclev9i.this.snapshot);
                new PropertiesPropagationDialog(SnapshotPropertyDialogOraclev9i.this.getAppView(), SnapshotPropertyDialogOraclev9i.this.snapshot, arrayList).showDialog();
            }
        });
        this.general.add(jButton);
        this.setObjectConstraints(jButton, 10, 570);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("SnapshotPropertyDialogOracle.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 570);
    }

    private void initRefresh() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Refresh"));
        this.refreshPanel.add(jLabel);
        this.cbRefresh = new JComboBox<String>(SnapshotOracle.REFRESH_STATES);
        this.setBG(this.cbRefresh);
        this.cbRefresh.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.cbRefresh);
        this.setLabelConstraints(this.getRefreshLayout(), jLabel, 10, 20);
        this.setObjectConstraints(this.getRefreshLayout(), this.cbRefresh, 20);
    }

    private void initRefreshType() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.RefreshType"));
        this.refreshPanel.add(jLabel);
        this.cbRefreshType = new JComboBox<String>(SnapshotOracle.REFRESH_TYPE_STATES);
        this.setBG(this.cbRefreshType);
        this.cbRefreshType.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.cbRefreshType);
        this.setLabelConstraints(this.getRefreshLayout(), jLabel, 10, 50);
        this.setObjectConstraints(this.getRefreshLayout(), this.cbRefreshType, 50);
    }

    private void updateDates() {
        this.tfStartDate.setEnabled(this.cbAction.getSelectedIndex() == 0);
        this.tfNextDate.setEnabled(this.tfStartDate.isEnabled());
    }

    private void initAction() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.Action"));
        this.refreshPanel.add(jLabel);
        this.cbAction = new JComboBox<String>(SnapshotOracle.ACTION_STATES);
        this.cbAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotPropertyDialogOraclev9i.this.updateDates();
            }
        });
        this.setBG(this.cbAction);
        this.cbAction.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.cbAction);
        this.setLabelConstraints(this.getRefreshLayout(), jLabel, 10, 80);
        this.setObjectConstraints(this.getRefreshLayout(), this.cbAction, 80);
    }

    private void initStartDate() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.StartDate"));
        this.refreshPanel.add(jLabel);
        this.tfStartDate = new JTextField();
        this.setBG(this.tfStartDate);
        this.tfStartDate.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.tfStartDate);
        this.setLabelConstraints(this.getRefreshLayout(), jLabel, 10, 110);
        this.setObjectConstraints(this.getRefreshLayout(), this.tfStartDate, 110);
    }

    private void initNextDate() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.NextDate"));
        this.refreshPanel.add(jLabel);
        this.tfNextDate = new JTextField();
        this.setBG(this.tfNextDate);
        this.tfNextDate.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.tfNextDate);
        this.setLabelConstraints(this.getRefreshLayout(), jLabel, 10, 140);
        this.setObjectConstraints(this.getRefreshLayout(), this.tfNextDate, 140);
    }

    private void initWith() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.With"));
        this.refreshPanel.add(jLabel);
        this.cbWith = new JComboBox<String>(SnapshotOracle.WITH_STATES);
        this.setBG(this.cbWith);
        this.cbWith.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.cbWith);
        this.setLabelConstraints(this.getRefreshLayout(), jLabel, 10, 170);
        this.setObjectConstraints(this.getRefreshLayout(), this.cbWith, 170);
    }

    private void updateRollbackSegment() {
        this.cbRollbackSegment.setEnabled(!YES.equalsIgnoreCase((String)this.cbDefaultSegment.getSelectedItem()));
    }

    private void initDefaultSegment() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.DefaultSegment"));
        this.refreshPanel.add(jLabel);
        this.cbDefaultSegment = new JComboBox<String>(YES_NO);
        this.cbDefaultSegment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotPropertyDialogOraclev9i.this.updateRollbackSegment();
            }
        });
        this.setBG(this.cbDefaultSegment);
        this.cbDefaultSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.cbDefaultSegment);
        this.setLabelConstraints(this.getRefreshLayout(), jLabel, 10, 200);
        this.setObjectConstraints(this.getRefreshLayout(), this.cbDefaultSegment, 200);
    }

    private void initSegmentType() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.SegmentType"));
        this.refreshPanel.add(jLabel);
        this.cbSegmentType = new JComboBox<String>(SnapshotOracle.SEGMENT_TYPE_STATES);
        this.setBG(this.cbSegmentType);
        this.cbSegmentType.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.cbSegmentType);
        this.setLabelConstraints(this.getRefreshLayout(), jLabel, 10, 230);
        this.setObjectConstraints(this.getRefreshLayout(), this.cbSegmentType, 230);
    }

    private void initRollbackSegment() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOracle.RollbackSegment"));
        this.refreshPanel.add(jLabel);
        this.cbRollbackSegment = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getRollbackSegmentSet().toArray(), this.cbRollbackSegment);
        }
        this.setBG(this.cbRollbackSegment);
        this.cbRollbackSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.refreshPanel.add(this.cbRollbackSegment);
        this.setLabelConstraints(this.getRefreshLayout(), jLabel, 10, 260);
        this.setObjectConstraints(this.getRefreshLayout(), this.cbRollbackSegment, 260);
    }

    private void initPartitioningView() {
        this.pnPartitioning = new JPanel(new BorderLayout());
        this.getPane().addTab(Messages.getString("SnapshotPropertyDialogOraclev9i.Partitioning"), this.pnPartitioning);
        this.tpPartitions = new JTabbedPane();
        this.pnPartitioning.add((Component)this.tpPartitions, "Center");
        this.pnPartGeneral = new JPanel(new SpringLayout());
        this.hashPTS = new JPanel(new SpringLayout());
        this.subPartColumns = new JPanel(new SpringLayout());
        this.subPartTS = new JPanel(new SpringLayout());
        this.tpPartitions.addTab(Messages.getString("SnapshotPropertyDialogOraclev9i.General"), this.pnPartGeneral);
        this.tpPartitions.addTab(Messages.getString("SnapshotPropertyDialogOraclev9i.HashPartTableSpaces"), this.hashPTS);
        this.tpPartitions.addTab(Messages.getString("SnapshotPropertyDialogOraclev9i.SubPartColumns"), this.subPartColumns);
        this.tpPartitions.addTab(Messages.getString("SnapshotPropertyDialogOraclev9i.HashSubPartTableSpaces"), this.subPartTS);
        this.initPartitioning();
    }

    protected SpringLayout getHashPTSLayout() {
        return (SpringLayout)this.hashPTS.getLayout();
    }

    protected SpringLayout getSubPartTSLayout() {
        return (SpringLayout)this.subPartTS.getLayout();
    }

    protected SpringLayout getSubPartColumnsLayout() {
        return (SpringLayout)this.subPartColumns.getLayout();
    }

    protected SpringLayout getGeneralPartitioningLayout() {
        return (SpringLayout)this.pnPartGeneral.getLayout();
    }

    private void initPartitioning() {
        this.initGeneralPartitioning();
        this.initHashPTS();
        this.initSubPartColumns();
        this.initSubPartTS();
    }

    private void initGeneralPartitioning() {
        this.initPartType();
        this.initHashPQuantity();
        this.initSubPartQuantity();
        this.initLocIndexTableSpace();
        this.initLocIndexLogging();
        this.initIndexSegment();
        this.initColumns();
    }

    private void initColumns() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOraclev9i.PartitioningColumns"));
        this.pnPartGeneral.add(jLabel);
        this.taColumns = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.taColumns);
        jScrollPane.setPreferredSize(new Dimension(395, 330));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.pnPartGeneral.add(jScrollPane);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), jLabel, 200);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), jScrollPane, 10, 220);
    }

    private void initHashPTS() {
        this.initAllHashPTSList();
        this.initSelectedHashPTSList();
        this.initHashPTSButtons();
    }

    private void initSubPartColumns() {
        this.taSubPartColumns = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.taSubPartColumns);
        jScrollPane.setPreferredSize(new Dimension(390, 535));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartColumns.add(jScrollPane);
        this.setObjectConstraints(this.getSubPartColumnsLayout(), jScrollPane, 10, 12);
    }

    private void initSubPartTS() {
        this.initAllSubPartTSList();
        this.initSelectedSubPartTSList();
        this.initSubPartTSButtons();
    }

    private void initPartType() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOraclev9i.PartitionType"));
        this.pnPartGeneral.add(jLabel);
        this.cbPartType = new JComboBox<String>(PartitionListOraclev9i.getPartitionTypes());
        this.setBG(this.cbPartType);
        this.cbPartType.setPreferredSize(this.tfName.getPreferredSize());
        this.pnPartGeneral.add(this.cbPartType);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), jLabel, 20);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.cbPartType, 20);
    }

    private void initHashPQuantity() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOraclev9i.HashPQuantity"));
        this.pnPartGeneral.add(jLabel);
        this.ifHashPQuantity = new JIntegerField(0, 26);
        this.pnPartGeneral.add(this.ifHashPQuantity);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), jLabel, 50);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.ifHashPQuantity, 50);
    }

    private void initSubPartQuantity() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOraclev9i.SubPartQuantity"));
        this.pnPartGeneral.add(jLabel);
        this.ifSubPartQuantity = new JIntegerField(0, 26);
        this.pnPartGeneral.add(this.ifSubPartQuantity);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), jLabel, 80);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.ifSubPartQuantity, 80);
    }

    private void initLocIndexTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOraclev9i.IndexTableSpace"));
        this.pnPartGeneral.add(jLabel);
        this.cbLocIndexTableSpace = new JComboBox();
        this.setBG(this.cbLocIndexTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbLocIndexTableSpace);
        }
        this.cbLocIndexTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.pnPartGeneral.add(this.cbLocIndexTableSpace);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), jLabel, 110);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.cbLocIndexTableSpace, 110);
    }

    private void initLocIndexLogging() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOraclev9i.IndexLogging"));
        this.pnPartGeneral.add(jLabel);
        this.cbLocIndexLogging = new JComboBox<String>(YES_NO);
        this.setBG(this.cbLocIndexLogging);
        this.cbLocIndexLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.pnPartGeneral.add(this.cbLocIndexLogging);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), jLabel, 140);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.cbLocIndexLogging, 140);
    }

    private void initIndexSegment() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOraclev9i.IndexSegment"));
        this.pnPartGeneral.add(jLabel);
        this.cbIndexSegment = new JComboBox();
        this.setBG(this.cbIndexSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbIndexSegment);
        }
        this.cbIndexSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.pnPartGeneral.add(this.cbIndexSegment);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), jLabel, 170);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.cbIndexSegment, 170);
    }

    private void initAllHashPTSList() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOraclev9i.AllTableSpaces"));
        this.hashPTS.add(jLabel);
        this.allHashPTSModel = new DefaultListModel();
        this.allHashPTSList = new JList(this.allHashPTSModel);
        ListSelectionModel listSelectionModel = this.allHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllHashPTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allHashPTSList);
        jScrollPane.setPreferredSize(new Dimension(144, 525));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashPTS.add(jScrollPane);
        this.setLabelConstraints(this.getHashPTSLayout(), jLabel, 8, 4);
        this.setObjectConstraints(this.getHashPTSLayout(), jScrollPane, 6, 22);
    }

    private void initSelectedHashPTSList() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOraclev9i.SelectedTableSpaces"));
        this.hashPTS.add(jLabel);
        this.selectedHashPTSModel = new DefaultListModel();
        this.selectedHashPTSList = new JList(this.selectedHashPTSModel);
        ListSelectionModel listSelectionModel = this.selectedHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedHashPTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedHashPTSList);
        jScrollPane.setPreferredSize(new Dimension(145, 525));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashPTS.add(jScrollPane);
        this.setLabelConstraints(this.getHashPTSLayout(), jLabel, 292, 4);
        this.setObjectConstraints(this.getHashPTSLayout(), jScrollPane, 290, 22);
    }

    private void initHashPTSButtons() {
        this.bnAddHashPTS = new JButton(ADD_CAPTION);
        this.bnAddHashPTS.addActionListener(new AddHashPTSActionListener());
        this.bnAddHashPTS.setEnabled(false);
        this.hashPTS.add(this.bnAddHashPTS);
        this.setObjectConstraints(this.getHashPTSLayout(), this.bnAddHashPTS, 175, 195);
        this.bnRemoveHashPTS = new JButton(REMOVE_CAPTION);
        this.bnRemoveHashPTS.setEnabled(false);
        this.bnRemoveHashPTS.addActionListener(new RemoveHashPTSActionListener());
        this.hashPTS.add(this.bnRemoveHashPTS);
        this.setObjectConstraints(this.getHashPTSLayout(), this.bnRemoveHashPTS, 175, 225);
        SnapshotPropertyDialogOraclev9i.equalizeButtonSizes(this.bnAddHashPTS, this.bnRemoveHashPTS);
    }

    private void setPartitioning(boolean bl) {
        this.taColumns.setEnabled(bl);
        this.allHashPTSList.setEnabled(bl);
        this.selectedHashPTSList.setEnabled(bl);
        this.bnAddHashPTS.setEnabled(bl && this.allHashPTSList.getSelectedIndex() != -1);
        this.bnRemoveHashPTS.setEnabled(bl && this.selectedHashPTSList.getSelectedIndex() != -1);
        this.taSubPartColumns.setEnabled(bl);
        this.allSubPartTSList.setEnabled(bl);
        this.selectedSubPartTSList.setEnabled(bl);
        this.bnAddSubPartTS.setEnabled(bl && this.allSubPartTSList.getSelectedIndex() != -1);
        this.bnRemoveSubPartTS.setEnabled(bl && this.selectedSubPartTSList.getSelectedIndex() != -1);
        this.cbPartType.setEnabled(bl);
        this.ifHashPQuantity.setEditable(bl);
        this.ifSubPartQuantity.setEditable(bl);
        this.cbLocIndexTableSpace.setEnabled(bl);
        this.cbLocIndexLogging.setEnabled(bl);
        this.cbIndexSegment.setEnabled(bl);
        this.allHashPTSModel.clear();
        this.selectedHashPTSModel.clear();
        this.allSubPartTSModel.clear();
        this.selectedSubPartTSModel.clear();
        if (bl) {
            this.initPartColumns();
            this.initHashPTS((PartitionListOraclev9i)this.snapshot.getPartitionList());
            this.initSubPartColumnsArea();
            this.initSubPartTS((PartitionListOraclev9i)this.snapshot.getPartitionList());
        }
    }

    private void initPartColumns() {
        this.taColumns.setText(this.snapshot.getColumns());
    }

    private void initHashPTS(PartitionListOraclev9i partitionListOraclev9i) {
        if (this.getStorageDesign().getTableSpaceSet().size() > 0) {
            Object[] objectArray = this.getStorageDesign().getTableSpaceSet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                TableSpaceOraclev9i tableSpaceOraclev9i = (TableSpaceOraclev9i)objectArray[i];
                if (partitionListOraclev9i != null && partitionListOraclev9i.getHashPartitionsTableSpacesSet().contains(tableSpaceOraclev9i.getObjectID())) {
                    this.selectedHashPTSModel.addElement(tableSpaceOraclev9i);
                    continue;
                }
                this.allHashPTSModel.addElement(tableSpaceOraclev9i);
            }
        }
    }

    private void initSubPartColumnsArea() {
        this.taSubPartColumns.setText(this.snapshot.getSubPartColumns());
    }

    private void initSubPartTS(PartitionListOraclev9i partitionListOraclev9i) {
        if (this.getStorageDesign().getTableSpaceSet().size() > 0) {
            TableSpaceOracle[] tableSpaceOracleArray = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
            for (int i = 0; i < tableSpaceOracleArray.length; ++i) {
                TableSpaceOracle tableSpaceOracle = tableSpaceOracleArray[i];
                if (partitionListOraclev9i != null && partitionListOraclev9i.getSubPartitionsTableSpacesSet().contains(tableSpaceOracle.getObjectID())) {
                    this.selectedSubPartTSModel.addElement(tableSpaceOracle);
                    continue;
                }
                this.allSubPartTSModel.addElement(tableSpaceOracle);
            }
        }
    }

    private void initAllSubPartTSList() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOraclev9i.AllTableSpaces"));
        this.subPartTS.add(jLabel);
        this.allSubPartTSModel = new DefaultListModel();
        this.allSubPartTSList = new JList(this.allSubPartTSModel);
        ListSelectionModel listSelectionModel = this.allSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllSubPartTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allSubPartTSList);
        jScrollPane.setPreferredSize(new Dimension(144, 525));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartTS.add(jScrollPane);
        this.setLabelConstraints(this.getSubPartTSLayout(), jLabel, 8, 4);
        this.setObjectConstraints(this.getSubPartTSLayout(), jScrollPane, 6, 22);
    }

    private void initSelectedSubPartTSList() {
        JLabel jLabel = new JLabel(Messages.getString("SnapshotPropertyDialogOraclev9i.SelectedTableSpaces"));
        this.subPartTS.add(jLabel);
        this.selectedSubPartTSModel = new DefaultListModel();
        this.selectedSubPartTSList = new JList(this.selectedSubPartTSModel);
        ListSelectionModel listSelectionModel = this.selectedSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedSubPartTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedSubPartTSList);
        jScrollPane.setPreferredSize(new Dimension(145, 525));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartTS.add(jScrollPane);
        this.setLabelConstraints(this.getSubPartTSLayout(), jLabel, 292, 4);
        this.setObjectConstraints(this.getSubPartTSLayout(), jScrollPane, 290, 22);
    }

    private void initSubPartTSButtons() {
        this.bnAddSubPartTS = new JButton(ADD_CAPTION);
        this.bnAddSubPartTS.addActionListener(new AddSubPartTSActionListener());
        this.bnAddSubPartTS.setEnabled(false);
        this.subPartTS.add(this.bnAddSubPartTS);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.bnAddSubPartTS, 175, 195);
        this.bnRemoveSubPartTS = new JButton(REMOVE_CAPTION);
        this.bnRemoveSubPartTS.setEnabled(false);
        this.bnRemoveSubPartTS.addActionListener(new RemoveSubPartTSActionListener());
        this.subPartTS.add(this.bnRemoveSubPartTS);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.bnRemoveSubPartTS, 175, 225);
        SnapshotPropertyDialogOraclev9i.equalizeButtonSizes(this.bnAddSubPartTS, this.bnRemoveSubPartTS);
    }

    protected SpringLayout getRefreshLayout() {
        return (SpringLayout)this.refreshPanel.getLayout();
    }

    protected SpringLayout getBodyLayout() {
        return (SpringLayout)this.bodyPanel.getLayout();
    }

    protected SpringLayout getClusterColumnsLayout() {
        return (SpringLayout)this.clusterColumnsPanel.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.snapshot.getName());
        this.tfName.setText(this.snapshot.getName());
        this.tfImplementedTable.setText(this.snapshot.getImplementedTable() != null ? this.snapshot.getImplementedTable().getName() : "");
        this.cbOwner.setSelectedItem(this.snapshot.getUser());
        this.cbLobStorage.setSelectedItem(this.snapshot.getLobStorage());
        this.cbPartitioned.setSelectedItem(SnapshotPropertyDialogOraclev9i.translateYesNoForDisplay(this.snapshot.getPartitioned()));
        this.cbSegment.setSelectedItem(this.snapshot.getSegment());
        this.cbCluster.setSelectedItem(this.snapshot.getCluster());
        this.cbParalelClause.setSelectedItem(SnapshotPropertyDialogOraclev9i.translateYesNoForDisplay(this.snapshot.getParalelClause()));
        this.cbBuild.setSelectedItem(this.snapshot.getBuild());
        this.cbReducedPrecision.setSelectedItem(SnapshotPropertyDialogOraclev9i.translateYesNoForDisplay(this.snapshot.getReducedPrecision()));
        if (this.snapshot.getImplementedTable() != null) {
            this.cbOnPrebuild.setEnabled(false);
        } else {
            this.cbOnPrebuild.setSelectedItem(this.snapshot.getOnPrebuildTable());
        }
        this.cbUseIndex.setSelectedItem(SnapshotPropertyDialogOraclev9i.translateNoneYesNoForDisplay(this.snapshot.getUseIndex()));
        this.cbForUpdate.setSelectedItem(SnapshotPropertyDialogOraclev9i.translateYesNoForDisplay(this.snapshot.getForUpdate()));
        this.cbQueryRewrite.setSelectedItem(this.snapshot.getQueryRewrite());
        this.cbTablespace.setSelectedItem(this.snapshot.getTablespace());
        this.cbIndexTablespace.setSelectedItem(this.snapshot.getIndexTablespace());
        this.cbLogging.setSelectedItem(SnapshotPropertyDialogOraclev9i.translateNoneYesNoForDisplay(this.snapshot.getLogging()));
        this.cbCache.setSelectedItem(SnapshotPropertyDialogOraclev9i.translateNoneYesNoForDisplay(this.snapshot.getCache()));
        this.taBody.setText(this.snapshot.getSubquery());
        this.clusterColumnsBody.setText(this.snapshot.getClusterColumns());
        if (this.snapshot.getPartitionList() != null) {
            this.setPartitioning(true);
            PartitionListOraclev9i partitionListOraclev9i = (PartitionListOraclev9i)this.snapshot.getPartitionList();
            this.cbPartType.setSelectedItem(partitionListOraclev9i.getPartitionType());
            this.ifHashPQuantity.setValue((long)partitionListOraclev9i.getHashPQuantity());
            this.ifSubPartQuantity.setValue((long)partitionListOraclev9i.getSubPartitionsQuantity());
        }
        this.cbRefresh.setSelectedItem(this.snapshot.getRefresh());
        this.cbRefreshType.setSelectedItem(this.snapshot.getRefreshType());
        this.cbAction.setSelectedItem(this.snapshot.getAction());
        if (this.cbAction.getSelectedIndex() == 0) {
            this.tfStartDate.setText(this.snapshot.getStartDate());
            this.tfNextDate.setText(this.snapshot.getNextDate());
        }
        this.cbWith.setSelectedItem(this.snapshot.getWith());
        this.cbDefaultSegment.setSelectedItem(SnapshotPropertyDialogOraclev9i.translateYesNoForDisplay(this.snapshot.getDefaultSegment()));
        this.cbSegmentType.setSelectedItem(this.snapshot.getSegmentType());
        this.cbRollbackSegment.setSelectedItem(this.snapshot.getRollbackSegment());
        this.getCommentsList().insert(this.snapshot.getComment(), 0);
        this.taCommentsInRDBMS.insert(this.snapshot.getCommentInRDBMS(), 0);
        this.taNotes.setText(this.snapshot.getNotes());
        this.updateDates();
        this.updateRollbackSegment();
        this.clusterStateChanged();
    }

    @Override
    protected void setProperties() {
        if (this.snapshot != null) {
            this.snapshot.setUser((UserOracle)this.cbOwner.getSelectedItem());
            this.snapshot.setName(this.tfName.getText());
            this.snapshot.setLobStorage((LobStorageOracle)this.cbLobStorage.getSelectedItem());
            this.snapshot.setPartitioned(SnapshotPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbPartitioned.getSelectedItem()));
            this.snapshot.setSegment((SegmentOracle)this.cbSegment.getSelectedItem());
            this.snapshot.setCluster((ClusterOracle)this.cbCluster.getSelectedItem());
            this.snapshot.setParalelClause(SnapshotPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbParalelClause.getSelectedItem()));
            this.snapshot.setBuild((String)this.cbBuild.getSelectedItem());
            this.snapshot.setReducedPrecision(SnapshotPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbReducedPrecision.getSelectedItem()));
            if (this.cbOnPrebuild.getSelectedItem() instanceof String) {
                this.snapshot.setOnPrebuildTable(null);
            } else {
                this.snapshot.setOnPrebuildTable((TableProxyOracle)this.cbOnPrebuild.getSelectedItem());
            }
            this.snapshot.setUseIndex(SnapshotPropertyDialogOraclev9i.translateNoneYesNoForStorage((String)this.cbUseIndex.getSelectedItem()));
            this.snapshot.setForUpdate(SnapshotPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbForUpdate.getSelectedItem()));
            this.snapshot.setQueryRewrite((String)this.cbQueryRewrite.getSelectedItem());
            this.snapshot.setTablespace((TableSpaceOracle)this.cbTablespace.getSelectedItem());
            this.snapshot.setIndexTablespace((TableSpaceOracle)this.cbIndexTablespace.getSelectedItem());
            this.snapshot.setLogging(SnapshotPropertyDialogOraclev9i.translateNoneYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            this.snapshot.setCache(SnapshotPropertyDialogOraclev9i.translateNoneYesNoForStorage((String)this.cbCache.getSelectedItem()));
            this.snapshot.setSubquery(this.taBody.getText());
            this.snapshot.setClusterColumns(this.clusterColumnsBody.getText());
            Object object = this.cbPartitioned.getSelectedItem();
            boolean bl = String.valueOf(object).equalsIgnoreCase(YES);
            if (bl) {
                Object object2;
                int n;
                PartitionListOraclev9i partitionListOraclev9i = this.snapshot.getPartitionList() != null ? (PartitionListOraclev9i)this.snapshot.getPartitionList() : (PartitionListOraclev9i)this.getStorageDesign().getPartitionListSet().createPartitionList();
                partitionListOraclev9i.setPartitionType((String)this.cbPartType.getSelectedItem());
                partitionListOraclev9i.setHashPQuantity(this.ifHashPQuantity.getIntValue());
                partitionListOraclev9i.setSubPartitionsQuantity(this.ifSubPartQuantity.getIntValue());
                object = this.cbLocIndexTableSpace.getSelectedItem();
                this.snapshot.setPartitionList(partitionListOraclev9i);
                partitionListOraclev9i.clear();
                this.snapshot.setColumns(this.taColumns.getText());
                Object[] objectArray = this.selectedHashPTSModel.toArray();
                for (n = 0; n < objectArray.length; ++n) {
                    object2 = objectArray[n];
                    if (!(object2 instanceof TableSpaceOracle)) continue;
                    partitionListOraclev9i.setHashPTableSpaces(((TableSpaceOracle)object2).getObjectID());
                }
                this.snapshot.setSubPartColumns(this.taSubPartColumns.getText());
                objectArray = this.selectedSubPartTSModel.toArray();
                for (n = 0; n < objectArray.length; ++n) {
                    object2 = objectArray[n];
                    if (!(object2 instanceof TableSpaceOracle)) continue;
                    partitionListOraclev9i.setSubPartitionsTableSpaces(((TableSpaceOracle)object2).getObjectID());
                }
            } else if (this.snapshot.getPartitionList() != null) {
                PartitionListOraclev9i partitionListOraclev9i = (PartitionListOraclev9i)this.snapshot.getPartitionList();
                this.snapshot.setPartitionList(null);
                partitionListOraclev9i.remove();
            }
            this.snapshot.setRefresh((String)this.cbRefresh.getSelectedItem());
            this.snapshot.setRefreshType((String)this.cbRefreshType.getSelectedItem());
            this.snapshot.setAction((String)this.cbAction.getSelectedItem());
            if (this.cbAction.getSelectedIndex() == 0) {
                this.snapshot.setStartDate(this.tfStartDate.getText());
                this.snapshot.setNextDate(this.tfNextDate.getText());
            }
            this.snapshot.setWith((String)this.cbWith.getSelectedItem());
            this.snapshot.setDefaultSegment(SnapshotPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbDefaultSegment.getSelectedItem()));
            this.snapshot.setSegmentType((String)this.cbSegmentType.getSelectedItem());
            this.snapshot.setRollbackSegment((RollbackSegmentOracle)this.cbRollbackSegment.getSelectedItem());
            this.snapshot.setComment(this.getCommentsList().getText());
            this.snapshot.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
            this.snapshot.setNotes(this.taNotes.getText());
        }
    }

    @Override
    protected boolean allowName(String string) {
        Object object = this.cbOwner.getSelectedItem();
        if (object instanceof UserOracle) {
            string = ((UserOracle)object).getName() + '.' + string;
        }
        return this.getStorageObject().allowName(string, true);
    }

    private class RemoveSubPartTSActionListener
    implements ActionListener {
        private RemoveSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SnapshotPropertyDialogOraclev9i.this.selectedSubPartTSModel.isEmpty()) {
                Object[] objectArray = SnapshotPropertyDialogOraclev9i.this.selectedSubPartTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (SnapshotPropertyDialogOraclev9i.this.allSubPartTSModel.contains(object)) continue;
                    SnapshotPropertyDialogOraclev9i.this.allSubPartTSModel.addElement(object);
                    SnapshotPropertyDialogOraclev9i.this.selectedSubPartTSModel.removeElement(object);
                }
            }
        }
    }

    private class AddSubPartTSActionListener
    implements ActionListener {
        private AddSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SnapshotPropertyDialogOraclev9i.this.allSubPartTSModel.isEmpty()) {
                Object[] objectArray = SnapshotPropertyDialogOraclev9i.this.allSubPartTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (SnapshotPropertyDialogOraclev9i.this.selectedSubPartTSModel.contains(object)) continue;
                    SnapshotPropertyDialogOraclev9i.this.selectedSubPartTSModel.addElement(object);
                    SnapshotPropertyDialogOraclev9i.this.allSubPartTSModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (SnapshotPropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (SnapshotPropertyDialogOraclev9i.this.selectedSubPartTSList.getSelectedIndex() == -1) {
                    SnapshotPropertyDialogOraclev9i.this.bnRemoveSubPartTS.setEnabled(false);
                } else {
                    SnapshotPropertyDialogOraclev9i.this.bnRemoveSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class AllSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private AllSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (SnapshotPropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (SnapshotPropertyDialogOraclev9i.this.allSubPartTSList.getSelectedIndex() == -1) {
                    SnapshotPropertyDialogOraclev9i.this.bnAddSubPartTS.setEnabled(false);
                } else {
                    SnapshotPropertyDialogOraclev9i.this.bnAddSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class PartitionedAction
    implements ActionListener {
        private PartitionedAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = ((String)SnapshotPropertyDialogOraclev9i.this.cbPartitioned.getSelectedItem()).equalsIgnoreCase(AbstractPropertyDialog.YES);
            int n = SnapshotPropertyDialogOraclev9i.this.getPane().indexOfComponent(SnapshotPropertyDialogOraclev9i.this.pnPartitioning);
            if (n > -1) {
                SnapshotPropertyDialogOraclev9i.this.getPane().setEnabledAt(n, bl);
            }
            SnapshotPropertyDialogOraclev9i.this.setPartitioning(bl);
        }
    }

    private class RemoveHashPTSActionListener
    implements ActionListener {
        private RemoveHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SnapshotPropertyDialogOraclev9i.this.selectedHashPTSModel.isEmpty()) {
                Object[] objectArray = SnapshotPropertyDialogOraclev9i.this.selectedHashPTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (SnapshotPropertyDialogOraclev9i.this.allHashPTSModel.contains(object)) continue;
                    SnapshotPropertyDialogOraclev9i.this.allHashPTSModel.addElement(object);
                    SnapshotPropertyDialogOraclev9i.this.selectedHashPTSModel.removeElement(object);
                }
            }
        }
    }

    private class AddHashPTSActionListener
    implements ActionListener {
        private AddHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SnapshotPropertyDialogOraclev9i.this.allHashPTSModel.isEmpty()) {
                Object[] objectArray = SnapshotPropertyDialogOraclev9i.this.allHashPTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (SnapshotPropertyDialogOraclev9i.this.selectedHashPTSModel.contains(object)) continue;
                    SnapshotPropertyDialogOraclev9i.this.selectedHashPTSModel.addElement(object);
                    SnapshotPropertyDialogOraclev9i.this.allHashPTSModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedHashPTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (SnapshotPropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (SnapshotPropertyDialogOraclev9i.this.selectedHashPTSList.getSelectedIndex() == -1) {
                    SnapshotPropertyDialogOraclev9i.this.bnRemoveHashPTS.setEnabled(false);
                } else {
                    SnapshotPropertyDialogOraclev9i.this.bnRemoveHashPTS.setEnabled(true);
                }
            }
        }
    }

    private class AllHashPTSListSelectionHandler
    implements ListSelectionListener {
        private AllHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (SnapshotPropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (SnapshotPropertyDialogOraclev9i.this.allHashPTSList.getSelectedIndex() == -1) {
                    SnapshotPropertyDialogOraclev9i.this.bnAddHashPTS.setEnabled(false);
                } else {
                    SnapshotPropertyDialogOraclev9i.this.bnAddHashPTS.setEnabled(true);
                }
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SnapshotPropertyDialogOraclev9i.this.dialog = new ObjectPermissionsDialogOracle(SnapshotPropertyDialogOraclev9i.this.getAppView(), SnapshotPropertyDialogOraclev9i.this.getStorageDesign(), SnapshotPropertyDialogOraclev9i.this.snapshot);
            SnapshotPropertyDialogOraclev9i.this.dialog.showDialog();
        }
    }

    private class PrebuildListener
    implements ActionListener {
        private PrebuildListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (SnapshotPropertyDialogOraclev9i.this.cbOnPrebuild.getSelectedItem() != null && SnapshotPropertyDialogOraclev9i.this.cbOnPrebuild.getSelectedItem() instanceof TableProxyOraclev9i) {
                TableProxyOraclev9i tableProxyOraclev9i = (TableProxyOraclev9i)SnapshotPropertyDialogOraclev9i.this.cbOnPrebuild.getSelectedItem();
                SnapshotPropertyDialogOraclev9i.this.tfName.setText(tableProxyOraclev9i.getName());
                SnapshotPropertyDialogOraclev9i.this.tfName.setEnabled(false);
            } else if (SnapshotPropertyDialogOraclev9i.this.cbOnPrebuild.getSelectedItem() != null && SnapshotPropertyDialogOraclev9i.this.cbOnPrebuild.getSelectedItem() instanceof String) {
                SnapshotPropertyDialogOraclev9i.this.tfName.setEnabled(true);
            } else if (SnapshotPropertyDialogOraclev9i.this.cbOnPrebuild.getSelectedItem() == null) {
                SnapshotPropertyDialogOraclev9i.this.tfName.setEnabled(true);
                SnapshotPropertyDialogOraclev9i.this.tfName.setText(SnapshotPropertyDialogOraclev9i.this.snapshot.getName());
            }
        }
    }
}

