/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PermissionsOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v9i.ColumnsPermissionsDialogOraclev9i;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class PermissionsDialogOraclev9i
extends JDialog
implements AbstractEditorConstants {
    private static String EMPTY_VALUE = "";
    private static String CHECKED = "v";
    private static String CHECKED_WITH_GRANT_OPTION = "v->";
    private static String COLUMN_CHECKED = "c";
    protected final String[] YES_NO = new String[]{Messages.getString("PermissionsDialogOraclev9i.YES"), Messages.getString("PermissionsDialogOraclev9i.NO")};
    protected static final String EDIT = Messages.getString("PermissionsDialogOraclev9i.Edit");
    private StorageObject storageObject;
    private RoleSetOracle rolesSet;
    private StorageDesignOracle storageDesign;
    private JButton bnCancel;
    private JTabbedPane tpane;
    private JPanel jpanel;
    private JPanel objectsPanel;
    private UsersTable usersTable;
    private RolesTable rolesTable;
    private ApplicationView appView;
    private ColumnsPermissionsDialogOraclev9i dialog;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PermissionsDialogOraclev9i.this.bnCancel.doClick();
        }
    };

    public PermissionsDialogOraclev9i(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView.getFrame());
        JComponent jComponent;
        this.storageDesign = (StorageDesignOracle)storageDesign;
        this.storageObject = storageObject;
        this.appView = applicationView;
        this.storageObject.setDialogVisible(true, this);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                PermissionsDialogOraclev9i.this.storageObject.setDialogVisible(false, null);
            }
        });
        this.jpanel = new JPanel(new BorderLayout());
        this.jpanel.add((Component)this.getTabbedPane(), "Center");
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel();
        if (this.isEditable()) {
            JButton jButton;
            if (this.storageObject instanceof TableProxyOracle) {
                jButton = new JButton(Messages.getString("PermissionsDialogOraclev9i.Columns"));
                jButton.addActionListener(new ColumnsPermissionsListener(this));
                jButton.setCursor(Cursor.getPredefinedCursor(12));
                jButton.setMnemonic(79);
                jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                jPanel.add((Component)jButton, "Before");
            }
            jButton = new JButton(Messages.getString("PermissionsDialogOraclev9i.OK"));
            jButton.addActionListener(new OKAction());
            jButton.setCursor(Cursor.getPredefinedCursor(12));
            jButton.setMnemonic(79);
            jPanel.add(jButton);
            this.getRootPane().setDefaultButton(jButton);
            jComponent = new JButton(Messages.getString("PermissionsDialogOraclev9i.Apply"));
            ((AbstractButton)jComponent).addActionListener(new ApplyAction());
            jComponent.setCursor(Cursor.getPredefinedCursor(12));
            ((AbstractButton)jComponent).setMnemonic(65);
            jPanel.add(jComponent);
            jButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            jComponent.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        }
        this.bnCancel = new JButton(this.isEditable() ? Messages.getString("PermissionsDialogOraclev9i.Cancel") : Messages.getString("PermissionsDialogOraclev9i.Close"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        int n = 1;
        jComponent = (JComponent)this.getContentPane();
        jComponent.getInputMap(n).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        jComponent.getActionMap().put("ESCAPE", this.escape);
        jPanel.add(this.bnCancel);
        this.jpanel.add((Component)jPanel, "South");
        this.getContentPane().add(this.jpanel);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.addTabs();
        this.initProperties();
        this.setModal(true);
    }

    protected boolean isEditable() {
        return !ApplicationView.IS_VIEWER && !ApplicationView.LOGICAL_MODEL_ONLY;
    }

    public void addTabs() {
        this.initUsersTable();
        this.initRolesTable();
    }

    private JTabbedPane getTabbedPane() {
        if (this.tpane == null) {
            this.tpane = new JTabbedPane();
            this.tpane.setPreferredSize(new Dimension(820, 320));
            this.tpane.setTabPlacement(3);
        }
        return this.tpane;
    }

    private void initUsersTable() {
        this.usersTable = new UsersTable();
        this.usersTable.setSelectionMode(0);
        this.usersTable.setRowSelectionAllowed(true);
        JScrollPane jScrollPane = new JScrollPane(this.usersTable);
        jScrollPane.setPreferredSize(new Dimension(800, 320));
        jScrollPane.setHorizontalScrollBar(new JScrollBar());
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.objectsPanel = new JPanel();
        this.objectsPanel.add(jScrollPane);
        this.getTabbedPane().addTab(Messages.getString("PermissionsDialogOraclev9i.Users"), this.objectsPanel);
        this.usersTable.updateUI();
        UsersModel usersModel = (UsersModel)this.usersTable.getModel();
        for (int i = 0; i < this.storageDesign.getUserSet().size(); ++i) {
            String[] stringArray;
            UserOracle userOracle;
            UserOracle userOracle2 = (UserOracle)this.storageDesign.getUserSet().getElement(i);
            if (this.storageObject instanceof TableProxyOracle) {
                userOracle = ((TableProxyOracle)this.storageObject).getUser();
                stringArray = PermissionsOraclev9i.getTablePrivilegesValues();
            } else if (this.storageObject instanceof TableViewProxyOracle) {
                userOracle = ((TableViewProxyOracle)this.storageObject).getUser();
                stringArray = PermissionsOraclev9i.getViewPrivilegesValues();
            } else if (this.storageObject instanceof StoredProcedureOracle) {
                userOracle = ((StoredProcedureOracle)this.storageObject).getOwner();
                stringArray = PermissionsOraclev9i.getProcedurePrivilegesValues();
            } else if (this.storageObject instanceof SequenceOracle) {
                userOracle = ((SequenceOracle)this.storageObject).getUser();
                stringArray = PermissionsOracle.getSeqPrivilegesValues();
            } else {
                userOracle = ((SnapshotOracle)this.storageObject).getUser();
                stringArray = PermissionsOraclev9i.getSnapshotPrivilegesValues();
            }
            if (userOracle2 == userOracle) continue;
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(userOracle2);
            for (int j = 0; j < stringArray.length; ++j) {
                JButton jButton = new JButton();
                vector.addElement(jButton);
            }
            vector.addElement("No");
            Object[] objectArray = vector.toArray();
            usersModel.addRow(objectArray);
        }
    }

    private void initRolesTable() {
        this.rolesSet = this.storageDesign.getRoleSet();
        this.rolesTable = new RolesTable();
        this.rolesTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.rolesTable);
        jScrollPane.setPreferredSize(new Dimension(800, 320));
        jScrollPane.setHorizontalScrollBar(new JScrollBar());
        jScrollPane.setHorizontalScrollBarPolicy(30);
        this.objectsPanel = new JPanel();
        this.objectsPanel.add(jScrollPane);
        this.getTabbedPane().addTab(Messages.getString("PermissionsDialogOraclev9i.Roles"), this.objectsPanel);
        this.rolesTable.updateUI();
        RolesModel rolesModel = (RolesModel)this.rolesTable.getModel();
        for (int i = 0; i < this.rolesSet.size(); ++i) {
            RoleOracle roleOracle = (RoleOracle)this.rolesSet.getElement(i);
            String[] stringArray = this.storageObject instanceof TableProxyOracle ? PermissionsOraclev9i.getTablePrivilegesValues() : (this.storageObject instanceof TableViewProxyOracle ? PermissionsOraclev9i.getViewPrivilegesValues() : (this.storageObject instanceof StoredProcedureOracle ? PermissionsOraclev9i.getProcedurePrivilegesValues() : (this.storageObject instanceof SequenceOracle ? PermissionsOracle.getSeqPrivilegesValues() : PermissionsOraclev9i.getSnapshotPrivilegesValues())));
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(roleOracle);
            for (int j = 0; j < stringArray.length; ++j) {
                JButton jButton = new JButton();
                vector.addElement(jButton);
            }
            vector.addElement("No");
            Object[] objectArray = vector.toArray();
            rolesModel.addRow(objectArray);
        }
    }

    private boolean hasSelectedUserPrivileges(int n) {
        for (int i = 0; i < this.usersTable.getColumnCount() - 1; ++i) {
            if (!(this.usersTable.getValueAt(n, i) instanceof JButton)) continue;
            JButton jButton = (JButton)this.usersTable.getValueAt(n, i);
            if (jButton.getText().equals(CHECKED)) {
                return true;
            }
            if (jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                return true;
            }
            if (!jButton.getText().equals(COLUMN_CHECKED)) continue;
            return true;
        }
        return false;
    }

    public void setColumnPermissions(StorageObject storageObject, String string) {
        block5: {
            int n;
            int n2;
            block4: {
                int n3;
                n2 = 0;
                if (!(storageObject instanceof UserOracle)) break block4;
                for (n3 = 0; n3 < this.usersTable.getRowCount(); ++n3) {
                    if (this.usersTable.getValueAt(n3, 0) != storageObject) continue;
                    n2 = n3;
                    break;
                }
                for (n3 = 1; n3 < this.usersTable.getColumnCount(); ++n3) {
                    if (!((UsersModel)this.usersTable.getModel()).getColumnName(n3).equalsIgnoreCase(string)) continue;
                    JButton jButton = (JButton)this.usersTable.getValueAt(n2, n3);
                    jButton.setText(COLUMN_CHECKED);
                    this.usersTable.updateUI();
                }
                break block5;
            }
            if (!(storageObject instanceof RoleOracle)) break block5;
            for (n = 0; n < this.rolesTable.getRowCount(); ++n) {
                if (this.rolesTable.getValueAt(n, 0) != storageObject) continue;
                n2 = n;
                break;
            }
            for (n = 1; n < this.rolesTable.getColumnCount(); ++n) {
                if (!((RolesModel)this.rolesTable.getModel()).getColumnName(n).equalsIgnoreCase(string)) continue;
                JButton jButton = (JButton)this.rolesTable.getValueAt(n2, n);
                jButton.setText(COLUMN_CHECKED);
                this.rolesTable.updateUI();
            }
        }
    }

    public void clearColumnPermissions(StorageObject storageObject, String string) {
        block5: {
            int n;
            int n2;
            block4: {
                int n3;
                n2 = 0;
                if (!(storageObject instanceof UserOracle)) break block4;
                for (n3 = 0; n3 < this.usersTable.getRowCount(); ++n3) {
                    if (this.usersTable.getValueAt(n3, 0) != storageObject) continue;
                    n2 = n3;
                    break;
                }
                for (n3 = 1; n3 < this.usersTable.getColumnCount(); ++n3) {
                    JButton jButton;
                    if (!((UsersModel)this.usersTable.getModel()).getColumnName(n3).equalsIgnoreCase(string) || !(jButton = (JButton)this.usersTable.getValueAt(n2, n3)).getText().equalsIgnoreCase(COLUMN_CHECKED)) continue;
                    jButton.setText(EMPTY_VALUE);
                }
                break block5;
            }
            if (!(storageObject instanceof RoleOracle)) break block5;
            for (n = 0; n < this.rolesTable.getRowCount(); ++n) {
                if (this.rolesTable.getValueAt(n, 0) != storageObject) continue;
                n2 = n;
                break;
            }
            for (n = 1; n < this.rolesTable.getColumnCount(); ++n) {
                JButton jButton;
                if (!((RolesModel)this.rolesTable.getModel()).getColumnName(n).equalsIgnoreCase(string) || !(jButton = (JButton)this.rolesTable.getValueAt(n2, n)).getText().equalsIgnoreCase(COLUMN_CHECKED)) continue;
                jButton.setText(EMPTY_VALUE);
            }
        }
    }

    private boolean hasSelectedRolePrivileges(int n) {
        for (int i = 0; i < this.rolesTable.getColumnCount() - 1; ++i) {
            if (!(this.rolesTable.getValueAt(n, i) instanceof JButton)) continue;
            JButton jButton = (JButton)this.rolesTable.getValueAt(n, i);
            if (jButton.getText().equals(CHECKED)) {
                return true;
            }
            if (!jButton.getText().equals(COLUMN_CHECKED)) continue;
            return true;
        }
        return false;
    }

    public String getCaption() {
        return Messages.getString("PermissionsDialogOraclev9i.Permissions");
    }

    private PermissionsOraclev9i getPermission(StorageObject storageObject, StorageObject storageObject2) {
        Iterator iterator = this.storageDesign.getPermissionsSet().iterator();
        while (iterator.hasNext()) {
            PermissionsOraclev9i permissionsOraclev9i = (PermissionsOraclev9i)iterator.next();
            if (permissionsOraclev9i.getUser() != storageObject && permissionsOraclev9i.getRole() != storageObject || permissionsOraclev9i.getTable() != storageObject2 && permissionsOraclev9i.getView() != storageObject2 && permissionsOraclev9i.getProc() != storageObject2 && permissionsOraclev9i.getSequence() != storageObject2 && permissionsOraclev9i.getSnapshot() != storageObject2 && permissionsOraclev9i.getDirectoryOracle() != storageObject2 && permissionsOraclev9i.getStructuredTypeOracle() != storageObject2 && permissionsOraclev9i.getCollectionTypeOracle() != storageObject2 && permissionsOraclev9i.getExternalTableOracle() != storageObject2) continue;
            return permissionsOraclev9i;
        }
        return null;
    }

    public void initProperties() {
        String string;
        int n;
        PermissionsOraclev9i permissionsOraclev9i;
        AbstractStorageObjectOracle abstractStorageObjectOracle;
        int n2;
        for (n2 = 0; n2 < this.usersTable.getRowCount(); ++n2) {
            abstractStorageObjectOracle = (UserOracle)this.usersTable.getValueAt(n2, 0);
            permissionsOraclev9i = this.getPermission(abstractStorageObjectOracle, this.storageObject);
            for (n = 0; n < this.usersTable.getColumnCount() - 1; ++n) {
                if (!(this.usersTable.getValueAt(n2, n) instanceof JButton)) continue;
                JButton jButton = (JButton)this.usersTable.getValueAt(n2, n);
                if (permissionsOraclev9i != null) {
                    if (permissionsOraclev9i.getPrivileges().indexOf(this.usersTable.getColumnName(n)) > -1) {
                        jButton.setText(CHECKED);
                        jButton.updateUI();
                    } else if (permissionsOraclev9i.getPrivilegesWithGrantOption().indexOf(this.usersTable.getColumnName(n)) > -1) {
                        jButton.setText(CHECKED_WITH_GRANT_OPTION);
                        jButton.updateUI();
                    } else if (this.getPermission(abstractStorageObjectOracle, this.storageObject).hasColPrivilege(this.usersTable.getColumnName(n))) {
                        jButton.setText(COLUMN_CHECKED);
                        jButton.updateUI();
                    } else {
                        jButton.setText(EMPTY_VALUE);
                        jButton.updateUI();
                    }
                    string = permissionsOraclev9i.getHierarchyOption();
                    this.usersTable.setValueAt(string, n2, this.usersTable.getColumnCount() - 1);
                    continue;
                }
                jButton.setText(EMPTY_VALUE);
                jButton.updateUI();
            }
        }
        for (n2 = 0; n2 < this.rolesTable.getRowCount(); ++n2) {
            abstractStorageObjectOracle = (RoleOracle)this.rolesTable.getValueAt(n2, 0);
            permissionsOraclev9i = this.getPermission(abstractStorageObjectOracle, this.storageObject);
            for (n = 0; n < this.rolesTable.getColumnCount(); ++n) {
                if (!(this.rolesTable.getValueAt(n2, n) instanceof JButton)) continue;
                JButton jButton = (JButton)this.rolesTable.getValueAt(n2, n);
                if (permissionsOraclev9i != null) {
                    if (permissionsOraclev9i.getPrivileges().indexOf(this.rolesTable.getColumnName(n)) > -1) {
                        jButton.setText(CHECKED);
                        jButton.updateUI();
                    } else {
                        jButton.setText(EMPTY_VALUE);
                        jButton.updateUI();
                    }
                    string = permissionsOraclev9i.getHierarchyOption();
                    this.rolesTable.setValueAt(string, n2, this.rolesTable.getColumnCount() - 1);
                    continue;
                }
                jButton.setText(EMPTY_VALUE);
                jButton.updateUI();
            }
        }
    }

    protected void setProperties() {
        JButton jButton;
        int n;
        PermissionsOraclev9i permissionsOraclev9i;
        AbstractStorageObjectOracle abstractStorageObjectOracle;
        int n2;
        for (n2 = 0; n2 < this.usersTable.getRowCount(); ++n2) {
            abstractStorageObjectOracle = (UserOracle)this.usersTable.getValueAt(n2, 0);
            permissionsOraclev9i = this.getPermission(abstractStorageObjectOracle, this.storageObject);
            if (this.hasSelectedUserPrivileges(n2)) {
                if (permissionsOraclev9i == null) {
                    permissionsOraclev9i = (PermissionsOraclev9i)this.storageDesign.getPermissionsSet().createPermissions();
                    permissionsOraclev9i.setUser((UserOracle)abstractStorageObjectOracle);
                    if (this.storageObject instanceof TableProxyOracle) {
                        permissionsOraclev9i.setTable((TableProxyOracle)this.storageObject);
                    } else if (this.storageObject instanceof TableViewProxyOracle) {
                        permissionsOraclev9i.setView((TableViewProxyOracle)this.storageObject);
                    } else if (this.storageObject instanceof SnapshotOracle) {
                        permissionsOraclev9i.setSnapshot((SnapshotOracle)this.storageObject);
                    } else if (this.storageObject instanceof SequenceOracle) {
                        permissionsOraclev9i.setSequence((SequenceOracle)this.storageObject);
                    } else if (this.storageObject instanceof StoredProcedureOracle) {
                        permissionsOraclev9i.setProc((StoredProcedureOracle)this.storageObject);
                    } else if (this.storageObject instanceof DirectoryOracle) {
                        permissionsOraclev9i.setDirectoryOracle((DirectoryOracle)this.storageObject);
                    } else if (this.storageObject instanceof StructuredTypeProxyOracle) {
                        permissionsOraclev9i.setStructuredTypeOracle((StructuredTypeProxyOracle)this.storageObject);
                    } else if (this.storageObject instanceof CollectionTypeProxyOracle) {
                        permissionsOraclev9i.setCollectionTypeOracle((CollectionTypeProxyOracle)this.storageObject);
                    } else if (this.storageObject instanceof ExternalTableOracle) {
                        permissionsOraclev9i.setExternalTableOracle((ExternalTableOracle)this.storageObject);
                    }
                }
                permissionsOraclev9i.clear();
                for (n = 0; n < this.usersTable.getColumnCount(); ++n) {
                    if (!(this.usersTable.getValueAt(n2, n) instanceof JButton)) continue;
                    jButton = (JButton)this.usersTable.getValueAt(n2, n);
                    if (jButton.getText().equals(CHECKED)) {
                        permissionsOraclev9i.setPrivileges(this.usersTable.getColumnName(n));
                        continue;
                    }
                    if (!jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
                    permissionsOraclev9i.setPrivilegesWithGrantOption(this.usersTable.getColumnName(n));
                }
                permissionsOraclev9i.setHierarchyOption((String)this.usersTable.getValueAt(n2, this.usersTable.getColumnCount() - 1));
                continue;
            }
            if (permissionsOraclev9i == null) continue;
            this.storageDesign.getPermissionsSet().remove(permissionsOraclev9i);
        }
        for (n2 = 0; n2 < this.rolesTable.getRowCount(); ++n2) {
            abstractStorageObjectOracle = (RoleOracle)this.rolesTable.getValueAt(n2, 0);
            permissionsOraclev9i = this.getPermission(abstractStorageObjectOracle, this.storageObject);
            if (this.hasSelectedRolePrivileges(n2)) {
                if (permissionsOraclev9i == null) {
                    permissionsOraclev9i = (PermissionsOraclev9i)this.storageDesign.getPermissionsSet().createPermissions();
                    permissionsOraclev9i.setRole((RoleOracle)abstractStorageObjectOracle);
                    if (this.storageObject instanceof TableProxyOracle) {
                        permissionsOraclev9i.setTable((TableProxyOracle)this.storageObject);
                    } else if (this.storageObject instanceof TableViewProxyOracle) {
                        permissionsOraclev9i.setView((TableViewProxyOracle)this.storageObject);
                    } else if (this.storageObject instanceof SnapshotOracle) {
                        permissionsOraclev9i.setSnapshot((SnapshotOracle)this.storageObject);
                    } else if (this.storageObject instanceof SequenceOracle) {
                        permissionsOraclev9i.setSequence((SequenceOracle)this.storageObject);
                    } else if (this.storageObject instanceof StoredProcedureOracle) {
                        permissionsOraclev9i.setProc((StoredProcedureOracle)this.storageObject);
                    } else if (this.storageObject instanceof DirectoryOracle) {
                        permissionsOraclev9i.setDirectoryOracle((DirectoryOracle)this.storageObject);
                    } else if (this.storageObject instanceof StructuredTypeProxyOracle) {
                        permissionsOraclev9i.setStructuredTypeOracle((StructuredTypeProxyOracle)this.storageObject);
                    } else if (this.storageObject instanceof CollectionTypeProxyOracle) {
                        permissionsOraclev9i.setCollectionTypeOracle((CollectionTypeProxyOracle)this.storageObject);
                    } else if (this.storageObject instanceof ExternalTableOracle) {
                        permissionsOraclev9i.setExternalTableOracle((ExternalTableOracle)this.storageObject);
                    }
                }
                permissionsOraclev9i.clear();
                for (n = 0; n < this.rolesTable.getColumnCount(); ++n) {
                    if (!(this.rolesTable.getValueAt(n2, n) instanceof JButton) || !(jButton = (JButton)this.rolesTable.getValueAt(n2, n)).getText().equals(CHECKED)) continue;
                    permissionsOraclev9i.setPrivileges(this.rolesTable.getColumnName(n));
                }
                permissionsOraclev9i.setHierarchyOption((String)this.rolesTable.getValueAt(n2, this.rolesTable.getColumnCount() - 1));
                continue;
            }
            if (permissionsOraclev9i == null) continue;
            this.storageDesign.getPermissionsSet().remove(permissionsOraclev9i);
        }
    }

    private class ColumnsPermissionsListener
    implements ActionListener {
        PermissionsDialogOraclev9i permDialog;

        public ColumnsPermissionsListener(PermissionsDialogOraclev9i permissionsDialogOraclev9i2) {
            this.permDialog = permissionsDialogOraclev9i2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StorageObject storageObject = null;
            if (PermissionsDialogOraclev9i.this.tpane.getSelectedIndex() == 0) {
                if (PermissionsDialogOraclev9i.this.usersTable.getSelectedRow() > -1) {
                    storageObject = (StorageObject)PermissionsDialogOraclev9i.this.usersTable.getValueAt(PermissionsDialogOraclev9i.this.usersTable.getSelectedRow(), 0);
                }
            } else if (PermissionsDialogOraclev9i.this.rolesTable.getSelectedRow() > -1) {
                storageObject = (StorageObject)PermissionsDialogOraclev9i.this.rolesTable.getValueAt(PermissionsDialogOraclev9i.this.rolesTable.getSelectedRow(), 0);
            }
            if (storageObject != null && (PermissionsDialogOraclev9i.this.dialog == null || PermissionsDialogOraclev9i.this.dialog.getUser() != storageObject)) {
                PermissionsDialogOraclev9i.this.dialog = new ColumnsPermissionsDialogOraclev9i(PermissionsDialogOraclev9i.this.appView, PermissionsDialogOraclev9i.this.storageDesign, PermissionsDialogOraclev9i.this.storageObject, storageObject, this.permDialog);
            }
            if (PermissionsDialogOraclev9i.this.dialog != null) {
                PermissionsDialogOraclev9i.this.dialog.show();
            }
        }
    }

    class ButtonRoleTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton button;

        ButtonRoleTableCellEditor() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                JButton jButton = (JButton)actionEvent.getSource();
                if (jButton.getText() == null) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(CHECKED)) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(EMPTY_VALUE)) {
                    jButton.setText(CHECKED);
                }
            } else {
                this.button.setText(this.button.getText().toString());
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.button = (JButton)object;
            this.button.setOpaque(true);
            this.button.setBackground(jTable.getBackground());
            this.button.setActionCommand(EDIT);
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
            return this.button;
        }
    }

    class ButtonUserTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton button;

        ButtonUserTableCellEditor() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EDIT.equals(actionEvent.getActionCommand())) {
                JButton jButton = (JButton)actionEvent.getSource();
                if (jButton.getText() == null) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(CHECKED)) {
                    jButton.setText(CHECKED_WITH_GRANT_OPTION);
                } else if (jButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                    jButton.setText(EMPTY_VALUE);
                } else if (jButton.getText().equals(EMPTY_VALUE)) {
                    jButton.setText(CHECKED);
                }
            } else {
                this.button.setText(this.button.getText().toString());
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.button = (JButton)object;
            this.button.setOpaque(true);
            this.button.setBackground(jTable.getBackground());
            this.button.setActionCommand(EDIT);
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
            return this.button;
        }
    }

    class ButtonTableCellRenderer
    extends JButton
    implements TableCellRenderer {
        ButtonTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.setText(object == null ? "" : "  " + ((JButton)object).getText());
            return this;
        }
    }

    class LabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.setHorizontalAlignment(2);
            this.setText(object == null ? "" : "  " + object.toString());
            return this;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PermissionsDialogOraclev9i.this.dispose();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PermissionsDialogOraclev9i.this.setProperties();
            PermissionsDialogOraclev9i.this.storageObject.setDirty(true);
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PermissionsDialogOraclev9i.this.setProperties();
            PermissionsDialogOraclev9i.this.storageObject.setDirty(true);
            PermissionsDialogOraclev9i.this.dispose();
        }
    }

    public class RolesModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            String[] stringArray = PermissionsDialogOraclev9i.this.storageObject instanceof TableProxyOracle ? PermissionsOraclev9i.getTablePrivilegesValues() : (PermissionsDialogOraclev9i.this.storageObject instanceof TableViewProxyOracle ? PermissionsOraclev9i.getViewPrivilegesValues() : (PermissionsDialogOraclev9i.this.storageObject instanceof StoredProcedureOracle ? PermissionsOraclev9i.getProcedurePrivilegesValues() : (PermissionsDialogOraclev9i.this.storageObject instanceof SequenceOracle ? PermissionsOracle.getSeqPrivilegesValues() : PermissionsOraclev9i.getSnapshotPrivilegesValues())));
            return stringArray.length + 2;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int n) {
            String[] stringArray = PermissionsDialogOraclev9i.this.storageObject instanceof TableProxyOracle ? PermissionsOraclev9i.getTablePrivilegesValues() : (PermissionsDialogOraclev9i.this.storageObject instanceof TableViewProxyOracle ? PermissionsOraclev9i.getViewPrivilegesValues() : (PermissionsDialogOraclev9i.this.storageObject instanceof StoredProcedureOracle ? PermissionsOraclev9i.getProcedurePrivilegesValues() : (PermissionsDialogOraclev9i.this.storageObject instanceof SequenceOracle ? PermissionsOracle.getSeqPrivilegesValues() : PermissionsOraclev9i.getSnapshotPrivilegesValues())));
            if (n == 0) {
                return Messages.getString("PermissionsDialogOraclev9i.Role");
            }
            if (n == this.getColumnCount() - 1) {
                return Messages.getString("PermissionsDialogOraclev9i.Hierarchy");
            }
            for (int i = 1; i < this.getColumnCount() - 1; ++i) {
                if (n != i) continue;
                return stringArray[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!PermissionsDialogOraclev9i.this.isEditable()) {
                return false;
            }
            return n2 > 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }

    class RolesTable
    extends JTable {
        RolesModel dataModel;

        public RolesTable() {
            this.dataModel = new RolesModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 0 || n2 == this.getColumnCount() - 1) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                return super.getCellEditor();
            }
            if (n2 == this.getColumnCount() - 1) {
                JComboBox<String> jComboBox = new JComboBox<String>(PermissionsDialogOraclev9i.this.YES_NO);
                jComboBox.setModel(new DefaultComboBoxModel<String>(PermissionsDialogOraclev9i.this.YES_NO));
                return new DefaultCellEditor(jComboBox);
            }
            return new ButtonRoleTableCellEditor();
        }
    }

    class UsersTable
    extends JTable {
        UsersModel dataModel;

        public UsersTable() {
            this.dataModel = new UsersModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int n = this.dataModel.getRowCount();
            for (int i = n - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            if (n2 == 0 || n2 == this.getColumnCount() - 1) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                return super.getCellEditor();
            }
            if (n2 == this.getColumnCount() - 1) {
                JComboBox<String> jComboBox = new JComboBox<String>(PermissionsDialogOraclev9i.this.YES_NO);
                jComboBox.setModel(new DefaultComboBoxModel<String>(PermissionsDialogOraclev9i.this.YES_NO));
                return new DefaultCellEditor(jComboBox);
            }
            return new ButtonUserTableCellEditor();
        }
    }

    public class UsersModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            String[] stringArray = PermissionsDialogOraclev9i.this.storageObject instanceof TableProxyOracle ? PermissionsOraclev9i.getTablePrivilegesValues() : (PermissionsDialogOraclev9i.this.storageObject instanceof TableViewProxyOracle ? PermissionsOraclev9i.getViewPrivilegesValues() : (PermissionsDialogOraclev9i.this.storageObject instanceof StoredProcedureOracle ? PermissionsOraclev9i.getProcedurePrivilegesValues() : (PermissionsDialogOraclev9i.this.storageObject instanceof SequenceOracle ? PermissionsOracle.getSeqPrivilegesValues() : PermissionsOraclev9i.getSnapshotPrivilegesValues())));
            return stringArray.length + 2;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int n) {
            String[] stringArray = PermissionsDialogOraclev9i.this.storageObject instanceof TableProxyOracle ? PermissionsOraclev9i.getTablePrivilegesValues() : (PermissionsDialogOraclev9i.this.storageObject instanceof TableViewProxyOracle ? PermissionsOraclev9i.getViewPrivilegesValues() : (PermissionsDialogOraclev9i.this.storageObject instanceof StoredProcedureOracle ? PermissionsOraclev9i.getProcedurePrivilegesValues() : (PermissionsDialogOraclev9i.this.storageObject instanceof SequenceOracle ? PermissionsOracle.getSeqPrivilegesValues() : PermissionsOraclev9i.getSnapshotPrivilegesValues())));
            if (n == 0) {
                return Messages.getString("PermissionsDialogOraclev9i.User");
            }
            if (n == this.getColumnCount() - 1) {
                return Messages.getString("PermissionsDialogOraclev9i.Hierarchy");
            }
            for (int i = 1; i < this.getColumnCount() - 1; ++i) {
                if (n != i) continue;
                return stringArray[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (!PermissionsDialogOraclev9i.this.isEditable()) {
                return false;
            }
            return n2 > 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector vector) {
            this.dataVector = vector;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }
}

