/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class LobItemPartitionDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private HashPartitionLobItemOracle lobItem;
    private JComboBox cbLobColumn;
    private JComboBox cbTableSpace;

    public LobItemPartitionDialogOraclev9i(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.lobItem = (HashPartitionLobItemOracle)storageObject;
        this.setHeight(140);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("LobItemPartitionDialogOraclev9i.LobItemProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initLobColumn();
        this.initTableSpace();
    }

    private void initLobColumn() {
        JLabel jLabel = new JLabel(Messages.getString("LobItemPartitionDialogOraclev9i.LobColumn"));
        this.general.add(jLabel);
        this.cbLobColumn = new JComboBox();
        this.setBG(this.cbLobColumn);
        this.cbLobColumn.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLobColumn);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbLobColumn, 50);
    }

    private void initTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("LobItemPartitionDialogOraclev9i.TableSpace"));
        this.general.add(jLabel);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.cbTableSpace, 80);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.lobItem.getName());
        this.tfName.setText(this.lobItem.getName());
        PartitionListOracle partitionListOracle = null;
        AbstractStorageObjectOracle abstractStorageObjectOracle = null;
        if (this.lobItem.getHashPartition() != null) {
            HashPartitionOracle hashPartitionOracle = this.lobItem.getHashPartition();
            partitionListOracle = hashPartitionOracle.getPartitionList();
            if (partitionListOracle == null) {
                if (hashPartitionOracle.getPartOfStorageTable() != null) {
                    partitionListOracle = hashPartitionOracle.getPartOfStorageTable().getPartitionList();
                } else {
                    abstractStorageObjectOracle = hashPartitionOracle.getSubPartitionOf();
                }
            }
        } else if (this.lobItem.getListTemplatePartition() != null) {
            ListStorageTemplatePartitionOracle listStorageTemplatePartitionOracle = this.lobItem.getListTemplatePartition();
            if (listStorageTemplatePartitionOracle.getPartOfStorageTable() != null) {
                partitionListOracle = listStorageTemplatePartitionOracle.getPartOfStorageTable().getPartitionList();
            } else {
                abstractStorageObjectOracle = listStorageTemplatePartitionOracle.getSubPartitionOf();
            }
        } else if (this.lobItem.getRangePartition() instanceof PartitionOraclev11g) {
            PartitionOraclev11g partitionOraclev11g = (PartitionOraclev11g)this.lobItem.getRangePartition();
            if (partitionOraclev11g.getPartOfStorageTable() != null) {
                partitionListOracle = partitionOraclev11g.getPartOfStorageTable().getPartitionList();
            } else {
                abstractStorageObjectOracle = partitionOraclev11g.getSubPartitionOf();
            }
        }
        if (partitionListOracle == null) {
            if (abstractStorageObjectOracle instanceof PartitionOracle) {
                partitionListOracle = ((PartitionOracle)abstractStorageObjectOracle).getPartitionList();
            } else if (abstractStorageObjectOracle instanceof ListPartitionOracle) {
                partitionListOracle = ((ListPartitionOracle)abstractStorageObjectOracle).getPartitionList();
            } else if (abstractStorageObjectOracle instanceof HashPartitionOracle) {
                partitionListOracle = ((HashPartitionOracle)abstractStorageObjectOracle).getPartitionList();
            }
        }
        if (partitionListOracle != null && partitionListOracle.getTable() != null) {
            this.fillComboItems(partitionListOracle.getTable().getColumnProxies(), this.cbLobColumn);
        }
        this.selectObject(this.cbLobColumn, this.lobItem.getLobColumn());
        this.selectObject(this.cbTableSpace, this.lobItem.getTableSpace());
        this.getCommentsList().insert(this.lobItem.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.lobItem != null) {
            this.lobItem.setName(this.tfName.getText());
            Object object = this.cbLobColumn.getSelectedItem();
            if (object instanceof ColumnProxy) {
                this.lobItem.setLobColumn((ColumnProxy)object);
            } else {
                this.lobItem.setLobColumn(null);
            }
            object = this.cbTableSpace.getSelectedItem();
            if (object instanceof TableSpaceOracle) {
                this.lobItem.setTableSpace((TableSpaceOracle)object);
            } else {
                this.lobItem.setTableSpace(null);
            }
            this.lobItem.setComment(this.getCommentsList().getText());
        }
    }
}

