/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionsListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexProxyOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.ColumnsSortOrderModel;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class IndexPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private static final String NON_PARTITIONED = "NON_PARTITIONED";
    private static final String LOCAL = "LOCAL";
    private static final String GLOBAL = "GLOBAL";
    private static final String[] PARTITIONED_CHOICES = new String[]{"NON_PARTITIONED", "LOCAL", "GLOBAL"};
    private static final String NO_SORT = NO;
    private static final String SORTED = "SORTED";
    private static final String REVERSE = "REVERSE";
    private static final String[] SORT_CHOICES = new String[]{NO_SORT, "SORTED", "REVERSE"};
    private IndexProxyOraclev9i index;
    private JComboBox cbUser;
    private JTextField tfTable;
    private JTextField tfUnique;
    private JComboBox cbBitmapIndex;
    private JTextField tfIndextype;
    private JComboBox cbPartitioned;
    private JComboBox cbTableSpace;
    private JComboBox cbLogging;
    private JComboBox cbSegment;
    private JIntegerField ifCompress;
    private JComboBox cbParallel;
    private JTextField tfDegree;
    private JComboBox cbSortedRows;
    private JComboBox cbComputeStats;
    private JComboBox cbOnline;
    private JCheckBox cbSpatialIndex;
    private JPanel columns;
    private JList columnList;
    private DefaultListModel columnListModel;
    private JPanel partitioning;
    private JList allColumnsList;
    private JList selectedColumnsList;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JButton bnAdd;
    private JButton bnRemove;
    private JPanel columnsView;
    private JTable columnsTable;
    private ColumnsSortOrderModel sortModel;
    private JPanel hashSubPartTS;
    private JList allHashSubPartTSList;
    private JList selectedHashSubPartTSList;
    private DefaultListModel allHashSubPartTSModel;
    private DefaultListModel selectedHashSubPartTSModel;
    private JButton bnAddHashSubPartTS;
    private JButton bnRemoveHashSubPartTS;
    private JPanel indextypeParametersPanel;
    private JTextArea taIndextypeParameters;
    private JScrollPane spIndextypeParameters;
    private String comment;
    private String commentInRDBMS;
    private JPanel spatialPanel;
    private JComboBox cbNonLeaf;
    private JIntegerField ifBatchSize;
    private JComboBox cbWorkTablespace;
    private JTextField tfLayerType;
    private JTextField tfGeodetic;
    private JTextField tfDimensions;

    public IndexPropertyDialogOraclev9i(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.index = (IndexProxyOraclev9i)storageObject;
        this.setHeight(650);
        this.initCommentsView(200);
        this.initCommentsInRDBMS(200);
        this.initColumnsView(this.getPane().getPreferredSize().height - 90);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("IndexPropertyDialogOracle.IndexProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initUser();
        this.initTable();
        this.initUnique();
        this.initBitmapIndex();
        this.initIndextype();
        this.initPartitioned();
        this.initTableSpace();
        this.initLogging();
        this.initSegment();
        this.initCompress();
        this.initParallel();
        this.initDegree();
        this.initSortedRows();
        this.initComputeStats();
        this.initOnline();
        this.initSpatialIndex();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
    }

    private void initUser() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogOracle.User"));
        this.general.add(jLabel);
        this.cbUser = new JComboBox();
        this.setBG(this.cbUser);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbUser);
        }
        this.cbUser.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.cbUser.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUser);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.cbUser, 50);
    }

    private void initTable() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogOracle.Table"));
        this.general.add(jLabel);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEditable(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfTable, 80);
    }

    private void initUnique() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogOracle.Unique"));
        this.general.add(jLabel);
        this.tfUnique = new JTextField("", 26);
        this.tfUnique.setEditable(false);
        this.general.add(this.tfUnique);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.tfUnique, 110);
    }

    private void initBitmapIndex() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogOracle.BitmapIndex"));
        this.general.add(jLabel);
        this.cbBitmapIndex = new JComboBox<String>(YES_NO);
        this.setBG(this.cbBitmapIndex);
        this.cbBitmapIndex.setPreferredSize(this.tfName.getPreferredSize());
        this.cbBitmapIndex.addActionListener(new BitmapListener());
        this.general.add(this.cbBitmapIndex);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbBitmapIndex, 140);
    }

    private void initIndextype() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogOracle.Indextype"));
        this.general.add(jLabel);
        this.tfIndextype = new JTextField("", 26);
        this.setBG(this.tfIndextype);
        this.tfIndextype.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfIndextype);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.tfIndextype, 170);
    }

    private void initPartitioned() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogOracle.Partitioned"));
        this.general.add(jLabel);
        this.cbPartitioned = new JComboBox<String>(PARTITIONED_CHOICES);
        this.setBG(this.cbPartitioned);
        this.cbPartitioned.addActionListener(new LocalPartitionListener());
        this.cbPartitioned.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPartitioned);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbPartitioned, 200);
    }

    private void initTableSpace() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogOracle.TableSpace"));
        this.general.add(jLabel);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbTableSpace, 230);
    }

    private void initLogging() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogOracle.Logging"));
        this.general.add(jLabel);
        this.cbLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLogging);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbLogging, 260);
    }

    private void initSegment() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogOracle.Segment"));
        this.general.add(jLabel);
        this.cbSegment = new JComboBox();
        this.setBG(this.cbSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegment);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.cbSegment, 290);
    }

    private void initCompress() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogOracle.Compress"));
        this.general.add(jLabel);
        this.ifCompress = new JIntegerField(0, 26);
        this.general.add(this.ifCompress);
        this.setLabelConstraints(jLabel, 320);
        this.setObjectConstraints(this.ifCompress, 320);
    }

    private void initParallel() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogOracle.Parallel"));
        this.general.add(jLabel);
        this.cbParallel = new JComboBox<String>(YES_NO);
        this.setBG(this.cbParallel);
        this.cbParallel.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbParallel);
        this.setLabelConstraints(jLabel, 350);
        this.setObjectConstraints(this.cbParallel, 350);
    }

    private void initDegree() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogOracle.Degree"));
        this.general.add(jLabel);
        this.tfDegree = new JTextField();
        this.tfDegree.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfDegree);
        this.setLabelConstraints(jLabel, 380);
        this.setObjectConstraints(this.tfDegree, 380);
    }

    private void initSortedRows() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogOracle.SortedRows"));
        this.general.add(jLabel);
        this.cbSortedRows = new JComboBox<String>(SORT_CHOICES);
        this.setBG(this.cbSortedRows);
        this.cbSortedRows.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSortedRows);
        this.setLabelConstraints(jLabel, 410);
        this.setObjectConstraints(this.cbSortedRows, 410);
    }

    private void initComputeStats() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogOracle.ComputeStats"));
        this.general.add(jLabel);
        this.cbComputeStats = new JComboBox<String>(YES_NO);
        this.setBG(this.cbComputeStats);
        this.cbComputeStats.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbComputeStats);
        this.setLabelConstraints(jLabel, 440);
        this.setObjectConstraints(this.cbComputeStats, 440);
    }

    private void initOnline() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogOracle.Online"));
        this.general.add(jLabel);
        this.cbOnline = new JComboBox<String>(YES_NO);
        this.setBG(this.cbOnline);
        this.cbOnline.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOnline);
        this.setLabelConstraints(jLabel, 470);
        this.setObjectConstraints(this.cbOnline, 470);
    }

    private void initSpatialIndex() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogOracle.SpatialIndexL"));
        this.general.add(jLabel);
        this.cbSpatialIndex = new JCheckBox();
        this.cbSpatialIndex.setEnabled(false);
        this.general.add(this.cbSpatialIndex);
        this.setLabelConstraints(jLabel, 500);
        this.setObjectConstraints(this.cbSpatialIndex, 500);
    }

    private void initPropagatePropsButton() {
        JButton jButton = new JButton(Messages.getString("IndexPropertyDialogOracle.PropagateProperties"));
        jButton.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(IndexPropertyDialogOraclev9i.this.getStorageDesign().getIndexProxySet().getElements());
                arrayList.remove(IndexPropertyDialogOraclev9i.this.index);
                new PropertiesPropagationDialog(IndexPropertyDialogOraclev9i.this.getAppView(), IndexPropertyDialogOraclev9i.this.index, arrayList).showDialog();
            }
        });
        this.general.add(jButton);
        this.setObjectConstraints(jButton, 10, 530);
    }

    @Override
    public void initProperties() {
        Object object;
        this.initCaption(this.index.getName());
        this.tfName.setText(this.index.getName());
        ColumnProxy[] columnProxyArray = this.index.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxy columnProxy = columnProxyArray[i];
            this.columnListModel.addElement(columnProxy);
        }
        this.selectObject(this.cbUser, this.index.getUser());
        this.tfTable.setText(this.index.getTableName());
        this.tfUnique.setText(this.index.isUnique() ? YES : NO);
        this.cbBitmapIndex.setSelectedItem(this.index.getBitmapIndex() ? YES : NO);
        this.tfIndextype.setText(this.index.getIndexType());
        this.cbPartitioned.setSelectedItem(this.translate(this.index.getIndexPartitioned(), IndexProxyOracle.getPartitionedChoices(), PARTITIONED_CHOICES));
        this.selectObject(this.cbTableSpace, this.index.getTableSpace());
        this.cbLogging.setSelectedItem(IndexPropertyDialogOraclev9i.translateYesNoForDisplay(this.index.getLogging()));
        this.selectObject(this.cbSegment, this.index.getSegment());
        this.ifCompress.setValue((long)this.index.getCompress());
        this.cbParallel.setSelectedItem(IndexPropertyDialogOraclev9i.translateYesNoForDisplay(this.index.getParallel()));
        this.tfDegree.setText(this.index.getDegree());
        this.cbSortedRows.setSelectedItem(this.translate(this.index.getSortedRows(), IndexProxyOracle.getSortedRowsChoices(), SORT_CHOICES));
        this.cbComputeStats.setSelectedItem(IndexPropertyDialogOraclev9i.translateYesNoForDisplay(this.index.getComputeStatistics()));
        this.cbOnline.setSelectedItem(IndexPropertyDialogOraclev9i.translateYesNoForDisplay(this.index.getOnline()));
        if (this.index.getIndexGlobalPartitionsList() != null) {
            this.setPartitioning(true);
        }
        TableSpaceOracle[] tableSpaceOracleArray = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tableSpaceOracleArray.length; ++i) {
            object = tableSpaceOracleArray[i];
            if (this.index != null && this.index.getHashPartitionsTableSpacesSet().contains(((ModelIDObject)object).getObjectID())) {
                this.selectedHashSubPartTSModel.addElement(object);
                continue;
            }
            this.allHashSubPartTSModel.addElement(object);
        }
        PartitionListOracle partitionListOracle = ((TableProxyOracle)this.index.getTableProxy()).getPartitionList();
        object = null;
        if (partitionListOracle != null) {
            object = partitionListOracle.getPartitionType();
        }
        if (this.index.getIndexPartitioned().equalsIgnoreCase(LOCAL) && object != null && (((String)object).equalsIgnoreCase("COMPOSITE BY HASH") || ((String)object).equalsIgnoreCase("HASH BY LIST OF PARTITIONS") || ((String)object).equalsIgnoreCase("HASH BY QUANTITY"))) {
            this.allHashSubPartTSList.setEnabled(true);
            this.selectedHashSubPartTSList.setEnabled(true);
            this.bnAddHashSubPartTS.setEnabled(this.allHashSubPartTSList.getSelectedIndex() != -1);
            this.bnRemoveHashSubPartTS.setEnabled(this.selectedHashSubPartTSList.getSelectedIndex() != -1);
        } else {
            this.allHashSubPartTSList.setEnabled(false);
            this.selectedHashSubPartTSList.setEnabled(false);
            this.bnAddHashSubPartTS.setEnabled(false);
            this.bnRemoveHashSubPartTS.setEnabled(false);
        }
        this.taIndextypeParameters.insert(this.index.getIndexDomainParameters(), 0);
        this.comment = this.index.getObject().getComment();
        this.commentInRDBMS = this.index.getObject().getCommentInRDBMS();
        if (this.index.isCommentChanged()) {
            this.getCommentsList().insert(this.index.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.index.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.index.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
        this.initColumnsSortOrder();
        this.cbSpatialIndex.setSelected(this.index.getIndex().isSpatialIndex());
        this.initSpatialIndexView();
        this.getPane().setEnabledAt(this.getPane().indexOfComponent(this.spatialPanel), this.index.getIndex().isSpatialIndex());
        this.tfLayerType.setText(this.index.getLayerType());
        this.tfGeodetic.setText(this.index.etGeodetic());
        this.tfDimensions.setText(this.index.getDimensionsNumber());
        this.cbNonLeaf.setSelectedItem(IndexPropertyDialogOraclev9i.translateYesNoForDisplay(this.index.getNonLeaf()));
        this.ifBatchSize.setValue((long)this.index.getBatchSize());
        this.fillComboItems(((StorageDesignOracle)this.index.getStorageDesign()).getTableSpaceSet().toArray(), this.cbWorkTablespace);
        this.cbWorkTablespace.setSelectedItem(this.index.getWorkTablespace());
    }

    private void initPartColumns(IndexGlobalPartitionsListOraclev9i indexGlobalPartitionsListOraclev9i) {
        this.selectedColumnsModel.clear();
        this.allColumnsModel.clear();
        ColumnProxy[] columnProxyArray = this.index.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxy columnProxy = columnProxyArray[i];
            if (indexGlobalPartitionsListOraclev9i != null && indexGlobalPartitionsListOraclev9i.getColumnSet().contains(columnProxy.getObjectID())) {
                this.selectedColumnsModel.addElement(columnProxy);
                continue;
            }
            this.allColumnsModel.addElement(columnProxy);
        }
    }

    @Override
    protected void setProperties() {
        if (this.index != null) {
            Object object;
            this.index.setName(this.tfName.getText());
            Object object2 = this.cbUser.getSelectedItem();
            if (object2 instanceof UserOracle) {
                this.index.setUser((UserOracle)object2);
            } else {
                this.index.setUser(null);
            }
            object2 = this.cbBitmapIndex.getSelectedItem();
            boolean bl = String.valueOf(object2).equalsIgnoreCase(YES);
            this.index.setBitmapIndex(bl);
            this.index.setIndexType(this.tfIndextype.getText().trim());
            this.index.setIndexPartitioned(this.translate((String)this.cbPartitioned.getSelectedItem(), PARTITIONED_CHOICES, IndexProxyOracle.getPartitionedChoices()));
            object2 = this.cbTableSpace.getSelectedItem();
            if (object2 instanceof TableSpaceOracle) {
                this.index.setTableSpace((TableSpaceOracle)object2);
            } else {
                this.index.setTableSpace(null);
            }
            this.index.setLogging(IndexPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            object2 = this.cbSegment.getSelectedItem();
            if (object2 instanceof SegmentOracle) {
                this.index.setSegment((SegmentOracle)object2);
            } else {
                this.index.setSegment(null);
            }
            this.index.setCompress(this.ifCompress.getIntValue());
            this.index.setParallel(IndexPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbParallel.getSelectedItem()));
            this.index.setDegree(this.tfDegree.getText());
            this.index.setSortedRows(this.translate((String)this.cbSortedRows.getSelectedItem(), SORT_CHOICES, IndexProxyOracle.getSortedRowsChoices()));
            this.index.setComputeStatistics(IndexPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbComputeStats.getSelectedItem()));
            this.index.setOnline(IndexPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbOnline.getSelectedItem()));
            String string = (String)this.cbPartitioned.getSelectedItem();
            if (!string.equalsIgnoreCase(NON_PARTITIONED) && !string.equalsIgnoreCase(LOCAL)) {
                if (this.index.getIndexGlobalPartitionsList() != null) {
                    object = (IndexGlobalPartitionsListOraclev9i)this.index.getIndexGlobalPartitionsList();
                } else {
                    object = (IndexGlobalPartitionsListOraclev9i)this.getStorageDesign().getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                    this.index.setIndexGlobalPartitionsList((IndexGlobalPartitionsListOracle)object);
                }
                Object[] objectArray = this.selectedColumnsModel.toArray();
                ((IndexGlobalPartitionsListOracle)object).clear();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object3 = objectArray[i];
                    if (!(object3 instanceof RelationalObjectProxy)) continue;
                    ((IndexGlobalPartitionsListOracle)object).setGlobalPartColumns(((RelationalObjectProxy)object3).getObjectID());
                }
            } else if (this.index.getIndexGlobalPartitionsList() != null) {
                object = (IndexGlobalPartitionsListOraclev9i)this.index.getIndexGlobalPartitionsList();
                this.index.setIndexGlobalPartitionsList(null);
                this.getStorageDesign().getIndexGlobalPartitionsListSet().remove((ModelObject)object);
            }
            object = this.selectedHashSubPartTSModel.toArray();
            for (int i = 0; i < ((Object[])object).length; ++i) {
                Object object4 = object[i];
                if (!(object4 instanceof TableSpaceOracle)) continue;
                this.index.setHashSubPartitionsTableSpaces(((TableSpaceOracle)object4).getObjectID());
            }
            this.index.setIndexDomainParameters(this.taIndextypeParameters.getText());
            String string2 = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(string2) && !this.comment.equals(string2)) {
                this.index.setComment(string2);
                this.index.setCommentChanged(true);
            } else {
                this.index.setComment("");
                this.index.setCommentChanged(false);
            }
            String string3 = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(string3) && !this.commentInRDBMS.equals(string3)) {
                this.index.setCommentInRDBMS(string3);
                this.index.setCommentInRDBMSChanged(true);
            } else {
                this.index.setCommentInRDBMS("");
                this.index.setCommentInRDBMSChanged(false);
            }
            this.index.setNonLeaf(IndexPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbNonLeaf.getSelectedItem()));
            this.index.setBatchSize(this.ifBatchSize.getIntValue());
            this.index.setWorkTablespace((TableSpaceOracle)this.cbWorkTablespace.getSelectedItem());
            this.applyColumnsSortOrder();
        }
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
        this.initPartitioningView();
        this.initHashPartTSView();
        this.initIndextypeParametersView();
        this.tpane.addChangeListener(new PartitionedListener());
    }

    private void initIndextypeParametersView() {
        this.indextypeParametersPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogOracle.IndextypeParameters"), this.indextypeParametersPanel);
        this.initIndextypeParameters();
    }

    private void initIndextypeParameters() {
        this.taIndextypeParameters = new JTextArea();
        this.spIndextypeParameters = new JScrollPane(this.taIndextypeParameters);
        this.spIndextypeParameters.setPreferredSize(new Dimension(395, 420));
        this.spIndextypeParameters.setBorder(BorderFactory.createEtchedBorder(0));
        this.taIndextypeParameters.setLineWrap(true);
        this.indextypeParametersPanel.add(this.spIndextypeParameters);
        this.setObjectConstraints((SpringLayout)this.indextypeParametersPanel.getLayout(), this.spIndextypeParameters, 10, 12);
    }

    private void initHashPartTSView() {
        this.hashSubPartTS = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogOracle.HashCompositeByHashTablespaces"), this.hashSubPartTS);
        this.initHashPartTablespaces();
    }

    private void initHashPartTablespaces() {
        this.initAllHashSubPartTSList();
        this.initSelectedHashSubPartTSList();
        this.initHashSubPartTSButtons();
    }

    private void initAllHashSubPartTSList() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogOracle.AllTableSpaces"));
        this.hashSubPartTS.add(jLabel);
        this.allHashSubPartTSModel = new DefaultListModel();
        this.allHashSubPartTSList = new JList(this.allHashSubPartTSModel);
        ListSelectionModel listSelectionModel = this.allHashSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllHashSubPartTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allHashSubPartTSList);
        jScrollPane.setPreferredSize(new Dimension(144, 400));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashSubPartTS.add(jScrollPane);
        this.setLabelConstraints(this.getHashSubPartTSLayout(), jLabel, 12, 12);
        this.setObjectConstraints(this.getHashSubPartTSLayout(), jScrollPane, 10, 32);
    }

    private void initSelectedHashSubPartTSList() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogOracle.SelectedTableSpaces"));
        this.hashSubPartTS.add(jLabel);
        this.selectedHashSubPartTSModel = new DefaultListModel();
        this.selectedHashSubPartTSList = new JList(this.selectedHashSubPartTSModel);
        ListSelectionModel listSelectionModel = this.selectedHashSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedHashSubPartTSListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedHashSubPartTSList);
        jScrollPane.setPreferredSize(new Dimension(145, 400));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashSubPartTS.add(jScrollPane);
        this.setLabelConstraints(this.getHashSubPartTSLayout(), jLabel, 292, 12);
        this.setObjectConstraints(this.getHashSubPartTSLayout(), jScrollPane, 290, 32);
    }

    private void initHashSubPartTSButtons() {
        this.bnAddHashSubPartTS = new JButton(ADD_CAPTION);
        this.bnAddHashSubPartTS.addActionListener(new AddHashSubPartTSActionListener());
        this.bnAddHashSubPartTS.setEnabled(false);
        this.hashSubPartTS.add(this.bnAddHashSubPartTS);
        this.setObjectConstraints(this.getHashSubPartTSLayout(), this.bnAddHashSubPartTS, 175, 185);
        this.bnRemoveHashSubPartTS = new JButton(REMOVE_CAPTION);
        this.bnRemoveHashSubPartTS.setEnabled(false);
        this.bnRemoveHashSubPartTS.addActionListener(new RemoveHashSubPartTSActionListener());
        this.hashSubPartTS.add(this.bnRemoveHashSubPartTS);
        this.setObjectConstraints(this.getHashSubPartTSLayout(), this.bnRemoveHashSubPartTS, 175, 215);
        IndexPropertyDialogOraclev9i.equalizeButtonSizes(this.bnAddHashSubPartTS, this.bnRemoveHashSubPartTS);
    }

    protected SpringLayout getHashSubPartTSLayout() {
        return (SpringLayout)this.hashSubPartTS.getLayout();
    }

    private void initColumnsView() {
        this.columns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogOracle.Columns"), this.columns);
        this.initColumns();
    }

    private void initColumns() {
        this.columnListModel = new DefaultListModel();
        this.columnList = new JList(this.columnListModel);
        this.columnList.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.columnList);
        jScrollPane.setPreferredSize(new Dimension(395, 420));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(jScrollPane);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.columns.getLayout();
    }

    private void initPartitioningView() {
        this.partitioning = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogOracle.GlobalPartitioning"), this.partitioning);
        this.initPartitioning();
    }

    protected SpringLayout getPartitioningLayout() {
        return (SpringLayout)this.partitioning.getLayout();
    }

    private void initPartitioning() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initButtons();
    }

    private void initAllColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogOracle.AllColumns"));
        this.partitioning.add(jLabel);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.allColumnsList);
        jScrollPane.setPreferredSize(new Dimension(144, 400));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitioning.add(jScrollPane);
        this.setLabelConstraints(this.getPartitioningLayout(), jLabel, 12, 12);
        this.setObjectConstraints(this.getPartitioningLayout(), jScrollPane, 10, 32);
    }

    private void initSelectedColumnsList() {
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogOracle.SelectedColumns"));
        this.partitioning.add(jLabel);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane jScrollPane = new JScrollPane(this.selectedColumnsList);
        jScrollPane.setPreferredSize(new Dimension(145, 400));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitioning.add(jScrollPane);
        this.setLabelConstraints(this.getPartitioningLayout(), jLabel, 292, 12);
        this.setObjectConstraints(this.getPartitioningLayout(), jScrollPane, 290, 32);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("IndexPropertyDialogOracle.Add"));
        this.bnAdd.addActionListener(new AddColumnsActionListener());
        this.bnAdd.setEnabled(false);
        this.partitioning.add(this.bnAdd);
        this.setObjectConstraints(this.getPartitioningLayout(), this.bnAdd, 175, 185);
        this.bnRemove = new JButton(Messages.getString("IndexPropertyDialogOracle.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveColumnsActionListener());
        this.partitioning.add(this.bnRemove);
        this.setObjectConstraints(this.getPartitioningLayout(), this.bnRemove, 175, 215);
        IndexPropertyDialogOraclev9i.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    private void setPartitioning(boolean bl) {
        this.allColumnsList.setEnabled(bl);
        this.selectedColumnsList.setEnabled(bl);
        this.bnAdd.setEnabled(bl && this.allColumnsList.getSelectedIndex() != -1);
        this.bnAdd.setEnabled(bl && this.selectedColumnsList.getSelectedIndex() != -1);
        this.allColumnsModel.clear();
        this.selectedColumnsModel.clear();
        this.initPartColumns((IndexGlobalPartitionsListOraclev9i)this.index.getIndexGlobalPartitionsList());
    }

    protected void initColumnsView(int n) {
        this.columnsView = new JPanel(new BorderLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogOracle.ColumnsSortOrder"), this.columnsView);
        this.columnsTable = new JTable();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet, 0);
        JScrollPane jScrollPane = new JScrollPane(this.columnsTable);
        jScrollPane.setPreferredSize(new Dimension(395, n));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columnsView.add(jScrollPane);
    }

    protected void initColumnsSortOrder() {
        this.sortModel = new ColumnsSortOrderModel((Index)this.index.getObject());
        this.columnsTable.setModel(this.sortModel);
        this.sortModel.setUpSortOrderColumn(this.columnsTable.getColumnModel().getColumn(1));
    }

    protected void applyColumnsSortOrder() {
        Collection collection = this.sortModel.getColumnsSortOrederColl();
        Iterator iterator = collection.iterator();
        Index index = (Index)this.index.getObject();
        while (iterator.hasNext()) {
            ColumnsSortOrderModel.ColumnNode columnNode = (ColumnsSortOrderModel.ColumnNode)iterator.next();
            Column column = (Column)index.getElementByID(columnNode.objectId);
            if (column == null) continue;
            index.setColumnSortOrder(column, columnNode.sortOrder);
        }
    }

    private void initSpatialIndexView() {
        this.spatialPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogOracle.SpatialIndex"), this.spatialPanel);
        JLabel jLabel = new JLabel(Messages.getString("IndexPropertyDialogOracle.ConstrainToLayerType"));
        this.spatialPanel.add(jLabel);
        this.tfLayerType = new JTextField("", 26);
        this.tfLayerType.setEnabled(false);
        this.tfLayerType.setPreferredSize(this.tfName.getPreferredSize());
        this.spatialPanel.add(this.tfLayerType);
        this.setLabelConstraints((SpringLayout)this.spatialPanel.getLayout(), jLabel, 20);
        this.setObjectConstraints((SpringLayout)this.spatialPanel.getLayout(), this.tfLayerType, 20);
        JLabel jLabel2 = new JLabel(Messages.getString("IndexPropertyDialogOracle.GeodeticIndex"));
        this.spatialPanel.add(jLabel2);
        this.tfGeodetic = new JTextField("", 26);
        this.tfGeodetic.setEnabled(false);
        this.tfGeodetic.setPreferredSize(this.tfName.getPreferredSize());
        this.spatialPanel.add(this.tfGeodetic);
        this.setLabelConstraints((SpringLayout)this.spatialPanel.getLayout(), jLabel2, 50);
        this.setObjectConstraints((SpringLayout)this.spatialPanel.getLayout(), this.tfGeodetic, 50);
        JLabel jLabel3 = new JLabel(Messages.getString("IndexPropertyDialogOracle.NumberOfDimensions"));
        this.spatialPanel.add(jLabel3);
        this.tfDimensions = new JTextField("", 26);
        this.tfDimensions.setEnabled(false);
        this.tfDimensions.setPreferredSize(this.tfName.getPreferredSize());
        this.spatialPanel.add(this.tfDimensions);
        this.setLabelConstraints((SpringLayout)this.spatialPanel.getLayout(), jLabel3, 80);
        this.setObjectConstraints((SpringLayout)this.spatialPanel.getLayout(), this.tfDimensions, 80);
        JLabel jLabel4 = new JLabel(Messages.getString("IndexPropertyDialogOracle.CreateTableForNonleafNodes"));
        this.spatialPanel.add(jLabel4);
        this.cbNonLeaf = new JComboBox<String>(YES_NO);
        this.cbNonLeaf.setPreferredSize(this.tfName.getPreferredSize());
        this.spatialPanel.add(this.cbNonLeaf);
        this.setLabelConstraints((SpringLayout)this.spatialPanel.getLayout(), jLabel4, 110);
        this.setObjectConstraints((SpringLayout)this.spatialPanel.getLayout(), this.cbNonLeaf, 110);
        JLabel jLabel5 = new JLabel(Messages.getString("IndexPropertyDialogOracle.UpdatesPerBatch"));
        this.spatialPanel.add(jLabel5);
        this.ifBatchSize = new JIntegerField(0, 26);
        this.spatialPanel.add(this.ifBatchSize);
        this.setLabelConstraints((SpringLayout)this.spatialPanel.getLayout(), jLabel5, 140);
        this.setObjectConstraints((SpringLayout)this.spatialPanel.getLayout(), this.ifBatchSize, 140);
        JLabel jLabel6 = new JLabel(Messages.getString("IndexPropertyDialogOracle.WorkTablespace"));
        this.spatialPanel.add(jLabel6);
        this.cbWorkTablespace = new JComboBox();
        this.cbWorkTablespace.setPreferredSize(this.tfName.getPreferredSize());
        this.spatialPanel.add(this.cbWorkTablespace);
        this.setLabelConstraints((SpringLayout)this.spatialPanel.getLayout(), jLabel6, 170);
        this.setObjectConstraints((SpringLayout)this.spatialPanel.getLayout(), this.cbWorkTablespace, 170);
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!IndexPropertyDialogOraclev9i.this.selectedColumnsModel.isEmpty()) {
                Object[] objectArray = IndexPropertyDialogOraclev9i.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (IndexPropertyDialogOraclev9i.this.allColumnsModel.contains(object)) continue;
                    IndexPropertyDialogOraclev9i.this.allColumnsModel.addElement(object);
                    IndexPropertyDialogOraclev9i.this.selectedColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!IndexPropertyDialogOraclev9i.this.allColumnsModel.isEmpty()) {
                Object[] objectArray = IndexPropertyDialogOraclev9i.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (IndexPropertyDialogOraclev9i.this.selectedColumnsModel.contains(object)) continue;
                    IndexPropertyDialogOraclev9i.this.selectedColumnsModel.addElement(object);
                    IndexPropertyDialogOraclev9i.this.allColumnsModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (IndexPropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (IndexPropertyDialogOraclev9i.this.selectedColumnsList.getSelectedIndex() == -1) {
                    IndexPropertyDialogOraclev9i.this.bnRemove.setEnabled(false);
                } else {
                    IndexPropertyDialogOraclev9i.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (IndexPropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (IndexPropertyDialogOraclev9i.this.allColumnsList.getSelectedIndex() == -1) {
                    IndexPropertyDialogOraclev9i.this.bnAdd.setEnabled(false);
                } else {
                    IndexPropertyDialogOraclev9i.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class RemoveHashSubPartTSActionListener
    implements ActionListener {
        private RemoveHashSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!IndexPropertyDialogOraclev9i.this.selectedHashSubPartTSModel.isEmpty()) {
                Object[] objectArray = IndexPropertyDialogOraclev9i.this.selectedHashSubPartTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (IndexPropertyDialogOraclev9i.this.allHashSubPartTSModel.contains(object)) continue;
                    IndexPropertyDialogOraclev9i.this.allHashSubPartTSModel.addElement(object);
                    IndexPropertyDialogOraclev9i.this.selectedHashSubPartTSModel.removeElement(object);
                }
            }
        }
    }

    private class AddHashSubPartTSActionListener
    implements ActionListener {
        private AddHashSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!IndexPropertyDialogOraclev9i.this.allHashSubPartTSModel.isEmpty()) {
                Object[] objectArray = IndexPropertyDialogOraclev9i.this.allHashSubPartTSList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    if (IndexPropertyDialogOraclev9i.this.selectedHashSubPartTSModel.contains(object)) continue;
                    IndexPropertyDialogOraclev9i.this.selectedHashSubPartTSModel.addElement(object);
                    IndexPropertyDialogOraclev9i.this.allHashSubPartTSModel.removeElement(object);
                }
            }
        }
    }

    private class SelectedHashSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedHashSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (IndexPropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (IndexPropertyDialogOraclev9i.this.selectedHashSubPartTSList.getSelectedIndex() == -1) {
                    IndexPropertyDialogOraclev9i.this.bnRemoveHashSubPartTS.setEnabled(false);
                } else {
                    IndexPropertyDialogOraclev9i.this.bnRemoveHashSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class AllHashSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private AllHashSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (IndexPropertyDialogOraclev9i.this.isEditable() && !listSelectionEvent.getValueIsAdjusting()) {
                if (IndexPropertyDialogOraclev9i.this.allHashSubPartTSList.getSelectedIndex() == -1) {
                    IndexPropertyDialogOraclev9i.this.bnAddHashSubPartTS.setEnabled(false);
                } else {
                    IndexPropertyDialogOraclev9i.this.bnAddHashSubPartTS.setEnabled(true);
                }
            }
        }
    }

    class BitmapListener
    implements ActionListener {
        BitmapListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)IndexPropertyDialogOraclev9i.this.cbBitmapIndex.getSelectedItem();
            if (string.equalsIgnoreCase(AbstractPropertyDialog.YES) && IndexPropertyDialogOraclev9i.this.index != null && ((TableProxyOracle)IndexPropertyDialogOraclev9i.this.index.getTableProxy()).getPartitioned().equalsIgnoreCase("YES")) {
                IndexPropertyDialogOraclev9i.this.cbPartitioned.setSelectedItem(IndexPropertyDialogOraclev9i.LOCAL);
                IndexPropertyDialogOraclev9i.this.cbPartitioned.setEnabled(false);
            } else {
                IndexPropertyDialogOraclev9i.this.cbPartitioned.setEnabled(true);
            }
        }
    }

    public class PartitionedListener
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (IndexPropertyDialogOraclev9i.this.tpane.getSelectedComponent() == IndexPropertyDialogOraclev9i.this.tpane.getComponentAt(2)) {
                String string = (String)IndexPropertyDialogOraclev9i.this.cbPartitioned.getSelectedItem();
                if (!string.equalsIgnoreCase(IndexPropertyDialogOraclev9i.NON_PARTITIONED) && !string.equalsIgnoreCase(IndexPropertyDialogOraclev9i.LOCAL)) {
                    IndexPropertyDialogOraclev9i.this.allColumnsList.setEnabled(true);
                    IndexPropertyDialogOraclev9i.this.selectedColumnsList.setEnabled(true);
                    IndexPropertyDialogOraclev9i.this.bnAdd.setEnabled(IndexPropertyDialogOraclev9i.this.allColumnsList.getSelectedIndex() != -1);
                    IndexPropertyDialogOraclev9i.this.bnRemove.setEnabled(IndexPropertyDialogOraclev9i.this.selectedColumnsList.getSelectedIndex() != -1);
                    IndexPropertyDialogOraclev9i.this.initPartColumns((IndexGlobalPartitionsListOraclev9i)IndexPropertyDialogOraclev9i.this.index.getIndexGlobalPartitionsList());
                } else {
                    IndexPropertyDialogOraclev9i.this.allColumnsList.setEnabled(false);
                    IndexPropertyDialogOraclev9i.this.selectedColumnsList.setEnabled(false);
                    IndexPropertyDialogOraclev9i.this.bnAdd.setEnabled(false);
                    IndexPropertyDialogOraclev9i.this.bnRemove.setEnabled(false);
                }
            }
        }
    }

    private class LocalPartitionListener
    implements ActionListener {
        private LocalPartitionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PartitionListOracle partitionListOracle = ((TableProxyOracle)IndexPropertyDialogOraclev9i.this.index.getTableProxy()).getPartitionList();
            String string = null;
            if (partitionListOracle != null) {
                string = partitionListOracle.getPartitionType();
            }
            if (((String)IndexPropertyDialogOraclev9i.this.cbPartitioned.getSelectedItem()).equalsIgnoreCase(IndexPropertyDialogOraclev9i.LOCAL) && string != null && (string.equalsIgnoreCase("COMPOSITE BY HASH") || string.equalsIgnoreCase("HASH BY LIST OF PARTITIONS") || string.equalsIgnoreCase("HASH BY QUANTITY"))) {
                IndexPropertyDialogOraclev9i.this.allHashSubPartTSList.setEnabled(true);
                IndexPropertyDialogOraclev9i.this.selectedHashSubPartTSList.setEnabled(true);
                IndexPropertyDialogOraclev9i.this.bnAddHashSubPartTS.setEnabled(IndexPropertyDialogOraclev9i.this.allHashSubPartTSList.getSelectedIndex() != -1);
                IndexPropertyDialogOraclev9i.this.bnRemoveHashSubPartTS.setEnabled(IndexPropertyDialogOraclev9i.this.selectedHashSubPartTSList.getSelectedIndex() != -1);
            } else {
                IndexPropertyDialogOraclev9i.this.allHashSubPartTSList.setEnabled(false);
                IndexPropertyDialogOraclev9i.this.selectedHashSubPartTSList.setEnabled(false);
                IndexPropertyDialogOraclev9i.this.bnAddHashSubPartTS.setEnabled(false);
                IndexPropertyDialogOraclev9i.this.bnRemoveHashSubPartTS.setEnabled(false);
            }
        }
    }
}

