/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.string.StringUtilities;

public class FKPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private FKProxyOracle fkIndex;
    private JTextField tfTable;
    private JTextField tfRefTable;
    private JTextField tfOnDelete;
    private JComboBox cbInitially;
    private JComboBox cbDeferrable;
    private JComboBox cbEnable;
    private JComboBox cbValidate;
    private JComboBox cbRely;
    private JComboBox cbExTable;
    private JPanel columns;
    private JPanel refColumns;
    private JList columnList;
    private JList refColumnsList;
    private DefaultListModel columnListModel;
    private DefaultListModel refColumnsListModel;
    private String comment;

    public FKPropertyDialogOraclev9i(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.fkIndex = (FKProxyOracle)storageObject;
        this.setHeight(350);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("FKPropertyDialogOraclev9i.ForeignKeyProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initRefTable();
        this.initOnDelete();
        this.initInitially();
        this.initDeferrable();
        this.initEnable();
        this.initValidate();
        this.initRely();
        this.initExTable();
    }

    private void initTable() {
        JLabel jLabel = new JLabel(Messages.getString("FKPropertyDialogOraclev9i.Table"));
        this.general.add(jLabel);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEditable(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initRefTable() {
        JLabel jLabel = new JLabel(Messages.getString("FKPropertyDialogOraclev9i.RefTable"));
        this.general.add(jLabel);
        this.tfRefTable = new JTextField("", 26);
        this.tfRefTable.setEditable(false);
        this.general.add(this.tfRefTable);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfRefTable, 80);
    }

    private void initOnDelete() {
        JLabel jLabel = new JLabel(Messages.getString("FKPropertyDialogOraclev9i.OnDelete"));
        this.general.add(jLabel);
        this.tfOnDelete = new JTextField();
        this.setBG(this.tfOnDelete);
        this.tfOnDelete.setPreferredSize(this.tfName.getPreferredSize());
        this.tfOnDelete.setEnabled(false);
        this.general.add(this.tfOnDelete);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.tfOnDelete, 110);
    }

    private void initInitially() {
        JLabel jLabel = new JLabel(Messages.getString("FKPropertyDialogOraclev9i.Initially"));
        this.general.add(jLabel);
        this.cbInitially = new JComboBox<String>(FKProxyOracle.getInitiallyChoices());
        this.setBG(this.cbInitially);
        this.cbInitially.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbInitially);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.cbInitially, 140);
    }

    private void initDeferrable() {
        JLabel jLabel = new JLabel(Messages.getString("FKPropertyDialogOraclev9i.Deferrable"));
        this.general.add(jLabel);
        this.cbDeferrable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDeferrable);
        this.cbDeferrable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDeferrable);
        this.setLabelConstraints(jLabel, 170);
        this.setObjectConstraints(this.cbDeferrable, 170);
    }

    private void initEnable() {
        JLabel jLabel = new JLabel(Messages.getString("FKPropertyDialogOraclev9i.Enable"));
        this.general.add(jLabel);
        this.cbEnable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbEnable);
        this.cbEnable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbEnable);
        this.setLabelConstraints(jLabel, 200);
        this.setObjectConstraints(this.cbEnable, 200);
    }

    private void initValidate() {
        JLabel jLabel = new JLabel(Messages.getString("FKPropertyDialogOraclev9i.Validate"));
        this.general.add(jLabel);
        this.cbValidate = new JComboBox<String>(YES_NO);
        this.cbValidate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FKPropertyDialogOraclev9i.this.cbRely.setEnabled(FKPropertyDialogOraclev9i.this.cbValidate.getSelectedItem().equals(AbstractPropertyDialog.NO));
            }
        });
        this.setBG(this.cbValidate);
        this.cbValidate.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbValidate);
        this.setLabelConstraints(jLabel, 230);
        this.setObjectConstraints(this.cbValidate, 230);
    }

    private void initRely() {
        JLabel jLabel = new JLabel(Messages.getString("FKPropertyDialogOraclev9i.Rely"));
        this.general.add(jLabel);
        this.cbRely = new JComboBox<String>(YES_NO);
        this.setBG(this.cbRely);
        this.cbRely.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRely);
        this.setLabelConstraints(jLabel, 260);
        this.setObjectConstraints(this.cbRely, 260);
    }

    private void initExTable() {
        JLabel jLabel = new JLabel(Messages.getString("FKPropertyDialogOraclev9i.ExceptionsTable"));
        this.general.add(jLabel);
        this.cbExTable = new JComboBox();
        this.setBG(this.cbExTable);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableProxySet().toArray(), this.cbExTable);
        }
        this.cbExTable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbExTable);
        this.setLabelConstraints(jLabel, 290);
        this.setObjectConstraints(this.cbExTable, 290);
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
        this.initRefColumnsView();
    }

    private void initColumnsView() {
        this.columns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("FKPropertyDialogOraclev9i.Columns"), this.columns);
        this.initColumns();
    }

    private void initColumns() {
        this.columnListModel = new DefaultListModel();
        this.columnList = new JList(this.columnListModel);
        this.columnList.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.columnList);
        jScrollPane.setPreferredSize(new Dimension(395, 300));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(jScrollPane);
        this.setObjectConstraints(this.getColumnsLayout(), jScrollPane, 10, 12);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.columns.getLayout();
    }

    protected SpringLayout getRefColumnsLayout() {
        return (SpringLayout)this.refColumns.getLayout();
    }

    private void initRefColumnsView() {
        this.refColumns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("FKPropertyDialogOraclev9i.ReferencedColumns"), this.refColumns);
        this.initRefColumns();
    }

    private void initRefColumns() {
        this.refColumnsListModel = new DefaultListModel();
        this.refColumnsList = new JList(this.refColumnsListModel);
        this.refColumnsList.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.refColumnsList);
        jScrollPane.setPreferredSize(new Dimension(395, 300));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.refColumns.add(jScrollPane);
        this.setObjectConstraints(this.getRefColumnsLayout(), jScrollPane, 10, 12);
    }

    @Override
    public void initProperties() {
        Object object;
        this.initCaption(this.fkIndex.getName());
        this.tfName.setText(this.fkIndex.getName());
        this.tfTable.setText(this.fkIndex.getTable().getName());
        this.tfRefTable.setText(this.fkIndex.getReferenceTable());
        ColumnProxy[] columnProxyArray = this.fkIndex.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxy columnProxy = columnProxyArray[i];
            this.columnListModel.addElement(columnProxy);
        }
        Column[] columnArray = this.fkIndex.getRefColumns();
        for (int i = 0; i < columnArray.length; ++i) {
            object = columnArray[i];
            this.refColumnsListModel.addElement(object);
        }
        FKIndexAssociation fKIndexAssociation = ((Index)this.fkIndex.getObject()).getFKAssociation();
        object = fKIndexAssociation.getDeleteRule();
        if (((String)object).equalsIgnoreCase("SET DEFAULT")) {
            object = fKIndexAssociation.isMandatory() ? "RESTRICT" : "SET NULL";
        }
        this.tfOnDelete.setText((String)object);
        this.cbInitially.setSelectedItem(this.fkIndex.getInitially());
        this.cbDeferrable.setSelectedItem(FKPropertyDialogOraclev9i.translateYesNoForDisplay(this.fkIndex.getDeferrable()));
        this.cbEnable.setSelectedItem(FKPropertyDialogOraclev9i.translateYesNoForDisplay(this.fkIndex.getEnable()));
        this.cbValidate.setSelectedItem(FKPropertyDialogOraclev9i.translateYesNoForDisplay(this.fkIndex.getValidate()));
        this.cbRely.setSelectedItem(FKPropertyDialogOraclev9i.translateYesNoForDisplay(this.fkIndex.getRely()));
        this.cbExTable.setSelectedItem(this.fkIndex.getExceptionsTable());
        this.comment = fKIndexAssociation.getComment();
        if (this.fkIndex.isCommentChanged()) {
            this.getCommentsList().insert(this.fkIndex.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
    }

    @Override
    protected void setProperties() {
        if (this.fkIndex != null) {
            this.fkIndex.setName(this.tfName.getText());
            this.fkIndex.setInitially((String)this.cbInitially.getSelectedItem());
            this.fkIndex.setDeferrable(FKPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbDeferrable.getSelectedItem()));
            this.fkIndex.setEnable(FKPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbEnable.getSelectedItem()));
            this.fkIndex.setValidate(FKPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbValidate.getSelectedItem()));
            this.fkIndex.setRely(FKPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbRely.getSelectedItem()));
            Object object = this.cbExTable.getSelectedItem();
            if (object instanceof TableProxyOracle) {
                this.fkIndex.setExceptionsTable((TableProxyOracle)object);
            } else {
                this.fkIndex.setExceptionsTable(null);
            }
            String string = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(string) && !this.comment.equals(string)) {
                this.fkIndex.setComment(string);
                this.fkIndex.setCommentChanged(true);
            } else {
                this.fkIndex.setComment("");
                this.fkIndex.setCommentChanged(false);
            }
        }
    }
}

