/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.NotNullConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ColumnProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ColumnProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ObjectPermissionsDialogOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v11g.ColumnPropertyDialogOraclev11g;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class ColumnPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private ColumnProxyOraclev9i column;
    private JTextField tfDataType;
    private JTextField tfScope;
    private JTextField tfNullsAllowed;
    private JTextField tfCluster;
    private JIntegerField ifPosInCluster;
    private JTextField tfDefaultValue;
    protected JPanel xmlTypeOptions;
    protected JComboBox cbStoreAs;
    protected JComboBox cbLobStorageType;
    private JTextField tfLobSegmentName;
    private JTextField tfXmlSchemaUrl;
    private JTextField tfXmlSchemaElement;
    protected JComboBox cbAllowAnySchema;
    protected JComboBox cbAllowNonSchema;
    private JComboBox cbTableSpace;
    private JComboBox cbStorageInRow;
    private JComboBox cbLogging;
    private JComboBox cbCache;
    private JIntegerField ifChunk;
    private JComboBox cbOldVersions;
    private JIntegerField ifPctVersion;
    private JIntegerField ifFreePools;
    private JIntegerField ifSCInitialExtent;
    private JIntegerField ifSCNextExtent;
    private JIntegerField ifSCMinExtents;
    private JTextField tfSCMaxExtents;
    private JIntegerField ifSCPctIncrease;
    private JComboBox cbSCBufferPool;
    private JIntegerField ifSCFreeLists;
    private JIntegerField ifSCFreeListsGroups;
    private JComboBox cbWithRowId;
    private JPanel columnCheckOptions;
    private JTextField tfConstraintName;
    private JTextArea taConstraint;
    private JComboBox cbInitially;
    private JComboBox cbDeferrable;
    private JComboBox cbEnable;
    private JComboBox cbValidate;
    private JComboBox cbExTable;
    private String comment;
    private String commentInRDBMS;
    private JComboBox cbSubstitutable;
    private JComboBox cbElementType;
    private JComboBox cbAutoIncrementUser;
    private JPanel vArrayAndNT;
    private JTextField tfNTStorageTable;
    private JComboBox cbNTReturn;
    private JTextField tfLobSegname;
    private JTextArea taAdditionalNTS;
    private String notNullConstraintName;
    private ObjectPermissionsDialogOracle dialog;
    private JComboBox cbNNCInitially;
    private JComboBox cbNNCDeferrable;
    private JComboBox cbNNCEnable;
    private JComboBox cbNNCValidate;
    private JComboBox cbNNCExTable;
    private JPanel generalNNC;
    private JTextField tfNNCName;

    public ColumnPropertyDialogOraclev9i(ApplicationView applicationView, StorageDesign storageDesign, StorageObject storageObject) {
        super(applicationView, storageDesign, storageObject);
        this.column = (ColumnProxyOraclev9i)storageObject;
    }

    @Override
    protected int getDialogWidth() {
        return 500;
    }

    public void init() {
        this.setHeight(640);
        this.initCommentsView(230);
        this.initCommentsInRDBMS(230);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    protected Integer getRDBMSType() {
        return new Integer(7);
    }

    @Override
    public String getCaption() {
        return Messages.getString("ColumnPropertyDialogOraclev9i.ColumnProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDataType();
        this.initScope();
        this.initNullsAllowed();
        this.initDefaultValue();
        int n = 170;
        n += this.initComputed(n);
        n += this.initColumnExpression(n);
        this.initCluster(n);
        this.initPosInCluster(n += 30);
        this.initStoreAs(n += 30);
        n += 30;
        n += this.initLobStorageType(n);
        this.initLobSegmentName(n);
        this.initXmlSchemaUrl(n += 30);
        this.initXmlSchemaElement(n += 30);
        this.initWithRowId(n += 30);
        this.initSubstitutable(n += 30);
        this.initElementType(n += 30);
        this.initAutoIncrementUser(n += 30);
    }

    private void initDataType() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.DataType"));
        this.general.add(jLabel);
        this.tfDataType = new JTextField("", 26);
        this.tfDataType.setEnabled(false);
        this.general.add(this.tfDataType);
        this.setLabelConstraints(jLabel, 50);
        this.setObjectConstraints(this.tfDataType, 50);
    }

    private void initScope() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Scope"));
        this.general.add(jLabel);
        this.tfScope = new JTextField("", 26);
        this.tfScope.setEnabled(false);
        this.general.add(this.tfScope);
        this.setLabelConstraints(jLabel, 80);
        this.setObjectConstraints(this.tfScope, 80);
    }

    private void initNullsAllowed() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.NullsAllowed"));
        this.general.add(jLabel);
        this.tfNullsAllowed = new JTextField("", 26);
        this.tfNullsAllowed.setEnabled(false);
        this.general.add(this.tfNullsAllowed);
        this.setLabelConstraints(jLabel, 110);
        this.setObjectConstraints(this.tfNullsAllowed, 110);
    }

    private void initDefaultValue() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.DefaultValue"));
        this.general.add(jLabel);
        this.tfDefaultValue = new JTextField("", 26);
        this.general.add(this.tfDefaultValue);
        this.setLabelConstraints(jLabel, 140);
        this.setObjectConstraints(this.tfDefaultValue, 140);
    }

    protected int initComputed(int n) {
        return 0;
    }

    protected int initColumnExpression(int n) {
        return 0;
    }

    protected int initLobStorageType(int n) {
        return 0;
    }

    private void initCluster(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Cluster"));
        this.general.add(jLabel);
        this.tfCluster = new JTextField("", 26);
        this.tfCluster.setEnabled(false);
        this.general.add(this.tfCluster);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.tfCluster, n);
    }

    private void initPosInCluster(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.PositionInCluster"));
        this.general.add(jLabel);
        this.ifPosInCluster = new JIntegerField(0, 26);
        this.ifPosInCluster.setEnabled(false);
        this.general.add(this.ifPosInCluster);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.ifPosInCluster, n);
    }

    private void initStoreAs(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.StoreAs"));
        this.general.add(jLabel);
        this.cbStoreAs = this.getStorageDesign() instanceof StorageDesignOraclev11g ? new JComboBox<String>(ColumnProxyOraclev11g.getStoreAsValues11g()) : new JComboBox<String>(ColumnProxyOraclev9i.getStoreAsValues());
        this.cbStoreAs.addActionListener(new StoreAsListener());
        this.setBG(this.cbStoreAs);
        this.cbStoreAs.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbStoreAs);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.cbStoreAs, n);
    }

    private void initLobSegmentName(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.LobSegmentName"));
        this.general.add(jLabel);
        this.tfLobSegmentName = new JTextField("", 26);
        this.general.add(this.tfLobSegmentName);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.tfLobSegmentName, n);
    }

    private void initXmlSchemaUrl(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.XMLSchemaURL"));
        this.general.add(jLabel);
        this.tfXmlSchemaUrl = new JTextField("", 26);
        this.general.add(this.tfXmlSchemaUrl);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.tfXmlSchemaUrl, n);
    }

    private void initXmlSchemaElement(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.XMLSchemaElem"));
        this.general.add(jLabel);
        this.tfXmlSchemaElement = new JTextField("", 26);
        this.general.add(this.tfXmlSchemaElement);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.tfXmlSchemaElement, n);
    }

    private void initWithRowId(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.WithROWID"));
        this.general.add(jLabel);
        this.cbWithRowId = new JComboBox<String>(YES_NO);
        this.setBG(this.cbWithRowId);
        this.cbWithRowId.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbWithRowId);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.cbWithRowId, n);
    }

    @Override
    protected void addTabs() {
        this.initXMLTypeOptionsView();
        this.initColumnCheckOptionsView();
        this.initVarrayAndNTView();
        this.initNNC();
    }

    private void initXMLTypeOptionsView() {
        this.xmlTypeOptions = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ColumnPropertyDialogOraclev9i.XMLTypeCLOBOptions"), this.xmlTypeOptions);
        this.initXMLTypeOptions();
    }

    protected SpringLayout getXmlTypeLayout() {
        return (SpringLayout)this.xmlTypeOptions.getLayout();
    }

    private void initXMLTypeOptions() {
        int n = this.initAllowAnySchema(20);
        n = this.initAllowNonSchema(n);
        this.initTableSpace(n);
        this.initStorageInRow(n += 30);
        this.initLogging(n += 30);
        this.initCache(n += 30);
        this.initChunk(n += 30);
        this.initOldVersions(n += 30);
        this.initPctVersion(n += 30);
        this.initFreePools(n += 30);
        this.initSCInitialExtent(n += 30);
        this.initSCNextExtent(n += 30);
        this.initSCMinExtents(n += 30);
        this.initSCMaxExtents(n += 30);
        this.initSCPctIncrease(n += 30);
        this.initSCBufferPool(n += 30);
        this.initSCFreeLists(n += 30);
        this.initSCFreeListsGroups(n += 30);
    }

    protected int initAllowAnySchema(int n) {
        return n;
    }

    protected int initAllowNonSchema(int n) {
        return n;
    }

    private void initTableSpace(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.TableSpace"));
        this.xmlTypeOptions.add(jLabel);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.xmlTypeOptions.add(this.cbTableSpace);
        this.setLabelConstraints(this.getXmlTypeLayout(), jLabel, n);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.cbTableSpace, n);
    }

    private void initStorageInRow(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.StorageInRow"));
        this.xmlTypeOptions.add(jLabel);
        this.cbStorageInRow = new JComboBox<String>(ColumnProxyOraclev9i.getStorageInRowValues());
        this.setBG(this.cbStorageInRow);
        this.cbStorageInRow.setPreferredSize(this.tfName.getPreferredSize());
        this.xmlTypeOptions.add(this.cbStorageInRow);
        this.setLabelConstraints(this.getXmlTypeLayout(), jLabel, n);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.cbStorageInRow, n);
    }

    private void initLogging(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Logging"));
        this.xmlTypeOptions.add(jLabel);
        this.cbLogging = new JComboBox<String>(this instanceof ColumnPropertyDialogOraclev11g ? ColumnProxyOraclev11g.getLoggingChoices11g() : EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.xmlTypeOptions.add(this.cbLogging);
        this.setLabelConstraints(this.getXmlTypeLayout(), jLabel, n);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.cbLogging, n);
    }

    private void initCache(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Cache"));
        this.xmlTypeOptions.add(jLabel);
        this.cbCache = new JComboBox<String>(ColumnProxyOraclev9i.getCacheValues());
        this.setBG(this.cbCache);
        this.cbCache.setPreferredSize(this.tfName.getPreferredSize());
        this.xmlTypeOptions.add(this.cbCache);
        this.setLabelConstraints(this.getXmlTypeLayout(), jLabel, n);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.cbCache, n);
    }

    private void initChunk(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Chunk"));
        this.xmlTypeOptions.add(jLabel);
        this.ifChunk = new JIntegerField(0, 26);
        this.xmlTypeOptions.add(this.ifChunk);
        this.setLabelConstraints(this.getXmlTypeLayout(), jLabel, n);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.ifChunk, n);
    }

    private void initOldVersions(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.OldVersions"));
        this.xmlTypeOptions.add(jLabel);
        this.cbOldVersions = new JComboBox<String>(ColumnProxyOraclev9i.getOldVersionChoices());
        this.cbOldVersions.addActionListener(new VersionListener());
        this.setBG(this.cbOldVersions);
        this.cbOldVersions.setPreferredSize(this.tfName.getPreferredSize());
        this.xmlTypeOptions.add(this.cbOldVersions);
        this.setLabelConstraints(this.getXmlTypeLayout(), jLabel, n);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.cbOldVersions, n);
    }

    private void initPctVersion(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.PCTVersion"));
        this.xmlTypeOptions.add(jLabel);
        this.ifPctVersion = new JIntegerField(0, 26);
        this.xmlTypeOptions.add(this.ifPctVersion);
        this.setLabelConstraints(this.getXmlTypeLayout(), jLabel, n);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.ifPctVersion, n);
    }

    private void initFreePools(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.FreePools"));
        this.xmlTypeOptions.add(jLabel);
        this.ifFreePools = new JIntegerField(0, 26);
        this.xmlTypeOptions.add(this.ifFreePools);
        this.setLabelConstraints(this.getXmlTypeLayout(), jLabel, n);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.ifFreePools, n);
    }

    private void initSCInitialExtent(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.SCInitialExtent"));
        this.xmlTypeOptions.add(jLabel);
        this.ifSCInitialExtent = new JIntegerField(0, 26);
        this.xmlTypeOptions.add(this.ifSCInitialExtent);
        this.setLabelConstraints(this.getXmlTypeLayout(), jLabel, n);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.ifSCInitialExtent, n);
    }

    private void initSCNextExtent(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.SCNextExtent"));
        this.xmlTypeOptions.add(jLabel);
        this.ifSCNextExtent = new JIntegerField(0, 26);
        this.xmlTypeOptions.add(this.ifSCNextExtent);
        this.setLabelConstraints(this.getXmlTypeLayout(), jLabel, n);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.ifSCNextExtent, n);
    }

    private void initSCMinExtents(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.SCMinExtents"));
        this.xmlTypeOptions.add(jLabel);
        this.ifSCMinExtents = new JIntegerField(0, 26);
        this.xmlTypeOptions.add(this.ifSCMinExtents);
        this.setLabelConstraints(this.getXmlTypeLayout(), jLabel, n);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.ifSCMinExtents, n);
    }

    private void initSCMaxExtents(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.SCMaxExtents"));
        this.xmlTypeOptions.add(jLabel);
        this.tfSCMaxExtents = new JTextField("UNLIMITED", 26);
        this.xmlTypeOptions.add(this.tfSCMaxExtents);
        this.setLabelConstraints(this.getXmlTypeLayout(), jLabel, n);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.tfSCMaxExtents, n);
    }

    private void initSCPctIncrease(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.SCPCTIncrease"));
        this.xmlTypeOptions.add(jLabel);
        this.ifSCPctIncrease = new JIntegerField(0, 26);
        this.xmlTypeOptions.add(this.ifSCPctIncrease);
        this.setLabelConstraints(this.getXmlTypeLayout(), jLabel, n);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.ifSCPctIncrease, n);
    }

    private void initSCBufferPool(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.SCBufferPool"));
        this.xmlTypeOptions.add(jLabel);
        this.cbSCBufferPool = new JComboBox<String>(ColumnProxyOraclev9i.getSCBufferPoolValues());
        this.setBG(this.cbSCBufferPool);
        this.cbSCBufferPool.setPreferredSize(this.tfName.getPreferredSize());
        this.xmlTypeOptions.add(this.cbSCBufferPool);
        this.setLabelConstraints(this.getXmlTypeLayout(), jLabel, n);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.cbSCBufferPool, n);
    }

    private void initSCFreeLists(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.SCFreeLists"));
        this.xmlTypeOptions.add(jLabel);
        this.ifSCFreeLists = new JIntegerField(0, 26);
        this.xmlTypeOptions.add(this.ifSCFreeLists);
        this.setLabelConstraints(this.getXmlTypeLayout(), jLabel, n);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.ifSCFreeLists, n);
    }

    private void initSCFreeListsGroups(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.SCFreeListsGrps"));
        this.xmlTypeOptions.add(jLabel);
        this.ifSCFreeListsGroups = new JIntegerField(0, 26);
        this.xmlTypeOptions.add(this.ifSCFreeListsGroups);
        this.setLabelConstraints(this.getXmlTypeLayout(), jLabel, n);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.ifSCFreeListsGroups, n);
    }

    private void enableXMLTypeClobOptions(boolean bl) {
        int n = this.getPane().indexOfComponent(this.xmlTypeOptions);
        if (n > -1) {
            this.getPane().setEnabledAt(n, bl);
        }
    }

    private void initVarrayAndNTView() {
        this.vArrayAndNT = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ColumnPropertyDialogOraclev9i.VarrayAndNestedTable"), this.vArrayAndNT);
        this.initVarrayAndNT();
    }

    private void initVarrayAndNT() {
        this.initNTStorageTable();
        this.initNTReturn();
        this.initLOBSegname();
        this.initAdditionalNTS();
    }

    private void initNTStorageTable() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.NTStorageTable"));
        this.vArrayAndNT.add(jLabel);
        this.tfNTStorageTable = new JTextField(26);
        this.vArrayAndNT.add(this.tfNTStorageTable);
        this.tfNTStorageTable.setEnabled(true);
        this.setLabelConstraints(this.getVarrayAndNTLayout(), jLabel, 20);
        this.setObjectConstraints(this.getVarrayAndNTLayout(), this.tfNTStorageTable, 20);
    }

    private void initNTReturn() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.NTReturnAS"));
        this.vArrayAndNT.add(jLabel);
        this.cbNTReturn = new JComboBox<String>(ColumnProxyOraclev9i.getReturnAsValues());
        this.setBG(this.cbNTReturn);
        this.cbNTReturn.setPreferredSize(this.tfName.getPreferredSize());
        this.vArrayAndNT.add(this.cbNTReturn);
        this.setLabelConstraints(this.getVarrayAndNTLayout(), jLabel, 50);
        this.setObjectConstraints(this.getVarrayAndNTLayout(), this.cbNTReturn, 50);
    }

    private void initLOBSegname() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.LOBSegname"));
        this.vArrayAndNT.add(jLabel);
        this.tfLobSegname = new JTextField(26);
        this.vArrayAndNT.add(this.tfLobSegname);
        this.tfLobSegname.setEnabled(true);
        this.setLabelConstraints(this.getVarrayAndNTLayout(), jLabel, 80);
        this.setObjectConstraints(this.getVarrayAndNTLayout(), this.tfLobSegname, 80);
    }

    private void initAdditionalNTS() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.AdditionalNestedTableSettings"));
        this.vArrayAndNT.add(jLabel);
        this.taAdditionalNTS = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.taAdditionalNTS);
        jScrollPane.setPreferredSize(new Dimension(395, 100));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.taAdditionalNTS.setLineWrap(true);
        this.taAdditionalNTS.setEnabled(true);
        this.vArrayAndNT.add(jScrollPane);
        this.setLabelConstraints(this.getVarrayAndNTLayout(), jLabel, 110);
        this.setObjectConstraints(this.getVarrayAndNTLayout(), jScrollPane, 10, 130);
    }

    protected SpringLayout getVarrayAndNTLayout() {
        return (SpringLayout)this.vArrayAndNT.getLayout();
    }

    protected SpringLayout getColumnCheckOptionsLayout() {
        return (SpringLayout)this.columnCheckOptions.getLayout();
    }

    private void initColumnCheckOptionsView() {
        this.columnCheckOptions = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ColumnPropertyDialogOraclev9i.ColumnCheckOptions"), this.columnCheckOptions);
        this.initColumnCheckOptions();
    }

    private void initColumnCheckOptions() {
        this.initConstraintName();
        this.initConstraint();
        this.initInitially();
        this.initDeferrable();
        this.initEnable();
        this.initValidate();
        this.initExTable();
    }

    private void initConstraintName() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.ConstraintName"));
        this.columnCheckOptions.add(jLabel);
        this.tfConstraintName = new JTextField(26);
        this.columnCheckOptions.add(this.tfConstraintName);
        this.tfConstraintName.setEnabled(false);
        this.setLabelConstraints(this.getColumnCheckOptionsLayout(), jLabel, 20);
        this.setObjectConstraints(this.getColumnCheckOptionsLayout(), this.tfConstraintName, 20);
    }

    private void initConstraint() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Constraint"));
        this.columnCheckOptions.add(jLabel);
        this.taConstraint = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.taConstraint);
        jScrollPane.setPreferredSize(new Dimension(395, 80));
        jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.taConstraint.setLineWrap(true);
        this.taConstraint.setEnabled(false);
        this.columnCheckOptions.add(jScrollPane);
        this.setLabelConstraints(this.getColumnCheckOptionsLayout(), jLabel, 50);
        this.setObjectConstraints(this.getColumnCheckOptionsLayout(), jScrollPane, 10, 70);
    }

    private void initInitially() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Initially"));
        this.columnCheckOptions.add(jLabel);
        this.cbInitially = new JComboBox<String>(NotNullConstraintOracle.getInitiallyChoices());
        this.setBG(this.cbInitially);
        this.cbInitially.setPreferredSize(this.tfName.getPreferredSize());
        this.columnCheckOptions.add(this.cbInitially);
        this.setLabelConstraints(this.getColumnCheckOptionsLayout(), jLabel, 170);
        this.setObjectConstraints(this.getColumnCheckOptionsLayout(), this.cbInitially, 170);
    }

    private void initDeferrable() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Deferrable"));
        this.columnCheckOptions.add(jLabel);
        this.cbDeferrable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDeferrable);
        this.cbDeferrable.setPreferredSize(this.tfName.getPreferredSize());
        this.columnCheckOptions.add(this.cbDeferrable);
        this.setLabelConstraints(this.getColumnCheckOptionsLayout(), jLabel, 200);
        this.setObjectConstraints(this.getColumnCheckOptionsLayout(), this.cbDeferrable, 200);
    }

    private void initEnable() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Enable"));
        this.columnCheckOptions.add(jLabel);
        this.cbEnable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbEnable);
        this.cbEnable.setPreferredSize(this.tfName.getPreferredSize());
        this.columnCheckOptions.add(this.cbEnable);
        this.setLabelConstraints(this.getColumnCheckOptionsLayout(), jLabel, 230);
        this.setObjectConstraints(this.getColumnCheckOptionsLayout(), this.cbEnable, 230);
    }

    private void initValidate() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Validate"));
        this.columnCheckOptions.add(jLabel);
        this.cbValidate = new JComboBox<String>(YES_NO);
        this.setBG(this.cbValidate);
        this.cbValidate.setPreferredSize(this.tfName.getPreferredSize());
        this.columnCheckOptions.add(this.cbValidate);
        this.setLabelConstraints(this.getColumnCheckOptionsLayout(), jLabel, 260);
        this.setObjectConstraints(this.getColumnCheckOptionsLayout(), this.cbValidate, 260);
    }

    private void initExTable() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.ExceptionsTable"));
        this.columnCheckOptions.add(jLabel);
        this.cbExTable = new JComboBox();
        this.setBG(this.cbExTable);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableProxySet().toArray(), this.cbExTable);
        }
        this.cbExTable.setPreferredSize(this.tfName.getPreferredSize());
        this.columnCheckOptions.add(this.cbExTable);
        this.setLabelConstraints(this.getColumnCheckOptionsLayout(), jLabel, 290);
        this.setObjectConstraints(this.getColumnCheckOptionsLayout(), this.cbExTable, 290);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.column.getName());
        this.notNullConstraintName = this.column.getColumn().getNotNullConstraintName();
        if (this.column.isNotNullConstraintNameChanged()) {
            this.tfNNCName.setText(this.column.getNncName());
        } else {
            this.tfNNCName.setText(this.notNullConstraintName);
        }
        this.cbNNCInitially.setSelectedItem(this.column.getNncInitially());
        this.cbNNCDeferrable.setSelectedItem(ColumnPropertyDialogOraclev9i.translateYesNoForDisplay(this.column.getNncDeferrable()));
        this.cbNNCEnable.setSelectedItem(ColumnPropertyDialogOraclev9i.translateYesNoForDisplay(this.column.getNncEnable()));
        this.cbNNCValidate.setSelectedItem(ColumnPropertyDialogOraclev9i.translateYesNoForDisplay(this.column.getNncValidate()));
        this.cbNNCExTable.setSelectedItem(this.column.getNncExceptionsTable());
        this.tfName.setText(this.column.getName());
        this.tfDataType.setText(this.column.getDatatypeString());
        if (this.column.getColumn().getScope() == null) {
            this.tfScope.setText("");
        } else {
            this.tfScope.setText(this.column.getColumn().getScope().getName());
        }
        this.tfNullsAllowed.setText(this.column.getNullsAllowed() ? YES : NO);
        this.tfDefaultValue.setText(this.column.getDefaultValue());
        this.tfCluster.setText(this.column.getCluster());
        this.ifPosInCluster.setValue((long)this.column.getPositionInCluster());
        this.cbWithRowId.setSelectedItem(ColumnPropertyDialogOraclev9i.translateYesNoForDisplay(this.column.getWithRowId()));
        this.cbWithRowId.setEnabled(((Column)this.column.getObject()).isReference());
        if (this.column.getDataType().toString().equals("XMLTYPE")) {
            this.cbStoreAs.setEnabled(true);
            this.tfLobSegmentName.setEnabled(true);
            this.tfXmlSchemaUrl.setEnabled(true);
            this.tfXmlSchemaElement.setEnabled(true);
            if (this.column.getStoreAs().equalsIgnoreCase("OBJECT RELATIONAL")) {
                this.enableXMLTypeClobOptions(false);
            } else {
                this.enableXMLTypeClobOptions(true);
            }
            this.cbStoreAs.setSelectedItem(this.column.getStoreAs());
            this.tfLobSegmentName.setText(this.column.getLobSegmentName());
            this.tfXmlSchemaUrl.setText(this.column.getXmlSchemaUrl());
            this.tfXmlSchemaElement.setText(this.column.getXmlSchemaElement());
            this.selectObject(this.cbTableSpace, this.column.getTablespace());
            this.cbStorageInRow.setSelectedItem(this.column.getStorageInRow());
            this.cbLogging.setSelectedItem(ColumnPropertyDialogOraclev9i.translateYesNoForDisplay(this.column.getLogging()));
            this.cbCache.setSelectedItem(this.column.getCache());
            this.ifChunk.setValue((long)this.column.getChunk());
            this.cbOldVersions.setSelectedItem(this.column.getOldVersions());
            this.ifFreePools.setValue((long)this.column.getFreepools());
            this.ifPctVersion.setValue((long)this.column.getPCTVersion());
            this.ifSCInitialExtent.setValue(this.column.getSCInitialExtent());
            this.ifSCNextExtent.setValue(this.column.getSCNextExtent());
            this.ifSCMinExtents.setValue((long)this.column.getSCMinExtents());
            this.tfSCMaxExtents.setText(this.column.getSCMaxExtents());
            this.ifSCPctIncrease.setValue((long)this.column.getSCPctIncrease());
            this.cbSCBufferPool.setSelectedItem(this.column.getSCBufferPool());
            this.ifSCFreeLists.setValue((long)this.column.getSCFreeLists());
            this.ifSCFreeListsGroups.setValue((long)this.column.getSCFreelistGroups());
        } else {
            this.cbStoreAs.addItem("");
            this.cbStoreAs.setSelectedItem("");
            this.cbStoreAs.setEnabled(false);
            this.tfLobSegmentName.setEnabled(false);
            this.tfXmlSchemaUrl.setEnabled(false);
            this.tfXmlSchemaElement.setEnabled(false);
            this.enableXMLTypeClobOptions(false);
        }
        CheckConstraint checkConstraint = this.column.getColumn().getCheck();
        if (checkConstraint != null) {
            this.tfConstraintName.setText(checkConstraint.getName());
            this.taConstraint.setText(checkConstraint.getImplementation(this.getRDBMSType()));
        }
        this.cbInitially.setSelectedItem(this.column.getInitially());
        this.cbDeferrable.setSelectedItem(ColumnPropertyDialogOraclev9i.translateYesNoForDisplay(this.column.getDeferrable()));
        this.cbEnable.setSelectedItem(ColumnPropertyDialogOraclev9i.translateYesNoForDisplay(this.column.getEnable()));
        this.cbValidate.setSelectedItem(ColumnPropertyDialogOraclev9i.translateYesNoForDisplay(this.column.getValidate()));
        this.cbExTable.setSelectedItem(this.column.getExceptionsTable());
        this.tfNTStorageTable.setText(this.column.getNtStorageTable());
        this.cbNTReturn.setSelectedItem(this.column.getNtReturn());
        this.tfLobSegname.setText(this.column.getLobSegname());
        this.taAdditionalNTS.setText(this.column.getAdditionalNTS());
        this.cbSubstitutable.setSelectedItem(this.column.getSubtitutable());
        this.cbElementType.setSelectedItem(this.column.getElementType());
        this.cbAutoIncrementUser.setSelectedItem(this.column.getAutoIncrementUser());
        this.cbAutoIncrementUser.setEnabled(this.column.getColumn().isAutoIncrementColumn());
        this.comment = this.column.getObject().getComment();
        this.commentInRDBMS = this.column.getObject().getCommentInRDBMS();
        if (this.column.isCommentChanged()) {
            this.getCommentsList().insert(this.column.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.column.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.column.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
        Datatype datatype = ((Column)this.column.getObject()).getDataType();
        this.setTabVarrayAndNTVisible(datatype instanceof CollectionType);
        if ((datatype instanceof StructuredType || datatype instanceof CollectionType) && ((Column)this.column.getObject()).isAllowSubtypeSubstitution()) {
            if (datatype instanceof CollectionType) {
                this.cbSubstitutable.removeItemAt(3);
            }
        } else {
            this.cbSubstitutable.setEnabled(false);
        }
    }

    private void setTabVarrayAndNTVisible(boolean bl) {
        int n = this.getPane().indexOfComponent(this.vArrayAndNT);
        if (n > -1) {
            this.getPane().setEnabledAt(n, bl);
        }
    }

    private void initSubstitutable(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Substitutable"));
        jLabel.setToolTipText(Messages.getString("ColumnPropertyDialogOraclev9i.SubstitutionForVARRAYAndNestedTable"));
        this.general.add(jLabel);
        this.cbSubstitutable = new JComboBox<String>(ColumnProxyOraclev9i.getSubstitutableValues());
        this.cbSubstitutable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Datatype datatype = ((Column)ColumnPropertyDialogOraclev9i.this.column.getObject()).getDataType();
                if (ColumnPropertyDialogOraclev9i.this.cbSubstitutable.getSelectedItem().equals("ONLY FOR TYPE")) {
                    ColumnPropertyDialogOraclev9i.this.cbElementType.removeAllItems();
                    ColumnPropertyDialogOraclev9i.this.cbElementType.setEnabled(true);
                    List list = ColumnPropertyDialogOraclev9i.this.getListInheritans(datatype);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ColumnPropertyDialogOraclev9i.this.cbElementType.addItem(iterator.next().toString());
                    }
                } else {
                    ColumnPropertyDialogOraclev9i.this.cbElementType.removeAllItems();
                    ColumnPropertyDialogOraclev9i.this.cbElementType.setEnabled(false);
                    ColumnPropertyDialogOraclev9i.this.cbElementType.addItem(datatype.toString());
                }
            }
        });
        this.setBG(this.cbSubstitutable);
        this.cbSubstitutable.setPreferredSize(this.tfName.getPreferredSize());
        this.cbSubstitutable.setToolTipText(Messages.getString("ColumnPropertyDialogOraclev9i.SubstitutionForVARRAYAndNestedTable"));
        this.general.add(this.cbSubstitutable);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.cbSubstitutable, n);
    }

    private List getListInheritans(Datatype datatype) {
        CollectionType collectionType;
        ArrayList arrayList = new ArrayList();
        if (datatype instanceof CollectionType && (collectionType = (CollectionType)datatype).getDataType() instanceof StructuredType) {
            arrayList.addAll(((StructuredType)collectionType.getDataType()).getAllInstantiableSubTypes(true));
        }
        if (datatype instanceof StructuredType) {
            arrayList.addAll(((StructuredType)datatype).getAllInstantiableSubTypes(true));
        }
        return arrayList;
    }

    private void initElementType(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.ElementType"));
        this.general.add(jLabel);
        this.cbElementType = new JComboBox();
        this.setBG(this.cbElementType);
        this.cbElementType.setPreferredSize(this.tfName.getPreferredSize());
        this.cbElementType.setEnabled(false);
        this.general.add(this.cbElementType);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.cbElementType, n);
    }

    private void initAutoIncrementUser(int n) {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.AutoIncrementUser"));
        String string = Messages.getString("ColumnPropertyDialogOraclev9i.AutoIncrementUserTooltip");
        jLabel.setToolTipText(string);
        this.general.add(jLabel);
        this.cbAutoIncrementUser = new JComboBox();
        this.setBG(this.cbAutoIncrementUser);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbAutoIncrementUser);
        }
        this.cbAutoIncrementUser.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.cbAutoIncrementUser.setToolTipText(string);
        this.cbAutoIncrementUser.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAutoIncrementUser);
        this.setLabelConstraints(jLabel, n);
        this.setObjectConstraints(this.cbAutoIncrementUser, n);
    }

    @Override
    protected void setProperties() {
        if (this.column != null) {
            Object object;
            Object object2;
            this.column.setName(this.tfName.getText());
            this.column.setDefaultValue(this.tfDefaultValue.getText());
            this.column.setWithRowId(ColumnPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbWithRowId.getSelectedItem()));
            if (this.cbStoreAs.isEnabled()) {
                object2 = (String)this.cbStoreAs.getSelectedItem();
                this.column.setStoreAs((String)object2);
                this.column.setLobSegmentName(this.tfLobSegmentName.getText());
                this.column.setXmlSchemaUrl(this.tfXmlSchemaUrl.getText());
                this.column.setXmlSchemaElement(this.tfXmlSchemaElement.getText());
                if (!((String)object2).equalsIgnoreCase("OBJECT RELATIONAL")) {
                    object = this.cbTableSpace.getSelectedItem();
                    if (object instanceof TableSpaceOraclev9i) {
                        this.column.setTablespace((TableSpaceOraclev9i)object);
                    } else {
                        this.column.setTablespace(null);
                    }
                    this.column.setStorageInRow((String)this.cbStorageInRow.getSelectedItem());
                    this.column.setLogging(ColumnPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
                    this.column.setCache((String)this.cbCache.getSelectedItem());
                    this.column.setChunk(this.ifChunk.getIntValue());
                    this.column.setOldVersions((String)this.cbOldVersions.getSelectedItem());
                    this.column.setFreepools(this.ifFreePools.getIntValue());
                    this.column.setPCTVersion(this.ifPctVersion.getIntValue());
                    this.column.setSCInitialExtent(this.ifSCInitialExtent.getIntValue());
                    this.column.setSCNextExtent(this.ifSCNextExtent.getIntValue());
                    this.column.setSCMinExtents(this.ifSCMinExtents.getIntValue());
                    this.column.setSCMaxExtents(this.tfSCMaxExtents.getText());
                    this.tfSCMaxExtents.setText(this.column.getSCMaxExtents());
                    this.column.setSCPctIncrease(this.ifSCPctIncrease.getIntValue());
                    this.column.setSCBufferPool((String)this.cbSCBufferPool.getSelectedItem());
                    this.column.setSCFreeLists(this.ifSCFreeLists.getIntValue());
                    this.column.setSCFreelistGroups(this.ifSCFreeListsGroups.getIntValue());
                }
            }
            this.column.setInitially((String)this.cbInitially.getSelectedItem());
            this.column.setDeferrable(ColumnPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbDeferrable.getSelectedItem()));
            this.column.setEnable(ColumnPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbEnable.getSelectedItem()));
            this.column.setValidate(ColumnPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbValidate.getSelectedItem()));
            object2 = this.cbExTable.getSelectedItem();
            if (object2 instanceof TableProxyOracle) {
                this.column.setExceptionsTable((TableProxyOracle)object2);
            } else {
                this.column.setExceptionsTable(null);
            }
            object = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty((String)object) && !this.comment.equals(object)) {
                this.column.setComment((String)object);
                this.column.setCommentChanged(true);
            } else {
                this.column.setComment("");
                this.column.setCommentChanged(false);
            }
            String string = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(string) && !this.commentInRDBMS.equals(string)) {
                this.column.setCommentInRDBMS(string);
                this.column.setCommentInRDBMSChanged(true);
            } else {
                this.column.setCommentInRDBMS("");
                this.column.setCommentInRDBMSChanged(false);
            }
            this.column.setNtStorageTable(this.tfNTStorageTable.getText());
            this.column.setNtReturn((String)this.cbNTReturn.getSelectedItem());
            this.column.setLobSegname(this.tfLobSegname.getText());
            this.column.setAdditionalNTS(this.taAdditionalNTS.getText());
            this.column.setSubtitutable((String)this.cbSubstitutable.getSelectedItem());
            this.column.setElementType((String)this.cbElementType.getSelectedItem());
            this.column.setAutoIncrementUser((UserOracle)this.cbAutoIncrementUser.getSelectedItem());
            if (!this.tfNNCName.getText().equals(this.notNullConstraintName)) {
                this.column.setNncName(this.tfNNCName.getText());
                this.column.setNotNullConstraintNameChanged(true);
            } else {
                this.column.setNotNullConstraintNameChanged(false);
            }
            this.column.setNncInitially((String)this.cbNNCInitially.getSelectedItem());
            this.column.setNncDeferrable(ColumnPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbNNCDeferrable.getSelectedItem()));
            this.column.setNncEnable(ColumnPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbNNCEnable.getSelectedItem()));
            this.column.setNncValidate(ColumnPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbNNCValidate.getSelectedItem()));
            Object object3 = this.cbNNCExTable.getSelectedItem();
            if (object3 instanceof TableProxyOracle) {
                this.column.setNncExceptionsTable((TableProxyOracle)object3);
            } else {
                this.column.setNncExceptionsTable(null);
            }
        }
    }

    private void initNNC() {
        this.generalNNC = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ColumnPropertyDialogOraclev9i.ColumnNotNullConstraint"), this.generalNNC);
        this.initNNCName();
        this.initNNCInitially();
        this.initNNCDeferrable();
        this.initNNCEnable();
        this.initNNCValidate();
        this.initNNCExTable();
    }

    private void initNNCName() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.ConstraintName"));
        this.generalNNC.add(jLabel);
        this.tfNNCName = new JTextField("", 26);
        this.generalNNC.add(this.tfNNCName);
        this.setLabelConstraints(this.getNNCTypeLayout(), jLabel, 20);
        this.setObjectConstraints(this.getNNCTypeLayout(), this.tfNNCName, 20);
    }

    private void initNNCInitially() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Initially"));
        this.generalNNC.add(jLabel);
        this.cbNNCInitially = new JComboBox<String>(NotNullConstraintOracle.getInitiallyChoices());
        this.setBG(this.cbNNCInitially);
        this.cbNNCInitially.setPreferredSize(this.tfName.getPreferredSize());
        this.generalNNC.add(this.cbNNCInitially);
        this.setLabelConstraints(this.getNNCTypeLayout(), jLabel, 50);
        this.setObjectConstraints(this.getNNCTypeLayout(), this.cbNNCInitially, 50);
    }

    private void initNNCDeferrable() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Deferrable"));
        this.generalNNC.add(jLabel);
        this.cbNNCDeferrable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbNNCDeferrable);
        this.cbNNCDeferrable.setPreferredSize(this.tfName.getPreferredSize());
        this.generalNNC.add(this.cbNNCDeferrable);
        this.setLabelConstraints(this.getNNCTypeLayout(), jLabel, 80);
        this.setObjectConstraints(this.getNNCTypeLayout(), this.cbNNCDeferrable, 80);
    }

    private void initNNCEnable() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Enable"));
        this.generalNNC.add(jLabel);
        this.cbNNCEnable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbNNCEnable);
        this.cbNNCEnable.setPreferredSize(this.tfName.getPreferredSize());
        this.generalNNC.add(this.cbNNCEnable);
        this.setLabelConstraints(this.getNNCTypeLayout(), jLabel, 110);
        this.setObjectConstraints(this.getNNCTypeLayout(), this.cbNNCEnable, 110);
    }

    private void initNNCValidate() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.Validate"));
        this.generalNNC.add(jLabel);
        this.cbNNCValidate = new JComboBox<String>(YES_NO);
        this.setBG(this.cbNNCValidate);
        this.cbNNCValidate.setPreferredSize(this.tfName.getPreferredSize());
        this.generalNNC.add(this.cbNNCValidate);
        this.setLabelConstraints(this.getNNCTypeLayout(), jLabel, 140);
        this.setObjectConstraints(this.getNNCTypeLayout(), this.cbNNCValidate, 140);
    }

    private void initNNCExTable() {
        JLabel jLabel = new JLabel(Messages.getString("ColumnPropertyDialogOraclev9i.ExceptionsTable"));
        this.generalNNC.add(jLabel);
        this.cbNNCExTable = new JComboBox();
        this.setBG(this.cbNNCExTable);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableProxySet().toArray(), this.cbNNCExTable);
        }
        this.cbNNCExTable.setPreferredSize(this.tfName.getPreferredSize());
        this.generalNNC.add(this.cbNNCExTable);
        this.setLabelConstraints(this.getNNCTypeLayout(), jLabel, 170);
        this.setObjectConstraints(this.getNNCTypeLayout(), this.cbNNCExTable, 170);
    }

    private SpringLayout getNNCTypeLayout() {
        return (SpringLayout)this.generalNNC.getLayout();
    }

    class PermissionsListener
    implements ActionListener {
        PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ColumnPropertyDialogOraclev9i.this.dialog = new ObjectPermissionsDialogOracle(ColumnPropertyDialogOraclev9i.this.getAppView(), ColumnPropertyDialogOraclev9i.this.getStorageDesign(), ColumnPropertyDialogOraclev9i.this.column);
            ColumnPropertyDialogOraclev9i.this.dialog.showDialog();
        }
    }

    private class StoreAsListener
    implements ActionListener {
        private StoreAsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = ColumnPropertyDialogOraclev9i.this.cbStoreAs.getSelectedItem().equals("OBJECT RELATIONAL");
            ColumnPropertyDialogOraclev9i.this.enableXMLTypeClobOptions(!bl);
            ColumnPropertyDialogOraclev9i.this.tfLobSegmentName.setEnabled(!bl);
            if (ColumnPropertyDialogOraclev9i.this.getStorageDesign() instanceof StorageDesignOraclev11g) {
                ColumnPropertyDialogOraclev9i.this.cbLobStorageType.setEnabled(!bl);
                boolean bl2 = ColumnPropertyDialogOraclev9i.this.cbStoreAs.getSelectedItem().equals("BINARY XML");
                ColumnPropertyDialogOraclev9i.this.cbAllowAnySchema.setEnabled(bl2);
                ColumnPropertyDialogOraclev9i.this.cbAllowNonSchema.setEnabled(bl2);
            }
        }
    }

    private class VersionListener
    implements ActionListener {
        private VersionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (((String)ColumnPropertyDialogOraclev9i.this.cbOldVersions.getSelectedItem()).equalsIgnoreCase(ColumnProxyOraclev9i.getOldVersionChoices()[0])) {
                ColumnPropertyDialogOraclev9i.this.ifPctVersion.setEnabled(false);
            } else {
                ColumnPropertyDialogOraclev9i.this.ifPctVersion.setEnabled(true);
            }
        }
    }
}

